<?php

/*
=====================================================================

  프로젝트 이름 : 피리 웹프로그램

  만든사람 : 피리 PIREE ( piree1977@gmail.com )

  홈페이지 : www.piree.kr

  작성날짜 : 2020년 07월 24일 금요일 오전 01시 40분 - 날씨 흐림, 18, 18, 22, 20 / 최고 좋음, 2, 0

  저 작 권 : Copyright ⓒ 2014-2023 피리 piree.kr All right reserved
            그누보드 외에 추가된 소스는~
            만든사람의 허락없이 무단으로 사용할수 없습니다.
            사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
            http://.piree.kr 에 문의해 주세요.

=====================================================================
 피리 > 피리 기본 관리 > 라이브러리 > INDEX
=====================================================================

//*****************************************************************
//** SAM_SOSS
//*****************************************************************

*/

/*
  ▣ 작업자 : 피리 PIREE ( piree1977@gmail.com )
  ▣ 작업일시 : 2020년 07월 24일 금요일 오전 05시 23분 - 날씨 
  ▣ 작업내용 : 
*/

  IF ( !defined('_GNUBOARD_') )                  EXIT;

  function get__index_table_info($arti_code, $idx_n)
  {

      global $piree;

      $row_div_n = 0;

      $table_head_s = "";

      $table_info_arr['table_n'] = 0;
      $table_info_arr['table_s'] = "";

      $row_div_n = get__div_num($div_code, $var_n);

      SWITCH($arti_code)
      {
          CASE 'comment' :      $table_head_s = $piree['comment_table_prefix'];      BREAK;
          CASE 'image' :        $table_head_s = $piree['image_table_prefix'];         BREAK;
          DEFAULT :                                                                  BREAK;
      }

      $table_info_arr['table_n'] = ceil($idx_n/$row_div_n);

      $table_info_arr['table_s'] = $table_head_s.$table_info_arr['table_n'];

      return $table_info_arr;

  }

  function get__index_table_name($arti_code, $idx_n)
  {

      global $piree;

      $table_info_arr = get__index_table_info($arti_code, $idx_n);

      return $table_info_arr['table_s'];

  }

  function save__index($overlap_ck, $idx_code, $idx_table, $idx_v_n, $idx_v_s, $reload_idx_n, $reload_table, $reload_wh_s)
  {

      global $piree;

      $index_n = 0;

      $in_errors = 0;

      IF ( !$idx_code && !$idx_table)              $in_errors++;
      IF ( !$idx_v_n  && !$idx_v_s )              $in_errors++;

      IF ( $in_errors == 0 )
      {

          $sql_where_s = "`idx_code` = '". $idx_code ."' AND `idx_table` = '". $idx_table ."'";

          IF ( $idx_v_n > 0 )
          {

              $sql_where_s .= " AND `idx_v_n`='". $idx_v_n ."'";
          }

          IF ( $idx_v_s )
          {

              $sql_where_s .= " AND `idx_v_s`='". $idx_v_s."'";
          }

          $sql   = "SELECT COUNT(*) FROM `". $piree['piree_index'] ."` WHERE ". $sql_where_s;
          $exist = sql_efv($sql);

          $save_sql_s = "insert";

          IF ( $overlap_ck == 1 )
          {

              IF ( $exist > 0 )
              {

                  $save_sql_s = "update";

              }

          }

          $sql_common .= "idx_code  = '". $idx_code ."', ";
          $sql_common .= "idx_table  = '". $idx_table ."', ";
          $sql_common .= "idx_v_n  = '". $idx_v_n ."', ";
          $sql_common .= "idx_v_s  = '". $idx_v_s."'";

          IF ( $save_sql_s == "update" )
          {

              $sql  = "UPDATE `". $piree['piree_index'] ."` SET ";
              $sql .= $sql_common." ";
              $sql .= "WHERE ". $sql_where_s;

              IF ( !sql_query($sql) )
              {

              $msg_s = "[ ". $idx_code." / ". $idx_table." / ". $idx_v_n." / ". $idx_v_s ." ] 의 INDEX를 수정하지 못했습니다. >> ". $sql;
              alert($msg_s, "");
              }

              $sql     = "SELECT index_n FROM `". $piree['piree_index'] ."` WHERE ". $sql_where_s." ORDER BY `index_n DESC LIMIT 1";
              $index_n = sql_efv($sql);

          }
          ELSE
          {

              $sql  = "INSERT INTO `". $piree['piree_index'] ."` SET ";
              $sql .= $sql_common.", ";
              $sql .= "idx_regtm_n = '". G5_SERVER_TIME ."'";

              IF ( !sql_query($sql) )
              {

                  $msg_s = "[ ". $idx_code." / ". $idx_table." / ". $idx_v_n." / ". $idx_v_s ." ] 의 INDEX를 입력하지 못했습니다. >> ". $sql;

                  alert($msg_s, "");

              }

              $index_n = sql_insert_id();

          }

          IF ( $reload_idx_n == 1 )
          {

              $in_errors = 0;

              IF ( !$reload_table || $reload_table == "")    $in_errors++;
              IF ( !$reload_wh_s )                          $in_errors++;

              IF ( $in_errors == 0 )
              {

                  $sql  = "UPDATE ". $reload_table." SET ";
                  $sql .= "`idx_n` = '". $index_n  ."' ";
                  $sql .= "WHERE ". $reload_wh_s;

                  IF ( !sql_query($sql) )
                  {
                      alert("INDEX 정보를 저장하지 못했습니다.");
                  }

              }

          }

      }

      return $index_n;

  }

  function get__index_info($idx_n)
  {

      global $piree;

      $idx_row = array();

      IF ( $idx_n > 0 )
      {

          $sql = "SELECT * FROM `". $piree['piree_index'] ."` WHERE `index_n` = '". $idx_n ."'";
          $row = sql_fetch($sql);

          IF ( $idx_n == $row['index_n'] )
          {

              $idx_row['index_n'] = $row['index_n'];

              $idx_row['idx_code'] = $row['idx_code'];

              $idx_row['idx_table'] = $row['idx_table'];

              $idx_row['idx_v_n'] = $row['idx_v_n'];

              $idx_row['idx_v_s'] = clean_xss_tags($row['idx_v_s']);

              $idx_row['idx_regtm_n'] = $row['idx_regtm_n'];

          }

      }

      return $idx_row;

  }

  function get__article_div_info($arti_code, $arti_table, $arti_idx_n)
  {

      global $g5, $idx_row, $piree;

      $arti_row = array();

      SWITCH($arti_code)
      {

          CASE 'article' :

//$write_table = $g5['write_prefix'].$arti_table;
              $write_table = $arti_table;

              $sql = "SELECT * FROM `". $write_table ."` WHERE `idx_n` = '". $arti_idx_n ."'";
              $row = sql_fetch($sql);

              IF ( $arti_idx_n == $row['idx_n'] )
              {

                  $arti_row = $row;

                  $arti_row['arti_table']  = $write_table;

                  $arti_row['arti_n']                = $row['wr_id'];
                  $arti_row['row_idx_n']            = $row['idx_n'];
                  $arti_row['arti_idx_n']            = $row['idx_n'];
                  $arti_row['arti_iml_list_key_n']  = $row['iml_list_key_n'];
                  $arti_row['arti_comment_t']        = $row['wr_comment_t'];
                  $arti_row['arti_title_s']          = stripslashes($row['wr_subject']);
                  $arti_row['arti_cont_s']          = stripslashes($row['wr_content']);
                  $arti_row['arti_hit_n']            = $row['wr_hit'];
                  $arti_row['arti_like_n']          = $row['wr_good'];
                  $arti_row['arti_hate_n']          = $row['wr_nogood'];
                  $arti_row['arti_mem_nu']          = 0;
                  $arti_row['arti_mem_id']          = $row['mb_id'];
                  $arti_row['arti_mem_ni']          = $row['wr_name'];
                  $arti_row['arti_ip_s']            = $row['wr_ip'];
                  $arti_row['arti_regist_date_s']    = $row['wr_datetime'];
                  $arti_row['arti_regist_time_n']    = $row['wr_regist_time_n'];
                  $arti_row['arti_update_date_s']    = $row['wr_last'];
                  $arti_row['arti_update_time_n']    = $row['wr_last_time_n'];
                  $arti_row['arti_read_level_n']    = $row['wr_read_level_n'];
                  $arti_row['arti_image_t']          = $row['wr_pi_image_t'];
                  $arti_row['arti_image_face_n']    = $row['wr_pi_image_face_n'];
                  $arti_row['arti_image_face_s']    = $row['wr_pi_image_face_s'];
                  $arti_row['arti_report_t']        = $row['wr_pi_report_t'];

              }

          BREAK;

          CASE 'image' :

              IF ( !$arti_table || $arti_table == "" )
              {

                  $arti_table = get__index_table_name($idx_row['idx_code'], $arti_idx_n);
              }

              $sql = "SELECT * FROM `". $arti_table."` WHERE idx_n='". $arti_idx_n ."'";
              $row = sql_fetch($sql);

              IF ( $arti_idx_n == $row['idx_n'] )
              {

                  $arti_row = $row;

                  $arti_row['arti_table']  = $arti_table;

                  $arti_row['arti_n']                = $row['iml_image_n'];
                  $arti_row['row_idx_n']            = $row['idx_n'];
                  $arti_row['arti_idx_n']            = $row['iml_arti_idx_n'];
                  $arti_row['arti_iml_list_key_n']  = $row['iml_list_key_n'];
                  $arti_row['arti_comment_t']        = $row['iml_comment_t'];
                  $arti_row['arti_title_s']          = stripslashes($row['iml_title_s']);
                  $arti_row['arti_cont_s']          = "";
                  $arti_row['arti_hit_n']            = 0;
                  $arti_row['arti_like_n']          = $row['iml_good'];
                  $arti_row['arti_hate_n']          = $row['iml_nogood'];
                  $arti_row['arti_mem_nu']          = 0;
                  $arti_row['arti_mem_id']          = $row['iml_mem_id'];
                  $arti_row['arti_mem_ni']          = $row['iml_mem_nick'];
                  $arti_row['arti_ip_s']            = $row['iml_ip'];
                  $arti_row['arti_regist_date_s']    = date("Y-m-d H:i:s", $row['iml_regi_time_n']);
                  $arti_row['arti_regist_time_n']    = $row['iml_regi_time_n'];
                  $arti_row['arti_update_date_s']    = date("Y-m-d H:i:s", $row['iml_last_time_n']);
                  $arti_row['arti_update_time_n']    = $row['iml_last_time_n'];
                  $arti_row['arti_read_level_n']    = 0;
                  $arti_row['arti_image_t']          = 0;
                  $arti_row['arti_image_face_n']    = 0;
                  $arti_row['arti_image_face_s']    = 0;
                  $arti_row['arti_report_t']        = 0;

              }

          BREAK;

      }

      return $arti_row;

  }

  function get__table_name($arti_code, $arti_table)
  {

      global $g5;

      $table_name = "";

      SWITCH($arti_code)
      {

          CASE 'article' :

//$write_table = $g5['write_prefix'].$arti_table;
              $bo_table = substr($arti_table, strlen($g5['write_prefix']), (strlen($arti_table)-strlen($g5['write_prefix'] ) ));

              $sql = "SELECT bo_subject,bo_mobile_subject FROM `". $g5['board_table'] ."` WHERE bo_table='". $bo_table."'";
              $row = sql_fetch($sql);

              IF ( $row['bo_subject'] || $row['bo_mobile_subject'] )
              {

                  $table_name = $row['bo_subject'];

                  IF ( G5_IS_MOBILE && $row['bo_mobile_subject'] )
                  {

                      $table_name = $row['bo_mobile_subject'];

                  }

              }

          BREAK;

          CASE 'image' :

              $table_name = str_replace($piree['image_table_prefix'], '이미지 ', $arti_table);

          BREAK;

      }

      return $table_name;

  }

  function get__arti_posi($arti_code, $arti_table, $arti_num, $table_name, $table_len)
  {

      global $arti_code_arr;

      $arti_arr = array();

      IF ( $arti_code && $arti_num > 0 )
      {

          $arti_arr['posi_code'] = $arti_code;

          $arti_arr['posi_path'] = $arti_code_arr[$arti_code]['name'];

          IF ( $table_len > 0 )
          {

              $arti_table = cut_str($arti_table, $table_len, '');
              $table_name = cut_str($table_name, $table_len, '');
          }

          IF ( $arti_table)
          {

              $arti_arr['posi_code'] .= ' ▶ '. $arti_table;
          }

          IF ( $table_name )
          {

              $arti_arr['posi_path'] .= ' ▶ '. $table_name;
          }

          $arti_arr['posi_code'] .= ' ▶ '. $arti_num;

          $arti_arr['posi_path'] .= ' ▶ '. $arti_num;

      }

      return $arti_arr;

  }

?>