<?php

/*
=====================================================================

  프로젝트 이름 : 피리 웹프로그램

  만든사람 : 피리 PIREE ( piree1977@gmail.com )

  홈페이지 : www.piree.kr

  작업날짜 : 2024년 04월 01일 월요일 오전 10시 52분 / 맑음, 14.0, 일교차 주의, 18, 3, 0%, 0%, 3.3ms / 나쁨, 58, 20

  저 작 권 : Copyright ⓒ 2014-2023 피리 piree.kr All right reserved
            그누보드 외에 추가된 소스는~
            만든사람의 허락없이 무단으로 사용할수 없습니다.
            사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
            http://.piree.kr 에 문의해 주세요.

=====================================================================
 피리 > 피리 기본 관리 > 라이브러리 > 지역 > SMALLINT > 2단계
=====================================================================

=============================

서울특별시|서울
부산광역시|부산
인천광역시|인천
대구광역시|대구
광주광역시|광주
대전광역시|대전
울산광역시|울산
세종특별자치시|세종
경기도|경기
강원특별자치도|강원
충청남도|충남
충청북도|충북
전라남도|전남
전라북도|전북
경상남도|경남
경상북도|경북
제주특별자치도|제주

-- 서울특별시|서울
강남구
강동구
강북구
강서구
관악구
광진구
구로구
금천구
노원구
도봉구
동대문구
동작구
마포구
서대문구
서초구
성동구
성북구
송파구
양천구
영등포구
용산구
은평구
종로구
중구
중랑구

-- 부산광역시|부산
강서구
금정구
기장군
남구
동래구
부산진구
북구
사상구
사하구
수영구
연제구
중구
해운대구

-- 인천광역시|인천
강화군|
계양구|
남동구|
동구|
미추홀구|
부평구|
서구|
연수구|
옹진군|
중구|

-- 대구광역시|대구
군위군|
남구|
달서구|
달성군|
동구|
북구|
서구|
수성구|
중구|

-- 광주광역시|광주
광산구|
남구|
동구|
북구|
서구|

-- 대전광역시|대전
대덕구|
동구|
서구|
유성구|
중구|

-- 울산광역시|울산
남구|
동구|
북구|
울주군|
중구|

-- 세종특별자치시|세종
고운동|
금남면|
나성동|
다정동|
대평동|
도담동|
반곡동|
보람동|
부강면|
새롬동|
소담동|
소정면|
아름동|
어진동|
연기면|
연동면|
연서면|
장군면|
전동면|
전의면|
조치원읍|
종촌동|
한솔동|
해밀동|

-- 경기도|
가평군|
고양특례시|고양시
과천시|
광명시|
광주시|
구리시|
군포시|
김포시|
남양주시|
동두천시|
부천시|
성남시|
수원특례시|수원시
시흥시|
안산시|
안성시|
안양시|
양주시|
양평군|
여주시|
연천군|
오산시|
용인특례시|용인시
의왕시|
의정부시|
이천시|
파주시|
평택시|
포천시|
하남시|
화성시|

-- 강원특별자치도|
강릉시|
고성군|
동해시|
삼척시|
속초시|
양구군|
양양군|
영월군|
원주시|
인제군|
정선군|
철원군|
춘천시|
태백시|
평창군|
홍천군|
화천군|
횡성군|

-- 충청남도|
계룡시|
공주시|
금산군|
논산시|
당진시|
보령시|
부여군|
서산시|
서천군|
아산시|
예산군|
천안시|
청양군|
태안군|
홍성군|

-- 충청북도|
괴산군|
단양군|
보은군|
영동군|
옥천군|
음성군|
제천시|
증평군|
진천군|
청주시|
충주시|

-- 전라남도|
강진군|
고흥군|
곡성군|
광양시|
구례군|
나주시|
담양군|
목포시|
무안군|
보성군|
순천시|
신안군|
여수시|
영광군|
영암군|
완도군|
장성군|
장흥군|
진도군|
함평군|
해남군|
화순군|

-- 전북특별자치도|
고창군|
군산시|
김제시|
남원시|
무주군|
부안군|
순창군|
완주군|
익산시|
임실군|
장수군|
전주시|
정읍시|
진안군|

-- 경상남도|
거제시|
거창군|
고성군|
김해시|
남해군|
밀양시|
사천시|
산청군|
양산시|
의령군|
진주시|
창녕군|
창원시|
통영시|
하동군|
함안군|
함양군|
합천군|

-- 경상북도|
경산시|
경주시|
고령군|
구미시|
김천시|
문경시|
봉화군|
상주시|
성주군|
안동시|
영덕군|
영양군|
영주시|
영천시|
예천군|
울릉군|
울진군|
의성군|
청도군|
청송군|
칠곡군|
포항시|

-- 제주특별자치도|제주
제주시|
서귀포시|

=============================

*/

  IF (!defined('_GNUBOARD_'))                      EXIT;

  function get_region_record_map_smallint2($fnc_mb_id)
  {

      global $piree_prog_a;

      $in_link_s = "";

      IF ( $fnc_mb_id )
      {

          $in_link_s  = piree__url($piree_prog_a[770100]['num'], 'member_region_record.php');
          $in_link_s .= '?mem_id='. $fnc_mb_id;

      }

      return $in_link_s;

  }

  function get_region_row_smallint2($region_n, $func_fd_c='')
  {

      global $piree;

      $region_arr = array();

      IF ( $region_n > 0 )
      {

          $sql  = "SELECT ". $func_fd_c ." FROM `". $piree['region'] ."` ";
          $sql .= "WHERE `region_n` = '". $region_n ."'";
          $res  = sql_fetch($sql);

          IF ( $res['region_kor_p'] )
          {

              $res['region_kor_p2'] = str_replace('--', ' > ', $res['region_kor_p']);

          }

      }

      return $res;

  }

  function get_region_upper_smallint2($region_n)
  {

      global $piree;

      $region_i_a = array();

      IF ( !$region_n || $region_n == 0 )
      {
          return false;
      }

      $region_i_a[1] = floor($region_n/100) * 100;
      $region_i_a[2] = floor($region_n/1) * 1;

      IF ( $region_n == $region_i_a[1] )
      {

          $region_i_a[0] = 1;

          $region_i_a[2] = 0;

          $region_i_a[6] = $region_i_a[1] .'--';

      }
      ELSE IF ( $region_n == $region_i_a[2] )
      {

          $region_i_a[0] = 2;

          $region_i_a[6] = $region_i_a[1] .'--'. $region_i_a[2] .'--';

      }

      return $region_i_a;

  }

  function get_region_sql_where_smallint2($region_num_a, $sql_fd_s, $region_n = 0, $get_children = 0)
  {

      global $piree;

      IF ( !$sql_fd_s )
      {
          return false;
      }

      $sql_where_a = array();

      FOR ( $loop_n=1; $loop_n<3; $loop_n++)
      {

          IF ( $region_num_a[$loop_n] > 0 )
          {

              $sql_where_a[] = "`". $sql_fd_s ."` = '". $region_num_a[$loop_n] ."'";

          }

      }

      $sql_where_s = implode(' OR ', $sql_where_a);

      IF ( $get_children == 1 )
      {

          IF ( $region_n > 0 )
          {

              $sql_where_s .= " OR `region_parent_n` = '". $region_n ."'";

          }

      }

      return $sql_where_s;

  }

  function get_region_name_path_smallint2($region_num_a, $sql_where_s)
  {

      global $piree;

      IF ( !$region_num_a )
      {
          return false;
      }

      IF ( !$sql_where_s )
      {
          return false;
      }

      $region_str_a[0] = '';
      $region_str_a[1] = '';
      $region_str_a[2] = '';
      $region_str_a[6] = '';

      $region_kor_p = '';

      $sql  = "SELECT `region_n`, `region_s`, `region_depth_n` FROM `". $piree['region'] ."` ";
      $sql .= "WHERE ". $sql_where_s ." ORDER BY `region_n` ASC";
      $result = sql_query($sql);

      WHILE ( $res = sql_fetch_array($result) )
      {

          IF ( $res['region_n'] > 0 )
          {

              IF ( $res['region_s'] )
              {

                  $in_depth_n = $res['region_depth_n'];

                  $in_region_s = clean_str($res['region_s']);

                  $region_str_a[$in_depth_n] = $in_region_s;

                  $region_kor_p .= $in_region_s .'--';

              }

          }

      }

      $region_str_a[6] = $region_kor_p;

      return $region_str_a;

  }

  function get_new_region_num_smallint2($parent_region_n, $depth_n)
  {

      global $piree;

      IF ( !$depth_n || $depth_n == 0 )
      {
          return false;
      }

      IF ( !$parent_region_n )
      {
          $parent_region_n = 0;
      }

      IF ( $depth_n > 1 )
      {

          IF ( $parent_region_n == 1 )
          {
              return false;
          }

      }

      $sql  = "SELECT MAX(`region_n`) FROM `". $piree['region'] ."` ";
      $sql .= "WHERE `region_parent_n` = '". $parent_region_n ."' AND `region_depth_n` = '". $depth_n ."'";
      $temp_n = sql_efv($sql);

      IF ( !$temp_n )
      {

          $temp_n = $parent_region_n;

      }

      $new_region_n = 0;

      SWITCH ( $depth_n )
      {
          CASE 1 :          $new_region_n = $temp_n + 100;                BREAK;
          CASE 2 :          $new_region_n = $temp_n + 1;                  BREAK;
      }

      return $new_region_n;

  }

  function get_region_range_smallint2($region_n, $region_depth_n, $sql_fd_s)
  {

      global $piree;

      IF ( !$region_n )
      {
          return false;
      }

      IF ( !$region_depth_n )
      {

          $sql  = "SELECT region_depth_n FROM `". $piree['region'] ."` ";
          $sql .= "WHERE `region_n` = '". $region_n ."'";
          $region_depth_n = sql_efv($sql);

      }

      $range_a[0] = $region_n;
      $range_a[1] = "";
      $range_a[2] = "";
      $range_a[3] = "";

      SWITCH ( $region_depth_n )
      {
          CASE 1 :          $range_a[1] = $region_n + 99;                BREAK;
          CASE 2 :          $range_a[1] = $region_n;                    BREAK;
      }

      IF ( $sql_fd_s )
      {

          IF ( $region_n )
          {

              IF ( $range_a[1] > $region_n )
              {

                  $range_a[2] = "(`". $sql_fd_s ."` BETWEEN '". $region_n ."' AND '". $range_a[1] ."')";
                  $range_a[3] = "(`". $sql_fd_s ."` BETWEEN '". ($region_n+1) ."' AND '". $range_a[1] ."')";

              }
              ELSE
              {

                  $range_a[2] = "`". $sql_fd_s ."` = '". $region_n ."'";
                  $range_a[3] = "";

              }

          }

      }

      return $range_a;

  }

  function get_sub_region_count_depth_smallint2($region_i_a, $region_n)
  {

      global $piree;

      IF ( !count($region_i_a) )
      {
          return false;
      }

      IF ( !$region_n )
      {
          return false;
      }

      FOR ( $i=1; $i<6; $i++ )
      {

          IF ( $region_i_a[$i] > 0 )
          {

              IF ( $region_n != $region_i_a[$i] )
              {

                  get_sub_region_count_single_smallint2($region_i_a[$i], $i, 1);

              }

          }

      }

  }

  function get_sub_region_count_single_smallint2($region_n, $region_depth_n, $is_db_update = 0)
  {

      global $piree;

      IF ( !$region_n )
      {
          return false;
      }

      $range_a = get_region_range_smallint2($region_n, $region_depth_n, 'region_n');

      $sql  = "SELECT COUNT(*) FROM `". $piree['region'] ."` ";
      $sql .= "WHERE ". $range_a[3];
      $region_sub_t = (int)sql_efv($sql);

      IF ( $is_db_update == 1 )
      {

          $sql  = "UPDATE `". $piree['region'] ."` SET ";
          $sql .= "`region_sub_t` = '". $region_sub_t ."' ";
          $sql .= "WHERE `region_n` = '". $region_n ."'";

          IF ( !sql_query($sql) )
          {

              alert ("[ ". $region_n ." ] 지역의 하위지역 수를 새로고침하지 못했습니다.");
          }

      }

      return $region_sub_t;

  }

  function set__colorbox_css_js()
  {

  // add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
      add_stylesheet('<link rel="stylesheet" href="http://.jacklmoore.com/colorbox/example3/colorbox.css">', 0);

  // add_javascript('js 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
      add_javascript('<script src="http://.jacklmoore.com/colorbox/jquery.colorbox.js"></script>', 75);

  }

/*

  function get__0000($0000)
  {

      global $piree;

      IF (  )
      {

      }

      return $aaaa;

  }

  function get__0000($0000)
  {

      global $piree;

      IF (  )
      {

      }

      return $aaaa;

  }

*/

?>