<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 심플

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https:/\/piree.kr/nett_dev

  작성날짜 : 2024년 03월 31일 요일

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
            그누보드 외에 추가된 소스는~
            만든사람의 허락없이 무단으로 사용할수 없습니다.
            사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
            http://.piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 심플 > 피리 카페 심플 > 피리 카페 관리 > 설정 파일
=====================================================================

cut_str($str, $len, $suffix="…")

//-8 문자열 자르기
utf8_strcut( $str, $size, $suffix='...' )

  function piree_cafe_skin_path_get($get_skin_a)

177316032

*/

  IF ( !defined('_GNUBOARD_') )                             EXIT;

  $nett_prog_n = 770099;

  $piree_prog_a[$nett_prog_n]['name_l'] = "피리 NETT 피리 카페 관리";

  $piree_prog_a[$nett_prog_n]['name_s'] = "피리 NETT 피리 카페";

  $piree_prog_a[$nett_prog_n]['prog_c'] = "피리 NETT Cafe Manage";

  $piree_prog_a[$nett_prog_n]['version_s'] = "0.0.0.1";

  $piree_prog_a[$nett_prog_n]['memo_s'] = "[ 피리 NETT ]를 기본 관리하는 기능입니다.";

  $p770099__word_data_work_c = 'cafe.search';

  $cafe_member_info_get_way_a = array();
  $cafe_member_info_get_way_a[11] = array('num'=>11, 'code'=>'piree_피리 NETT', 'name'=>'피리 NETT');
  $cafe_member_info_get_way_a[21] = array('num'=>21, 'code'=>'gnuboard5',  'name'=>'그누보드5');

  $cafe_make_auto_manual_a = array();
  $cafe_make_auto_manual_a['manual'] = array('code'=>'manual', 'name_s'=>'수동', 'name_l'=>'수동으로 만들기');
  $cafe_make_auto_manual_a['auto']   = array('code'=>'auto',   'name_s'=>'자동', 'name_l'=>'자동으로 만들기');

  $cafe_member_level_a = array();

  $cafe_member_level_a[250] = array('num'=>250, 'name'=>'주인');
  $cafe_member_level_a[240] = array('num'=>240, 'name'=>'관리자');
  $cafe_member_level_a[230] = array('num'=>230, 'name'=>'매니저');

  $cafe_member_level_a[110] = array('num'=>110, 'name'=>'회원 레벨 10');
  $cafe_member_level_a[109] = array('num'=>109, 'name'=>'회원 레벨 9');
  $cafe_member_level_a[108] = array('num'=>108, 'name'=>'회원 레벨 8');
  $cafe_member_level_a[107] = array('num'=>107, 'name'=>'회원 레벨 7');
  $cafe_member_level_a[106] = array('num'=>106, 'name'=>'회원 레벨 6');
  $cafe_member_level_a[105] = array('num'=>105, 'name'=>'회원 레벨 5');
  $cafe_member_level_a[104] = array('num'=>104, 'name'=>'회원 레벨 4');
  $cafe_member_level_a[103] = array('num'=>103, 'name'=>'회원 레벨 3');
  $cafe_member_level_a[102] = array('num'=>102, 'name'=>'회원 레벨 2');
  $cafe_member_level_a[101] = array('num'=>101, 'name'=>'회원 레벨 1');

  $cafe_member_level_a[81]  = array('num'=>81,  'name'=>'서로 바라기');
  $cafe_member_level_a[71]  = array('num'=>71,  'name'=>'나 바라기');

  $cafe_member_level_a[54]  = array('num'=>54,  'name'=>'5분 정지');
  $cafe_member_level_a[52]  = array('num'=>52,  'name'=>'10분 정지');
  $cafe_member_level_a[50]  = array('num'=>50,  'name'=>'20분 정지');
  $cafe_member_level_a[48]  = array('num'=>48,  'name'=>'30분 정지');
  $cafe_member_level_a[46]  = array('num'=>46,  'name'=>'1시간 정지');
  $cafe_member_level_a[44]  = array('num'=>44,  'name'=>'3시간 정지');
  $cafe_member_level_a[42]  = array('num'=>42,  'name'=>'6시간 정지');
  $cafe_member_level_a[40]  = array('num'=>40,  'name'=>'1일 정지');
  $cafe_member_level_a[38]  = array('num'=>38,  'name'=>'3일 정지');
  $cafe_member_level_a[36]  = array('num'=>36,  'name'=>'7일 정지');
  $cafe_member_level_a[34]  = array('num'=>34,  'name'=>'10일 정지');
  $cafe_member_level_a[32]  = array('num'=>32,  'name'=>'15일 정지');
  $cafe_member_level_a[30]  = array('num'=>30,  'name'=>'20일 정지');
  $cafe_member_level_a[28]  = array('num'=>28,  'name'=>'30일 정지');
  $cafe_member_level_a[26]  = array('num'=>26,  'name'=>'60일 정지');
  $cafe_member_level_a[24]  = array('num'=>24,  'name'=>'90일 정지');
  $cafe_member_level_a[22]  = array('num'=>22,  'name'=>'100일 정지');
  $cafe_member_level_a[20]  = array('num'=>20,  'name'=>'365일 정지');
  $cafe_member_level_a[18]  = array('num'=>18,  'name'=>'730일 정지');
  $cafe_member_level_a[16]  = array('num'=>16,  'name'=>'영구 정지');

  $piree['cafe'] = G5_TABLE_PREFIX .'_piree__cafe';

  $piree['cafe_member'] = G5_TABLE_PREFIX .'_piree__cafe_member';

  function cafe_sql_get($get_piree_cafe_n=0, $get_piree_cafe_c='')
  {

    $where_a = array();

    $where_s = '';

    IF ( $get_piree_cafe_n > 0 || $get_piree_cafe_c )
    {

      IF ( $get_piree_cafe_n > 0 )
      {

        $where_a[] = "`cafe_row_n` = '". $get_piree_cafe_n ."'";

      }

      IF ( $get_piree_cafe_c )
      {

        $get_piree_cafe_2_c = substr($get_piree_cafe_c, 0, 2);

        $where_a[] = " `cafe_code_c` = '". $get_piree_cafe_c ."'";

      }

      IF ( count($where_a) > 0 )
      {

        $where_s = array_to_sql_get($where_a, 'val_each', ' AND ');

      }

    }

    return $where_s;

  }

  function get_piree_cafe_info($get_piree_cafe_n=0, $get_piree_cafe_c='', $get_row_base_n=0, $get_row_list_n=0)
  {

    global $piree;

    $save_cafe_n = $get_piree_cafe_n;

    $where_s = cafe_sql_get($save_cafe_n, $get_piree_cafe_c);

    $cafe_base_a = array();
    $cafe_list_a = array();
    $piree_cafe_info_a = array();

    IF ( $get_row_base_n == 1 )
    {

      $sql_select  = "SELECT * FROM `". $piree['cafe'] ."` ";
      $sql_select .= "WHERE ". $where_s;
      $cafe_base_a = sql_fetch($sql_select);

      IF ( $save_cafe_n != $cafe_base_a['cafe_row_n'] )
      {

        $save_cafe_n = $cafe_base_a['cafe_row_n'];

      }

    }

    IF ( $get_row_list_n == 1 )
    {

      IF ( $save_cafe_n > 0 )
      {

        $cafe_table_a = cafe_table_get($save_cafe_n);

        $sql_select  = "SELECT * FROM `". $cafe_table_a['table_c'] ."` ";
        $sql_select .= "WHERE `cafe_row_n` = '". $save_cafe_n ."'";
        $cafe_list_a = sql_fetch($sql_select);

      }

    }

    $piree_cafe_info_a = array_merge($cafe_base_a, $cafe_list_a);

    return $piree_cafe_info_a;

  }

  function get_piree_cafe_domain($get_domain_s)
  {

    $domain_at_s = '';

    IF ( $get_domain_s )
    {

      $domain_at_s = '@'. $get_domain_s;

    }

    return $domain_at_s;

  }

  function piree_cafe_code_check($func_cafe_code_c, $func_piree_cafe_n=0)
  {

    global $piree;
    global $p770099__cafe_code_len_min_n;
    global $p770099__cafe_code_len_max_n;

    $cafe_result_a = array();
    $cafe_result_a['cafe_error_n']  = 1;
    $cafe_result_a['cafe_result_s'] = '';

    IF ( $func_cafe_code_c )
    {

      $func_cafe_code_2_c = substr($func_cafe_code_c, 0, 2);

      $cafe_code_len_n = strlen($func_cafe_code_c);

      IF ( $cafe_result_a['cafe_error_n'] == 1 && !$cafe_result_a['cafe_result_s'] )
      {

        IF ( !$func_cafe_code_c )
        {

          $cafe_result_a['cafe_error_n']++;
          $cafe_result_a['cafe_result_s'] = "[ 카페 코드 ]을 입력해 주세요.";

        }

      }

      IF ( $cafe_result_a['cafe_error_n'] == 1 && !$cafe_result_a['cafe_result_s'] )
      {

// ( !preg_match("/^([A-Za-z0-9_.]{1,20})$/", $func_cafe_code_c) )
        IF ( !preg_match("/^([a-zA-Z0-9_.]+)$/", $func_cafe_code_c) )
        {

          $cafe_result_a['cafe_error_n']++;
          $cafe_result_a['cafe_result_s'] = "[ 카페 코드 ]은 공백없이 영문자, 숫자, _, .만 입력해 주세요.";

        }

      }

      IF ( $cafe_result_a['cafe_error_n'] == 1 && !$cafe_result_a['cafe_result_s'] )
      {

        IF ( $cafe_code_len_n < $p770099__cafe_code_len_min_n )
        {

          $cafe_result_a['cafe_error_n']++;
          $cafe_result_a['cafe_result_s'] = "[ 카페 코드 ]의 글자수를 ". $p770099__cafe_code_len_min_n ."자 보다 길게 입력해 주세요.";

        }

      }

      IF ( $cafe_result_a['cafe_error_n'] == 1 && !$cafe_result_a['cafe_result_s'] )
      {

        IF ( $p770099__cafe_code_len_max_n < $cafe_code_len_n )
        {

          $cafe_result_a['cafe_error_n']++;
          $cafe_result_a['cafe_result_s'] = "[ 카페 코드 ]의 글자수를 ". $p770099__cafe_code_len_max_n ."자 보다 짧게 입력해 주세요.";

        }

      }

        $sql_where_cafe_s = "";

        $sql_where_code_s = "";

        IF ( $func_piree_cafe_n > 0 )
        {

          $sql_where_cafe_s = " AND `cafe_row_n` != '". $func_piree_cafe_n ."'";

          $sql_where_code_s = " AND `ecob_cafe_n` != '". $func_piree_cafe_n ."'";

        }

        IF ( $cafe_result_a['cafe_error_n'] == 1 && !$cafe_result_a['cafe_result_s'] )
        {

          $sql_select  = "SELECT COUNT(*) FROM `". $piree['cafe'] ."` ";
          $sql_select .= "WHERE `cafe_code_c` = '". $func_cafe_code_c ."'". $sql_where_cafe_s;
          $exist_t = sql_efv($sql_select);

          IF ( $exist_t > 0 )
          {

            $cafe_result_a['cafe_error_n']++;
            $cafe_result_a['cafe_result_s'] = "사용할수 없는 [ 카페 코드 ] 입니다. 다시 입력해 주세요.";

          }

        }

        IF ( $cafe_result_a['cafe_error_n'] == 1 && !$cafe_result_a['cafe_result_s'] )
        {

          $sql_select  = "SELECT COUNT(*) FROM `". $piree['code_english'] ."` ";
          $sql_select .= "WHERE `ecob_2_c` = '". $func_cafe_code_2_c ."' AND `ecob_code_var_c` = '". $func_cafe_code_c ."'". $sql_where_code_s;
          $exist_t = sql_efv($sql_select);

          IF ( $exist_t > 0 )
          {

            $cafe_result_a['cafe_error_n']++;
            $cafe_result_a['cafe_result_s'] = "사용할수 없는 [ 카페 코드 ] 입니다. 다시 입력해 주세요.";

          }

        }

    }

    return $cafe_result_a;

  }

// $piree;

  function cafe_table_get($func_cafe_n=0, $func_table_n=0)
  {

    IF ( $func_cafe_n > 0 || $func_table_n > 0 )
    {

      global $piree;

      $table_info_a['table_n'] = 0;
      $table_info_a['table_c'] = '';

      IF ( $func_cafe_n > 0 )
      {
        $table_info_a['table_n'] = ceil($func_cafe_n/$piree['lindex_data_div_n']);
      }
      ELSE
      {
        $table_info_a['table_n'] = $func_table_n;
      }

      $table_info_a['table_c'] = $piree['cafe'] .'_'. $table_info_a['table_n'];

      return $table_info_a;

    }

  }

  $piree_cafe_prog_a[$piree_cafe_prog_a[790000]['num']]['is_use'] = 0;

  $piree_cafe_prog_a[$piree_cafe_prog_a[790000]['num']]['prog_d'] = "p". $piree_cafe_prog_a[790000]['num'];

  $piree_cafe_prog_a[$piree_cafe_prog_a[790000]['num']]['prog_u'] = piree__url($piree_cafe_prog_a[790000]['num']);
  $piree_cafe_prog_a[$piree_cafe_prog_a[790000]['num']]['prog_p'] = piree__path($piree_cafe_prog_a[790000]['num']);

  $piree_cafe_prog_a[$piree_cafe_prog_a[790000]['num']]['img_u'] = $piree_cafe_prog_a[$piree_cafe_prog_a[790000]['num']]['prog_u'] .'images';
  $piree_cafe_prog_a[$piree_cafe_prog_a[790000]['num']]['img_p'] = $piree_cafe_prog_a[$piree_cafe_prog_a[790000]['num']]['prog_p'] .'images';

  IF ( $p790000_get == 1 )
  {

    $prog_conf = get_progran_row($piree_cafe_prog_a[790000]['num']);

    IF ( $piree_cafe_prog_a[790000]['num'] == $prog_conf['pgs_prog_n'] )
    {

      $incl__prog_n = $piree_cafe_prog_a[790000]['num'];

      include_once( piree__path($piree_prog_a[770099]['num'], 'program.config.common.inc.php') );

    }

  }

?>