<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 For 그누보드5.5 순정

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https://piree.kr/nett_dev

  작업날짜 : 2024년 04월 01일 월요일 오전 10시 52분 / 맑음, 14.0, 일교차 주의, 18, 3, 0%, 0%, 3.3ms / 나쁨, 58, 20

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
              그누보드 외에 추가된 소스는~
              만든사람의 허락없이 무단으로 사용할수 없습니다.
              사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
              http://www.piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 For 그누보드5.5 순정 > 프로그램 > 피리 카페 관리 > CONFIG 파일
=====================================================================


function 


  $piree['cafe'] = G5_TABLE_PREFIX .'_piree__cafe';


DROP TABLE `g5__piree__board_category`;
DROP TABLE `g5__piree__cafe`;
DROP TABLE `g5__piree__cafe_keyword`;
DROP TABLE `g5__piree__cafe_member`;
DROP TABLE `g5__piree__category`;
DROP TABLE `g5__piree__region`;


DELETE FROM g5_write_piree_cafe_1`;

DELETE FROM `g5_board_new`;
DELETE FROM `g5_board_good`;
DELETE FROM `g5_board_file`;
DELETE FROM `g5_scrap`



// 문자열 자르기
cut_str($str, $len, $suffix="…")


// UTF-8 문자열 자르기
utf8_strcut( $str, $size, $suffix='...' )


  function piree_cafe_skin_path_get($get_skin_a)


https://piree.kr/nett_dev/piree.nett/program/p770100/keyword.regist.ajax.php?prog_n=770100&piree_cafe_n=1&work_c=piree_cafe.search&keyword_s=%EB%8C%80%ED%95%9C%EB%AF%BC%EA%B5%AD


    IF ( $piree_cafe_n > 0 && $is_cafe_manager == $piree_cafe_n )
    {
        //
    }


    IF ( $is_cafe_manager != $piree_cafe_n )
    {
        //
    }


    $is_cafe_manager = $piree_cafe_n;


피리가 인생을 살며 보고, 듣고, 느낀 이야기들을 기록하는 피리 카페입니다.
열심히 기록할께요.


*/


  ###################################################################
  # 시작 => 개별_페이지__무단_접근_불가
  ###################################################################

  //=================================================================
  // 개별_페이지__접근_불가
  IF (!defined('_GNUBOARD_'))                      EXIT;

  ###################################################################
  # 끝 => 개별_페이지__무단_접근_불가
  ###################################################################



#####################################################################
# 시작 => 기본_설정_첨부__하기
#####################################################################


  //=================================================================
  // 시작 => 기본_설정_첨부__하기
  IF ( $get__p770000_conf == 1 )
  {

      //=============================================================
      // 설정_정보_파일__첨부
      include_once( piree__path($piree_prog_a[770000]['num'], 'config', 0) );

  }
  // 끝 => 기본_설정_첨부__하기
  //=================================================================


#####################################################################
# 끝 => 기본_설정_첨부__하기
#####################################################################










#####################################################################
# 시작 => 설정
#####################################################################


  //=================================================================
  // 프로그램_번호
  $nett_prog_n = 770100;


  //=================================================================
  // 프로그램_이름__긴_이름
  $piree_prog_a[$nett_prog_n]['name_l'] = "피리 카페 For 그누보드5.5 순정 (유료버젼)";


  //=================================================================
  // 프로그램_이름__짧은_이름
  $piree_prog_a[$nett_prog_n]['name_s'] = "피리 카페 그누보드5.5";


  //=================================================================
  // 프로그램_코드__영문_코드
  $piree_prog_a[$nett_prog_n]['prog_c'] = "Piree cafe For Gnuboard5.5 Original";


  //=================================================================
  // 버젼
  $piree_prog_a[$nett_prog_n]['version_s'] = "0.0.0.1";


  //=================================================================
  // 프로그램_메모
  $piree_prog_a[$nett_prog_n]['memo_s'] = "[ 피리 카페 ]를 기본 관리하는 기능입니다.";


#####################################################################
# 끝 => 설정
#####################################################################





#####################################################################
# 시작 => 상수__변수__배열
#####################################################################


  ###################################################################
  # 시작 => 상수
  ###################################################################

  //=================================================================
  // 디렉토리
  define('PIREE_CAFE_MANAGE_DIR',         'manage');
  define('PIREE_CAFE_SKIN_BASIC_PC_DIR',  '_basic_skin_pc');
  define('PIREE_CAFE_SKIN_BASIC_MO_DIR',  '_basic_skin_mo');
  define('PIREE_CAFE_SKIN_MANAGE_PC_DIR', '_manage_skin_pc');
  define('PIREE_CAFE_SKIN_MANAGE_MO_DIR', '_manage_skin_mo');
  define('PIREE_CAFE_SKIN_BOARD_PC_DIR',  '_board_skin_pc');
  define('PIREE_CAFE_SKIN_BOARD_MO_DIR',  '_board_skin_mo');
  define('PIREE_CAFE_SKIN_LATEST_PC_DIR', '_latest_skin_pc');
  define('PIREE_CAFE_SKIN_LATEST_MO_DIR', '_latest_skin_mo');


  //=================================================================
  // 카페_메인
  define('PIREE_CAFE_MAIN_URL',  piree__url($piree_prog_a[770100]['num'], 'cafe.index.php'));
  define('PIREE_CAFE_MAIN_PATH', piree__path($piree_prog_a[770100]['num'], 'cafe.index.php'));


  //=================================================================
  // 카페_관리
  define('PIREE_CAFE_MANAGE_URL',  piree__url($piree_prog_a[770100]['num'], '') . PIREE_CAFE_MANAGE_DIR);
  define('PIREE_CAFE_MANAGE_PATH', piree__path($piree_prog_a[770100]['num'], '') . PIREE_CAFE_MANAGE_DIR);

  ###################################################################
  # 끝 => 상수
  ###################################################################



  ###################################################################
  # 시작 => 변수
  ###################################################################

  //=================================================================
  // p770100__카페_상단_로고
  $p770100__cafe_logo_url_s = piree__url($piree_prog_a[770100]['num'], 'piree__156_38__1.png');


  //=================================================================
  // p770100__검색어_관리__자료_구분
  $p770100__word_data_work_c = 'piree_cafe.search';


  //=================================================================
  // 카페_코드__길이
  $p770100__piree_cafe_code_len_min_n = 8;
  $p770100__piree_cafe_code_len_max_n = 16;


  //=================================================================
  // 카페_이름__길이
  $p770100__piree_cafe_name_len_min_n = 12;
  $p770100__piree_cafe_name_len_max_n = 254;


  //=================================================================
  // 카페별로_게시글_가져올때__카페_지정__쿼리문
  $sql_article_category_s = "`wr_pi_piree_cafe_n` = '". $piree_cafe_n ."'";

  ###################################################################
  # 끝 => 변수
  ###################################################################



  ###################################################################
  # 시작 => 배열
  ###################################################################

  //=================================================================
  // 피리_카페__레벨
  $cafe_member_level_a = array();

  $cafe_member_level_a[250] = array('num'=>250, 'name'=>'주인');
  $cafe_member_level_a[240] = array('num'=>240, 'name'=>'관리자');
  $cafe_member_level_a[230] = array('num'=>230, 'name'=>'매니저');

  $cafe_member_level_a[10]  = array('num'=>10,  'name'=>'레벨 10');
  $cafe_member_level_a[9]   = array('num'=>9,   'name'=>'레벨 9');
  $cafe_member_level_a[8]   = array('num'=>8,   'name'=>'레벨 8');
  $cafe_member_level_a[7]   = array('num'=>7,   'name'=>'레벨 7');
  $cafe_member_level_a[6]   = array('num'=>6,   'name'=>'레벨 6');
  $cafe_member_level_a[5]   = array('num'=>5,   'name'=>'레벨 5');
  $cafe_member_level_a[4]   = array('num'=>4,   'name'=>'레벨 4');
  $cafe_member_level_a[3]   = array('num'=>3,   'name'=>'레벨 3');
  $cafe_member_level_a[2]   = array('num'=>2,   'name'=>'레벨 2');
  $cafe_member_level_a[1]   = array('num'=>1,   'name'=>'레벨 1');


  //=================================================================
  // 

  ###################################################################
  # 끝 => 배열
  ###################################################################


#####################################################################
# 끝 => 상수__변수__배열
#####################################################################





#####################################################################
# 시작 => 테이블__이름
#####################################################################


  //=================================================================
  // 피리_카페__테이블
  $piree['cafe'] = G5_TABLE_PREFIX .'_piree__cafe';


  //=================================================================
  // 피리_카페__회원__테이블
  $piree['cafe_member'] = G5_TABLE_PREFIX .'_piree__cafe_member';


  //=================================================================
  // 피리_카페__검색어__테이블
  $piree['cafe_keyword'] = G5_TABLE_PREFIX .'_piree__cafe_keyword';


  //=================================================================
  // 카테고리__테이블
  $piree['category'] = G5_TABLE_PREFIX .'_piree__category';


  //=================================================================
  // 피리_카페__게시판__카테고리__테이블
  $piree['cafe_board'] = G5_TABLE_PREFIX .'_piree__board_category';


  //=================================================================
  // 지역__테이블
  $piree['region'] = G5_TABLE_PREFIX .'_piree__region';


  //=================================================================
  // 피리_카페__게시판__코드
  $piree['cafe_board_code'] = 'piree_cafe_1';


  //=================================================================
  // 피리_카페__게시판__테이블
  $piree['cafe_article'] = $g5['write_prefix'] . $piree['cafe_board_code'];


#####################################################################
# 끝 => 테이블__이름
#####################################################################





#####################################################################
# 시작 => 피리_카페__관련
#####################################################################


  ###################################################################
  # 시작 => 피리_카페__권한__확인
  ###################################################################
  function piree_cafe_auth_get()
  {

    //===============================================================
    // 전역_변수
    global $is_admin;
    global $member;
    global $piree_cafe_n;
    global $piree_cafe_a;
    global $is_cafe_manager;


    //===============================================================
    // 권한_숫자
    $save_auth_n = 0;


    //===============================================================
    // 시작 => 관리자__이면
    IF ( $is_admin == 'super' )
    {
      //=============================================================
      // 권한_숫자__증가
      $save_auth_n++;
    }
    // 끝 => 관리자__이면
    //===============================================================


    //===============================================================
    // 시작 => 카페_번호__있고____카페_번호_와__카페_관리_번호__같으면
    IF ( $piree_cafe_n > 0 && $is_cafe_manager == $piree_cafe_n )
    {
      //=============================================================
      // 권한_숫자__증가
      $save_auth_n++;
    }
    // 끝 => 카페_번호__있고____카페_번호_와__카페_관리_번호__같으면
    //===============================================================


    //===============================================================
    // 시작 => 회원_번호__있고____회원_번호_와__카페_주인_번호__같으면
    IF ( $member['mb_id'] && $member['mb_id'] == $piree_cafe_a['cafe_mem_id'] )
    {
      //=============================================================
      // 권한_숫자__증가
      $save_auth_n++;
    }
    // 끝 => 회원_번호__있고____회원_번호_와__카페_주인_번호__같으면
    //===============================================================


    //===============================================================
    // 넘겨주기____권한_숫자
    return $save_auth_n;

  }
  ###################################################################
  # 끝 => 피리_카페__권한__확인
  ###################################################################



  ###################################################################
  # 시작 => 피리_카페__쿼리문__가져오기
  ###################################################################
  function piree_cafe_sql_get($get_piree_cafe_n=0, $get_piree_cafe_c='')
  {

    //===============================================================
    // 쿼리문_조건절__배열
    $where_a = array();


    //===============================================================
    // 쿼리문_조건절__문자열
    $where_s = '';


    //===============================================================
    // 시작 => 피리_카페_번호__있거나____피리_카페__카페_코드__있으면
    IF ( $get_piree_cafe_n > 0 || $get_piree_cafe_c )
    {

      //=============================================================
      // 시작 => 피리_카페_번호__있으면
      IF ( $get_piree_cafe_n > 0 )
      {

        //===========================================================
        // 쿼리문_조건절__배열
        $where_a[] = "`cafe_row_n` = '". $get_piree_cafe_n ."'";

      }
      // 끝 => 피리_카페_번호__있으면
      //=============================================================


      //=============================================================
      // 시작 => 피리_카페__카페_코드__있으면
      IF ( $get_piree_cafe_c )
      {

        //===========================================================
        // 쿼리문_조건절__배열
        $where_a[] = "`cafe_code_c` = '". $get_piree_cafe_c ."'";

      }
      // 끝 => 피리_카페__카페_코드__있으면
      //=============================================================


      //=============================================================
      // 시작 => 쿼리문_조건절__배열__있으면
      IF ( count($where_a) > 0 )
      {

        //===========================================================
        // 넘겨줄__쿼리문_문장
        $where_s = implode(' OR ', $where_a);

      }
      // 끝 => 쿼리문_조건절__배열__있으면
      //=============================================================

    }
    // 끝 => 피리_카페_번호__있거나____피리_카페__카페_코드__있으면
    //===============================================================


    //===============================================================
    // 넘겨주기____쿼리문_조건절__문자열
    return $where_s;

  }
  ###################################################################
  # 끝 => 피리_카페__정보__가져오는__함수
  ###################################################################



  ###################################################################
  # 시작 => 피리_카페__정보__가져오는__함수
  ###################################################################
  function get_piree_cafe_info($get_piree_cafe_n=0, $get_piree_cafe_c='')
  {

    //===============================================================
    // 전역_변수
    global $piree;


    //===============================================================
    // 넘겨줄____카페_정보_배열
    $piree_cafe_row_a = array();


    //===============================================================
    // 시작 => 피리_카페_번호__있거나
    // 시작 => 피리_카페_코드__있으면
    IF ( $get_piree_cafe_n > 0 || $get_piree_cafe_c )
    {

      //=============================================================
      // 피리_카페__쿼리문__가져오기
      $where_s = piree_cafe_sql_get($get_piree_cafe_n, $get_piree_cafe_c);


      //=============================================================
      // 피리_카페_BASE_ROW__가져오기
      $sql_select  = "SELECT * FROM `". $piree['cafe'] ."` ";
      $sql_select .= "WHERE ". $where_s;
      $piree_cafe_row_a = sql_fetch($sql_select);

    }
    // 끝 => 피리_카페_번호__있거나
    // 끝 => 피리_카페_코드__있으면
    //===============================================================


    //===============================================================
    // 넘겨주기____피리_카페_번호
    return $piree_cafe_row_a;

  }
  ###################################################################
  # 끝 => 피리_카페__정보__가져오는__함수
  ###################################################################



  ###################################################################
  # 시작 => 피리_카페_페이지__URL__알아내기
  ###################################################################
  function get_piree_cafe_page($get_page_s='', $get_qry_s='')
  {

    //===============================================================
    // 전역변수
    global $piree;
    global $piree_prog_a;
    global $piree_cafe__prog_a;


    //===============================================================
    // 넘겨줄__피리_카페_URL
    $piree_cafe__url_s = '';


    //===============================================================
    // 시작 => 페이지__구분
    SWITCH ($get_page_s)
    {
      CASE '' :                         $piree_cafe__url_s = piree__path($piree_prog_a[770100]['num'], $get_page_s);                   BREAK;
      CASE 'member.join.form.php' :     $piree_cafe__url_s = piree__path($piree_prog_a[770100]['num'], $get_page_s);                   BREAK;
      DEFAULT :                         $piree_cafe__url_s = piree__path($piree_prog_a[770100]['num'], '') .'/'. $get_page_s;          BREAK;
    }
    // 끝 => 페이지__구분
    //===============================================================


    //===============================================================
    // 시작 => QUERY_STRING
    IF ( $get_qry_s )
    {

      //=============================================================
      // 피리_카페_URL
      $piree_cafe__url_s .= '?'. $get_qry_s;

    }
    // 끝 => QUERY_STRING
    //===============================================================


    //===============================================================
    // 넘겨주기____피리_카페_URL
    return $piree_cafe__url_s;

  }
  ###################################################################
  # 끝 => 피리_카페_페이지__URL__알아내기
  ###################################################################



  ###################################################################
  # 시작 => 개별__카페__처음으로___이동하기
  ###################################################################
  function cafe_index_go($get_piree_cafe_n=0, $get_piree_cafe_c='', $func_url_get_n=1)
  {

    //===============================================================
    // 시작 => 카페_코드__있으면
    IF ( $get_piree_cafe_c )
    {

      //=============================================================
      // 카페_URL
      $piree_cafe_url_s = PIREE_CAFE_MAIN_URL .'?piree_cafe_c='. $get_piree_cafe_c;

    }
    // 끝 => 카페_코드__있으면
    //===============================================================


    //===============================================================
    // 시작 => 피리_카페_번호__있으면
    IF ( $get_piree_cafe_n > 0 )
    {

      //=============================================================
      // 카페_URL
      $piree_cafe_url_s = PIREE_CAFE_MAIN_URL .'?piree_cafe_n='. $get_piree_cafe_n;

    }
    // 끝 => 피리_카페_번호__있으면
    //===============================================================


    //===============================================================
    // 페이지__이동하기
    IF ( $func_url_get_n == 1 )
    {
      return $piree_cafe_url_s;
    }
    ELSE
    {
      goto_url($piree_cafe_url_s);
      EXIT;
    }

  }
  ###################################################################
  # 끝 => 개별__카페__처음으로___이동하기
  ###################################################################



  ###################################################################
  # 시작 => 카페__파일__URL__알아내기
  ###################################################################
  function get_piree_cafe_main($get_piree_cafe_n=0, $get_piree_cafe_c='')
  {

    //===============================================================
    // 전역변수
    global $piree;


    //===============================================================
    // 넘겨줄__카페_URL
    $piree_cafe_url_s = '';


    //===============================================================
    // 시작 => 피리_카페_번호__있거나____카페_코드__있으면
    IF ( $get_piree_cafe_n > 0 || $get_piree_cafe_c )
    {

      //=============================================================
      // 카페__정보__가져오는__함수
      $piree_cafe_info_a = get_piree_cafe_info($get_piree_cafe_n, $get_piree_cafe_c);


      //=============================================================
      // 피리_카페_번호
      // $get_piree_cafe_n = $piree_cafe_info_a['cafe_row_n'];

    }
    // 끝 => 피리_카페_번호__있거나____카페_코드__있으면
    //===============================================================


    //===============================================================
    // 시작 => 카페_코드__있으면
    IF ( $get_piree_cafe_c )
    {

      //=============================================================
      // 카페_URL
      $piree_cafe_url_s = PIREE_CAFE_MAIN_URL .'?piree_cafe_c='. $get_piree_cafe_c;

    }
    // 끝 => 카페_코드__있으면
    //===============================================================


    //===============================================================
    // 시작 => 피리_카페_번호__있으면
    IF ( $get_piree_cafe_n > 0 )
    {

      //=============================================================
      // 카페_URL
      $piree_cafe_url_s = PIREE_CAFE_MAIN_URL .'?piree_cafe_n='. $get_piree_cafe_n;

    }
    // 끝 => 피리_카페_번호__있으면
    //===============================================================


    //===============================================================
    // 넘겨주기____카페_URL
    return $piree_cafe_url_s;

  }
  ###################################################################
  # 끝 => 카페__파일__URL__알아내기
  ###################################################################



  ###################################################################
  # 시작 => 피리_카페__파일__URL__알아내기
  ###################################################################
  function get_piree_cafe_url($get_prog_n=0, $get_file_s='', $get_folder_sub_c='')
  {

    //===============================================================
    // 전역변수
    global $func_global_a;


    //===============================================================
    // 넘겨줄__값
    $return_var = '';


    //===============================================================
    // 파일_위치__알아내기_용__배열
    $put_var_a = array();
    $put_var_a['prog_n']     = $get_prog_n;
    $put_var_a['file_s']     = $get_file_s;
    $put_var_a['path_s']     = piree__path($piree_prog_a[770100]['num'], '');
    $put_var_a['folder_c']   = 'piree_cafe_';
    $put_var_a['folder_sub'] = $get_folder_sub_c;


    //===============================================================
    // 파일_위치__알아내기
    $return_var = file_path_get($put_var_a);


    //===============================================================
    // 넘겨주기____프로그램_경로
    return $return_var;

  }
  ###################################################################
  # 끝 => 피리_카페__파일__URL__알아내기
  ###################################################################



  ###################################################################
  # 시작 => 피리_카페__파일__경로__알아내기
  ###################################################################
  function get_piree_cafe_path($get_prog_n=0, $get_file_s='', $get_folder_sub_c='')
  {

    //===============================================================
    // 전역변수
    global $func_global_a;


    //===============================================================
    // 넘겨줄__값
    $return_var = '';


    //===============================================================
    // 파일_위치__알아내기_용__배열
    $put_var_a = array();
    $put_var_a['prog_n']     = $get_prog_n;
    $put_var_a['file_s']     = $get_file_s;
    $put_var_a['path_s']     = piree__path($piree_prog_a[770100]['num'], '');
    $put_var_a['folder_c']   = 'piree_cafe_';
    $put_var_a['folder_sub'] = $get_folder_sub_c;


    //===============================================================
    // 파일_위치__알아내기
    $return_var = file_path_get($put_var_a);


    //===============================================================
    // 넘겨주기____프로그램_경로
    return $return_var;

  }
  ###################################################################
  # 끝 => 피리_카페__파일__경로__알아내기
  ###################################################################



  ###################################################################
  # 시작 => 피리_카페__카페_코드_앳__알아내기
  ###################################################################
  function get_piree_cafe_domain($get_domain_s)
  {

    //===============================================================
    // 결과____피리_카페__카페_코드_앳_표시
    $domain_at_s = '';


    //===============================================================
    // 시작 => QUERY_STRING
    IF ( $get_domain_s )
    {

      //=============================================================
      // 피리_카페_URL
      $domain_at_s = '@'. $get_domain_s;

    }
    // 끝 => QUERY_STRING
    //===============================================================


    //===============================================================
    // 넘겨주기____피리_카페__카페_코드_앳_표시
    return $domain_at_s;

  }
  ###################################################################
  # 끝 => 피리_카페__카페_코드_앳__알아내기
  ###################################################################


#####################################################################
# 끝 => 피리_카페__관련
#####################################################################





#####################################################################
# 시작 => 피리_카페__회원__관련
#####################################################################


  ###################################################################
  # 시작 => 피리_카페__회원_정보__가져오기
  ###################################################################
  function get_piree_cafe_member_row($get_piree_cafe_n, $get_cafe_member_id)
  {

    //===============================================================
    // 넘겨줄____카페_회원_정보_배열
    $piree_cafe_member_a = array();


    //===============================================================
    // 시작 => 피리_카페_번호__있고____회원_아이디__있으면
    IF ( $get_piree_cafe_n > 0 && $get_cafe_member_id )
    {

      //=============================================================
      // 전역_변수
      global $piree;


      //=============================================================
      // 피리_카페_URL
      $sql_select  = "SELECT * FROM `". $piree['cafe_member'] ."` ";
      $sql_select .= "WHERE `cfml_cafe_n` = '". $get_piree_cafe_n ."' AND `cfml_mem_id` = '". $get_cafe_member_id ."'";
      $piree_cafe_member_a = sql_fetch($sql_select);

    }
    // 끝 => 피리_카페_번호__있고____회원_아이디__있으면
    //===============================================================


    //===============================================================
    // 넘겨주기____카페_회원_정보_배열
    return $piree_cafe_member_a;

  }
  ###################################################################
  # 끝 => 피리_카페__회원_정보__가져오기
  ###################################################################


#####################################################################
# 끝 => 피리_카페__회원__관련
#####################################################################





#####################################################################
# 시작 => 피리_카페__게시판__관련
#####################################################################


  ###################################################################
  # 시작 => 피리_카페__회원_정보__가져오기
  ###################################################################
  function go_piree_cafe_board($get_file_s='piree.cafe.board.php', $get_piree_cafe_n, $get_board_cate_n, $get_article_n=0, $get_comment_n=0)
  {

    //===============================================================
    // 전역_변수
    global $piree;
    global $piree_prog_a;


    //===============================================================
    // 넘겨줄____게시글_URL
    $return_article_url = '';


    //===============================================================
    // 시작 => 피리_카페_번호__있으면
    IF ( $get_piree_cafe_n > 0 )
    {

      //=============================================================
      // 사용한_파일
      $piree_cafe_board_file_a = array();
      $piree_cafe_board_file_a[] = 'piree.cafe.board.php';
      $piree_cafe_board_file_a[] = 'piree.cafe.board.write.php';
      $piree_cafe_board_file_a[] = 'piree.cafe.board.delete.php';
      $piree_cafe_board_file_a[] = 'piree.cafe.board.password.php';
      $piree_cafe_board_file_a[] = 'piree.cafe.board.move.php';
      $piree_cafe_board_file_a[] = 'piree.cafe.scrap.php';
      $piree_cafe_board_file_a[] = 'piree.cafe.scrap_popin.php';
      $piree_cafe_board_file_a[] = 'piree.cafe.board.good.php';
      $piree_cafe_board_file_a[] = 'piree.cafe.board.comment_delete.php';
      $piree_cafe_board_file_a[] = 'member.info.view.php';


      //=============================================================
      // 시작 => 파일_이름__검증
      IF ( !in_array($get_file_s, $piree_cafe_board_file_a) )
      {
        $get_file_s = 'piree.cafe.board.php';
      }
      // 끝 => 파일_이름__검증
      //=============================================================


      //=============================================================
      // 넘겨줄____게시글_URL
      $return_article_url  = piree__url($piree_prog_a[770100]['num'], $get_file_s) .'?';
      $return_article_url .= 'piree_cafe_n='. $get_piree_cafe_n;
      $return_article_url .= '&amp;bo_table='. $piree['cafe_board_code'];


      //=============================================================
      // 시작 => 게시판_분류_번호__있으면
      IF ( $get_board_cate_n > 0 )
      {

        //===========================================================
        // 넘겨줄____게시글_URL
        $return_article_url .= '&amp;board_cate_n='. $get_board_cate_n;

      }
      // 끝 => 게시판_분류_번호__있으면
      //=============================================================


      //=============================================================
      // 시작 => 게시글_번호__있으면
      IF ( $get_article_n > 0 )
      {

        //===========================================================
        // 넘겨줄____게시글_URL
        $return_article_url .= '&amp;wr_id='. $get_article_n;

      }
      // 끝 => 게시글_번호__있으면
      //=============================================================


      //=============================================================
      // 시작 => 댓글_번호__있으면
      IF ( $get_comment_n > 0 )
      {

        //===========================================================
        // 넘겨줄____게시글_URL
        $return_article_url .= '#c_'. $get_comment_n;

      }
      // 끝 => 댓글_번호__있으면
      //=============================================================

    }
    // 끝 => 피리_카페_번호__있으면
    //===============================================================


    //===============================================================
    // 넘겨주기____게시글_URL
    return $return_article_url;

  }
  ###################################################################
  # 끝 => 피리_카페__회원_정보__가져오기
  ###################################################################



  ###################################################################
  # 시작 => 게시판_검색__구문__가져오기
  ###################################################################
  function get_piree_cafe_sql_search($search_field, $search_text, $search_operator='and')
  {

    //===============================================================
    // 전역_변수
    global $g5;


    //===============================================================
    // 넘겨줄____검색_쿼리문_조건절
    $func_sql_where_s = "";


    //===============================================================
    // 검색어__다듬기
    $search_text = strip_tags(($search_text));
    $search_text = trim(stripslashes($search_text));


    //===============================================================
    // 시작 => 검색어__없으면
    IF ( !$search_text && $search_text !== '0' )
    {

      //=============================================================
      // 
      return '0';

    }
    // 끝 => 검색어__없으면
    //===============================================================


    //===============================================================
    // 시작 => 검색_쿼리문_조건절__있으면
    IF ( $func_sql_where_s )
    {

      //=============================================================
      // 검색_쿼리문_조건절
      $func_sql_where_s .= " AND ";

    }
    // 끝 => 검색_쿼리문_조건절__있으면
    //===============================================================


    //===============================================================
    // 외부_OPERATOR / 쿼리의_속도를__높이기_위하여__괄호는__최소화_한다
    $op1 = "";


    //===============================================================
    // 검색어를__구분자로_나눈다____여기서는_공백
    $s = array();
    $s = explode(" ", $search_text);


    //===============================================================
    // 검색필드를__구분자로_나눈다____여기서는_+
    $tmp = array();
    $tmp = explode(",", trim($search_field));


    //===============================================================
    // 칼럼__구분자_기준으로_배열로_나누기
    $field = explode("||", $tmp[0]);


    //===============================================================
    // 검색시__댓글_제외
    $not_comment = "";


    //===============================================================
    // 시작 => 검색_칼럼__2번째_없으면
    IF ( !empty($tmp[1]) )
    {
      //=============================================================
      // 검색시__댓글_제외
      $not_comment = $tmp[1];
    }
    // 끝 => 검색_칼럼__2번째_없으면
    //===============================================================


    //===============================================================
    // 검색_쿼리문_조건절
    $func_sql_where_s .= "(";


    //===============================================================
    // 시작 => 반복문____검색어_수__만큼
    FOR ( $loop_one_n=0; $loop_one_n<count($s); $loop_one_n++ )
    {

      //=============================================================
      // 검색어
      $search_str = trim($s[$loop_one_n]);


      //=============================================================
      // 시작 => 검색어__없으면
      IF ( $search_str == "" )
      {

        //===========================================================
        // 그냥_반복문_회차_통과
        continue;

      }
      // 끝 => 검색어__없으면
      //=============================================================


      //=============================================================
      // 인기_검색어__등록
      insert_popular($field, $search_str);


      //=============================================================
      // 검색_쿼리문_조건절
      $func_sql_where_s .= $op1;
      $func_sql_where_s .= "(";


      //=============================================================
      // 내부_OPERATOR
      $op2 = "";


      //=============================================================
      // 시작 => 반복문____다중_검색어_수__만큼
      FOR ( $loop_two_n=0; $loop_two_n<count($field); $loop_two_n++ )
      {

        //===========================================================
        // SQL_Injection__방지
        // 필드값에 a-z A-Z 0-9 _ , | 이외의 값이 있다면 검색필드를 wr_subject 로 설정한다.
        $field[$loop_two_n] = preg_match("/^[\w\,\|]+$/", $field[$loop_two_n]) ? strtolower($field[$loop_two_n]) : "wr_subject";


        //===========================================================
        // 검색_쿼리문_조건절
        $func_sql_where_s .= $op2;


        //===========================================================
        // 시작 => 칼럼__구분
        SWITCH ($field[$loop_two_n])
        {

          ###########################################################
          # 시작 => 회원_아이디
          CASE "mb_id" :

          BREAK;


          ###########################################################
          # 시작 => 회원_이름
          CASE "wr_name" :
            $func_sql_where_s .= " ". $field[$loop_two_n] ." = '". $s[$loop_one_n] ."' ";
          BREAK;


          ###########################################################
          # 시작 => 조회수
          CASE "wr_hit" :

          BREAK;



          ###########################################################
          # 시작 => 추천
          CASE "wr_good" :

          BREAK;



          ###########################################################
          # 시작 => 비추천
          CASE "wr_nogood" :
            $func_sql_where_s .= " ". $field[$loop_two_n] ." >= '". $s[$loop_one_n] ."' ";
          BREAK;



          ###########################################################
          # 시작 => 글_위치_번호?
          // 번호는__해당_검색어에_빼기1_을__곱함
          CASE "wr_num" :
            $func_sql_where_s .= " ". $field[$loop_two_n] ." = ". ((-1)*$s[$loop_one_n]);
          BREAK;



          ###########################################################
          # 시작 => 아이피
          CASE "wr_ip" :

          BREAK;



          ###########################################################
          # 시작 => 패스워드?
          // 항상_거짓
          CASE "wr_password" :
            $func_sql_where_s .= "1=0";
          BREAK;



          ###########################################################
          # LIKE_보다__INSTR_속도가__빠름
          DEFAULT :

            //=======================================================
            // 시작 => 검색어__알파벳_여부
            IF ( preg_match("/[a-zA-Z]/", $search_str) )
            {
              $func_sql_where_s .= "INSTR(LOWER(". $field[$loop_two_n] ."), LOWER('". $search_str ."'))";
            }
            ELSE
            {
              $func_sql_where_s .= "INSTR(". $field[$loop_two_n] .", '". $search_str ."')";
            }
            // 끝 => 검색어__알파벳_여부
            //=======================================================

          BREAK;

        }
        // 끝 => 칼럼__구분
        //===========================================================


        //===========================================================
        // 내부_OPERATOR
        $op2 = " OR ";

      }
      // 끝 => 반복문____다중_검색어_수__만큼
      //=============================================================


      //=============================================================
      // 검색_쿼리문_조건절
      $func_sql_where_s .= ")";


      //=============================================================
      // 외부_OPERATOR
      $op1 = " ". $search_operator ." ";

    }
    // 끝 => 반복문____검색어_수__만큼
    //===============================================================


    //===============================================================
    // 검색_쿼리문_조건절
    $func_sql_where_s .= " ) ";


    //===============================================================
    // 시작 => 댓글_검색__안하면
    IF ( $not_comment )
    {
      $func_sql_where_s .= " AND `wr_is_comment` = '0' ";
    }
    // 끝 => 댓글_검색__안하면
    //===============================================================


    //===============================================================
    // 넘겨주기____검색_쿼리문_조건절
    return $func_sql_where_s;

  }
  ###################################################################
  # 끝 => 게시판_검색__구문__가져오기
  ###################################################################



  ###################################################################
  # 시작 => 정렬_필드__가져오기
  ###################################################################
  function get_piree_cafe_board_sort_fields($board_cate_a=array(), $make_key_return='')
  {

    //===============================================================
    // 
    $bo_sort_fields = run_replace('get_board_sort_fields', array(
        array('wr_num, wr_reply', '기본'),
        array('wr_datetime asc', '날짜 이전것 부터'),
        array('wr_datetime desc', '날짜 최근것 부터'),
        array('wr_hit asc, wr_num, wr_reply', '조회수 낮은것 부터'),
        array('wr_hit desc, wr_num, wr_reply', '조회수 높은것 부터'),
        array('wr_last asc', '최근글 이전것 부터'),
        array('wr_last desc', '최근글 최근것 부터'),
        array('wr_comment asc, wr_num, wr_reply', '댓글수 낮은것 부터'),
        array('wr_comment desc, wr_num, wr_reply', '댓글수 높은것 부터'),
        array('wr_good asc, wr_num, wr_reply', '추천수 낮은것 부터'),
        array('wr_good desc, wr_num, wr_reply', '추천수 높은것 부터'),
        array('wr_nogood asc, wr_num, wr_reply', '비추천수 낮은것 부터'),
        array('wr_nogood desc, wr_num, wr_reply', '비추천수 높은것 부터'),
        array('wr_subject asc, wr_num, wr_reply', '제목 오름차순'),
        array('wr_subject desc, wr_num, wr_reply', '제목 내림차순'),
        array('wr_name asc, wr_num, wr_reply', '글쓴이 오름차순'),
        array('wr_name desc, wr_num, wr_reply', '글쓴이 내림차순'),
        array('ca_name asc, wr_num, wr_reply', '분류명 오름차순'),
        array('ca_name desc, wr_num, wr_reply', '분류명 내림차순'),
    ), $board_cate_a, $make_key_return);


    IF ( $make_key_return )
    {
        
      $returns = array();

      FOREACH( $bo_sort_fields as $v )
      {
        $key = preg_replace("/[\<\>\'\"\\\'\\\"\%\=\(\)\/\^\*\s]/", "", $v[0]);
        $returns[$key] = $v[0];
      }
        
      return $returns;

    }


    //===============================================================
    // 넘겨주기____정렬_필드
    return $bo_sort_fields;

  }
  ###################################################################
  # 끝 => 정렬_필드__가져오기
  ###################################################################



  ###################################################################
  # 시작 => 게시글_범위__쿼리문__가져오기
  ###################################################################
  function get_piree_cafe_article_count($func_cate_n, $func_cate_depth_n, $func_fd_c='wr_pi_board_cate_n')
  {

    //===============================================================
    // 전역_변수
    global $g5;


    //===============================================================
    // 넘겨줄____검색_쿼리문_조건절
    $func_sql_where_s = "";


    //===============================================================
    // 시작 => 카테고리_번호__있으면
    IF ( $func_cate_n > 0 )
    {

      //=============================================================
      // 시작 => 단계__구분
      SWITCH ( $func_cate_depth_n )
      {
        CASE 1 :     $func_sql_where_s .= "`". $func_fd_c ."` BETWEEN '". $func_cate_n ."' AND '". ($func_cate_n+99) ."'";     BREAK;
        CASE 2 :     $func_sql_where_s .= "`". $func_fd_c ."` = '". $func_cate_n ."'";                                        BREAK;
      }
      // 끝 => 단계__구분
      //=============================================================

    }
    // 끝 => 카테고리_번호__있으면
    //===============================================================


    //===============================================================
    // 넘겨주기____검색_쿼리문_조건절
    return $func_sql_where_s;

  }
  ###################################################################
  # 끝 => 게시글_범위__쿼리문__가져오기
  ###################################################################


#####################################################################
# 끝 => 피리_카페__게시판__관련
#####################################################################





#####################################################################
# 시작 => 피리_카페__게시판__최신글
#####################################################################


  ###################################################################
  # 시작 => 게시판_최신글__만들기
  ###################################################################
  function piree_cafe_latest_make($func_piree_cafe_n, $func_board_cate_n=0, $skin_dir='', $func_scale_n=10, $subject_len=40, $cache_time=1, $options='')
  {

    //===============================================================
    // 전역_변수
    global $g5;
    global $piree;
    global $piree_prog_a;
    global $piree_cafe_a;
    global $board_cate_list_a;
    global $piree_cafe_skin_latest_u;
    global $piree_cafe_skin_latest_p;


    //===============================================================
    // 시작 => 스킨_폴더__없으면__기본값_사용
    IF ( !$skin_dir )
    {
      $skin_dir = 'piree_basic';
    }
    // 끝 => 스킨_폴더__없으면__기본값_사용
    //===============================================================


    //===============================================================
    // 1시간으로_고정
    $time_unit = 3600;


    //===============================================================
    // 캐시_사용_여부____기본값__사용안함
    $caches = false;


    //===============================================================
    // 시작 => 그누보드5__캐시__사용_하면
    IF ( G5_USE_CACHE )
    {

      //=============================================================
      // 캐시_파일_이름
      $cache_file_name = "latest-". $func_piree_cafe_n ."-". $func_board_cate_n ."-". $skin_dir ."-". $func_scale_n ."-". $subject_len ."-". g5_cache_secret_key();


      //=============================================================
      // 
      $caches = g5_get_cache($cache_file_name, (int) $time_unit * (int) $cache_time);


      //=============================================================
      // 
      $cache_list = isset($caches['list']) ? $caches['list'] : array();


      //=============================================================
      // 
      piree_cafe_latest_cache_data($func_piree_cafe_n, $func_board_cate_n, $cache_list);

    }
    // 끝 => 그누보드5__캐시__사용_하면
    //===============================================================


    //===============================================================
    // 임시____캐시__사용_안함
    $caches = false;


    //===============================================================
    // 시작 => 캐시__사용__여부
    IF ( $caches === false )
    {

      ###############################################################
      # 시작 => 캐시__사용__안함
      ###############################################################

      //=============================================================
      // 최신글_자료__목록__배열
      $list = array();


      //=============================================================
      // 게시판_분류_정보__가져오기
      $func_board_cate_a = $board_cate_list_a[$func_board_cate_n];


      //=============================================================
      // 시작 => 게시판_분류_정보__배열__없으면____반환값_없음
      IF ( !$func_board_cate_a )
      {
        return '';
      }
      // 끝 => 게시판_분류_정보__배열__없으면____반환값_없음
      //=============================================================


      //=============================================================
      // 시작 => 게시판_분류_경로__유무
      IF ( $func_board_cate_a['bca_s_p'] )
      {

        //===========================================================
        // 게시판_분류__경로__이름
        $bca_cate_s = $func_board_cate_a['bca_s_p'];
        $bca_cate_s = str_replace('--', ' > ', $func_board_cate_a['bca_s_p']);
        $bca_cate_s = get_text($bca_cate_s);
        $bca_cate_s = trim($bca_cate_s);

      }
      ELSE
      {

        //===========================================================
        // 게시판_분류__이름
        $bca_cate_s = get_text($func_board_cate_a['bca_cate_s']);

      }
      // 끝 => 게시판_분류_경로__유무
      //=============================================================


      //=============================================================
      // 쿼리문_조건절__배열
      $sql_where_a = array();


      //=============================================================
      // 쿼리문_조건절__문자열
      $sql_where_s = "";


      //=============================================================
      // 쿼리문_조건절__배열____카페_구분
      $sql_where_a[] = "`wr_pi_piree_cafe_n` = '". $func_piree_cafe_n ."'";


      //=============================================================
      // 시작 => 게시판_분류_번호__있으면
      IF ( $func_board_cate_n > 0 )
      {

        //===========================================================
        // 카페_게시판_분류__SMALLINT_2단계__관련_파일__첨부
        include_once( piree__path($piree_prog_a[770000]['num'], 'cafe.board.category.smallint.2.lib.php') );


        //===========================================================
        // 상위_게시판_분류_번호__배열로__가져오기
        $temp_cate_a = get_category_upper_smallint2_cafe_board($func_board_cate_n);


        //===========================================================
        // 게시판_분류_단계
        $board_cate_depth_n = $temp_cate_a[0];


        //===========================================================
        // 시작 => 단계__구분
        SWITCH ( $board_cate_depth_n )
        {
          CASE 1 :     $sql_where_cafe_cate_where_s = "(`wr_pi_board_cate_n` BETWEEN '". $func_board_cate_n ."' AND '". ($func_board_cate_n+99) ."')";     BREAK;
          CASE 2 :     $sql_where_cafe_cate_where_s = "`wr_pi_board_cate_n` = '". $func_board_cate_n ."'";                                                 BREAK;
        }
        // 끝 => 단계__구분
        //===========================================================


        //===========================================================
        // 쿼리문_조건절__배열____게시판_분류_구분
        $sql_where_a[] = $sql_where_cafe_cate_where_s;

      }
      // 끝 => 게시판_분류_번호__있으면
      //=============================================================


      //=============================================================
      // 시작 => 쿼리문_조건절__배열__있으면
      IF ( count($sql_where_a) > 0 )
      {

        //===========================================================
        // 쿼리문_조건절__문자열
        $sql_where_s = implode(' AND ', $sql_where_a);

      }
      // 끝 => 게시판_분류_번호__있으면
      //=============================================================


      //=============================================================
      // 해당_게시글__목록__불러오기
      $sql_select  = "SELECT * FROM `". $piree['cafe_article'] ."` ";
      $sql_select .= "WHERE ". $sql_where_s ." AND `wr_is_comment` = '0' ";
      $sql_select .= "ORDER BY `wr_num` LIMIT 0, ". $func_scale_n;
      $result = sql_query($sql_select);


      //=============================================================
      // 시작 => 반복문____게시글_수__만큼
      FOR ( $loop_n=0; $row = sql_fetch_array($result); $loop_n++ )
      {

        //===========================================================
        // 시작 => 
        try
        {
          // 패스워드 저장 안함( 아예 삭제 )
          unset($row['wr_password']);
        }
        catch (Exception $e)
        {
        }
        // 끝 => 
        //===========================================================


        //===========================================================
        // 이메일__저장_안함
        $row['wr_email'] = '';


        //===========================================================
        // 시작 => 비밀글일_경우__내용_링크_파일__저장_안함
        IF ( strstr($row['wr_option'], 'secret') )
        {
          $row['wr_content'] = $row['wr_link1'] = $row['wr_link2'] = '';
          $row['file'] = array('count'=>0);
        }
        // 끝 => 비밀글일_경우__내용_링크_파일__저장_안함
        //===========================================================


        //===========================================================
        // 게시글_목록__배열
        $list[$loop_n] = get_list($row, $func_board_cate_a, $latest_skin_url, $subject_len);


        //===========================================================
        // 게시글_목록__배열____첫번째_썸네일_파일
        $list[$loop_n]['first_file_thumb'] = (isset($row['wr_file']) && $row['wr_file']) ? get_board_file_db($bca_table, $row['wr_id'], 'bf_file, bf_content', "and bf_type in (1, 2, 3, 18) ", true) : array('bf_file'=>'', 'bf_content'=>'');


        //===========================================================
        // 게시글_목록__배열____카페_이름
        $list[$loop_n]['cafe_name_s'] = $piree_cafe_a['cfml_cafe_s'];


        //===========================================================
        // 게시글_목록__배열____게시판_코드
        $list[$loop_n]['bo_table'] = $piree['cafe_board_code'];


        //===========================================================
        // 시작 => 썸네일__추가
        IF ( $options && is_string($options) )
        {

          $options_arr = explode(',', $options);
          $thumb_width = $options_arr[0];
          $thumb_height = $options_arr[1];
          $thumb = get_list_thumbnail($bca_table, $row['wr_id'], $thumb_width, $thumb_height, false, true);


          //=======================================================
          // 시작 => 이미지_썸네일__유무
          IF ( $thumb['src'] )
          {
            $img_content = '<img src="'. $thumb['src'].'" alt="'. $thumb['alt'].'" width="'. $thumb_width.'" height="'. $thumb_height.'">';
            $list[$loop_n]['img_thumbnail'] = '<a href="'. $list[$loop_n]['href'].'" class="lt_img">'. $img_content.'</a>';
          }
          ELSE
          {
            // $img_content = '<img src="'. G5_IMG_URL .'/no_img.png'.'" alt="'. $thumb['alt'].'" width="'. $thumb_width.'" height="'. $thumb_height.'" class="no_img">';
          }
          // 끝 => 이미지_썸네일__유무
          //=======================================================

        }
        // 끝 => 썸네일__추가
        //===========================================================


        //===========================================================
        // 시작 => 아이콘_파일__없으면
        IF ( !isset($list[$loop_n]['icon_file']) )
        {
          $list[$loop_n]['icon_file'] = '';
        }
        // 끝 => 아이콘_파일__없으면
        //===========================================================

      }
      // 끝 => 반복문____게시글_수__만큼
      //=============================================================


      //=============================================================
      // 
      piree_cafe_latest_cache_data($func_piree_cafe_n, $func_board_cate_n, $list);


      //=============================================================
      // 시작 => 
      IF ( G5_USE_CACHE )
      {

        //===========================================================
        // 
        $caches = array(
                        'list' => $list,
                        'bca_cate_s' => sql_escape_string($bca_cate_s),
                        'piree_cafe_n' => $func_piree_cafe_n,
                        'board_cate_n' => $func_board_cate_n,
                        'board_cate_depth_n' => $board_cate_depth_n
                        );


        //===========================================================
        // 
        g5_set_cache($cache_file_name, $caches, (int) $time_unit * (int) $cache_time);

      }
      // 끝 => 
      //=============================================================

    }
    ELSE
    {

      ###############################################################
      # 시작 => 캐시__사용__함
      ###############################################################

      //=============================================================
      // 
      $list = $cache_list;


      //=============================================================
      // 
      $bca_cate_s = (is_array($caches) && isset($caches['bca_cate_s'])) ? $caches['bca_cate_s'] : '';

    }
    // 끝 => 캐시__사용__여부
    //===============================================================


    //===============================================================
    // 출력_버퍼링__시작
    ob_start();


    //===============================================================
    // 스킨_파일__첨부
    include $piree_cafe_skin_latest_p .'/latest.skin.php';


    //===============================================================
    // 출력_버퍼링_에__내용__저장
    $content = ob_get_contents();


    //===============================================================
    // 출력_버퍼링__비우기
    ob_end_clean();


    //===============================================================
    // 넘겨주기____최신글_내용
    return $content;

  }
  ###################################################################
  # 끝 => 게시글_범위__쿼리문__가져오기
  ###################################################################



  ###################################################################
  # 시작 => 게시판_최신글__CACHE_DATA
  ###################################################################
  function piree_cafe_latest_cache_data($func_piree_cafe_n, $func_board_cate_n=0, $cache_list=array(), $find_wr_id=0)
  {

    static $cache = array();

    IF ( $bo_table && $cache_list && ! isset($cache[$bo_table]) )
    {

      FOREACH( (array) $cache_list as $wr )
      {

        IF ( empty($wr) || ! isset($wr['wr_id']) )
        {
          continue;
        }

        $cache[$bo_table][$wr['wr_id']] = $wr;

      }

    }

    IF ( $find_wr_id && isset($cache[$bo_table][$find_wr_id]) )
    {
      return $cache[$bo_table][$find_wr_id];
    }

  }
  ###################################################################
  # 끝 => 게시판_최신글__CACHE_DATA
  ###################################################################


#####################################################################
# 끝 => 피리_카페__게시판__최신글
#####################################################################





#####################################################################
# 시작 => 피리_카페__파일__관련
#####################################################################


  ###################################################################
  # 시작 => 스킨_파일_경로__불러오기
  ###################################################################
  function get_cafe_skin_file($func_schema_c='path', $func_div_c, $func_skin_file_s='', $func_device_c='')
  {

    //===============================================================
    // 전역_변수
    global $piree_prog_a;
    global $piree_cafe_a;
    global $p770100__prog_u;
    global $p770100__prog_p;


    //===============================================================
    // 시작 => 파일_이름__없으면
    IF ( !$func_skin_file_s )
    {

      // 
      alert("불러오려는 파일 이름이 없습니다.");
    }
    // 끝 => 파일_이름__없으면
    //===============================================================


    //===============================================================
    // 스킨_파일_있는지_여부
    $skin_file_exist_n = 0;


    //===============================================================
    // 개별_카페___게시판_스킨
    $piree_cafe_skin_c = '';
    $piree_cafe_skin_u = '';
    $piree_cafe_skin_p = '';


    //===============================================================
    // 시작 => 스킨_분류__구분
    SWITCH ( $func_div_c )
    {

      ###############################################################
      # 시작 => 카페_관리_스킨
      ###############################################################
      CASE 'manage' :

        //===========================================================
        // 시작 => DEVICE__구분
        IF ( G5_IS_MOBILE && $func_device_c != 'pc' )
        {

          ###########################################################
          # 시작 => DEVIDE__모바일__이면
          ###########################################################

/*

          //=========================================================
          // 스킨__값
          $piree_cafe_skin_mo_c = $piree_cafe_a['cafe_skin_manage_mo_c'];


          //=========================================================
          // 스킨__PATH
          $piree_cafe_skin_mo_p = PIREE_CAFE_MANAGE_PATH ."/". PIREE_CAFE_SKIN_MANAGE_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;


          //=========================================================
          // 시작 => 스킨_파일__있으면
          // IF ( file_exists($piree_cafe_skin_mo_p) )
          // IF ( is_dir($piree_cafe_skin_mo_p) )
          IF ( file_exists($piree_cafe_skin_mo_p) )
          {

            #########################################################
            # 시작 => 스킨_파일__있으면

            //=======================================================
            // 스킨__URL
            $piree_cafe_skin_mo_u = PIREE_CAFE_MANAGE_URL ."/". PIREE_CAFE_SKIN_MANAGE_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;


            //=======================================================
            // 스킨_파일_있는지_여부____있다
            $skin_file_exist_n++;

          }
          ELSE
          {

            #########################################################
            # 시작 => 스킨_파일__없으면

            //=======================================================
            // 스킨__값
            $piree_cafe_skin_mo_c = $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_manage_mo_c'];


            //=======================================================
            // 스킨__PATH
            $piree_cafe_skin_mo_p = PIREE_CAFE_MANAGE_PATH ."/". PIREE_CAFE_SKIN_MANAGE_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;


            //=======================================================
            // 시작 => 스킨_파일__있으면
            // IF ( file_exists($piree_cafe_skin_mo_p) )
            // IF ( is_dir($piree_cafe_skin_mo_p) )
            IF ( file_exists($piree_cafe_skin_mo_p) )
            {

              //=====================================================
              // 스킨__URL
              $piree_cafe_skin_mo_u = PIREE_CAFE_MANAGE_URL ."/". PIREE_CAFE_SKIN_MANAGE_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;


              //=====================================================
              // 스킨_파일_있는지_여부____있다
              $skin_file_exist_n++;

            }
            // 끝 => 스킨_파일__있으면
            //=======================================================

          }
          // 끝 => 스킨_파일__있으면
          //=========================================================


          //=========================================================
          // 시작 => 스킨_파일_있는지_여부____있다
          IF ( $skin_file_exist_n > 0 )
          {

            //=======================================================
            // 개별_카페___게시판_스킨__모바일_스킨
            $piree_cafe_skin_c = $piree_cafe_skin_mo_c;
            $piree_cafe_skin_u = $piree_cafe_skin_mo_u;
            $piree_cafe_skin_p = $piree_cafe_skin_mo_p;

          }
          // 끝 => 스킨_파일_있는지_여부____있다
          //=========================================================

*/

          //=========================================================
          // 스킨__값
          $piree_cafe_skin_pc_c = $piree_cafe_a['cafe_skin_manage_pc_c'];


          //=========================================================
          // 스킨__PATH
          $piree_cafe_skin_pc_p = PIREE_CAFE_MANAGE_PATH ."/". PIREE_CAFE_SKIN_MANAGE_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;


          //=========================================================
          // 시작 => 스킨_파일__있으면
          // IF ( file_exists($piree_cafe_skin_pc_p) )
          // IF ( is_dir($piree_cafe_skin_pc_p) )
          IF ( file_exists($piree_cafe_skin_pc_p) )
          {

            #########################################################
            # 시작 => 스킨_파일__있으면

            //=======================================================
            // 스킨__URL
            $piree_cafe_skin_pc_u = PIREE_CAFE_MANAGE_URL ."/". PIREE_CAFE_SKIN_MANAGE_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;


            //=======================================================
            // 스킨_파일_있는지_여부____있다
            $skin_file_exist_n++;

          }
          ELSE
          {

            #########################################################
            # 시작 => 스킨_파일__없으면

            //=======================================================
            // 스킨__값
            $piree_cafe_skin_pc_c = $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_manage_pc_c'];


            //=======================================================
            // 스킨__PATH
            $piree_cafe_skin_pc_p = PIREE_CAFE_MANAGE_PATH ."/". PIREE_CAFE_SKIN_MANAGE_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;


            //=======================================================
            // 시작 => 스킨_파일__있으면
            // IF ( file_exists($piree_cafe_skin_pc_p) )
            // IF ( is_dir($piree_cafe_skin_pc_p) )
            IF ( file_exists($piree_cafe_skin_pc_p) )
            {

              //=====================================================
              // 스킨__URL
              $piree_cafe_skin_pc_u = PIREE_CAFE_MANAGE_URL ."/". PIREE_CAFE_SKIN_MANAGE_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;


              //=====================================================
              // 스킨_파일_있는지_여부____있다
              $skin_file_exist_n++;

            }
            // 끝 => 스킨_파일__있으면
            //=======================================================

          }
          // 끝 => 스킨_파일__있으면
          //=========================================================


          //=========================================================
          // 시작 => 스킨_파일_있는지_여부____있다
          IF ( $skin_file_exist_n > 0 )
          {

            //=======================================================
            // 개별_카페___게시판_스킨__모바일_스킨
            $piree_cafe_skin_c = $piree_cafe_skin_pc_c;
            $piree_cafe_skin_u = $piree_cafe_skin_pc_u;
            $piree_cafe_skin_p = $piree_cafe_skin_pc_p;

          }
          // 끝 => 스킨_파일_있는지_여부____있다
          //=========================================================

          ###########################################################
          # 끝 => DEVIDE__모바일__이면
          ###########################################################

        }
        ELSE
        {

          ###########################################################
          # 시작 => DEVIDE__PC__이면
          ###########################################################

          //=========================================================
          // 스킨__값
          $piree_cafe_skin_pc_c = $piree_cafe_a['cafe_skin_manage_pc_c'];


          //=========================================================
          // 스킨__PATH
          $piree_cafe_skin_pc_p = PIREE_CAFE_MANAGE_PATH ."/". PIREE_CAFE_SKIN_MANAGE_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;


          //=========================================================
          // 시작 => 스킨_파일__있으면
          // IF ( file_exists($piree_cafe_skin_pc_p) )
          // IF ( is_dir($piree_cafe_skin_pc_p) )
          IF ( file_exists($piree_cafe_skin_pc_p) )
          {

            #########################################################
            # 시작 => 스킨_파일__있으면

            //=======================================================
            // 스킨__URL
            $piree_cafe_skin_pc_u = PIREE_CAFE_MANAGE_URL ."/". PIREE_CAFE_SKIN_MANAGE_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;


            //=======================================================
            // 스킨_파일_있는지_여부____있다
            $skin_file_exist_n++;

          }
          ELSE
          {

            #########################################################
            # 시작 => 스킨_파일__없으면

            //=======================================================
            // 스킨__값
            $piree_cafe_skin_pc_c = $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_manage_pc_c'];


            //=======================================================
            // 스킨__PATH
            $piree_cafe_skin_pc_p = PIREE_CAFE_MANAGE_PATH ."/". PIREE_CAFE_SKIN_MANAGE_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;


            //=======================================================
            // 시작 => 스킨_파일__있으면
            // IF ( file_exists($piree_cafe_skin_pc_p) )
            // IF ( is_dir($piree_cafe_skin_pc_p) )
            IF ( file_exists($piree_cafe_skin_pc_p) )
            {

              //=====================================================
              // 스킨__URL
              $piree_cafe_skin_pc_u = PIREE_CAFE_MANAGE_URL ."/". PIREE_CAFE_SKIN_MANAGE_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;


              //=====================================================
              // 스킨_파일_있는지_여부____있다
              $skin_file_exist_n++;

            }
            // 끝 => 스킨_파일__있으면
            //=======================================================

          }
          // 끝 => 스킨_파일__있으면
          //=========================================================


          //=========================================================
          // 시작 => 스킨_파일_있는지_여부____있다
          IF ( $skin_file_exist_n > 0 )
          {

            //=======================================================
            // 개별_카페___게시판_스킨__모바일_스킨
            $piree_cafe_skin_c = $piree_cafe_skin_pc_c;
            $piree_cafe_skin_u = $piree_cafe_skin_pc_u;
            $piree_cafe_skin_p = $piree_cafe_skin_pc_p;

          }
          // 끝 => 스킨_파일_있는지_여부____있다
          //=========================================================

          ###########################################################
          # 끝 => DEVIDE__PC__이면
          ###########################################################

        }
        // 끝 => DEVICE__구분
        //===========================================================

      BREAK;
      ###############################################################
      # 끝 => 카페_관리_스킨
      ###############################################################



      ###############################################################
      # 시작 => 게시판
      ###############################################################
      CASE 'board' :

        //===========================================================
        // 시작 => DEVICE__구분
        IF ( G5_IS_MOBILE && $func_device_c != 'pc' )
        {

          ###########################################################
          # 시작 => DEVIDE__모바일__이면
          ###########################################################

          //=========================================================
          // 스킨__값
          $piree_cafe_skin_mo_c = $piree_cafe_a['cafe_skin_board_mo_c'];


          //=========================================================
          // 스킨__PATH
          $piree_cafe_skin_mo_p = $p770100__prog_p . PIREE_CAFE_SKIN_BOARD_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;


          //=========================================================
          // 시작 => 스킨_파일__있으면
          // IF ( file_exists($piree_cafe_skin_mo_p) )
          // IF ( is_dir($piree_cafe_skin_mo_p) )
          IF ( file_exists($piree_cafe_skin_mo_p) )
          {

            #########################################################
            # 시작 => 스킨_파일__있으면

            //=======================================================
            // 스킨__URL
            $piree_cafe_skin_mo_u = $p770100__prog_u . PIREE_CAFE_SKIN_BOARD_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;


            //=======================================================
            // 스킨_파일_있는지_여부____있다
            $skin_file_exist_n++;

          }
          ELSE
          {

            #########################################################
            # 시작 => 스킨_파일__없으면

            //=======================================================
            // 스킨__값
            $piree_cafe_skin_mo_c = $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_board_mo_c'];


            //=======================================================
            // 스킨__PATH
            $piree_cafe_skin_mo_p = $p770100__prog_p . PIREE_CAFE_SKIN_BOARD_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;


            //=======================================================
            // 시작 => 스킨_파일__있으면
            // IF ( file_exists($piree_cafe_skin_mo_p) )
            // IF ( is_dir($piree_cafe_skin_mo_p) )
            IF ( file_exists($piree_cafe_skin_mo_p) )
            {

              //=====================================================
              // 스킨__URL
              $piree_cafe_skin_mo_u = $p770100__prog_u . PIREE_CAFE_SKIN_BOARD_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;


              //=====================================================
              // 스킨_파일_있는지_여부____있다
              $skin_file_exist_n++;

            }
            // 끝 => 스킨_파일__있으면
            //=======================================================

          }
          // 끝 => 스킨_파일__있으면
          //=========================================================


          //=========================================================
          // 시작 => 스킨_파일_있는지_여부____있다
          IF ( $skin_file_exist_n > 0 )
          {

            //=======================================================
            // 개별_카페___게시판_스킨__모바일_스킨
            $piree_cafe_skin_c = $piree_cafe_skin_mo_c;
            $piree_cafe_skin_u = $piree_cafe_skin_mo_u;
            $piree_cafe_skin_p = $piree_cafe_skin_mo_p;

          }
          // 끝 => 스킨_파일_있는지_여부____있다
          //=========================================================

          ###########################################################
          # 끝 => DEVIDE__모바일__이면
          ###########################################################

        }
        ELSE
        {

          ###########################################################
          # 시작 => DEVIDE__PC__이면
          ###########################################################

          //=========================================================
          // 스킨__값
          $piree_cafe_skin_pc_c = $piree_cafe_a['cafe_skin_board_pc_c'];


          //=========================================================
          // 스킨__PATH
          $piree_cafe_skin_pc_p = $p770100__prog_p . PIREE_CAFE_SKIN_BOARD_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;


          //=========================================================
          // 시작 => 스킨_파일__있으면
          // IF ( file_exists($piree_cafe_skin_pc_p) )
          // IF ( is_dir($piree_cafe_skin_pc_p) )
          IF ( file_exists($piree_cafe_skin_pc_p) )
          {

            #########################################################
            # 시작 => 스킨_파일__있으면

            //=======================================================
            // 스킨__URL
            $piree_cafe_skin_pc_u = $p770100__prog_u . PIREE_CAFE_SKIN_BOARD_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;


            //=======================================================
            // 스킨_파일_있는지_여부____있다
            $skin_file_exist_n++;

          }
          ELSE
          {

            #########################################################
            # 시작 => 스킨_파일__없으면

            //=======================================================
            // 스킨__값
            $piree_cafe_skin_pc_c = $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_board_pc_c'];


            //=======================================================
            // 스킨__PATH
            $piree_cafe_skin_pc_p = $p770100__prog_p . PIREE_CAFE_SKIN_BOARD_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;


            //=======================================================
            // 시작 => 스킨_파일__있으면
            // IF ( file_exists($piree_cafe_skin_pc_p) )
            // IF ( is_dir($piree_cafe_skin_pc_p) )
            IF ( file_exists($piree_cafe_skin_pc_p) )
            {

              //=====================================================
              // 스킨__URL
              $piree_cafe_skin_pc_u = $p770100__prog_u . PIREE_CAFE_SKIN_BOARD_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;


              //=====================================================
              // 스킨_파일_있는지_여부____있다
              $skin_file_exist_n++;

            }
            // 끝 => 스킨_파일__있으면
            //=======================================================

          }
          // 끝 => 스킨_파일__있으면
          //=========================================================


          //=========================================================
          // 시작 => 스킨_파일_있는지_여부____있다
          IF ( $skin_file_exist_n > 0 )
          {

            //=======================================================
            // 개별_카페___게시판_스킨__모바일_스킨
            $piree_cafe_skin_c = $piree_cafe_skin_pc_c;
            $piree_cafe_skin_u = $piree_cafe_skin_pc_u;
            $piree_cafe_skin_p = $piree_cafe_skin_pc_p;

          }
          // 끝 => 스킨_파일_있는지_여부____있다
          //=========================================================

          ###########################################################
          # 끝 => DEVIDE__PC__이면
          ###########################################################

        }
        // 끝 => DEVICE__구분
        //===========================================================

      BREAK;
      ###############################################################
      # 끝 => 게시판
      ###############################################################



      ###############################################################
      # 시작 => 최신글_스킨
      ###############################################################
      CASE 'latest' :

        //===========================================================
        // 


        //===========================================================
        // 

      BREAK;
      ###############################################################
      # 끝 => 최신글_스킨
      ###############################################################



      ###############################################################
      # 시작 => 기본_스킨
      ###############################################################
      # CASE 'basic' :
      DEFAULT :

        //===========================================================
        // 시작 => DEVICE__구분
        IF ( G5_IS_MOBILE && $func_device_c != 'pc' )
        {

          ###########################################################
          # 시작 => DEVIDE__모바일__이면
          ###########################################################

          //=========================================================
          // 스킨__값
          $piree_cafe_skin_mo_c = $piree_cafe_a['cafe_skin_basic_mo_c'];


          //=========================================================
          // 스킨__PATH
          $piree_cafe_skin_mo_p = $p770100__prog_p . PIREE_CAFE_SKIN_BASIC_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;


          //=========================================================
          // 시작 => 스킨_파일__있으면
          // IF ( file_exists($piree_cafe_skin_mo_p) )
          // IF ( is_dir($piree_cafe_skin_mo_p) )
          IF ( file_exists($piree_cafe_skin_mo_p) )
          {

            #########################################################
            # 시작 => 스킨_파일__있으면

            //=======================================================
            // 스킨__URL
            $piree_cafe_skin_mo_u = $p770100__prog_u . PIREE_CAFE_SKIN_BASIC_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;


            //=======================================================
            // 스킨_파일_있는지_여부____있다
            $skin_file_exist_n++;

          }
          ELSE
          {

            #########################################################
            # 시작 => 스킨_파일__없으면

            //=======================================================
            // 스킨__값
            $piree_cafe_skin_mo_c = $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_basic_mo_c'];


            //=======================================================
            // 스킨__PATH
            $piree_cafe_skin_mo_p = $p770100__prog_p . PIREE_CAFE_SKIN_BASIC_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;


            //=======================================================
            // 시작 => 스킨_파일__있으면
            // IF ( file_exists($piree_cafe_skin_mo_p) )
            // IF ( is_dir($piree_cafe_skin_mo_p) )
            IF ( file_exists($piree_cafe_skin_mo_p) )
            {

              //=====================================================
              // 스킨__URL
              $piree_cafe_skin_mo_u = $p770100__prog_u . PIREE_CAFE_SKIN_BASIC_MO_DIR ."/". $piree_cafe_skin_mo_c ."/". $func_skin_file_s;


              //=====================================================
              // 스킨_파일_있는지_여부____있다
              $skin_file_exist_n++;

            }
            // 끝 => 스킨_파일__있으면
            //=======================================================

          }
          // 끝 => 스킨_파일__있으면
          //=========================================================


          //=========================================================
          // 시작 => 스킨_파일_있는지_여부____있다
          IF ( $skin_file_exist_n > 0 )
          {

            //=======================================================
            // 개별_카페___게시판_스킨__모바일_스킨
            $piree_cafe_skin_c = $piree_cafe_skin_mo_c;
            $piree_cafe_skin_u = $piree_cafe_skin_mo_u;
            $piree_cafe_skin_p = $piree_cafe_skin_mo_p;

          }
          // 끝 => 스킨_파일_있는지_여부____있다
          //=========================================================

          ###########################################################
          # 끝 => DEVIDE__모바일__이면
          ###########################################################

        }
        ELSE
        {

          ###########################################################
          # 시작 => DEVIDE__PC__이면
          ###########################################################

          //=========================================================
          // 스킨__값
          $piree_cafe_skin_pc_c = $piree_cafe_a['cafe_skin_basic_pc_c'];


          //=========================================================
          // 스킨__PATH
          $piree_cafe_skin_pc_p = $p770100__prog_p . PIREE_CAFE_SKIN_BASIC_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;


          //=========================================================
          // 시작 => 스킨_파일__있으면
          // IF ( file_exists($piree_cafe_skin_pc_p) )
          // IF ( is_dir($piree_cafe_skin_pc_p) )
          IF ( file_exists($piree_cafe_skin_pc_p) )
          {

            #########################################################
            # 시작 => 스킨_파일__있으면

            //=======================================================
            // 스킨__URL
            $piree_cafe_skin_pc_u = $p770100__prog_u . PIREE_CAFE_SKIN_BASIC_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;


            //=======================================================
            // 스킨_파일_있는지_여부____있다
            $skin_file_exist_n++;

          }
          ELSE
          {

            #########################################################
            # 시작 => 스킨_파일__없으면

            //=======================================================
            // 스킨__값
            $piree_cafe_skin_pc_c = $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_basic_pc_c'];


            //=======================================================
            // 스킨__PATH
            $piree_cafe_skin_pc_p = $p770100__prog_p . PIREE_CAFE_SKIN_BASIC_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;


            //=======================================================
            // 시작 => 스킨_파일__있으면
            // IF ( file_exists($piree_cafe_skin_pc_p) )
            // IF ( is_dir($piree_cafe_skin_pc_p) )
            IF ( file_exists($piree_cafe_skin_pc_p) )
            {

              //=====================================================
              // 스킨__URL
              $piree_cafe_skin_pc_u = $p770100__prog_u . PIREE_CAFE_SKIN_BASIC_PC_DIR ."/". $piree_cafe_skin_pc_c ."/". $func_skin_file_s;


              //=====================================================
              // 스킨_파일_있는지_여부____있다
              $skin_file_exist_n++;

            }
            // 끝 => 스킨_파일__있으면
            //=======================================================

          }
          // 끝 => 스킨_파일__있으면
          //=========================================================


          //=========================================================
          // 시작 => 스킨_파일_있는지_여부____있다
          IF ( $skin_file_exist_n > 0 )
          {

            //=======================================================
            // 개별_카페___게시판_스킨__모바일_스킨
            $piree_cafe_skin_c = $piree_cafe_skin_pc_c;
            $piree_cafe_skin_u = $piree_cafe_skin_pc_u;
            $piree_cafe_skin_p = $piree_cafe_skin_pc_p;

          }
          // 끝 => 스킨_파일_있는지_여부____있다
          //=========================================================

          ###########################################################
          # 끝 => DEVIDE__PC__이면
          ###########################################################

        }
        // 끝 => DEVICE__구분
        //===========================================================

      BREAK;
      ###############################################################
      # 끝 => 기본_스킨
      ###############################################################

    }
    // 끝 => 스킨_폴더__없으면__기본값_사용
    //===============================================================


    //===============================================================
    // 시작 => 가져_오려는__정보
    SWITCH ( $func_schema_c )
    {

      ###############################################################
      # 시작 => PATH
      CASE 'path' :

        //===========================================================
        // 넘겨주기____PATH
        return $piree_cafe_skin_p;

      BREAK;


      ###############################################################
      # 시작 => URL
      CASE 'url' :

        //===========================================================
        // 넘겨주기____URL
        return $piree_cafe_skin_u;

      BREAK;


      ###############################################################
      # 시작 => 배열
      DEFAULT :

        //===========================================================
        // 넘겨줄____배열
        $return_a = array();
        $return_a['url']  = $piree_cafe_skin_u;
        $return_a['path'] = $piree_cafe_skin_p;


        //===========================================================
        // 넘겨주기____배열
        return $return_a;

      BREAK;

    }
    // 끝 => 가져_오려는__정보
    //===============================================================

  }
  ###################################################################
  # 끝 => 스킨_파일_경로__불러오기
  ###################################################################



  ###################################################################
  # 시작 => 
  ###################################################################
  ###################################################################
  # 끝 => 
  ###################################################################


#####################################################################
# 끝 => 피리_카페__게시판__최신글
#####################################################################





#####################################################################
# 시작 => 함수
#####################################################################


  ###################################################################
  # 시작 => 
  ###################################################################

    //===============================================================
    // 전역변수
    // global $piree;


    //===============================================================
    // 


    //===============================================================
    // 시작 => 

      //=============================================================
      // 


      //=============================================================
      // 

    // 끝 => 
    //===============================================================


    //===============================================================
    // 

  ###################################################################
  # 끝 => 
  ###################################################################



  ###################################################################
  # 시작 => 피리_카페_자료별_테이블_번호_이름__알아내기
  ###################################################################
  function piree_cafe_table_get($func_piree_cafe_n=0, $func_table_n=0)
  {

    //===============================================================
    // 시작 => 자료_번호__테이블_번호__둘다__있으면
    IF ( $func_piree_cafe_n > 0 || $func_table_n > 0 )
    {

      //=============================================================
      // 전역변수
      global $piree;


      //=============================================================
      // 넘겨줄_테이블_정보
      $table_info_a['table_n'] = 0;
      $table_info_a['table_c'] = '';


      //=============================================================
      // 시작 => 자료_번호__테이블_번호__조건_확인
      IF ( $func_piree_cafe_n > 0 )
      {
        $table_info_a['table_n'] = ceil($func_piree_cafe_n/$piree['lindex_data_div_n']);
      }
      ELSE
      {
        $table_info_a['table_n'] = $func_table_n;
      }
      // 끝 => 자료_번호__테이블_번호__조건_확인
      //=============================================================


      //=============================================================
      // 테이블_코드
      $table_info_a['table_c'] = $piree['cafe'] .'_'. $table_info_a['table_n'];


      //=============================================================
      // 넘겨주기
      return $table_info_a;

    }
    // 끝 => 자료_번호__테이블_번호__둘다__있으면
    //===============================================================

  }
  ###################################################################
  # 끝 => 피리_카페_자료별_테이블_번호_이름__알아내기
  ###################################################################


#####################################################################
# 끝 => 함수
#####################################################################





#####################################################################
# 시작 => 피리_NETT__설정_정보__가져오기____함수형
#####################################################################


  ###################################################################
  # 시작 => 피리_프로그램_정보__가져오는__함수
  ###################################################################
  function get__prog_info__770100($func_prog_version_s)
  {

      //=============================================================
      // 전역_변수
      global $piree, $piree_prog_a, $prog_config_page;


      //=============================================================
      // 넘겨줄__배열_변수
      $prog_info = array();


      //=============================================================
      // 시작 => 피리_프로그램_번호__있으면
      IF ( $piree_prog_a[770100]['num'] > 0 )
      {

          //=========================================================
          // 피리_프로그램_정보__가져오기
          $sql_select  = "SELECT * FROM `". $piree['program_sam'] ."` ";
          $sql_select .= "WHERE `pgs_prog_n` = '". $piree_prog_a[770100]['num'] ."' AND `pgs_version_s` = '". $func_prog_version_s ."'";
          $row = sql_fetch($sql_select, false);


          //=========================================================
          // 시작 => 칼럼__없으면
          IF ( !isset($row['pgs_prog_n'] ))
          {

              //=====================================================
              // 외부_상수_변수
              global $is_admin, $is_extend;


              //=====================================================
              // 시작 => 운영자_일반회원__여부
              IF ( $is_admin)
              {

                  ###################################################
                  # 시작 => 운영자__이면

                  //=================================================
                  // 시작 => 설정_화면__아니면
                  IF ( $prog_config_page != 1 && $is_extend == 0 )
                  {

                      // 이동할_페이지
                      $move_url = piree__admin_url($piree_prog_a[770100]['num']);

                      // 에러_알림
                      alert("선택하신 프로그램이 설치되지 않았거나 DB정보가 없습니다. 770100", $move_url);

                  }
                  // 끝 => 설정_화면__아니면
                  //=================================================

              }
              ELSE
              {

                  ###################################################
                  # 시작 => 일반회원__이면

                  //=================================================
                  // 시작 => EXTEND__아니면
                  IF ( $is_extend == 0 )
                  {

                      // 에러_알림
                      // alert("선택하신 프로그램이 설치되지 않았거나 DB정보가 없습니다. 770100", G5_DOMAIN);

                  }
                  // 끝 => EXTEND__아니면
                  //=================================================

              }
              // 끝 => 운영자_일반회원__여부
              //=====================================================

          }
          // 끝 => 칼럼__없으면
          //=========================================================


          //=========================================================
          // 시작 => 피리_프로그램_번호__맞으면
          IF ( $piree_prog_a[770100]['num'] == $row['pgs_prog_n'] )
          {

              //=====================================================
              // 피리_프로그램_정보__배열
              $prog_info = $row;

          }
          // 끝 => 피리_프로그램_번호__맞으면
          //=========================================================

      }
      // 끝 => 피리_프로그램_번호__있으면
      //=============================================================


      //=============================================================
      // 피리_프로그램_정보
      return $prog_info;

  }
  ###################################################################
  # 끝 => 피리_프로그램_정보__가져오는__함수
  ###################################################################



  ###################################################################
  # 시작 => 피리_카페_관리__설정_정보__가져오는__함수
  ###################################################################
  function get__piree_cafe__config($func_prog_version_s)
  {

      //=============================================================
      // 전역_변수
      global $piree, $nett_prog_n, $get__p770000_conf;


      //=============================================================
      // 시작 => 피리_프로그램__테이블__유무
      IF ( isset($piree['program_sam'] ) && $get__p770000_conf == 1 )
      {

          //=========================================================
          // 피리_프로그램_정보__가져오기
          $prog_conf = get__prog_info($nett_prog_n, $func_prog_version_s);

      }
      ELSE
      {

          //=========================================================
          // 피리_프로그램_정보__가져오기
          $prog_conf = get__prog_info__770100($func_prog_version_s);

      }
      // 끝 => 피리_프로그램__테이블__유무
      //=============================================================


      //=============================================================
      // 프로그램_번호
      $prog_conf['g_program_n'] = $nett_prog_n;


      //=============================================================
      // 피리_카페_관리___설정
      // 넘겨줄_변수
      return $prog_conf;

  }
  ###################################################################
  # 끝 => 피리_카페_관리__설정_정보__가져오는__함수
  ###################################################################



  ###################################################################
  # 시작 => 피리_카페_관리__설정_정보__가져오기
  ###################################################################

  //=================================================================
  // 피리_카페_관리___사용여부
  // 0 - 안함
  // 1 - 사용함
  $use__p770100 = 0;


  //=================================================================
  // 시작 => 설정_정보__가져오기__이면
  IF ( $get__p770100 == 1 )
  {

      //=============================================================
      // 피리_카페_관리__정보__가져오기
      $prog_conf = get__piree_cafe__config($piree_prog_a[$piree_prog_a[770100]['num']]['version_s']);


      //=============================================================
      // 프로그램__디렉토리
      $p770100__prog_dir = 'p'. $nett_prog_n;


      //=============================================================
      // 프로그램__코드
      $p770100__prog_c = $prog_conf['pgs_prog_c'];


      //=============================================================
      // 프로그램__URL_경로
      $p770100__prog_u = piree__url($piree_prog_a[770100]['num']);
      $p770100__prog_p = piree__path($piree_prog_a[770100]['num']);


      //=============================================================
      // 시작 => 프로그램_번호__맞으면
      IF ( $nett_prog_n == $prog_conf['pgs_prog_n'] )
      {

          ###########################################################
          # 시작 => 설정__값
          ###########################################################

          //=========================================================
          // 피리_카페_관리___사용여부
          // 1 - 사용함
          $use__p770100 = 1;


          //=========================================================
          // 프로그램_번호
          $piree_prog_a[$piree_prog_a[770100]['num']]['prog_n'] = $prog_conf['pgs_prog_n'];


          //=========================================================
          // 프로그램_코드
          $piree_prog_a[$piree_prog_a[770100]['num']]['prog_prog_c'] = $prog_conf['pgs_prog_c'];


          //=========================================================
          // 프로그램_이름
          $piree_prog_a[$piree_prog_a[770100]['num']]['prog_prog_s'] = $prog_conf['pgs_prog_s'];


          //=========================================================
          // 프로그램_버젼
          $piree_prog_a[$piree_prog_a[770100]['num']]['prog_version_s'] = $prog_conf['pgs_version_s'];


          //=========================================================
          // 프로그램_등록_일시
          $piree_prog_a[$piree_prog_a[770100]['num']]['prog_regi_time_n'] = $prog_conf['pgs_regi_time_n'];


          //=========================================================
          // EXTEND_파일에서__파일_첨부__여부
          $p770100__prog_top_include_n = $prog_conf['pgs_top_include_n'];
          IF ( $p770100__prog_top_include_n != 1 && $p770100__prog_top_include_n != 11 )
          {
              $p770100__prog_top_include_n = 0;
          }


          //=========================================================
          // HEAD_태그_안에서__파일_첨부__여부
          $p770100__prog_head_include_n = $prog_conf['pgs_head_include_n'];
          IF ( $p770100__prog_head_include_n != 1 && $p770100__prog_head_include_n != 11 )
          {
              $p770100__prog_head_include_n = 0;
          }


          //=========================================================
          // BODY_태그_상단에__파일_첨부__여부
          $p770100__prog_body_include_n = $prog_conf['pgs_body_include_n'];
          IF ( $p770100__prog_body_include_n != 1 && $p770100__prog_body_include_n != 11 )
          {
              $p770100__prog_body_include_n = 0;
          }


          //=========================================================
          // 스킨_PC
          $p770100__skin_pc_c = $prog_conf['pgs_skin_pc_c'];
          $p770100__skin_pc_u = $p770100__prog_u . PIREE_SKIN_PC_DIR ."/". $p770100__skin_pc_c;
          $p770100__skin_pc_p = $p770100__prog_p . PIREE_SKIN_PC_DIR ."/". $p770100__skin_pc_c;


          //=========================================================
          // 스킨_모바일
          $p770100__skin_mo_c = $prog_conf['pgs_skin_mo_c'];
          $p770100__skin_mo_u = $p770100__prog_u . PIREE_SKIN_MO_DIR ."/". $p770100__skin_mo_c;
          $p770100__skin_mo_p = $p770100__prog_p . PIREE_SKIN_MO_DIR ."/". $p770100__skin_mo_c;


          //=========================================================
          // 시작 => DEVIDE__구분
          IF ( G5_IS_MOBILE )
          {

              #######################################################
              # 시작 => DEVIDE__모바일__이름

              //=====================================================
              // 스킨_정보
              $p770100__skin_c = $p770100__skin_mo_c;
              $p770100__skin_u = $p770100__skin_mo_u;
              $p770100__skin_p = $p770100__skin_mo_p;

          }
          ELSE
          {

              #######################################################
              # 시작 => DEVIDE__PC__이면

              //=====================================================
              // 스킨_정보
              $p770100__skin_c = $p770100__skin_pc_c;
              $p770100__skin_u = $p770100__skin_pc_u;
              $p770100__skin_p = $p770100__skin_pc_p;

          }
          // 끝 => DEVIDE__구분
          //=========================================================


          //=========================================================
          // 개별_카페___기본_스킨__PC_스킨
          $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_basic_pc_c'] = $prog_conf['pgs_cf_2_s'];


          //=========================================================
          // 개별_카페___기본_스킨__모바일_스킨
          $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_basic_mo_c'] = $prog_conf['pgs_cf_3_s'];


          //=========================================================
          // 개별_카페___카페_관리_스킨__PC_스킨
          $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_manage_pc_c'] = $prog_conf['pgs_cf_4_s'];


          //=========================================================
          // 개별_카페___카페_관리_스킨__모바일_스킨
          $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_manage_mo_c'] = $prog_conf['pgs_cf_5_s'];


          //=========================================================
          // 개별_카페___게시판_스킨__PC_스킨
          $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_board_pc_c'] = $prog_conf['pgs_cf_6_s'];


          //=========================================================
          // 개별_카페___게시판_스킨__모바일_스킨
          $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_board_mo_c'] = $prog_conf['pgs_cf_7_s'];


          //=========================================================
          // 개별_카페___최신글_스킨__PC_스킨
          $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_latest_pc_c'] = $prog_conf['pgs_cf_8_s'];


          //=========================================================
          // 개별_카페___최신글_스킨__모바일_스킨
          $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_latest_mo_c'] = $prog_conf['pgs_cf_9_s'];


          //=========================================================
          // 개별_카페___이용_약관_명칭
          $piree_prog_a[$piree_prog_a[770100]['num']]['contract_name'] = $prog_conf['pgs_cf_20_s'];


          //=========================================================
          //=========================================================


          //=========================================================
          // 프로필_이미지_해상도__가로
          $piree_prog_a[$piree_prog_a[770100]['num']]['profile_image_width_n'] = $prog_conf['pgs_cf_7_n'];


          //=========================================================
          // 프로필_이미지_해상도__세로
          $piree_prog_a[$piree_prog_a[770100]['num']]['profile_image_height_n'] = $prog_conf['pgs_cf_8_n'];


          //=========================================================
          // 피리_카페_검색어__제한_수
          $piree_prog_a[$piree_prog_a[770100]['num']]['search_keyword_max_n'] = $prog_conf['pgs_cf_9_n'];

          ###########################################################
          # 끝 => 설정_값
          ###########################################################



          ###########################################################
          # 시작 => 개별_카페___기본_스킨
          ###########################################################

          //=========================================================
          // 개별_카페___기본_스킨
          $p770100__cafe_skin_basic_c = '';
          $p770100__cafe_skin_basic_u = '';
          $p770100__cafe_skin_basic_p = '';


          //=========================================================
          // 개별_카페___기본_스킨__PC_스킨
          $p770100__cafe_skin_basic_pc_c = $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_basic_pc_c'];
          $p770100__cafe_skin_basic_pc_u = $p770100__prog_u . PIREE_CAFE_SKIN_BASIC_PC_DIR ."/". $p770100__cafe_skin_basic_pc_c;
          $p770100__cafe_skin_basic_pc_p = $p770100__prog_p . PIREE_CAFE_SKIN_BASIC_PC_DIR ."/". $p770100__cafe_skin_basic_pc_c;


          //=========================================================
          // 개별_카페___기본_스킨__모바일_스킨
          $p770100__cafe_skin_basic_mo_c = $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_basic_mo_c'];
          $p770100__cafe_skin_basic_mo_u = $p770100__prog_u . PIREE_CAFE_SKIN_BASIC_MO_DIR ."/". $p770100__cafe_skin_basic_mo_c;
          $p770100__cafe_skin_basic_mo_p = $p770100__prog_p . PIREE_CAFE_SKIN_BASIC_MO_DIR ."/". $p770100__cafe_skin_basic_mo_c;


          //=========================================================
          // 시작 => DEVIDE__구분
          IF ( G5_IS_MOBILE )
          {

              #######################################################
              # 시작 => DEVIDE__모바일__이름

              //=====================================================
              // 개별_카페___기본_스킨__모바일_스킨
              $p770100__cafe_skin_basic_c = $p770100__cafe_skin_basic_mo_c;
              $p770100__cafe_skin_basic_u = $p770100__cafe_skin_basic_mo_u;
              $p770100__cafe_skin_basic_p = $p770100__cafe_skin_basic_mo_p;

          }
          ELSE
          {

              #######################################################
              # 시작 => DEVIDE__PC__이면

              //=====================================================
              // 개별_카페___기본_스킨__PC_스킨
              $p770100__cafe_skin_basic_c = $p770100__cafe_skin_basic_pc_c;
              $p770100__cafe_skin_basic_u = $p770100__cafe_skin_basic_pc_u;
              $p770100__cafe_skin_basic_p = $p770100__cafe_skin_basic_pc_p;

          }
          // 끝 => DEVIDE__구분
          //=========================================================

          ###########################################################
          # 끝 => 개별_카페___기본_스킨
          ###########################################################



          ###########################################################
          # 시작 => 개별_카페___게시판_스킨
          ###########################################################

          //=========================================================
          // 개별_카페___게시판_스킨
          $p770100__cafe_skin_board_c = '';
          $p770100__cafe_skin_board_u = '';
          $p770100__cafe_skin_board_p = '';


          //=========================================================
          // 개별_카페___게시판_스킨__PC_스킨
          $p770100__cafe_skin_board_pc_c = $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_board_pc_c'];
          $p770100__cafe_skin_board_pc_u = PIREE_CAFE_MANAGE_URL .'/'. PIREE_CAFE_SKIN_BOARD_PC_DIR ."/". $p770100__cafe_skin_board_pc_c;
          $p770100__cafe_skin_board_pc_p = PIREE_CAFE_MANAGE_PATH .'/'. PIREE_CAFE_SKIN_BOARD_PC_DIR ."/". $p770100__cafe_skin_board_pc_c;


          //=========================================================
          // 개별_카페___게시판_스킨__모바일_스킨
          $p770100__cafe_skin_board_mo_c = $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_board_mo_c'];
          $p770100__cafe_skin_board_mo_u = PIREE_CAFE_MANAGE_URL .'/'. PIREE_CAFE_SKIN_BOARD_MO_DIR ."/". $p770100__cafe_skin_board_mo_c;
          $p770100__cafe_skin_board_mo_p = PIREE_CAFE_MANAGE_PATH .'/'. PIREE_CAFE_SKIN_BOARD_MO_DIR ."/". $p770100__cafe_skin_board_mo_c;


          //=========================================================
          // 시작 => DEVIDE__구분
          IF ( G5_IS_MOBILE )
          {

              #######################################################
              # 시작 => DEVIDE__모바일__이름

              //=====================================================
              // 개별_카페___게시판_스킨__모바일_스킨
              $p770100__cafe_skin_board_c = $p770100__cafe_skin_board_mo_c;
              $p770100__cafe_skin_board_u = $p770100__cafe_skin_board_mo_u;
              $p770100__cafe_skin_board_p = $p770100__cafe_skin_board_mo_p;


              //=====================================================
              // 개별_카페___게시판_스킨__PC_스킨
              $p770100__cafe_skin_board_c = $p770100__cafe_skin_board_pc_c;
              $p770100__cafe_skin_board_u = $p770100__cafe_skin_board_pc_u;
              $p770100__cafe_skin_board_p = $p770100__cafe_skin_board_pc_p;

          }
          ELSE
          {

              #######################################################
              # 시작 => DEVIDE__PC__이면

              //=====================================================
              // 개별_카페___게시판_스킨__PC_스킨
              $p770100__cafe_skin_board_c = $p770100__cafe_skin_board_pc_c;
              $p770100__cafe_skin_board_u = $p770100__cafe_skin_board_pc_u;
              $p770100__cafe_skin_board_p = $p770100__cafe_skin_board_pc_p;

          }
          // 끝 => DEVIDE__구분
          //=========================================================

          ###########################################################
          # 끝 => 개별_카페___게시판_스킨
          ###########################################################



          ###########################################################
          # 시작 => 개별_카페___최신글_스킨
          ###########################################################

          //=========================================================
          // 개별_카페___최신글_스킨
          $p770100__cafe_skin_latest_c = '';
          $p770100__cafe_skin_latest_u = '';
          $p770100__cafe_skin_latest_p = '';


          //=========================================================
          // 개별_카페___최신글_스킨__PC_스킨
          $p770100__cafe_skin_latest_pc_c = $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_latest_pc_c'];
          $p770100__cafe_skin_latest_pc_u = PIREE_CAFE_MANAGE_URL .'/'. PIREE_CAFE_SKIN_LATEST_PC_DIR ."/". $p770100__cafe_skin_latest_pc_c;
          $p770100__cafe_skin_latest_pc_p = PIREE_CAFE_MANAGE_PATH .'/'. PIREE_CAFE_SKIN_LATEST_PC_DIR ."/". $p770100__cafe_skin_latest_pc_c;


          //=========================================================
          // 개별_카페___최신글_스킨__모바일_스킨
          $p770100__cafe_skin_latest_mo_c = $piree_prog_a[$piree_prog_a[770100]['num']]['piree_cafe_skin_latest_mo_c'];
          $p770100__cafe_skin_latest_mo_u = PIREE_CAFE_MANAGE_URL .'/'. PIREE_CAFE_SKIN_LATEST_MO_DIR ."/". $p770100__cafe_skin_latest_mo_c;
          $p770100__cafe_skin_latest_mo_p = PIREE_CAFE_MANAGE_PATH .'/'. PIREE_CAFE_SKIN_LATEST_MO_DIR ."/". $p770100__cafe_skin_latest_mo_c;


          //=========================================================
          // 시작 => DEVIDE__구분
          IF ( G5_IS_MOBILE )
          {

              #######################################################
              # 시작 => DEVIDE__모바일__이름

              //=====================================================
              // 개별_카페___최신글_스킨__모바일_스킨
              $p770100__cafe_skin_latest_c = $p770100__cafe_skin_latest_mo_c;
              $p770100__cafe_skin_latest_u = $p770100__cafe_skin_latest_mo_u;
              $p770100__cafe_skin_latest_p = $p770100__cafe_skin_latest_mo_p;


              //=====================================================
              // 개별_카페___최신글_스킨__PC_스킨
              $p770100__cafe_skin_latest_c = $p770100__cafe_skin_latest_pc_c;
              $p770100__cafe_skin_latest_u = $p770100__cafe_skin_latest_pc_u;
              $p770100__cafe_skin_latest_p = $p770100__cafe_skin_latest_pc_p;

          }
          ELSE
          {

              #######################################################
              # 시작 => DEVIDE__PC__이면

              //=====================================================
              // 개별_카페___최신글_스킨__PC_스킨
              $p770100__cafe_skin_latest_c = $p770100__cafe_skin_latest_pc_c;
              $p770100__cafe_skin_latest_u = $p770100__cafe_skin_latest_pc_u;
              $p770100__cafe_skin_latest_p = $p770100__cafe_skin_latest_pc_p;

          }
          // 끝 => DEVIDE__구분
          //=========================================================

          ###########################################################
          # 끝 => 개별_카페___최신글_스킨
          ###########################################################



          ###########################################################
          # 시작 => 기본_값
          ###########################################################

          //=========================================================
          // 


          //=========================================================
          // 

          ###########################################################
          # 끝 => 기본_값
          ###########################################################

      }
      // 끝 => 프로그램_번호__맞으면
      //=============================================================

  }
  // 끝 => 설정_정보__가져오기__이면
  //=================================================================

  ###################################################################
  # 끝 => 피리_포인트_베팅__설정_정보__가져오기
  ###################################################################


#####################################################################
# 끝 => 피리_포인트_베팅__설정_정보__가져오기
#####################################################################


?>