<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 For 그누보드5.5 순정

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https://piree.kr/nett_dev

  작성날짜 : 2024년 04월 14일 일요일 오후 18시 43분 / 맑음, 26.5, 건조주의보, 28, 9, 0%, 0%, 2.4ms / 양호, 33, 12, 0.005

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
              그누보드 외에 추가된 소스는~
              만든사람의 허락없이 무단으로 사용할수 없습니다.
              사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
              http://www.piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 For 그누보드5.5 순정 > 프로그램 > 피리 카페 관리 > 내 카페 > 게시판 > 스킨 > PC 스킨 > 게시글 쓰기
=====================================================================


*/


  //=================================================================
  // 개별_페이지__접근_불가
  IF (!defined('_GNUBOARD_'))                      EXIT;


  //=================================================================
  // add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
  add_stylesheet('<link rel="stylesheet" href="'. $board_cate_list_a[$board_cate_n]['board_skin_u'] .'/piree.cafe.style.css">', 0);


  //=================================================================
  // 게시판_분류__경로
  include_once( $board_cate_list_a[$board_cate_n]['board_skin_p'] .'/piree.cafe.category.location.php');

?>

<section id="bo_w" class="cl_bo">
    <h2 class="sound_only"><?php echo $g5['title'] ?></h2>

    <!-- 게시물 작성/수정 시작 { -->
    <form name="piree_cafe_board_write" id="piree_cafe_board_write" action="<?php echo $piree_cafe_board_write_action_u ?>" onsubmit="return piree_cafe_board_write_submit(this);" method="post" enctype="multipart/form-data" autocomplete="off" style="width:<?php echo $width; ?>">
    <input type="hidden" name="uid"          value="<?php echo get_uniqid(); ?>">
    <input type="hidden" name="w"            value="<?php echo $w ?>">
    <input type="hidden" name="mode_c"       value="piree_cafe_board_write">
    <input type="hidden" name="piree_cafe_n" value="<?php echo $piree_cafe_n ?>">
    <input type="hidden" name="board_cate_n" value="<?php echo $board_cate_n ?>">
    <input type="hidden" name="bo_table"     value="<?php echo $piree['cafe_board_code'] ?>">
    <input type="hidden" name="wr_id"        value="<?php echo $wr_id ?>">
    <input type="hidden" name="sca"          value="<?php echo $sca ?>">
    <input type="hidden" name="sfl"          value="<?php echo $sfl ?>">
    <input type="hidden" name="stx"          value="<?php echo $stx ?>">
    <input type="hidden" name="spt"          value="<?php echo $spt ?>">
    <input type="hidden" name="sst"          value="<?php echo $sst ?>">
    <input type="hidden" name="sod"          value="<?php echo $sod ?>">
    <input type="hidden" name="page"         value="<?php echo $page ?>">
<?php

  //=================================================================
  // 시작 => 게시판_분류_번호__있으면
  IF ( $board_cate_n > 0 )
  {
?>
    <input type="hidden" name="board_cate_n" value="<?php echo $board_cate_n ?>">
<?php
  }
  // 끝 => 게시판_분류_번호__있으면
  //=================================================================

?>

    <?php
    $option = '';
    $option_hidden = '';
    if ($is_notice || $is_html || $is_secret || $is_mail) { 
        $option = '';
        if ($is_notice) {
            $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="notice" name="notice"  class="selec_chk" value="1" '. $notice_checked.'>'.PHP_EOL.'<label for="notice"><span></span>공지</label></li>';
        }
        if ($is_html) {
            if ($is_dhtml_editor) {
                $option_hidden .= '<input type="hidden" value="html1" name="html">';
            } else {
                $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="html" name="html" onclick="html_auto_br(this);" class="selec_chk" value="'. $html_value.'" '. $html_checked.'>'.PHP_EOL.'<label for="html"><span></span>html</label></li>';
            }
        }
        if ($is_secret) {
            if ( piree_cafe_auth_get() || $is_secret==1 ) {
                $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="secret" name="secret"  class="selec_chk" value="secret" '. $secret_checked.'>'.PHP_EOL.'<label for="secret"><span></span>비밀글</label></li>';
            } else {
                $option_hidden .= '<input type="hidden" name="secret" value="secret">';
            }
        }
        if ($is_mail) {
            $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="mail" name="mail"  class="selec_chk" value="mail" '. $recv_email_checked.'>'.PHP_EOL.'<label for="mail"><span></span>답변메일받기</label></li>';
        }
    }
    echo $option_hidden;
    ?>

<?php

  //=================================================================
  // 시작 => 게시판_전체_분류_수__있고____게시판_분류_이름__있으면
  IF ( $board_cate_all_t > 0 && ( ( $w == 'u' && !$write['wr_pi_board_cate_n'] ) || ( $w != 'u' && !$board_cate_n ) ) )
  {
?>
    <div class="bo_w_select write_div">
        <label for="board_cate_n" class="sound_only">게시판 분류<strong>필수</strong></label>
        <select name="board_cate_n" id="board_cate_n" required>
            <option value="">분류를 선택하세요</option>
<?php

        //===========================================================
        // 시작 => 반복문____게시판_전체_분류_수__수__만큼
        FOREACH ( $board_cate_list_a AS $key=>$val )
        {

          //=========================================================
          // 시작 => 게시판_분류__정보__있으면
          IF ( $val['bca_cate_n'] > 0 && $val['bca_s_p'] )
          {

            //=======================================================
          	// 선택__여부
          	$loop_selected = $write['wr_pi_board_cate_n'] == $val['bca_cate_n'] ? ' selected' : '';

?>
            <option value="<?php echo $val['bca_cate_n']; ?>"<?php echo $loop_selected; ?>><?php echo str_replace('--', ' ≫ ', $val['bca_s_p']); ?></option>
<?php
          }
          // 끝 => 게시판_분류__정보__있으면
          //=========================================================

        }
        // 끝 => 반복문____게시판_전체_분류_수__수__만큼
        //===========================================================

?>
        </select>
    </div>


    <div class="cl_bo line_h_2_4" style="margin-left:<?php echo $margin_left_n; ?>px">
      <img src="<?php echo $left_image; ?>">
      <a href="" class="<?php echo $board_cate_style_s; ?>"><?php echo $val['bca_cate_s']; ?></a>
      <span class="font_999" style="float:right;"><?php echo number_format($val['bca_article_t']); ?></span>
    </div>
<?php
  }
  // 끝 => 게시판_전체_분류_수__있고____게시판_분류_이름__있으면
  //=================================================================

?>

    <div class="bo_w_info write_div">
	    <?php if ($is_name) { ?>
	        <label for="wr_name" class="sound_only">이름<strong>필수</strong></label>
	        <input type="text" name="wr_name" value="<?php echo $name ?>" id="wr_name" required class="frm_input half_input required" placeholder="이름">
	    <?php } ?>
	
	    <?php if ($is_password) { ?>
	        <label for="wr_password" class="sound_only">비밀번호<strong>필수</strong></label>
	        <input type="password" name="wr_password" id="wr_password" <?php echo $password_required ?> class="frm_input half_input <?php echo $password_required ?>" placeholder="비밀번호">
	    <?php } ?>
	
	    <?php if ($is_email) { ?>
			<label for="wr_email" class="sound_only">이메일</label>
			<input type="text" name="wr_email" value="<?php echo $email ?>" id="wr_email" class="frm_input half_input email " placeholder="이메일">
	    <?php } ?>
	    
	
	    <?php if ($is_homepage) { ?>
	        <label for="wr_homepage" class="sound_only">홈페이지</label>
	        <input type="text" name="wr_homepage" value="<?php echo $homepage ?>" id="wr_homepage" class="frm_input half_input" size="50" placeholder="홈페이지">
	    <?php } ?>
	</div>
	
    <?php if ($option) { ?>
    <div class="write_div">
        <span class="sound_only">옵션</span>
        <ul class="bo_v_option">
        <?php echo $option ?>
        </ul>
    </div>
    <?php } ?>

    <div class="bo_w_tit write_div">
        <label for="wr_subject" class="sound_only">제목<strong>필수</strong></label>
        
        <div id="autosave_wrapper" class="write_div">
            <input type="text" name="wr_subject" value="<?php echo $subject ?>" id="wr_subject" required class="frm_input full_input required" size="50" maxlength="255" placeholder="제목">
            <?php if ($is_member) { // 임시 저장된 글 기능 ?>
            <script src="<?php echo G5_JS_URL; ?>/autosave.js"></script>
            <?php IF ($editor_content_js) echo $editor_content_js; ?>
            <button type="button" id="btn_autosave" class="btn_frmline">임시 저장된 글 (<span id="autosave_count"><?php echo $autosave_count; ?></span>)</button>
            <div id="autosave_pop">
                <strong>임시 저장된 글 목록</strong>
                <ul></ul>
                <div><button type="button" class="autosave_close">닫기</button></div>
            </div>
            <?php } ?>
        </div>
        
    </div>

    <div class="write_div">
        <label for="wr_content" class="sound_only">내용<strong>필수</strong></label>
        <div class="wr_content <?php echo $is_dhtml_editor ? $config['cf_editor'] : ''; ?>">
            <?php IF ($write_min || $write_max) { ?>
            <!-- 최소/최대 글자 수 사용 시 -->
            <p id="char_count_desc">이 게시판은 최소 <strong><?php echo $write_min; ?></strong>글자 이상, 최대 <strong><?php echo $write_max; ?></strong>글자 이하까지 글을 쓰실 수 있습니다.</p>
            <?php } ?>
            <?php echo $editor_html; // 에디터 사용시는 에디터로, 아니면 textarea 로 노출 ?>
            <?php IF ($write_min || $write_max) { ?>
            <!-- 최소/최대 글자 수 사용 시 -->
            <div id="char_count_wrap"><span id="char_count"></span>글자</div>
            <?php } ?>
        </div>
        
    </div>

    <?php for ($i=1; $is_link && $i<=G5_LINK_COUNT; $i++) { ?>
    <div class="bo_w_link write_div">
        <label for="wr_link<?php echo $i ?>"><i class="fa fa-link" aria-hidden="true"></i><span class="sound_only"> 링크  #<?php echo $i ?></span></label>
        <input type="text" name="wr_link<?php echo $i ?>" value="<?php IF ($w=="u"){ echo $write['wr_link'. $i]; } ?>" id="wr_link<?php echo $i ?>" class="frm_input full_input" size="50">
    </div>
    <?php } ?>

    <?php for ($i=0; $is_file && $i<$file_count; $i++) { ?>
    <div class="bo_w_flie write_div">
        <div class="file_wr write_div">
            <label for="bf_file_<?php echo $i+1 ?>" class="lb_icon"><i class="fa fa-folder-open" aria-hidden="true"></i><span class="sound_only"> 파일 #<?php echo $i+1 ?></span></label>
            <input type="file" name="bf_file[]" id="bf_file_<?php echo $i+1 ?>" title="파일첨부 <?php echo $i+1 ?> : 용량 <?php echo $upload_max_filesize ?> 이하만 업로드 가능" class="frm_file ">
        </div>
        <?php if ($is_file_content) { ?>
        <input type="text" name="bf_content[]" value="<?php echo ($w == 'u') ? $file[$i]['bf_content'] : ''; ?>" title="파일 설명을 입력해주세요." class="full_input frm_input" size="50" placeholder="파일 설명을 입력해주세요.">
        <?php } ?>

        <?php IF ($w == 'u' && $file[$i]['file']) { ?>
        <span class="file_del">
            <input type="checkbox" id="bf_file_del<?php echo $i ?>" name="bf_file_del[<?php echo $i;  ?>]" value="1"> <label for="bf_file_del<?php echo $i ?>"><?php echo $file[$i]['source'].'('. $file[$i]['size'].')';  ?> 파일 삭제</label>
        </span>
        <?php } ?>
        
    </div>
    <?php } ?>


    <?php if ($is_use_captcha) { //자동등록방지  ?>
    <div class="write_div">
        <?php echo $captcha_html ?>
    </div>
    <?php } ?>

    <div class="btn_confirm write_div">
        <a href="<?php echo go_piree_cafe_board('', $piree_cafe_n, $board_cate_n); ?>" class="btn_cancel btn">취소</a>
        <button type="submit" id="btn_submit" accesskey="s" class="btn_submit btn">작성완료</button>
    </div>
    </form>

    <script>
    <?php IF ($write_min || $write_max) { ?>
    // 글자수 제한
    var char_min = parseInt(<?php echo $write_min; ?>); // 최소
    var char_max = parseInt(<?php echo $write_max; ?>); // 최대
    check_byte("wr_content", "char_count");

    $(function() {
        $("#wr_content").on("keyup", function() {
            check_byte("wr_content", "char_count");
        });
    });

    <?php } ?>
    function html_auto_br(obj)
    {
        if (obj.checked) {
            result = confirm("자동 줄바꿈을 하시겠습니까?\n\n자동 줄바꿈은 게시물 내용중 줄바뀐 곳을<br>태그로 변환하는 기능입니다.");
            if (result)
                obj.value = "html2";
            else
                obj.value = "html1";
        }
        else
            obj.value = "";
    }

    function piree_cafe_board_write_submit(f)
    {
        <?php echo $editor_js; // 에디터 사용시 자바스크립트에서 내용을 폼필드로 넣어주며 내용이 입력되었는지 검사함   ?>

        var subject = "";
        var content = "";
        $.ajax({
            url: g5_bbs_url+"/ajax.filter.php",
            type: "POST",
            data: {
                "subject": f.wr_subject.value,
                "content": f.wr_content.value
            },
            dataType: "json",
            async: false,
            cache: false,
            success: function(data, textStatus) {
                subject = data.subject;
                content = data.content;
            }
        });

        if (subject) {
            alert("제목에 금지단어('"+subject+"')가 포함되어있습니다");
            f.wr_subject.focus();
            return false;
        }

        if (content) {
            alert("내용에 금지단어('"+content+"')가 포함되어있습니다");
            if (typeof(ed_wr_content) != "undefined")
                ed_wr_content.returnFalse();
            else
                f.wr_content.focus();
            return false;
        }

        if (document.getElementById("char_count")) {
            if (char_min > 0 || char_max > 0) {
                var cnt = parseInt(check_byte("wr_content", "char_count"));
                if (char_min > 0 && char_min > cnt) {
                    alert("내용은 "+char_min+"글자 이상 쓰셔야 합니다.");
                    return false;
                }
                else if (char_max > 0 && char_max < cnt) {
                    alert("내용은 "+char_max+"글자 이하로 쓰셔야 합니다.");
                    return false;
                }
            }
        }

        <?php echo $captcha_js; // 캡챠 사용시 자바스크립트에서 입력된 캡챠를 검사함  ?>

        document.getElementById("btn_submit").disabled = "disabled";

        return true;
    }
    </script>
</section>
<!-- } 게시물 작성/수정 끝 -->