<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 For 그누보드5.5 순정

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https://piree.kr/nett_dev

  작성날짜 : 2024년 03월 31일 요일

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
            그누보드 외에 추가된 소스는~
            만든사람의 허락없이 무단으로 사용할수 없습니다.
            사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
            http://www.piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 For 그누보드5.5 순정 > 피리 카페 For 그누보드5.5 순정 > 피리 카페 관리 > 설정 파일
=====================================================================


// 문자열 자르기
cut_str($str, $len, $suffix="…")


// UTF-8 문자열 자르기
utf8_strcut( $str, $size, $suffix='...' )


  function piree_cafe_skin_path_get($get_skin_a)


177316032


*/


  ###################################################################
  # 시작 => 개별_페이지__무단_접근_불가
  ###################################################################

  //=================================================================
  // 개별_페이지__접근_불가
  IF ( !defined('_GNUBOARD_') )                             EXIT;

  ###################################################################
  # 끝 => 개별_페이지__무단_접근_불가
  ###################################################################



#####################################################################
# 시작 => 설정
#####################################################################


  //=================================================================
  // 프로그램_번호
  $nett_prog_n = 770100;


  //=================================================================
  // 프로그램_이름__긴_이름
  $piree_prog_a[$nett_prog_n]['name_l'] = "피리 NETT 피리 카페 관리";


  //=================================================================
  // 프로그램_이름__짧은_이름
  $piree_prog_a[$nett_prog_n]['name_s'] = "피리 NETT 피리 카페";


  //=================================================================
  // 프로그램_코드__영문_코드
  $piree_prog_a[$nett_prog_n]['prog_c'] = "피리 NETT Cafe Manage";


  //=================================================================
  // 버젼
  $piree_prog_a[$nett_prog_n]['version_s'] = "0.0.0.1";


  //=================================================================
  // 프로그램_메모
  $piree_prog_a[$nett_prog_n]['memo_s'] = "[ 피리 NETT ]를 기본 관리하는 기능입니다.";


#####################################################################
# 끝 => 설정
#####################################################################





#####################################################################
# 시작 => 상수__변수__배열
#####################################################################


  //=================================================================
  // p770100__단어_관리__자료_구분
  $p770100__word_data_work_c = 'cafe.search';


  //=================================================================
  // 피리_카페__회원_정보__불러오는__방식 
  $cafe_member_info_get_way_a = array();
  $cafe_member_info_get_way_a[11] = array('num'=>11, 'code'=>'piree_피리 NETT', 'name'=>'피리 NETT');
  $cafe_member_info_get_way_a[21] = array('num'=>21, 'code'=>'gnuboard5',  'name'=>'그누보드5');


  //=================================================================
  // 피리_카페__자동_수동__만들기__배열
  $cafe_make_auto_manual_a = array();
  $cafe_make_auto_manual_a['manual'] = array('code'=>'manual', 'name_s'=>'수동', 'name_l'=>'수동으로 만들기');
  $cafe_make_auto_manual_a['auto']   = array('code'=>'auto',   'name_s'=>'자동', 'name_l'=>'자동으로 만들기');


  //=================================================================
  // 피리_카페__레벨
  $cafe_member_level_a = array();

  $cafe_member_level_a[250] = array('num'=>250, 'name'=>'주인');
  $cafe_member_level_a[240] = array('num'=>240, 'name'=>'관리자');
  $cafe_member_level_a[230] = array('num'=>230, 'name'=>'매니저');

  $cafe_member_level_a[110] = array('num'=>110, 'name'=>'회원 레벨 10');
  $cafe_member_level_a[109] = array('num'=>109, 'name'=>'회원 레벨 9');
  $cafe_member_level_a[108] = array('num'=>108, 'name'=>'회원 레벨 8');
  $cafe_member_level_a[107] = array('num'=>107, 'name'=>'회원 레벨 7');
  $cafe_member_level_a[106] = array('num'=>106, 'name'=>'회원 레벨 6');
  $cafe_member_level_a[105] = array('num'=>105, 'name'=>'회원 레벨 5');
  $cafe_member_level_a[104] = array('num'=>104, 'name'=>'회원 레벨 4');
  $cafe_member_level_a[103] = array('num'=>103, 'name'=>'회원 레벨 3');
  $cafe_member_level_a[102] = array('num'=>102, 'name'=>'회원 레벨 2');
  $cafe_member_level_a[101] = array('num'=>101, 'name'=>'회원 레벨 1');

  $cafe_member_level_a[81]  = array('num'=>81,  'name'=>'서로 바라기');
  $cafe_member_level_a[71]  = array('num'=>71,  'name'=>'나 바라기');

  $cafe_member_level_a[54]  = array('num'=>54,  'name'=>'5분 정지');
  $cafe_member_level_a[52]  = array('num'=>52,  'name'=>'10분 정지');
  $cafe_member_level_a[50]  = array('num'=>50,  'name'=>'20분 정지');
  $cafe_member_level_a[48]  = array('num'=>48,  'name'=>'30분 정지');
  $cafe_member_level_a[46]  = array('num'=>46,  'name'=>'1시간 정지');
  $cafe_member_level_a[44]  = array('num'=>44,  'name'=>'3시간 정지');
  $cafe_member_level_a[42]  = array('num'=>42,  'name'=>'6시간 정지');
  $cafe_member_level_a[40]  = array('num'=>40,  'name'=>'1일 정지');
  $cafe_member_level_a[38]  = array('num'=>38,  'name'=>'3일 정지');
  $cafe_member_level_a[36]  = array('num'=>36,  'name'=>'7일 정지');
  $cafe_member_level_a[34]  = array('num'=>34,  'name'=>'10일 정지');
  $cafe_member_level_a[32]  = array('num'=>32,  'name'=>'15일 정지');
  $cafe_member_level_a[30]  = array('num'=>30,  'name'=>'20일 정지');
  $cafe_member_level_a[28]  = array('num'=>28,  'name'=>'30일 정지');
  $cafe_member_level_a[26]  = array('num'=>26,  'name'=>'60일 정지');
  $cafe_member_level_a[24]  = array('num'=>24,  'name'=>'90일 정지');
  $cafe_member_level_a[22]  = array('num'=>22,  'name'=>'100일 정지');
  $cafe_member_level_a[20]  = array('num'=>20,  'name'=>'365일 정지');
  $cafe_member_level_a[18]  = array('num'=>18,  'name'=>'730일 정지');
  $cafe_member_level_a[16]  = array('num'=>16,  'name'=>'영구 정지');

#####################################################################
# 끝 => 상수__변수__배열
#####################################################################





#####################################################################
# 시작 => 테이블__이름
#####################################################################


  //=================================================================
  // 피리_카페__테이블
  $piree['cafe'] = G5_TABLE_PREFIX .'_piree__cafe';


  //=================================================================
  // 피리_카페_회원__BASE__테이블
  $piree['cafe_member'] = G5_TABLE_PREFIX .'_piree__cafe_member';


#####################################################################
# 끝 => 테이블__이름
#####################################################################





#####################################################################
# 시작 => 피리_카페__관련
#####################################################################


  ###################################################################
  # 시작 => 피리_카페__쿼리문__가져오기
  ###################################################################
  function cafe_sql_get($get_piree_cafe_n=0, $get_piree_cafe_c='')
  {

    //===============================================================
    // 쿼리문_조건절__배열
    $where_a = array();


    //===============================================================
    // 쿼리문_조건절__문자열
    $where_s = '';


    //===============================================================
    // 시작 => 피리_카페_번호__있거나____피리_카페__카페_코드__있으면
    IF ( $get_piree_cafe_n > 0 || $get_piree_cafe_c )
    {

      //=============================================================
      // 시작 => 피리_카페_번호__있으면
      IF ( $get_piree_cafe_n > 0 )
      {

        //===========================================================
        // 쿼리문_조건절__배열
        $where_a[] = "`cafe_row_n` = '". $get_piree_cafe_n ."'";

      }
      // 끝 => 피리_카페_번호__있으면
      //=============================================================


      //=============================================================
      // 시작 => 피리_카페__카페_코드__있으면
      IF ( $get_piree_cafe_c )
      {

        //===========================================================
        // 앞_2자
        $get_piree_cafe_2_c = substr($get_piree_cafe_c, 0, 2);


        //===========================================================
        // 쿼리문_조건절__배열
        $where_a[] = " `cafe_code_c` = '". $get_piree_cafe_c ."'";
        // $where_a[] = "`cafe_code_2_c` = '". $get_piree_cafe_2_c ."' AND `cafe_code_c` = '". $get_piree_cafe_c ."'";

      }
      // 끝 => 피리_카페__카페_코드__있으면
      //=============================================================


      //=============================================================
      // 시작 => 쿼리문_조건절__배열__있으면
      IF ( count($where_a) > 0 )
      {

        //===========================================================
        // 쿼리문_조건절__문자열
        $where_s = array_to_sql_get($where_a, 'val_each', ' AND ');

      }
      // 끝 => 쿼리문_조건절__배열__있으면
      //=============================================================

    }
    // 끝 => 피리_카페_번호__있거나____피리_카페__카페_코드__있으면
    //===============================================================


    //===============================================================
    // 넘겨주기____쿼리문_조건절__문자열
    return $where_s;

  }
  ###################################################################
  # 끝 => 피리_카페__정보__가져오는__함수
  ###################################################################



  ###################################################################
  # 시작 => 피리_카페__정보__가져오는__함수
  ###################################################################
  function get_piree_cafe_info($get_piree_cafe_n=0, $get_piree_cafe_c='', $get_row_base_n=0, $get_row_list_n=0)
  {

    //===============================================================
    // 전역_변수
    global $piree;


    //===============================================================
    // 피리_카페_번호
    $save_cafe_n = $get_piree_cafe_n;


    //===============================================================
    // 피리_카페__쿼리문__가져오기
    $where_s = cafe_sql_get($save_cafe_n, $get_piree_cafe_c);


    //===============================================================
    // 넘겨줄__피리_카페_정보
    $cafe_base_a = array();
    $cafe_list_a = array();
    $piree_cafe_info_a = array();


    //===============================================================
    // 시작 => 피리_카페_BASE_ROW__가져오기_이면
    IF ( $get_row_base_n == 1 )
    {

      //=============================================================
      // 피리_카페_BASE_ROW__가져오기
      $sql_select  = "SELECT * FROM `". $piree['cafe'] ."` ";
      $sql_select .= "WHERE ". $where_s;
      $cafe_base_a = sql_fetch($sql_select);


      //=============================================================
      // 시작 => 피리_카페_번호__다르면
      IF ( $save_cafe_n != $cafe_base_a['cafe_row_n'] )
      {

        //===========================================================
        // 피리_카페_번호__새로고침
        $save_cafe_n = $cafe_base_a['cafe_row_n'];

      }
      // 끝 => 피리_카페_번호__다르면
      //=============================================================

    }
    // 끝 => 피리_카페_BASE_ROW__가져오기_이면
    //===============================================================


    //===============================================================
    // 시작 => 피리_카페_LIST_ROW__가져오기_이면
    IF ( $get_row_list_n == 1 )
    {

      //=============================================================
      // 시작 => 피리_카페_번호__있으면
      IF ( $save_cafe_n > 0 )
      {

        //===========================================================
        // 테이블__배열
        $cafe_table_a = cafe_table_get($save_cafe_n);


        //===========================================================
        // 피리_카페_정보
        $sql_select  = "SELECT * FROM `". $cafe_table_a['table_c'] ."` ";
        $sql_select .= "WHERE `cafe_row_n` = '". $save_cafe_n ."'";
        $cafe_list_a = sql_fetch($sql_select);

      }
      // 끝 => 피리_카페_번호__있으면
      //=============================================================

    }
    // 끝 => 피리_카페_LIST_ROW__가져오기_이면
    //===============================================================


    //===============================================================
    // 피리_카페_정보_배열__합치기
    $piree_cafe_info_a = array_merge($cafe_base_a, $cafe_list_a);


    //===============================================================
    // 피리_프로그램_정보
    return $piree_cafe_info_a;

  }
  ###################################################################
  # 끝 => 피리_카페__정보__가져오는__함수
  ###################################################################



  ###################################################################
  # 시작 => 피리_카페__카페_코드_앳__알아내기
  ###################################################################
  function get_piree_cafe_domain($get_domain_s)
  {

    //===============================================================
    // 결과____피리_카페__카페_코드_앳_표시
    $domain_at_s = '';

    //===============================================================
    // 시작 => QUERY_STRING
    IF ( $get_domain_s )
    {

      //=============================================================
      // 피리_카페_URL
      $domain_at_s = '@'. $get_domain_s;

    }
    // 끝 => QUERY_STRING
    //===============================================================


    //===============================================================
    // 넘겨주기____피리_카페__카페_코드_앳_표시
    return $domain_at_s;

  }
  ###################################################################
  # 끝 => 피리_카페__카페_코드_앳__알아내기
  ###################################################################


#####################################################################
# 끝 => 피리_카페__관련
#####################################################################





#####################################################################
# 시작 => 그누보드5__관련
#####################################################################


#####################################################################
# 끝 => 그누보드5__관련
#####################################################################





#####################################################################
# 시작 => 함수
#####################################################################


  ###################################################################
  # 시작 => 피리_카페__카페_코드__검증하기__중복확인_하기
  ###################################################################
  function piree_cafe_code_check($func_cafe_code_c, $func_piree_cafe_n=0)
  {

    //===============================================================
    // 전역변수
    global $piree;
    global $p770100__cafe_code_len_min_n;
    global $p770100__cafe_code_len_max_n;


    //===============================================================
    // 결과__배열
    $cafe_result_a = array();
    $cafe_result_a['cafe_error_n']  = 1;
    $cafe_result_a['cafe_result_s'] = '';


    //===============================================================
    // 시작 => 카페_코드__있으면
    IF ( $func_cafe_code_c )
    {

      ###############################################################
      # 시작 => 검증하기
      ###############################################################

      //=============================================================
      // 피리_카페__카페_코드__앞_2자
      $func_cafe_code_2_c = substr($func_cafe_code_c, 0, 2);


      //=============================================================
      // 피리_카페__카페_코드__글자_길이
      $cafe_code_len_n = strlen($func_cafe_code_c);


      //=============================================================
      // 시작 => 에러__없으면
      IF ( $cafe_result_a['cafe_error_n'] == 1 && !$cafe_result_a['cafe_result_s'] )
      {

        //===========================================================
        // 시작 => 카페_코드__입력하지_않았으면
        IF ( !$func_cafe_code_c )
        {

          //=========================================================
          // 결과
          $cafe_result_a['cafe_error_n']++;
          $cafe_result_a['cafe_result_s'] = "[ 카페 코드 ]을 입력해 주세요.";

        }
        // 끝 => 카페_코드__입력하지_않았으면
        //===========================================================

      }
      // 끝 => 에러__없으면
      //=============================================================


      //=============================================================
      // 시작 => 에러__없으면
      IF ( $cafe_result_a['cafe_error_n'] == 1 && !$cafe_result_a['cafe_result_s'] )
      {

        //===========================================================
        // 시작 => 카페_코드__입력하지_않았으면
        // IF ( !preg_match("/^([A-Za-z0-9_.]{1,20})$/", $func_cafe_code_c) )
        IF ( !preg_match("/^([a-zA-Z0-9_.]+)$/", $func_cafe_code_c) )
        {

          //=========================================================
          // 결과
          $cafe_result_a['cafe_error_n']++;
          $cafe_result_a['cafe_result_s'] = "[ 카페 코드 ]은 공백없이 영문자, 숫자, _, .만 입력해 주세요.";

        }
        // 끝 => 카페_코드__입력하지_않았으면
        //===========================================================

      }
      // 끝 => 에러__없으면
      //=============================================================


      //=============================================================
      // 시작 => 에러__없으면
      IF ( $cafe_result_a['cafe_error_n'] == 1 && !$cafe_result_a['cafe_result_s'] )
      {

        //===========================================================
        // 시작 => 카페_코드_글자_길이__최소값_보다__짧으면
        IF ( $cafe_code_len_n < $p770100__cafe_code_len_min_n )
        {

          //=========================================================
          // 결과
          $cafe_result_a['cafe_error_n']++;
          $cafe_result_a['cafe_result_s'] = "[ 카페 코드 ]의 글자수를 ". $p770100__cafe_code_len_min_n ."자 보다 길게 입력해 주세요.";

        }
        // 끝 => 카페_코드_글자_길이__최소값_보다__짧으면
        //===========================================================

      }
      // 끝 => 에러__없으면
      //=============================================================


      //=============================================================
      // 시작 => 에러__없으면
      IF ( $cafe_result_a['cafe_error_n'] == 1 && !$cafe_result_a['cafe_result_s'] )
      {

        //===========================================================
        // 시작 => 카페_코드_글자_길이__최대값_보다__길면
        IF ( $p770100__cafe_code_len_max_n < $cafe_code_len_n )
        {

          //=========================================================
          // 결과
          $cafe_result_a['cafe_error_n']++;
          $cafe_result_a['cafe_result_s'] = "[ 카페 코드 ]의 글자수를 ". $p770100__cafe_code_len_max_n ."자 보다 짧게 입력해 주세요.";

        }
        // 끝 => 카페_코드_글자_길이__최대값_보다__길면
        //===========================================================

      }
      // 끝 => 에러__없으면
      //=============================================================

      ###############################################################
      # 끝 => 검증하기
      ###############################################################



      ###############################################################
      # 시작 => 중복확인_하기
      ###############################################################

        #############################################################
        # 시작 => 상수__변수__배열
        #############################################################

        //===========================================================
        // 쿼리문_조건절__피리_카페_테이블
        $sql_where_cafe_s = "";


        //===========================================================
        // 쿼리문_조건절__카페_코드_테이블
        $sql_where_code_s = "";


        //===========================================================
        // 시작 => 피리_카페_번호__있으면
        IF ( $func_piree_cafe_n > 0 )
        {

          //=========================================================
          // 쿼리문_조건절__피리_카페_테이블
          $sql_where_cafe_s = " AND `cafe_row_n` != '". $func_piree_cafe_n ."'";


          //=========================================================
          // 쿼리문_조건절__카페_코드_테이블
          $sql_where_code_s = " AND `ecob_cafe_n` != '". $func_piree_cafe_n ."'";

        }
        // 끝 => 피리_카페_번호__있으면
        //===========================================================

        #############################################################
        # 끝 => 상수__변수__배열
        #############################################################



        #############################################################
        # 시작 => 피리_카페__BASE
        #############################################################

        //===========================================================
        // 시작 => 에러__없으면
        IF ( $cafe_result_a['cafe_error_n'] == 1 && !$cafe_result_a['cafe_result_s'] )
        {

          //=========================================================
          // 카페_코드__중복확인_하기
          $sql_select  = "SELECT COUNT(*) FROM `". $piree['cafe'] ."` ";
          $sql_select .= "WHERE `cafe_code_c` = '". $func_cafe_code_c ."'". $sql_where_cafe_s;
          // $sql_select .= "WHERE `cafe_code_2_c` = '". $func_cafe_code_2_c ."' AND `cafe_code_c` = '". $func_cafe_code_c ."'". $sql_where_cafe_s;
          $exist_t = sql_efv($sql_select);


          //=========================================================
          // 시작 => 중복__이면
          IF ( $exist_t > 0 )
          {

            //=======================================================
            // 결과
            $cafe_result_a['cafe_error_n']++;
            $cafe_result_a['cafe_result_s'] = "사용할수 없는 [ 카페 코드 ] 입니다. 다시 입력해 주세요.";

          }
          // 끝 => 중복__이면
          //=========================================================

        }
        // 끝 => 에러__없으면
        //===========================================================

        #############################################################
        # 끝 => 피리_카페__BASE
        #############################################################



        #############################################################
        # 시작 => 카페 코드
        #############################################################

        //===========================================================
        // 시작 => 에러__없으면
        IF ( $cafe_result_a['cafe_error_n'] == 1 && !$cafe_result_a['cafe_result_s'] )
        {

          //=========================================================
          // 카페_코드__중복확인_하기
          $sql_select  = "SELECT COUNT(*) FROM `". $piree['code_english'] ."` ";
          $sql_select .= "WHERE `ecob_2_c` = '". $func_cafe_code_2_c ."' AND `ecob_code_var_c` = '". $func_cafe_code_c ."'". $sql_where_code_s;
          $exist_t = sql_efv($sql_select);


          //=========================================================
          // 시작 => 중복__이면
          IF ( $exist_t > 0 )
          {

            //=======================================================
            // 결과
            $cafe_result_a['cafe_error_n']++;
            $cafe_result_a['cafe_result_s'] = "사용할수 없는 [ 카페 코드 ] 입니다. 다시 입력해 주세요.";

          }
          // 끝 => 중복__이면
          //=========================================================

        }
        // 끝 => 에러__없으면
        //===========================================================

        #############################################################
        # 끝 => 카페 코드
        #############################################################

      ###############################################################
      # 끝 => 중복확인_하기
      ###############################################################

    }
    // 끝 => 카페_코드__있으면
    //===============================================================


    //===============================================================
    // 넘겨주기____결과__배열
    return $cafe_result_a;
    // return array('cafe_error_n'=>$cafe_result_a['cafe_error_n'], 'cafe_result_s'=>$cafe_result_a['cafe_result_s']);

  }
  ###################################################################
  # 끝 => 피리_카페__카페_코드__검증하기__중복확인_하기
  ###################################################################



  ###################################################################
  # 시작 => 
  ###################################################################

    //===============================================================
    // 전역변수
    // global $piree;


    //===============================================================
    // 


    //===============================================================
    // 시작 => 

      //=============================================================
      // 


      //=============================================================
      // 

    // 끝 => 
    //===============================================================


    //===============================================================
    // 

  ###################################################################
  # 끝 => 
  ###################################################################



  ###################################################################
  # 시작 => 피리_카페_자료별_테이블_번호_이름__알아내기
  ###################################################################
  function cafe_table_get($func_cafe_n=0, $func_table_n=0)
  {

    //===============================================================
    // 시작 => 자료_번호__테이블_번호__둘다__있으면
    IF ( $func_cafe_n > 0 || $func_table_n > 0 )
    {

      //=============================================================
      // 전역변수
      global $piree;


      //=============================================================
      // 넘겨줄_테이블_정보
      $table_info_a['table_n'] = 0;
      $table_info_a['table_c'] = '';


      //=============================================================
      // 시작 => 자료_번호__테이블_번호__조건_확인
      IF ( $func_cafe_n > 0 )
      {
        $table_info_a['table_n'] = ceil($func_cafe_n/$piree['lindex_data_div_n']);
      }
      ELSE
      {
        $table_info_a['table_n'] = $func_table_n;
      }
      // 끝 => 자료_번호__테이블_번호__조건_확인
      //=============================================================


      //=============================================================
      // 테이블_코드
      $table_info_a['table_c'] = $piree['cafe'] .'_'. $table_info_a['table_n'];


      //=============================================================
      // 넘겨주기
      return $table_info_a;

    }
    // 끝 => 자료_번호__테이블_번호__둘다__있으면
    //===============================================================

  }
  ###################################################################
  # 끝 => 피리_카페_자료별_테이블_번호_이름__알아내기
  ###################################################################


#####################################################################
# 끝 => 함수
#####################################################################





#####################################################################
# 시작 => 피리_NETT__설정_정보__가져오기____함수형
#####################################################################


  ###################################################################
  # 시작 => 기본_설정__정보
  ###################################################################

  //=================================================================
  // 피리_NETT__사용여부
  // 0 - 안함
  // 1 - 사용함
  $piree_cafe_prog_a[$piree_cafe_prog_a[790000]['num']]['is_use'] = 0;


  //=================================================================
  // 프로그램__디렉토리
  $piree_cafe_prog_a[$piree_cafe_prog_a[790000]['num']]['prog_d'] = "p". $piree_cafe_prog_a[790000]['num'];


  //=================================================================
  // 프로그램__경로
  $piree_cafe_prog_a[$piree_cafe_prog_a[790000]['num']]['prog_u'] = piree__url($piree_cafe_prog_a[790000]['num']);
  $piree_cafe_prog_a[$piree_cafe_prog_a[790000]['num']]['prog_p'] = piree__path($piree_cafe_prog_a[790000]['num']);


  //=================================================================
  // 프로그램__이미지__경로
  $piree_cafe_prog_a[$piree_cafe_prog_a[790000]['num']]['img_u'] = $piree_cafe_prog_a[$piree_cafe_prog_a[790000]['num']]['prog_u'] .'images';
  $piree_cafe_prog_a[$piree_cafe_prog_a[790000]['num']]['img_p'] = $piree_cafe_prog_a[$piree_cafe_prog_a[790000]['num']]['prog_p'] .'images';

  ###################################################################
  # 끝 => 기본_설정__정보
  ###################################################################



  ###################################################################
  # 시작 => 피리_NETT__설정_정보__가져오기
  ###################################################################

  //=================================================================
  // 시작 => p790000__피리_NETT__설정_정보__가져오기__이면
  IF ( $p790000_get == 1 )
  {

    //===============================================================
    // 피리_NETT__정보__가져오기
    $prog_conf = get_progran_row($piree_cafe_prog_a[790000]['num']);


    //===============================================================
    // 시작 => 프로그램_번호__맞으면
    IF ( $piree_cafe_prog_a[790000]['num'] == $prog_conf['pgs_prog_n'] )
    {

      ###############################################################
      # 시작 => 프로그램__기본_정보
      ###############################################################

      //=============================================================
      // 프로그램_번호
      $incl__prog_n = $piree_cafe_prog_a[790000]['num'];


      //=============================================================
      // 프로그램_설정__공통_값__파일__첨부
      include_once( piree__path($piree_prog_a[770100]['num'], 'program.config.common.inc.php') );

      ###############################################################
      # 끝 => 프로그램__기본_정보
      ###############################################################



      ###############################################################
      # 시작 => 설정_값
      ###############################################################

      //=============================================================
      // 


      //=============================================================
      // 

      ###############################################################
      # 끝 => 설정_값
      ###############################################################



      ###############################################################
      # 시작 => 기본_값
      ###############################################################

      ###############################################################
      # 끝 => 기본_값
      ###############################################################

    }
    // 끝 => 프로그램_번호__맞으면
    //===============================================================

  }
  // 끝 => p790000__피리_NETT__설정_정보__가져오기__이면
  //=================================================================

  ###################################################################
  # 끝 => 피리_NETT__설정_정보__가져오기
  ###################################################################


#####################################################################
# 끝 => 피리_NETT__설정_정보__가져오기____기본형
#####################################################################


?>