<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 For 그누보드5.5 순정

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https://piree.kr/nett_dev

  작성날짜 : 2024년 04월 09일 화요일 오후 15시 15분 / 맑음, 19.6, 건조주의보, 18, 8, 1%, 0%, 2.5ms / 좋음, 28, 13

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
             그누보드 외에 추가된 소스는~
             만든사람의 허락없이 무단으로 사용할수 없습니다.
             사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
             https://piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 For 그누보드5.5 순정 > 피리 카페 For 그누보드5.5 순정 > 피리 카페 관리 > 스킨 > PC > MAIN > 게시판 분류 추가 > FORM
=====================================================================


피리가 인생을 살며 보고, 듣고, 느낀 이야기들을 기록하는 피리 카페입니다.
열심히 기록할께요.


      <a href="./board_thumbnail_delete.php?bca_table=<?php echo $board_cate_list_a[$board_cate_n]['bca_table']. '&amp;'. $qstr;?>" onclick="return delete_confirm2('게시판 썸네일 파일을 삭제하시겠습니까?');" class="btn_cancel btn">게시판 썸네일 삭제</a>


*/


  ###################################################################
  # 시작 => 선_처리
  ###################################################################

  //=================================================================
  // 개별_페이지__접근_불가
  IF ( !defined('_GNUBOARD_') )                             EXIT;


  //=================================================================
  // add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
  add_stylesheet('<link rel="stylesheet" href="'. get_cafe_skin_file('url', 'manage', 'p770100.manage.style.pc.css') .'">', 0);


  //=================================================================
  // add_javascript('js 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
  add_javascript('<script src="'. $p770100__skin_pc_u .'/p770100.cafe.make.js"></script>', 0);

  ###################################################################
  # 끝 => 선_처리
  ###################################################################



  ###################################################################
  # 시작 => 탭__링크
  ###################################################################

  //=================================================================
  // 탭__링크
  $pwp_tab  = '<ul class="piree_anchor">';
  $pwp_tab .= '  <li><a href="#anc__bca_basic">기본 설정</a></li>';
  $pwp_tab .= '  <li><a href="#anc__bca_auth">권한 설정</a></li>';
  $pwp_tab .= '  <li><a href="#anc__bca_function">기능 설정</a></li>';
  $pwp_tab .= '  <li><a href="#anc__bca_design">디자인/양식</a></li>';
  $pwp_tab .= '  <li><a href="#anc__bca_point">포인트 설정</a></li>';
  $pwp_tab .= '  <li><a href="#anc__bca_extra">여분필드</a></li>';
  $pwp_tab .= '</ul>';

  ###################################################################
  # 끝 => 탭__링크
  ###################################################################

?>

  <form method="post" name="board_category_config_form" id="board_category_config_form" action="<?php echo $piree_cafe_board_category_regist_action_u; ?>" onSubmit="piree_cafe_board_form_submit(this);">
  <input type="hidden" id="mode_c"            name="mode_c"            value="<?php echo $mode_c; ?>">
  <input type="hidden" id="cate_work_c"       name="cate_work_c"       value="<?php echo $cate_work_c; ?>">
  <input type="hidden" id="piree_cafe_n"      name="piree_cafe_n"      value="<?php echo $piree_cafe_n; ?>">
  <input type="hidden" id="board_cate_n"      name="board_cate_n"      value="<?php echo $board_cate_n; ?>">
  <input type="hidden" id="piree_cafe_name_s" name="piree_cafe_name_s" value="<?php echo $piree_cafe_name_s; ?>">

<!---- 시작 => 게시판_설정__FORM ---->
  <div class="piree_cafe_body_out">

    <div class="piree_cafe_body_title"><?php echo $g5['title']; ?></div>

    <div id="anc__bca_basic" style="margin-top:10px;">
      <h2>분류 정보 설정</h2>

      <?php echo $pwp_tab ?>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          게시판 분류 번호
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <span class="str_444_bold_10"><?php echo $board_cate_n ?></span>
            </p>
          </div>
        </div>
      </div>


<?php

    //=============================================================
    // 시작 => 수정_입력__구분
    IF ( $mode_c == 'modify' )
    {
?>
      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          현재 게시판 분류
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <span class="str_444_bold_10"><?php echo str_replace('--', ' > ', $now_cate_path_s); ?></span>
            </p>
            <p>
              <span class="font_37b44a">지금 선택된 게시판 분류입니다.</span>
            </p>
          </div>
        </div>
      </div>

<?php
    }
    ELSE IF ( $cate_name_parent_s )
    {
?>
      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          부모 (상위) 분류
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <span class="str_444_bold_10"><?php echo $cate_name_parent_s; ?></span>
            </p>
            <p>
              <span class="font_37b44a"><?php echo $cate_name_parent_s; ?> 아래에 게시판 분류를 추가 합니다.</span>
            </p>
          </div>
        </div>
      </div>

<?php
    }
    // 끝 => 수정_입력__구분
    //=============================================================

?>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="board_cate_name_s">게시판 분류 이름</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
<?php

          //=========================================================
          // 시작 => 게시판_설정__기본값_인지__아닌지__구분
          SWITCH ($cate_work_c)
          {

            #########################################################
            # 시작 => 기본값__설정
            CASE 'default' :

?>
              <span class="str_3334dd_bold_13">게시판 분류 기본값 설정</span> 
<?php
            BREAK;


            #########################################################
            # 시작 => 게시판_분류__설정
            DEFAULT :

?>
              <input type="text" name="board_cate_name_s" id="board_cate_name_s" value="<?php echo $cate_name_now_s; ?>" class="frm_input required" required placeholder="게시판 분류 입력" style="width:590px !important;"> 
<?php
            BREAK;

          }
          // 끝 => 게시판_설정__기본값_인지__아닌지__구분
          //=========================================================

?>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_device">접속기기</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <select id="bca_device" name="bca_device">
                <option value="both"<?php echo get_selected($board_cate_list_a[$board_cate_n]['bca_device'], 'both'); ?>>PC와 모바일에서 모두 사용</option>
                <option value="pc"<?php echo get_selected($board_cate_list_a[$board_cate_n]['bca_device'], 'pc'); ?>>PC 전용</option>
                <option value="mobile"<?php echo get_selected($board_cate_list_a[$board_cate_n]['bca_device'], 'mobile'); ?>>모바일 전용</option>
              </select>
            </p>
            <p>
              <span class="font_37b44a">PC 와 모바일 사용을 구분합니다.</span>
            </p>
          </div>
        </div>
      </div>

    </div>


    <div class="piree_cafe_body_line" style="padding-left:160px;">
      <input type="submit" value="  게시판 정보를 저장합니다  " class="btn_submit btn">
      <a href="<?php echo PIREE_CAFE_MANAGE_URL .'/board.category.list.php?piree_cafe_n='. $piree_cafe_n; ?>" class="btn_cancel btn">게시판 분류 목록</a>
<?php

    IF ( $cate_name_s )
    {
?>
      <a href="<?php echo go_piree_cafe_board('', $piree_cafe_n); ?>" class="btn_cancel btn">게시판 바로가기</a>
<?php
    }

?>
    </div>

    <br><br>




    <div id="anc__bca_auth" style="margin-top:10px;">
      <h2>게시판 권한 설정</h2>

      <?php echo $pwp_tab ?>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_list_level">목록보기 권한</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="fl_left line_h_2_2" style="margin-right:30px;">
            <?php echo get_member_level_select__piree('bca_list_level', 'bca_list_level', 1, 10, $board_cate_list_a[$board_cate_n]['bca_list_level'], '', ''); ?> 
          </div>
          <div class="fl_left line_h_2_2">
            <span class="font_37b44a">권한 1은 비회원, 2 이상 회원입니다. 권한은 10 이 가장 높습니다.</span>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_read_level">글읽기 권한</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <?php echo get_member_level_select__piree('bca_read_level', 'bca_read_level', 1, 10, $board_cate_list_a[$board_cate_n]['bca_read_level'], '', ''); ?> 
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_write_level">글쓰기 권한</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <?php echo get_member_level_select__piree('bca_write_level', 'bca_write_level', 2, 10, $board_cate_list_a[$board_cate_n]['bca_write_level'], '', ''); ?> 
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_reply_level">글답변 권한</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <?php echo get_member_level_select__piree('bca_reply_level', 'bca_reply_level', 2, 10, $board_cate_list_a[$board_cate_n]['bca_reply_level'], '', ''); ?> 
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_comment_level">댓글쓰기 권한</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <?php echo get_member_level_select__piree('bca_comment_level', 'bca_comment_level', 2, 10, $board_cate_list_a[$board_cate_n]['bca_comment_level'], '', ''); ?> 
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_link_level">링크 권한</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <?php echo get_member_level_select__piree('bca_link_level', 'bca_link_level', 1, 10, $board_cate_list_a[$board_cate_n]['bca_link_level'], '', ''); ?> 
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_upload_level">업로드 권한</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <?php echo get_member_level_select__piree('bca_upload_level', 'bca_upload_level', 1, 10, $board_cate_list_a[$board_cate_n]['bca_upload_level'], '', ''); ?> 
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_download_level">다운로드 권한</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <?php echo get_member_level_select__piree('bca_download_level', 'bca_download_level', 1, 10, $board_cate_list_a[$board_cate_n]['bca_download_level'], '', ''); ?> 
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_html_level">HTML 쓰기 권한</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <?php echo get_member_level_select__piree('bca_html_level', 'bca_html_level', 1, 10, $board_cate_list_a[$board_cate_n]['bca_html_level'], '', ''); ?> 
          </div>
        </div>
      </div>

    </div>


    <div class="piree_cafe_body_line" style="padding-left:160px;">
      <input type="submit" value="  게시판 정보를 저장합니다  " class="btn_submit btn">
      <a href="<?php echo PIREE_CAFE_MANAGE_URL .'/board.category.list.php?piree_cafe_n='. $piree_cafe_n; ?>" class="btn_cancel btn">게시판 분류 목록</a>
<?php

    IF ( $cate_name_s )
    {
?>
      <a href="<?php echo go_piree_cafe_board('', $piree_cafe_n); ?>" class="btn_cancel btn">게시판 바로가기</a>
<?php
    }

?>
    </div>

    <br><br>




    <div id="anc__bca_function" style="margin-top:10px;">
      <h2>게시판 기능 설정</h2>

      <?php echo $pwp_tab ?>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_count_modify">원글 수정 불가<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              댓글 <input type="text" name="bca_count_modify" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_count_modify'] ?>" id="bca_count_modify" class="numeric frm_input" size="3" style="width:120px !important;"> 개 이상 달리면 수정불가
            </p>
            <p>
              <span class="font_37b44a">댓글의 수가 설정 수 이상이면 원글을 수정할 수 없습니다.</span>
            </p>
            <p>
              <span class="font_37b44a">0으로 설정하시면 댓글 수에 관계없이 수정할 수있습니다.</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_count_delete">원글 삭제 불가<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            댓글 <input type="text" name="bca_count_delete" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_count_delete'] ?>" id="bca_count_delete" class="numeric frm_input" size="3" style="width:120px !important;"> 개 이상 달리면 삭제불가
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_sideview">글쓴이 사이드뷰</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="checkbox" name="bca_use_sideview" value="1" id="" <?php echo $board_cate_list_a[$board_cate_n]['bca_use_sideview'] ? 'checked' : ''; ?>>
            사용 (글쓴이 클릭시 나오는 레이어 메뉴)
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_secret">비밀글 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <select id="bca_use_secret" name="bca_use_secret">
                <?php echo option_selected(0, $board_cate_list_a[$board_cate_n]['bca_use_secret'], "사용하지 않음"); ?>
                <?php echo option_selected(1, $board_cate_list_a[$board_cate_n]['bca_use_secret'], "체크박스"); ?>
                <?php echo option_selected(2, $board_cate_list_a[$board_cate_n]['bca_use_secret'], "무조건"); ?>
              </select>
            </p>
            <p>
              <span class="font_37b44a">"체크박스"는 글작성시 비밀글 체크가 가능합니다.</span>
            </p>
            <p>
              <span class="font_37b44a">"무조건"은 작성되는 모든글을 비밀글로 작성합니다. (관리자는 체크박스로 출력합니다.)</span>
            </p>
            <p>
              <span class="font_37b44a">스킨에 따라 적용되지 않을 수 있습니다.</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_dhtml_editor">DHTML 에디터 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="checkbox" name="bca_use_dhtml_editor" value="1" <?php echo $board_cate_list_a[$board_cate_n]['bca_use_dhtml_editor'] ? 'checked' : ''; ?> id="bca_use_dhtml_editor">
            사용
            </p>
            <p>
              <span class="font_37b44a">글작성시 내용을 DHTML 에디터 기능으로 사용할 것인지 설정합니다.</span>
            </p>
            <p>
              <span class="font_37b44a">스킨에 따라 적용되지 않을 수 있습니다.</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_select_editor">게시판 에디터 선택</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <select name="bca_select_editor" id="bca_select_editor">
<?php

                $skin_list_a = get_g5_skin_dir('', G5_EDITOR_PATH);
                FOR ( $loop_n=0; $loop_n<count($skin_list_a); $loop_n++ )
                {

                  IF ( $loop_n == 0 )
                  {
                        echo "<option value=\"\">기본환경설정의 에디터 사용</option>";
                  }

?>
                  <option value="<?php echo $skin_list_a[$loop_n]; ?>"<?php echo get_selected($board_cate_list_a[$board_cate_n]['bca_select_editor'], $skin_list_a[$loop_n]); ?>><?php echo $skin_list_a[$loop_n]; ?></option>
<?php


                }

?>
              </select>
            </p>
            <p>
              <span class="font_37b44a">게시판에 사용할 에디터를 설정합니다. 스킨에 따라 적용되지 않을 수 있습니다.</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_rss_view">RSS 보이기 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="checkbox" name="bca_use_rss_view" value="1" <?php echo $board_cate_list_a[$board_cate_n]['bca_use_rss_view'] ? 'checked' : ''; ?> id="bca_use_rss_view">
            사용
            </p>
            <p>
              <span class="font_37b44a">비회원 글읽기가 가능하고 RSS 보이기 사용에 체크가 되어야만 RSS 지원을 합니다.</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_good">추천 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="checkbox" name="bca_use_good" value="1" <?php echo $board_cate_list_a[$board_cate_n]['bca_use_good'] ? 'checked' : ''; ?> id="bca_use_good">
            사용
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_nogood">비추천 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="checkbox" name="bca_use_nogood" value="1" id="bca_use_nogood" <?php echo $board_cate_list_a[$board_cate_n]['bca_use_nogood'] ? 'checked' : ''; ?>>
            사용
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_name">이름(실명) 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="checkbox" name="bca_use_name" value="1" id="bca_use_name" <?php echo $board_cate_list_a[$board_cate_n]['bca_use_name'] ? 'checked' : ''; ?>>
            사용
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_signature">서명보이기 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="checkbox" name="bca_use_signature" value="1" id="bca_use_signature" <?php echo $board_cate_list_a[$board_cate_n]['bca_use_signature'] ? 'checked' : ''; ?>>
            사용
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_ip_view">IP 보이기 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="checkbox" name="bca_use_ip_view" value="1" id="bca_use_ip_view" <?php echo $board_cate_list_a[$board_cate_n]['bca_use_ip_view'] ? 'checked' : ''; ?>>
            사용
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_list_content">목록에서 내용 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="checkbox" name="bca_use_list_content" value="1" id="bca_use_list_content" <?php echo $board_cate_list_a[$board_cate_n]['bca_use_list_content'] ? 'checked' : ''; ?>>
              사용 (사용시 속도가 느려질 수 있습니다.)
            </p>
            <p>
              <span class="font_37b44a">목록에서 게시판 제목외에 내용도 읽어와야 할 경우에 설정하는 옵션입니다.</span>
            </p>
            <p>
              <span class="font_37b44a">기본은 사용하지 않습니다.</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_list_file">목록에서 파일 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="checkbox" name="bca_use_list_file" value="1" id="bca_use_list_file" <?php echo $board_cate_list_a[$board_cate_n]['bca_use_list_file'] ? 'checked' : ''; ?>>
              사용 (사용시 속도가 느려질 수 있습니다.)
            </p>
            <p>
              <span class="font_37b44a">목록에서 게시판 첨부파일을 읽어와야 할 경우에 설정하는 옵션입니다. 기본은 사용하지 않습니다.</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_list_view">전체목록보이기 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="checkbox" name="bca_use_list_view" value="1" id="bca_use_list_view" <?php echo $board_cate_list_a[$board_cate_n]['bca_use_list_view'] ? 'checked' : ''; ?>>
            사용
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_email">메일발송 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="checkbox" name="bca_use_email" value="1" id="bca_use_email" <?php echo $board_cate_list_a[$board_cate_n]['bca_use_email'] ? 'checked' : ''; ?>>
            사용
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_cert">본인확인 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <select id="bca_use_cert" name="bca_use_cert">
<?php

                echo option_selected("", $board_cate_list_a[$board_cate_n]['bca_use_cert'], "사용안함");

                IF ( $config['cf_cert_use'] )
                {
                  echo option_selected("cert", $board_cate_list_a[$board_cate_n]['bca_use_cert'], "본인확인된 회원전체");
                  echo option_selected("adult", $board_cate_list_a[$board_cate_n]['bca_use_cert'], "본인확인된 성인회원만");
                }

?>
              </select>
            </p>
            <p>
              <span class="font_37b44a">본인확인 여부에 따라 게시물을 조회 할 수 있도록 합니다.</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_upload_count">파일 업로드 개수<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_upload_count" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_upload_count'] ?>" id="bca_upload_count" required class="required numeric frm_input" size="4" style="width:120px !important;">
            </p>
            <p>
              <span class="font_37b44a">게시물 한건당 업로드 할 수 있는 파일의 최대 개수 (0 은 파일첨부 사용하지 않음)</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_upload_size">파일 업로드 용량<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              업로드 파일 한개당 <input type="text" name="bca_upload_size" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_upload_size'] ?>" id="bca_upload_size" required class="required numeric frm_input"  size="10" style="width:120px !important;"> bytes 이하
            </p>
            <p>
              <span class="font_37b44a">최대 <?php echo ini_get("upload_max_filesize"); ?> 이하 업로드 가능, 1 MB = 1,048,576 bytes</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_file_content">파일 설명 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="checkbox" name="bca_use_file_content" value="1" id="bca_use_file_content" <?php echo $board_cate_list_a[$board_cate_n]['bca_use_file_content'] ? 'checked' : ''; ?>> 
            사용
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_write_min">최소 글수 제한</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_write_min" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_write_min'] ?>" id="bca_write_min" class="numeric frm_input" size="4" style="width:120px !important;">
            </p>
            <p>
              <span class="font_37b44a">글 입력시 최소 글자수를 설정. 0을 입력하거나 최고관리자, DHTML 에디터 사용시에는 검사하지 않음</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_write_max">최대 글수 제한</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_write_max" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_write_max'] ?>" id="bca_write_max" class="numeric frm_input" size="4" style="width:120px !important;">
            </p>
            <p>
              <span class="font_37b44a">글 입력시 최대 글자수를 설정. 0을 입력하거나 최고관리자, DHTML 에디터 사용시에는 검사하지 않음</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_comment_min">최소 댓글수 제한</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_comment_min" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_comment_min'] ?>" id="bca_comment_min" class="numeric frm_input" size="4" style="width:120px !important;">
            </p>
            <p>
              <span class="font_37b44a">댓글 입력시 최소 글자수를 설정. 0을 입력하면 검사하지 않음</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_comment_max">최대 댓글수 제한</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_comment_max" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_comment_max'] ?>" id="bca_comment_max" class="numeric frm_input" size="4" style="width:120px !important;">
            </p>
            <p>
              <span class="font_37b44a">댓글 입력시 최대 글자수를 설정. 0을 입력하면 검사하지 않음</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_sns">SNS 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="checkbox" name="bca_use_sns" value="1" id="bca_use_sns" <?php echo $board_cate_list_a[$board_cate_n]['bca_use_sns'] ? 'checked' : ''; ?>>
              사용
            </p>
            <p>
              <span class="font_37b44a">사용에 체크하시면 소셜네트워크서비스(SNS)에 글을 퍼가거나 댓글을 동시에 등록할수 있습니다.</span>
            </p>
            <p>
              <span class="font_37b44a">기본환경설정의 SNS 설정을 하셔야 사용이 가능합니다.</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_search">전체 검색 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="checkbox" name="bca_use_search" value="1" id="bca_use_search" <?php echo $board_cate_list_a[$board_cate_n]['bca_use_search'] ? 'checked' : ''; ?>>
            사용
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_order">출력 순서</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_order" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_order'] ?>" id="bca_order" class="frm_input" size="4" style="width:120px !important;">
            </p>
            <p>
              <span class="font_37b44a">숫자가 낮은 게시판 부터 메뉴나 검색시 우선 출력합니다.</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_use_captcha">캡챠 사용</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="checkbox" name="bca_use_captcha" value="1" <?php echo $board_cate_list_a[$board_cate_n]['bca_use_captcha'] ? 'checked' : ''; ?> id="bca_use_captcha">
              사용
            </p>
            <p>
              <span class="font_37b44a">체크하면 글 작성시 캡챠를 무조건 사용합니다.( 회원 + 비회원 모두 )</span>
            </p>
            <p>
              <span class="font_37b44a">미 체크하면 비회원에게만 캡챠를 사용합니다.</span>
            </p>
          </div>
        </div>
      </div>

    </div>


    <div class="piree_cafe_body_line" style="padding-left:160px;">
      <input type="submit" value="  게시판 정보를 저장합니다  " class="btn_submit btn">
      <a href="<?php echo PIREE_CAFE_MANAGE_URL .'/board.category.list.php?piree_cafe_n='. $piree_cafe_n; ?>" class="btn_cancel btn">게시판 분류 목록</a>
<?php

    IF ( $cate_name_s )
    {
?>
      <a href="<?php echo go_piree_cafe_board('', $piree_cafe_n); ?>" class="btn_cancel btn">게시판 바로가기</a>
<?php
    }

?>
    </div>

    <br><br>




    <div id="anc__bca_design" style="margin-top:10px;">
      <h2>게시판 디자인/양식</h2>

      <?php echo $pwp_tab ?>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_pc_skin">PC 스킨 디렉토리<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <select id="bca_pc_skin" name="bca_pc_skin">
              <option value="">-- 스킨 선택 --</option>
<?php

            //=======================================================
            // PC__스킨_목록__가져오기
            $skin_list_a = get_g5_skin_dir(PIREE_CAFE_SKIN_BOARD_PC_DIR, $p770100__prog_p);


            //=======================================================
            // 시작 => 반복문
            FOR ( $loop_n=0; $loop_n<count($skin_list_a); $loop_n++ )
            {
              // 선택_여부
              $selected = $board_cate_list_a[$board_cate_n]['bca_pc_skin'] == $skin_list_a[$loop_n] ? " selected" : "";
?>
              <option value="<?php echo $skin_list_a[$loop_n]; ?>"<?php echo $selected; ?>><?php echo $skin_list_a[$loop_n]; ?></option>
<?php
            }
            // 끝 => 반복문
            //=======================================================

?>
            </select>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_mo_skin">모바일 스킨 디렉토리<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <select id="bca_mo_skin" name="bca_mo_skin">
              <option value="">-- 스킨 선택 --</option>
<?php

            //=======================================================
            // PC__스킨_목록__가져오기
            $skin_list_a = get_g5_skin_dir(PIREE_CAFE_SKIN_BOARD_MO_DIR, $p770100__prog_p);


            //=======================================================
            // 시작 => 반복문
            FOR ( $loop_n=0; $loop_n<count($skin_list_a); $loop_n++ )
            {
              // 선택_여부
              $selected = $board_cate_list_a[$board_cate_n]['bca_mo_skin'] == $skin_list_a[$loop_n] ? " selected" : "";
?>
              <option value="<?php echo $skin_list_a[$loop_n]; ?>"<?php echo $selected; ?>><?php echo $skin_list_a[$loop_n]; ?></option>
<?php
            }
            // 끝 => 반복문
            //=======================================================

?>
            </select>
          </div>
        </div>
      </div>

<?php

    //===============================================================
    // 시작 => 최고관리자__또는__카페_주인__이면
    IF ( piree_cafe_auth_get() )
    {
?>
      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_include_head">상단 파일 경로</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="text" name="bca_include_head" value="<?php echo get_g5_sanitize_input($board_cate_list_a[$board_cate_n]['bca_include_head']); ?>" id="bca_include_head" class="frm_input" size="50" style="width:590px !important;">
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_include_tail">하단 파일 경로</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="text" name="bca_include_tail" value="<?php echo get_g5_sanitize_input($board_cate_list_a[$board_cate_n]['bca_include_tail']); ?>" id="bca_include_tail" class="frm_input" size="50" style="width:590px !important;">
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          자동등록방지</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
<?php

            include_once G5_CAPTCHA_PATH.'/captcha.lib.php';
            $captcha_html = captcha_html();
            $captcha_js   = chk_captcha_js();
            echo $captcha_html;

?>
            <script>
              jQuery("#captcha_key").removeAttr("required").removeClass("required");
            </script>
          </div>
          <div class="line_h_2_2">
            <span class="font_37b44a">파일 경로를 입력 또는 수정시 캡챠를 반드시 입력해야 합니다.</span>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_pc_content_head">PC 화면 상단 내용</label>
        </div>
        <div class="piree_cafe_body_cont" style="width:760px;">
          <div class="line_h_2_2">
            <?php echo editor_html("bca_pc_content_head", get_text(html_purifier($board_cate_list_a[$board_cate_n]['bca_pc_content_head']), 0));?>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_pc_content_tail">PC 화면 하단 내용</label>
        </div>
        <div class="piree_cafe_body_cont" style="width:760px;">
          <div class="line_h_2_2">
            <?php echo editor_html("bca_pc_content_tail", get_text(html_purifier($board_cate_list_a[$board_cate_n]['bca_pc_content_tail']), 0));?>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_mo_content_head">모바일 화면 상단 내용</label>
        </div>
        <div class="piree_cafe_body_cont" style="width:760px;">
          <div class="line_h_2_2">
            <?php echo editor_html("bca_mo_content_head", get_text(html_purifier($board_cate_list_a[$board_cate_n]['bca_mo_content_head']), 0));?>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_mo_content_tail">모바일 화면 하단 내용</label>
        </div>
        <div class="piree_cafe_body_cont" style="width:760px;">
          <div class="line_h_2_2">
            <?php echo editor_html("bca_mo_content_tail", get_text(html_purifier($board_cate_list_a[$board_cate_n]['bca_mo_content_tail']), 0));?>
          </div>
        </div>
      </div>
<?php
    }
    // 끝 => 최고관리자__또는__카페_주인__이면
    //===============================================================

?>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_insert_content">글쓰기 기본 내용</label>
        </div>
        <div class="piree_cafe_body_cont" style="width:760px;">
          <div class="line_h_2_2">
            <textarea id="bca_insert_content" name="bca_insert_content" style="width:760px; height:200px;"><?php echo html_purifier($board_cate_list_a[$board_cate_n]['bca_insert_content']); ?></textarea>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_pc_subject_len">PC 화면 제목 길이<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_pc_subject_len" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_pc_subject_len'] ?>" id="bca_pc_subject_len" required class="required numeric frm_input" size="4" style="width:120px !important;">
            </p>
            <p>
              <span class="font_37b44a">목록에서의 제목 글자수. 잘리는 글은 … 로 표시</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_mo_subject_len">모바일 화면 제목 길이<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_mo_subject_len" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_mo_subject_len'] ?>" id="bca_mo_subject_len" required class="required numeric frm_input" size="4" style="width:120px !important;">
            </p>
            <p>
              <span class="font_37b44a">목록에서의 제목 글자수. 잘리는 글은 … 로 표시</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_pc_page_rows">PC 페이지당 목록 수<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="text" name="bca_pc_page_rows" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_pc_page_rows'] ?>" id="bca_pc_page_rows" required class="required numeric frm_input" size="4" style="width:120px !important;">
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_mo_page_rows">모바일 페이지당 목록 수<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="text" name="bca_mo_page_rows" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_mo_page_rows'] ?>" id="bca_mo_page_rows" required class="required numeric frm_input" size="4" style="width:120px !important;">
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_gallery_cols">갤러리 이미지 수<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_gallery_cols" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_gallery_cols'] ?>" id="bca_gallery_cols" required class="required numeric frm_input" size="4" style="width:120px !important;">
            </p>
            <p>
              <span class="font_37b44a">갤러리 형식의 게시판 목록에서 이미지를 한줄에 몇장씩 보여 줄 것인지를 설정하는 값</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_pc_gallery_width">PC 갤러리 이미지 폭<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_pc_gallery_width" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_pc_gallery_width'] ?>" id="bca_pc_gallery_width" required class="required numeric frm_input" size="4" style="width:120px !important;">
            </p>
            <p>
              <span class="font_37b44a">PC 화면의 갤러리 형식의 게시판 목록에서 썸네일 이미지의 폭을 설정하는 값</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_pc_gallery_height">PC 갤러리 이미지 높이<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_pc_gallery_height" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_pc_gallery_height'] ?>" id="bca_pc_gallery_height" required class="required numeric frm_input" size="4" style="width:120px !important;">
            </p>
            <p>
              <span class="font_37b44a">PC 화면의 갤러리 형식의 게시판 목록에서 썸네일 이미지의 높이를 설정하는 값</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_mo_gallery_width">모바일 갤러리 이미지 폭<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_mo_gallery_width" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_mo_gallery_width'] ?>" id="bca_mo_gallery_width" required class="required numeric frm_input" size="4" style="width:120px !important;">
            </p>
            <p>
              <span class="font_37b44a">모바일 화면의 갤러리 형식의 게시판 목록에서 썸네일 이미지의 폭을 설정하는 값</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_mo_gallery_height">모바일 갤러리 이미지 높이<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_mo_gallery_height" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_mo_gallery_height'] ?>" id="bca_mo_gallery_height" required class="required numeric frm_input" size="4" style="width:120px !important;">
            </p>
            <p>
              <span class="font_37b44a">모바일로 접속시 갤러리 형식의 게시판 목록에서 썸네일 이미지의 높이를 설정하는 값</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_table_width">게시판 폭<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_table_width" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_table_width'] ?>" id="bca_table_width" required class="required numeric frm_input" size="4" style="width:120px !important;">
            </p>
            <p>
              <span class="font_37b44a">100 이하는 %</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_image_width">이미지 폭 크기<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_image_width" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_image_width'] ?>" id="bca_image_width" required class="required numeric frm_input" size="4" style="width:120px !important;"> 픽셀
            </p>
            <p>
              <span class="font_37b44a">게시판에서 출력되는 이미지의 폭 크기</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_new">새글 아이콘<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_new" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_new'] ?>" id="bca_new" required class="required numeric frm_input" size="4" style="width:120px !important;">
            </p>
            <p>
              <span class="font_37b44a">글 입력후 new 이미지를 출력하는 시간. 0을 입력하시면 아이콘을 출력하지 않습니다.</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_hot">인기글 아이콘<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <input type="text" name="bca_hot" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_hot'] ?>" id="bca_hot" required class="required numeric frm_input" size="4" style="width:120px !important;">
            </p>
            <p>
              <span class="font_37b44a">조회수가 설정값 이상이면 hot 이미지 출력. 0을 입력하시면 아이콘을 출력하지 않습니다.</span>
            </p>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_reply_order">답변 달기</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <select id="bca_reply_order" name="bca_reply_order">
              <option value="1"<?php echo get_selected($board_cate_list_a[$board_cate_n]['bca_reply_order'], 1, true); ?>>나중에 쓴 답변 아래로 달기 (기본)
              <option value="0"<?php echo get_selected($board_cate_list_a[$board_cate_n]['bca_reply_order'], 0); ?>>나중에 쓴 답변 위로 달기
            </select>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_sort_field">리스트 정렬 필드</label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <p>
              <select id="bca_sort_field" name="bca_sort_field">
<?php

              FOREACH ( get_board_sort_fields($board) as $v )
              {

                $option_value = $order_by_str = $v[0];

                IF ( $v[0] === 'wr_num, wr_reply' )
                {
                  $selected = (! $board_cate_list_a[$board_cate_n]['bca_sort_field']) ? 'selected="selected"' : '';
                  $option_value = '';
                }
                ELSE
                {
                  $selected = ($board_cate_list_a[$board_cate_n]['bca_sort_field'] === $v[0]) ? 'selected="selected"' : '';
                }

                IF ( $order_by_str !== 'wr_num, wr_reply' )
                {
                  $tmp = explode(',', $v[0]);
                  $order_by_str = $tmp[0];
                }

?>
                  echo '<option value="<?php echo $option_value; ?>" <?php echo $selected; ?>><?php echo $order_by_str .' : '. $v[1]; ?></option>
<?php
              }

?>
              </select>
            </p>
            <p>
              <span class="font_37b44a">리스트에서 기본으로 정렬에 사용할 필드를 선택합니다.</span>
            </p>
            <p>
              <span class="font_37b44a">"기본"으로 사용하지 않으시는 경우 속도가 느려질 수 있습니다.</span>
            </p>
          </div>
        </div>
      </div>

    </div>


    <div class="piree_cafe_body_line" style="padding-left:160px;">
      <input type="submit" value="  게시판 정보를 저장합니다  " class="btn_submit btn">
      <a href="<?php echo PIREE_CAFE_MANAGE_URL .'/board.category.list.php?piree_cafe_n='. $piree_cafe_n; ?>" class="btn_cancel btn">게시판 분류 목록</a>
<?php

    IF ( $cate_name_s )
    {
?>
      <a href="<?php echo go_piree_cafe_board('', $piree_cafe_n); ?>" class="btn_cancel btn">게시판 바로가기</a>
<?php
    }

?>
    </div>

    <br><br>




    <div id="anc__bca_point" style="margin-top:10px;">
      <h2>게시판 포인트 설정</h2>

      <?php echo $pwp_tab ?>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <div class="piree_cafe_body_label td_left_160">
            <label for="chk_grp_point">기본값으로 설정</label>
          </div>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="checkbox" name="chk_grp_point" id="chk_grp_point" onclick="set_point(this.form)"> 
            <span class="font_37b44a">환경설정에 입력된 포인트로 설정</span>
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_read_point">글읽기 포인트<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="text" name="bca_read_point" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_read_point'] ?>" id="bca_read_point" required class="required frm_input" size="5">
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_write_point">글쓰기 포인트<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="text" name="bca_write_point" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_write_point'] ?>" id="bca_write_point" required class="required frm_input" size="5">
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_comment_point">댓글쓰기 포인트<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="text" name="bca_comment_point" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_comment_point'] ?>" id="bca_comment_point" required class="required frm_input" size="5">
          </div>
        </div>
      </div>

      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          <label for="bca_download_point">다운로드 포인트<strong class="sound_only">필수</strong></label>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="line_h_2_2">
            <input type="text" name="bca_download_point" value="<?php echo $board_cate_list_a[$board_cate_n]['bca_download_point'] ?>" id="bca_download_point" required class="required frm_input" size="5">
          </div>
        </div>
      </div>

    </div>


    <div class="piree_cafe_body_line" style="padding-left:160px;">
      <input type="submit" value="  게시판 정보를 저장합니다  " class="btn_submit btn">
      <a href="<?php echo PIREE_CAFE_MANAGE_URL .'/board.category.list.php?piree_cafe_n='. $piree_cafe_n; ?>" class="btn_cancel btn">게시판 분류 목록</a>
<?php

    IF ( $cate_name_s )
    {
?>
      <a href="<?php echo go_piree_cafe_board('', $piree_cafe_n); ?>" class="btn_cancel btn">게시판 바로가기</a>
<?php
    }

?>
    </div>

    <br><br>




    <div id="anc__bca_extra" style="margin-top:10px;">
      <h2>게시판 여분필드 설정</h2>

      <?php echo $pwp_tab ?>

<?php

    FOR ( $loop_n=1; $loop_n<=10; $loop_n++ )
    {
?>
      <div class="piree_cafe_body_line">
        <div class="piree_cafe_body_label td_left_180">
          여분필드<?php echo $loop_n ?>
        </div>
        <div class="piree_cafe_body_cont">
          <div class="fl_left td_left_220 line_h_2_2">
            <label for="bca_<?php echo $loop_n ?>_subj">제목</label>
            <input type="text" name="bca_<?php echo $loop_n ?>_subj" id="bca_<?php echo $loop_n ?>_subj" value="<?php echo get_text($board_cate_list_a[$board_cate_n]['bca_'. $i.'_subj']) ?>" class="frm_input">
          </div>
          <div class="fl_left td_left_300 line_h_2_2">
            <label for="bca_<?php echo $loop_n ?>">값</label>
            <input type="text" name="bca_<?php echo $loop_n ?>" value="<?php echo get_text($board_cate_list_a[$board_cate_n]['bca_'. $i]) ?>" id="bca_<?php echo $loop_n ?>" class="frm_input extra-value-input">
          </div>
        </div>
      </div>
<?php
    }

?>

    </div>


    <div class="piree_cafe_body_line" style="padding-left:160px;">
      <input type="submit" value="  게시판 정보를 저장합니다  " class="btn_submit btn">
      <a href="<?php echo PIREE_CAFE_MANAGE_URL .'/board.category.list.php?piree_cafe_n='. $piree_cafe_n; ?>" class="btn_cancel btn">게시판 분류 목록</a>
<?php

    IF ( $cate_name_s )
    {
?>
      <a href="<?php echo go_piree_cafe_board('', $piree_cafe_n); ?>" class="btn_cancel btn">게시판 바로가기</a>
<?php
    }

?>
    </div>
<!---- 끝 => 게시판_설정__FORM ---->

  </div>

  </form>


<script>
$(function(){
    $("#board_copy").click(function(){
        window.open(this.href, "win_board_copy", "left=10,top=10,width=500,height=400");
        return false;
    });

    $(".get_theme_galc").on("click", function() {
        IF (!confirm("현재 테마의 게시판 이미지 설정을 적용하시겠습니까?"))
            return false;

        $.ajax({
            type: "POST",
            url: "./theme_config_load.php",
            cache: false,
            async: false,
            data: { type: "board" },
            dataType: "json",
            success: function(data) {
                IF (data.error) {
                    alert(data.error);
                    return false;
                }

                var field = Array('bca_gallery_cols', 'bca_pc_gallery_width', 'bca_pc_gallery_height', 'bca_mobile_gallery_width', 'bca_mobile_gallery_height', 'bca_image_width');
                var count = field.length;
                var key;

                for(i=0; i<count; i++) {
                    key = field[i];

                    IF (data[key] != undefined && data[key] != "")
                        $("input[name="+key+"]").val(data[key]);
                }
            }
        });
    });
});

function board_copy(bca_table) {
    window.open("./board_copy.php?bca_table="+bca_table, "BoardCopy", "left=10,top=10,width=500,height=200");
}

function set_point(gform) {
    if (f.chk_grp_point.checked) {
        f.bca_read_point.value = "<?php echo $config['cf_read_point'] ?>";
        f.bca_write_point.value = "<?php echo $config['cf_write_point'] ?>";
        f.bca_comment_point.value = "<?php echo $config['cf_comment_point'] ?>";
        f.bca_download_point.value = "<?php echo $config['cf_download_point'] ?>";
    } else {
        f.bca_read_point.value     = f.bca_read_point.defaultValue;
        f.bca_write_point.value    = f.bca_write_point.defaultValue;
        f.bca_comment_point.value  = f.bca_comment_point.defaultValue;
        f.bca_download_point.value = f.bca_download_point.defaultValue;
    }
}

var captcha_chk = false;

function use_captcha_check(){
    $.ajax({
        type: "POST",
        url: g5_admin_url+"/ajax.use_captcha.php",
        data: { admin_use_captcha: "1" },
        cache: false,
        async: false,
        dataType: "json",
        success: function(data) {
        }
    });
}

var bca_include_head = jQuery.trim(jQuery("#bca_include_head").val()),
    bca_include_tail = jQuery.trim(jQuery("#bca_include_tail").val());

function frm_check_file(){
    var head = jQuery.trim(jQuery("#bca_include_head").val());
    var tail = jQuery.trim(jQuery("#bca_include_tail").val());

    IF (bca_include_head !== head || bca_include_tail !== tail){
        // 캡챠를 사용합니다.
        jQuery("#admin_captcha_box").show();
        captcha_chk = true;

        use_captcha_check();

        return false;
    } else {
        jQuery("#admin_captcha_box").hide();
    }

    return true;
}

jQuery(function($){
    IF ( window.self !== window.top ){   // frame 또는 iframe을 사용할 경우 체크
        $("#bca_include_head, #bca_include_tail").on("change paste keyup", function(e) {
            frm_check_file();
        });

        use_captcha_check();
    }
});

function piree_cafe_board_form_submit(gform)
{

    <?php echo get_editor_js("bca_pc_content_head"); ?>
    <?php echo get_editor_js("bca_pc_content_tail"); ?>
    <?php echo get_editor_js("bca_mo_content_head"); ?>
    <?php echo get_editor_js("bca_mo_content_tail"); ?>

    IF ( captcha_chk ) {
        <?php echo isset($captcha_js) ? $captcha_js : ''; // 캡챠 사용시 자바스크립트에서 입력된 캡챠를 검사함  ?>
    }

    return true;
}
</script>
