<?php

/*
=======================================================================

  프로젝트 이름 : 피리 카페 For 그누보드5.5 순정

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https://piree.kr/nett_dev

  작성날짜 : 2024년 04월 09일 화요일 오후 15시 35분 / 맑음, 18.0, 건조주의보, 18, 8, 1%, 0%, 2.5ms / 양호, 35, 15

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
              그누보드 외에 추가된 소스는~
              만든사람의 허락없이 무단으로 사용할수 없습니다.
              사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
              http://www.piree.kr 에 문의해 주세요.

=======================================================================
 피리 카페 For 그누보드5.5 순정 > 피리 카페 For 그누보드5.5 순정 > 피리 카페 관리 > 게시판 게시판 분류 추가 > 처리하기
=======================================================================


*/


  ###################################################################
  # 시작 => 선_처리
  ###################################################################

  //=================================================================
  // 라이브러리__첨부
  include_once('./_common.php');

  ###################################################################
  # 끝 => 선_처리
  ###################################################################



  ###################################################################
  # 시작 => 필요한__라이브러리__파일__첨부
  ###################################################################

/*
  * PIREE_SOSS
  * 피리 PIREE ( piree1977@gmail.com )
  * Ver 2.0.0
*/

  //=================================================================
  // 입력_관련_라이브러리__파일_첨부
  include_once( piree__path($piree_prog_a[770000]['num'], 'save.lib.php') );


  //=================================================================
  // 카페_게시판_분류__SMALLINT_2단계__관련_파일__첨부
  include_once( piree__path($piree_prog_a[770000]['num'], 'cafe.board.category.smallint.2.lib.php') );

  ###################################################################
  # 끝 => 필요한__라이브러리__파일__첨부
  ###################################################################



  ###################################################################
  # 시작 => OUERY_STRING
  ###################################################################

  //=================================================================
  // OUERY_STRING__POST
  $board_cafe_n      = (int)$_POST['board_cafe_n'];
  $board_cate_n      = (int)$_POST['board_cate_n'];
  $board_cate_name_s = save__str($_POST['board_cate_name_s']);

  ###################################################################
  # 끝 => OUERY_STRING
  ###################################################################



  ###################################################################
  # 시작 => 형변환__기본값__XSS_방지
  ###################################################################

  //=================================================================
  // 시작 => 피리_카페_번호__선택_안되었으면
  IF ( !$piree_cafe_n )
  {
    alert("[ 피리 카페 ]를 선택해 주세요.");
  }
  // 끝 => 피리_카페_번호__선택_안되었으면
  //=================================================================


  //=================================================================
  // 시작 => 게시판_설정__기본값_인지__아닌지__구분
  SWITCH ($cate_work_c)
  {

    #################################################################
    # 시작 => 기본값__설정
    #################################################################
    CASE 'default' :

      //=============================================================
      // 게시판_분류_번호
      $board_cate_n = 0;


      //=============================================================
      // 게시판_분류_이름
      $board_cate_name_s = "게시글 전체보기";

    BREAK;
    #################################################################
    # 끝 => 기본값__설정
    #################################################################



    #################################################################
    # 시작 => 게시판_분류__설정
    #################################################################
    DEFAULT :

      //=============================================================
      // 시작 => 게시판_분류_이름__입력_안되었으면
      IF ( !$board_cate_name_s )
      {
        alert("[ 게시판 분류 이름 ]을 입력해 주세요.");
      }
      // 끝 => 게시판_분류_이름__입력_안되었으면
      //=============================================================

    BREAK;
    #################################################################
    # 끝 => 게시판_분류__설정
    #################################################################

  }
  // 끝 => 게시판_설정__기본값_인지__아닌지__구분
  //=================================================================

  ###################################################################
  # 끝 => 형변환__기본값__XSS_방지
  ###################################################################



  ###################################################################
  # 시작 => 피리_카페__정보__확인하기
  ###################################################################

  //=================================================================
  // 피리_카페__정보__확인하기
  include_once( "./_CAFE.MANAGE.INFO.CHECK.inc.php" );

  ###################################################################
  # 끝 => 피리_카페__정보__확인하기
  ###################################################################



  ###################################################################
  # 시작 => 임시____단어_BASE_TABLE_ROW__삭제
  ###################################################################

/*


  //=================================================================
  // 삭제_하는__쿼리문
  $sql_delete = "DELETE FROM `". $piree['cafe_board'] ."`";


// ECHO $sql_delete ." <<================ SQL_DELETE > 1 > 1 <br>\n";


  //=================================================================
  // 시작 => 쿼리__실행
  IF ( !sql_query($sql_delete) )
  {

    //===============================================================
    // 에러_보여주기__끝내기
    echo "#ERROR:단어를 BASE ROW를 삭제하지 못했습니다.";
    // exit;

  }
  // 끝 => 쿼리__실행
  //=================================================================


  ###################################################################


  //=================================================================
  // 삭제_하는__쿼리문
  $sql_delete = "DELETE FROM `". $piree['cafe_board'] ."`";
  $sql_delete .= "WHERE `bca_row_n` > '10'";


// ECHO $sql_delete ." <<================ SQL_DELETE > 1 > 1 <br>\n";


  //=================================================================
  // 시작 => 쿼리__실행
  IF ( !sql_query($sql_delete) )
  {

    //===============================================================
    // 에러_보여주기__끝내기
    echo "#ERROR:단어를 BASE ROW를 삭제하지 못했습니다.";
    exit;

  }
  // 끝 => 쿼리__실행
  //=================================================================

*/

  ###################################################################
  # 끝 => 임시____단어_BASE_TABLE_ROW__삭제
  ###################################################################



  ###################################################################
  # 시작 => 상수__변수__배열
  ###################################################################

  //=================================================================
  // 단계별_게시판_분류_이름
  $board_cate_1_s = '';
  $board_cate_2_s = '';
  $board_cate_s_p = '';


  //=================================================================
  // 저장할_게시판_분류__배열
  $category_save_a = array();


  //=================================================================
  // 저장할_쿼리문__배열
  $sql_common_s_a = array();

  ###################################################################
  # 끝 => 상수__변수__배열
  ###################################################################



  ###################################################################
  # 시작 => 게시판_분류_정보__변수_배열
  ###################################################################

  //=================================================================
  // 부모_게시판_분류_번호
  $board_cate_parent_n = 0;


  //=================================================================
  // 단계
  $board_cate_depth_n = 1;


  //=================================================================
  // 게시판_분류_번호_경로
  $board_cate_n_p = '';


  //=================================================================
  // 게시판_분류_정보
  $board_cate_1_n = 0;
  $board_cate_2_n = 0;


  //=================================================================
  // 하위_게시판_분류_수__파악하기
  $board_cate_sub_t = 0;


  //=================================================================
  // 게시판_분류_거주_회원_수__파악하기
  $board_cate_member_t = 0;

  ###################################################################
  # 끝 => 게시판_분류_정보__변수_배열
  ###################################################################



  ###################################################################
  # 시작 => 게시판_분류_정보__알아내기
  ###################################################################

/*

  //=================================================================
  // 원본_게시판_분류_정보_배열
  $board_cate = array();


  //=================================================================
  // 시작 => 피리_카페_번호__있고____게시판_분류_번호__있으면
  IF ( $piree_cafe_n > 0 && $board_cate_n > 0 )
  {

    //===============================================================
    // 게시판_분류_정보__알아내기
    $sql_select = "SELECT * FROM `". $piree['cafe_board'] ."` ";
    $sql_select .= "WHERE `bca_cafe_n` = '". $piree_cafe_n ."' AND `bca_cate_n` = '". $board_cate_n ."'";
    $board_cate_a = sql_fetch($sql_select);


    //===============================================================
    // 시작 => 게시판_분류_정보__유무
    IF ( $piree_cafe_n != $board_cate_list_a[$board_cate_n]['bca_cafe_n'] || $board_cate_n != $board_cate_list_a[$board_cate_n]['bca_cate_n'] )
    {

      //=============================================================
      // 에러
      alert("선택된 [ 게시판 분류 ]의  정보가 없습니다.");

    }
    // 끝 => 피리_카페_번호__있고____게시판_분류_번호__있으면
    //===============================================================


    //===============================================================
    // 게시판_분류__단계별_번호
    $board_cate_1_n = $board_cate_list_a[$board_cate_n]['bca_1_n'];
    $board_cate_2_n = $board_cate_list_a[$board_cate_n]['bca_2_n'];


    //===============================================================
    // 게시판_분류__단계별_이름
    $board_cate_1_s = $board_cate_list_a[$board_cate_n]['bca_1_s'];
    $board_cate_2_s = $board_cate_list_a[$board_cate_n]['bca_2_s'];


    //===============================================================
    // 단계
    $board_cate_depth_n = $board_cate_list_a[$board_cate_n]['bca_depth_n'];


    //===============================================================
    // 게시판_분류_정보__기타
    $board_cate_parent_n = $board_cate_list_a[$board_cate_n]['bca_parent_n'];
    $board_cate_sub_t    = $board_cate_list_a[$board_cate_n]['bca_sub_t'];

    #################################################################
    # 끝 => 게시판_분류_정보__있으면
    #################################################################

  }
  // 끝 => 게시판_분류_번호__있으면
  //=================================================================

*/

  ###################################################################
  # 끝 => 게시판_분류_정보
  ###################################################################



  ###################################################################
  # 시작 => 게시판_분류_정보__알아내기
  ###################################################################

  //=================================================================
  // 원본_게시판_분류_정보_배열
  $board_cate = array();


  //=================================================================
  // 시작 => 게시판_분류__하위_추가_이거나____수정__이면
  IF ( $mode_c == 'modify' || ( $mode_c == 'regist' && $board_cate_n > 0 ) )
  {

    //===============================================================
    // 게시판_분류_정보__알아내기
    $sql_select = "SELECT * FROM `". $piree['cafe_board'] ."` ";
    $sql_select .= "WHERE `bca_cafe_n` = '". $piree_cafe_n ."' AND `bca_cate_n` = '". $board_cate_n ."'";
    $board_cate_a = sql_fetch($sql_select);


    //===============================================================
    // 시작 => 게시판_분류_정보__유무
    IF ( $piree_cafe_n != $board_cate_list_a[$board_cate_n]['bca_cafe_n'] || $board_cate_n != $board_cate_list_a[$board_cate_n]['bca_cate_n'] )
    {

      //=============================================================
      // 에러
      alert("선택된 [ 게시판 분류 ]의  정보가 없습니다.");

    }
    // 끝 => 피리_카페_번호__있고____게시판_분류_번호__있으면
    //===============================================================


    //===============================================================
    // 게시판_분류__단계별_번호
    $board_cate_1_n = $board_cate_list_a[$board_cate_n]['bca_1_n'];
    $board_cate_2_n = $board_cate_list_a[$board_cate_n]['bca_2_n'];


    //===============================================================
    // 게시판_분류__단계별_이름
    $board_cate_1_s = $board_cate_list_a[$board_cate_n]['bca_1_s'];
    $board_cate_2_s = $board_cate_list_a[$board_cate_n]['bca_2_s'];


    //===============================================================
    // 단계
    $board_cate_depth_n = $board_cate_list_a[$board_cate_n]['bca_depth_n'];


    //===============================================================
    // 게시판_분류_정보__기타
    $board_cate_parent_n = $board_cate_list_a[$board_cate_n]['bca_parent_n'];
    $board_cate_sub_t    = $board_cate_list_a[$board_cate_n]['bca_sub_t'];

    #################################################################
    # 끝 => 게시판_분류_정보__있으면
    #################################################################

  }
  // 끝 => 게시판_분류__하위_추가_이거나____수정__이면
  //=================================================================

  ###################################################################
  # 끝 => 게시판_분류_정보
  ###################################################################



  ###################################################################
  # 시작 => 게시판_분류_입력_값__검증
  ###################################################################

  //=================================================================
  // QUERY_STRIG
  $bca_include_head          = isset($_POST['bca_include_head'])          ? preg_replace(array("#[\\\]+$#", "#(<\?php|<\?)#i"), "", substr($_POST['bca_include_head'], 0, 255)) : '';
  $bca_include_tail          = isset($_POST['bca_include_tail'])          ? preg_replace(array("#[\\\]+$#", "#(<\?php|<\?)#i"), "", substr($_POST['bca_include_tail'], 0, 255)) : '';
  $bca_use_sideview          = isset($_POST['bca_use_sideview'])          ? (int) $_POST['bca_use_sideview']                                                                    : 0;
  $bca_use_dhtml_editor      = isset($_POST['bca_use_dhtml_editor'])      ? (int) $_POST['bca_use_dhtml_editor']                                                                : 0;
  $bca_use_good              = isset($_POST['bca_use_good'])              ? (int) $_POST['bca_use_good']                                                                        : 0;
  $bca_use_nogood            = isset($_POST['bca_use_nogood'])            ? (int) $_POST['bca_use_nogood']                                                                      : 0;
  $bca_use_name              = isset($_POST['bca_use_name'])              ? (int) $_POST['bca_use_name']                                                                        : 0;
  $bca_use_signature         = isset($_POST['bca_use_signature'])         ? (int) $_POST['bca_use_signature']                                                                   : 0;
  $bca_use_ip_view           = isset($_POST['bca_use_ip_view'])           ? (int) $_POST['bca_use_ip_view']                                                                     : 0;
  $bca_use_list_view         = isset($_POST['bca_use_list_view'])         ? (int) $_POST['bca_use_list_view']                                                                   : 0;
  $bca_use_list_file         = isset($_POST['bca_use_list_file'])         ? (int) $_POST['bca_use_list_file']                                                                   : 0;
  $bca_use_list_content      = isset($_POST['bca_use_list_content'])      ? (int) $_POST['bca_use_list_content']                                                                : 0;
  $bca_use_email             = isset($_POST['bca_use_email'])             ? (int) $_POST['bca_use_email']                                                                       : 0;
  $bca_use_sns               = isset($_POST['bca_use_sns'])               ? (int) $_POST['bca_use_sns']                                                                         : 0;
  $bca_use_captcha           = isset($_POST['bca_use_captcha'])           ? (int) $_POST['bca_use_captcha']                                                                     : 0;
  $bca_table_width           = isset($_POST['bca_table_width'])           ? (int) $_POST['bca_table_width']                                                                     : 0;
  $bca_subject_len           = isset($_POST['bca_subject_len'])           ? (int) $_POST['bca_subject_len']                                                                     : 0;
  $bca_mo_subject_len        = isset($_POST['bca_mo_subject_len'])        ? (int) $_POST['bca_mo_subject_len']                                                                  : 0;
  $bca_pc_page_rows          = isset($_POST['bca_pc_page_rows'])          ? (int) $_POST['bca_pc_page_rows']                                                                    : 0;
  $bca_mo_page_rows          = isset($_POST['bca_mo_page_rows'])          ? (int) $_POST['bca_mo_page_rows']                                                                    : 0;
  $bca_use_rss_view          = isset($_POST['bca_use_rss_view'])          ? (int) $_POST['bca_use_rss_view']                                                                    : 0;
  $bca_use_secret            = isset($_POST['bca_use_secret'])            ? (int) $_POST['bca_use_secret']                                                                      : 0;
  $bca_use_file_content      = isset($_POST['bca_use_file_content'])      ? (int) $_POST['bca_use_file_content']                                                                : 0;
  $bca_new                   = isset($_POST['bca_new'])                   ? (int) $_POST['bca_new']                                                                             : 0;
  $bca_hot                   = isset($_POST['bca_hot'])                   ? (int) $_POST['bca_hot']                                                                             : 0;
  $bca_image_width           = isset($_POST['bca_image_width'])           ? (int) $_POST['bca_image_width']                                                                     : 0;
  $bca_use_search            = isset($_POST['bca_use_search'])            ? (int) $_POST['bca_use_search']                                                                      : 0;
  $bca_use_cert              = isset($_POST['bca_use_cert'])              ? preg_replace('/[^0-9a-z_]/i', '', $_POST['bca_use_cert'])                                           : '';
  $bca_device                = isset($_POST['bca_device'])                ? clean_xss_tags($_POST['bca_device'], 1, 1)                                                          : '';
  $bca_list_level            = isset($_POST['bca_list_level'])            ? (int) $_POST['bca_list_level']                                                                      : 0;
  $bca_read_level            = isset($_POST['bca_read_level'])            ? (int) $_POST['bca_read_level']                                                                      : 0;
  $bca_write_level           = isset($_POST['bca_write_level'])           ? (int) $_POST['bca_write_level']                                                                     : 0;
  $bca_reply_level           = isset($_POST['bca_reply_level'])           ? (int) $_POST['bca_reply_level']                                                                     : 0;
  $bca_comment_level         = isset($_POST['bca_comment_level'])         ? (int) $_POST['bca_comment_level']                                                                   : 0;
  $bca_html_level            = isset($_POST['bca_html_level'])            ? (int) $_POST['bca_html_level']                                                                      : 0;
  $bca_link_level            = isset($_POST['bca_link_level'])            ? (int) $_POST['bca_link_level']                                                                      : 0;
  $bca_count_modify          = isset($_POST['bca_count_modify'])          ? (int) $_POST['bca_count_modify']                                                                    : 0;
  $bca_count_delete          = isset($_POST['bca_count_delete'])          ? (int) $_POST['bca_count_delete']                                                                    : 0;
  $bca_upload_level          = isset($_POST['bca_upload_level'])          ? (int) $_POST['bca_upload_level']                                                                    : 0;
  $bca_download_level        = isset($_POST['bca_download_level'])        ? (int) $_POST['bca_download_level']                                                                  : 0;
  $bca_read_point            = isset($_POST['bca_read_point'])            ? (int) $_POST['bca_read_point']                                                                      : 0;
  $bca_write_point           = isset($_POST['bca_write_point'])           ? (int) $_POST['bca_write_point']                                                                     : 0;
  $bca_comment_point         = isset($_POST['bca_comment_point'])         ? (int) $_POST['bca_comment_point']                                                                   : 0;
  $bca_download_point        = isset($_POST['bca_download_point'])        ? (int) $_POST['bca_download_point']                                                                  : 0;
  $bca_select_editor         = isset($_POST['bca_select_editor'])         ? clean_xss_tags($_POST['bca_select_editor'], 1, 1)                                                   : '';
  $bca_pc_skin               = isset($_POST['bca_pc_skin'])               ? clean_xss_tags($_POST['bca_pc_skin'], 1, 1)                                                         : '';
  $bca_mo_skin               = isset($_POST['bca_mo_skin'])               ? clean_xss_tags($_POST['bca_mo_skin'], 1, 1)                                                         : '';
  $bca_pc_content_head       = isset($_POST['bca_pc_content_head'])       ? $_POST['bca_pc_content_head']                                                                          : '';
  $bca_pc_content_tail       = isset($_POST['bca_pc_content_tail'])       ? $_POST['bca_pc_content_tail']                                                                       : '';
  $bca_mo_content_head       = isset($_POST['bca_mo_content_head'])       ? $_POST['bca_mo_content_head']                                                                       : '';
  $bca_mo_content_tail       = isset($_POST['bca_mo_content_tail'])       ? $_POST['bca_mo_content_tail']                                                                       : '';
  $bca_insert_content        = isset($_POST['bca_insert_content'])        ? $_POST['bca_insert_content']                                                                        : '';
  $bca_gallery_cols          = isset($_POST['bca_gallery_cols'])          ? (int) $_POST['bca_gallery_cols']                                                                    : 0;
  $bca_pc_gallery_width      = isset($_POST['bca_pc_gallery_width'])      ? (int) $_POST['bca_pc_gallery_width']                                                                : 0;
  $bca_pc_gallery_height     = isset($_POST['bca_pc_gallery_height'])     ? (int) $_POST['bca_pc_gallery_height']                                                               : 0;
  $bca_mo_gallery_width      = isset($_POST['bca_mo_gallery_width'])      ? (int) $_POST['bca_mo_gallery_width']                                                                : 0;
  $bca_mo_gallery_height     = isset($_POST['bca_mo_gallery_height'])     ? (int) $_POST['bca_mo_gallery_height']                                                               : 0;
  $bca_upload_count          = isset($_POST['bca_upload_count'])          ? (int) $_POST['bca_upload_count']                                                                    : 0;
  $bca_upload_size           = isset($_POST['bca_upload_size'])           ? (int) $_POST['bca_upload_size']                                                                     : 0;
  $bca_reply_order           = isset($_POST['bca_reply_order'])           ? (int) $_POST['bca_reply_order']                                                                     : 0;
  $bca_order                 = isset($_POST['bca_order'])                 ? (int) $_POST['bca_order']                                                                           : 0;
  $bca_write_min             = isset($_POST['bca_write_min'])             ? (int) $_POST['bca_write_min']                                                                       : 0;
  $bca_write_max             = isset($_POST['bca_write_max'])             ? (int) $_POST['bca_write_max']                                                                       : 0;
  $bca_comment_min           = isset($_POST['bca_comment_min'])           ? (int) $_POST['bca_comment_min']                                                                     : 0;
  $bca_comment_max           = isset($_POST['bca_comment_max'])           ? (int) $_POST['bca_comment_max']                                                                     : 0;
  $bca_sort_field            = isset($_POST['bca_sort_field'])            ? clean_xss_tags($_POST['bca_sort_field'], 1, 1)                                                      : '';

  ###################################################################
  # 끝 => 게시판_분류_입력_값__검증
  ###################################################################



  ###################################################################
  # 시작 => 쿼리문__조합
  ###################################################################

  //=================================================================
  // 칼럼_수정__쿼리
  $sql_common_s .= "`bca_cate_s`                = '". $board_cate_name_s ."', ";

  $sql_common_s .= "`bca_sub_t`                 = '". $board_cate_sub_t ."', ";
  $sql_common_s .= "`bca_row_t`                 = '0', ";
  $sql_common_s .= "`bca_article_t`             = '0', ";

  $sql_common_s .= "`bca_device`                = '". $bca_device ."', ";
  $sql_common_s .= "`bca_list_level`            = '". $bca_list_level ."', ";
  $sql_common_s .= "`bca_read_level`            = '". $bca_read_level ."', ";
  $sql_common_s .= "`bca_write_level`           = '". $bca_write_level ."', ";
  $sql_common_s .= "`bca_reply_level`           = '". $bca_reply_level ."', ";
  $sql_common_s .= "`bca_comment_level`         = '". $bca_comment_level ."', ";
  $sql_common_s .= "`bca_upload_level`          = '". $bca_upload_level ."', ";
  $sql_common_s .= "`bca_download_level`        = '". $bca_download_level ."', ";

  $sql_common_s .= "`bca_html_level`            = '". $bca_html_level ."', ";
  $sql_common_s .= "`bca_link_level`            = '". $bca_link_level ."', ";
  $sql_common_s .= "`bca_count_delete`          = '". $bca_count_delete ."', ";
  $sql_common_s .= "`bca_count_modify`          = '". $bca_count_modify ."', ";

  $sql_common_s .= "`bca_read_point`            = '". $bca_read_point ."', ";
  $sql_common_s .= "`bca_write_point`           = '". $bca_write_point ."', ";
  $sql_common_s .= "`bca_comment_point`         = '". $bca_comment_point ."', ";
  $sql_common_s .= "`bca_download_point`        = '". $bca_download_point ."', ";
  $sql_common_s .= "`bca_use_sideview`          = '". $bca_use_sideview ."', ";

  $sql_common_s .= "`bca_use_file_content`      = '". $bca_use_file_content ."', ";
  $sql_common_s .= "`bca_use_secret`            = '". $bca_use_secret ."', ";
  $sql_common_s .= "`bca_use_dhtml_editor`      = '". $bca_use_dhtml_editor ."', ";
  $sql_common_s .= "`bca_select_editor`         = '". $bca_select_editor ."', ";
  $sql_common_s .= "`bca_use_rss_view`          = '". $bca_use_rss_view ."', ";
  $sql_common_s .= "`bca_use_good`              = '". $bca_use_good ."', ";
  $sql_common_s .= "`bca_use_nogood`            = '". $bca_use_nogood ."', ";
  $sql_common_s .= "`bca_use_name`              = '". $bca_use_name ."', ";
  $sql_common_s .= "`bca_use_signature`         = '". $bca_use_signature ."', ";

  $sql_common_s .= "`bca_use_ip_view`           = '". $bca_use_ip_view ."', ";
  $sql_common_s .= "`bca_use_list_view`         = '". $bca_use_list_view ."', ";
  $sql_common_s .= "`bca_use_list_file`         = '". $bca_use_list_file ."', ";
  $sql_common_s .= "`bca_use_list_content`      = '". $bca_use_list_content ."', ";
  $sql_common_s .= "`bca_table_width`           = '". $bca_table_width ."', ";
  $sql_common_s .= "`bca_pc_subject_len`        = '". $bca_pc_subject_len ."', ";
  $sql_common_s .= "`bca_mo_subject_len`        = '". $bca_mo_subject_len ."', ";
  $sql_common_s .= "`bca_pc_page_rows`          = '". $bca_pc_page_rows ."', ";

  $sql_common_s .= "`bca_mo_page_rows`          = '". $bca_mo_page_rows ."', ";
  $sql_common_s .= "`bca_new`                   = '". $bca_new ."', ";
  $sql_common_s .= "`bca_hot`                   = '". $bca_hot ."', ";
  $sql_common_s .= "`bca_image_width`           = '". $bca_image_width ."', ";
  $sql_common_s .= "`bca_pc_skin`               = '". $bca_pc_skin ."', ";
  $sql_common_s .= "`bca_mo_skin`               = '". $bca_mo_skin ."', ";
  $sql_common_s .= "`bca_include_head`          = '". $bca_include_head ."', ";
  $sql_common_s .= "`bca_include_tail`          = '". $bca_include_tail ."', ";
  $sql_common_s .= "`bca_pc_content_head`       = '". $bca_pc_content_head ."', ";
  $sql_common_s .= "`bca_pc_content_tail`       = '". $bca_pc_content_tail ."', ";
  $sql_common_s .= "`bca_mo_content_head`       = '". $bca_mo_content_head ."', ";
  $sql_common_s .= "`bca_mo_content_tail`       = '". $bca_mo_content_tail ."', ";
  $sql_common_s .= "`bca_insert_content`        = '". $bca_insert_content ."', ";
  $sql_common_s .= "`bca_gallery_cols`          = '". $bca_gallery_cols ."', ";
  $sql_common_s .= "`bca_pc_gallery_width`      = '". $bca_pc_gallery_width ."', ";
  $sql_common_s .= "`bca_pc_gallery_height`     = '". $bca_pc_gallery_height ."', ";
  $sql_common_s .= "`bca_mo_gallery_width`      = '". $bca_mo_gallery_width ."', ";
  $sql_common_s .= "`bca_mo_gallery_height`     = '". $bca_mo_gallery_height ."', ";
  $sql_common_s .= "`bca_upload_size`           = '". $bca_upload_size ."', ";

  $sql_common_s .= "`bca_reply_order`           = '". $bca_reply_order ."', ";
  $sql_common_s .= "`bca_use_search`            = '". $bca_use_search ."', ";
  $sql_common_s .= "`bca_order`                 = '". $bca_order ."', ";
  $sql_common_s .= "`bca_write_min`             = '". $bca_write_min ."', ";
  $sql_common_s .= "`bca_write_max`             = '". $bca_write_max ."', ";

  $sql_common_s .= "`bca_comment_min`           = '". $bca_comment_min ."', ";
  $sql_common_s .= "`bca_comment_max`           = '". $bca_comment_max ."', ";
  $sql_common_s .= "`bca_notice`                = '', ";
  $sql_common_s .= "`bca_upload_count`          = '". $bca_upload_count ."', ";
  $sql_common_s .= "`bca_use_email`             = '". $bca_use_email ."', ";
  $sql_common_s .= "`bca_use_cert`              = '". $bca_use_cert ."', ";
  $sql_common_s .= "`bca_use_sns`               = '". $bca_use_sns ."', ";
  $sql_common_s .= "`bca_use_captcha`           = '". $bca_use_captcha ."', ";
  $sql_common_s .= "`bca_sort_field`            = '". $bca_sort_field ."'";

  ###################################################################
  # 끝 => 쿼리문__조합
  ###################################################################



  ###################################################################
  # 시작 => 
  ###################################################################

    #################################################################
    # 시작 => 
    #################################################################

    //===============================================================
    // 


    //===============================================================
    // 

    #################################################################
    # 끝 => 
    #################################################################

  ###################################################################
  # 끝 => 
  ###################################################################



  ###################################################################
  # 시작 => 처리_하기
  ###################################################################

    #################################################################
    # 시작 => 작업__실행
    #################################################################

    //===============================================================
    // 시작 => MODE__구분
    SWITCH ( $mode_c )
    {

      ###############################################################
      # 시작 => 등록
      ###############################################################
      CASE 'regist' :


        #############################################################
        # 시작 => 선처리__검증하기
        #############################################################

        //===========================================================
        // 시작 => 3단계__이상이면
        IF ( $board_cate_list_a[$board_cate_n]['bca_depth_n'] > 2 )
        {
          alert("3단계 이상의 게시판 분류를 등록할수 없습니다.");
        }
        // 끝 => 3단계__이상이면
        //===========================================================


        //===========================================================
        // 시작 => 게시판_분류_번호__유무
        IF ( $board_cate_n > 0 )
        {

          //=========================================================
          // 시작 => 게시판_분류_정보__있으면
          IF ( $board_cate_n == $board_cate_list_a[$board_cate_n]['bca_cate_n'] )
          {

            //=======================================================
            // 부모_게시판_분류_번호
            $board_cate_parent_n = $board_cate_list_a[$board_cate_n]['bca_cate_n'];


            //=======================================================
            // 단계
            $board_cate_depth_n++;


            //=======================================================
            // 시작 => 나의__단계__2단계_초과__이면
            IF ( $board_cate_depth_n > 2 )
            {
              // 에러
              alert("선택된 [ 게시판 분류 정보 ]가 없습니다.");
            }
            // 끝 => 나의__단계__2단계_초과__이면
            //=======================================================

          }
          // 끝 => 게시판_분류_정보__있으면
          //=========================================================

        }
        // 끝 => 게시판_분류_번호__유무
        //===========================================================

        #############################################################
        # 끝 => 선처리__검증하기
        #############################################################



        #############################################################
        # 시작 => 중복확인
        #############################################################

        //===========================================================
        // 중복확인
        $sql_select  = "SELECT COUNT(*) FROM `". $piree['cafe_board'] ."` ";
        $sql_select .= "WHERE `bca_cafe_n` = '". $piree_cafe_n ."' AND `bca_cate_s` = '". $board_cate_name_s ."' AND `bca_depth_n` = '". $board_cate_depth_n ."' AND `bca_parent_n` = '". $board_cate_parent_n ."'";
        $exist_t = sql_efv($sql_select);

        #############################################################
        # 끝 => 중복확인
        #############################################################



        #############################################################
        # 시작 => 게시판_분류__위치_정보
        #############################################################

        //===========================================================
        // 게시판_분류__위치_정보__알아내는_파일__첨부
        include_once( PIREE_CAFE_MANAGE_PATH .'/board.category.regist.update.inc.php');

        #############################################################
        # 끝 => 게시판_분류__위치_정보
        #############################################################



        #############################################################
        # 시작 => 입력하기
        #############################################################

        //===========================================================
        // 입력하는__쿼리문
        $sql_insert  = "INSERT INTO `". $piree['cafe_board'] ."` SET ";
        $sql_insert .= "`bca_cafe_n`      = '". $piree_cafe_n ."', ";
        $sql_insert .= "`bca_cafe_c`      = '". $piree_cafe_code_c ."', ";
        $sql_insert .= "`bca_cafe_s`      = '". $piree_cafe_name_s ."', ";
        $sql_insert .= "`bca_cate_n`      = '". $board_cate_n ."', ";
        $sql_insert .= "`bca_1_n`         = '". $board_cate_1_n ."', ";
        $sql_insert .= "`bca_2_n`         = '". $board_cate_2_n ."', ";
        $sql_insert .= "`bca_cate_n_p`    = '". $board_cate_n_p ."', ";
        $sql_insert .= "`bca_1_s`         = '". $board_cate_1_s ."', ";
        $sql_insert .= "`bca_2_s`         = '". $board_cate_2_s ."', ";
        $sql_insert .= "`bca_s_p`         = '". $board_cate_s_p ."', ";
        $sql_insert .= "`bca_depth_n`     = '". $board_cate_depth_n ."', ";
        $sql_insert .= "`bca_parent_n`    = '". $board_cate_parent_n ."', ";
        $sql_insert .= "`bca_regi_time_n` = '". G5_SERVER_TIME ."', ";
        $sql_insert .= $sql_common_s;


        //===========================================================
        // 시작 => 입력_하지__못했으면
        IF ( !sql_query($sql_insert) )
        {

          //=========================================================
          // 에러
          alert("[ ". $piree_cafe_name_s ." ] 카페의\\n\\n[ ". $board_cate_name_s ." ] 게시판 분류를 입력하지 못했습니다.");

        }
        // 끝 => 입력_하지__못했으면
        //===========================================================


        //===========================================================
        // 상위_게시판_분류_번호__배열로__가져오기
        $category_i_a = get_category_upper_smallint2_cafe_board($board_cate_n);


        //===========================================================
        // 계층_게시판_분류__하위_게시판_분류_수__알아내기
        get_sub_category_count_depth_smallint2_cafe_board($category_i_a, $board_cate_n);

        #############################################################
        # 끝 => 입력하기
        #############################################################



        #############################################################
        # 시작 => 
        #############################################################

        //===========================================================
        // 


        //===========================================================
        // 


        //===========================================================
        // 


        //===========================================================
        // 

        #############################################################
        # 끝 => 
        #############################################################


      BREAK;
      ###############################################################
      # 끝 => 등록
      ###############################################################



      ###############################################################
      # 시작 => 수정
      ###############################################################
      CASE 'modify' :


        #############################################################
        # 시작 => 검증하기
        #############################################################

        //===========================================================
        // 시작 => 게시판_분류_이름__입력_안되었으면
        IF ( !$board_cate_name_s )
        {
          alert("[ 게시판 분류 이름 ]을 입력해 주세요.");
        }
        // 끝 => 게시판_분류_이름__입력_안되었으면
        //===========================================================


        //===========================================================
        // 중복확인
        $sql_select  = "SELECT COUNT(*) FROM `". $piree['cafe_board'] ."` ";
        $sql_select .= "WHERE `bca_cafe_n` = '". $piree_cafe_n ."' AND `bca_cate_s` = '". $board_cate_name_s ."' AND `bca_depth_n` = '". $board_cate_depth_n ."' AND `bca_parent_n` = '". $board_cate_parent_n ."' AND `bca_cate_n` != '". $board_cate_n ."'";
        $exist_t = sql_efv($sql_select);


        //===========================================================
        // 시작 => 중복__있으면
        IF ( $exist_t > 0 )
        {
            alert("같은 위치에 게시판 분류 [". $board_cate_name_s ."] 이(가) 이미 있습니다.");
        }
        // 끝 => 중복__있으면
        //===========================================================

        #############################################################
        # 시작 => 검증하기
        #############################################################



        #############################################################
        # 시작 => 
        #############################################################

        //===========================================================
        // 

        #############################################################
        # 시작 => 
        #############################################################



        #############################################################
        # 시작 => 게시판_분류__위치_정보
        #############################################################

        //===========================================================
        // 게시판_분류__위치_정보__알아내는_파일__첨부
        include_once( PIREE_CAFE_MANAGE_PATH .'/board.category.regist.update.inc.php');

        #############################################################
        # 끝 => 게시판_분류__위치_정보
        #############################################################



        #############################################################
        # 시작 => 게시글_수__댓글_수__파악하기
        #############################################################

        //===========================================================
        // 게시글_수__새로고침_하기
        $sql_select = $sql_select_cafe_all ." AND ". get_piree_cafe_article_count($board_cate_n, $board_cate_list_a[$board_cate_n]['bca_depth_n'], 'wr_pi_board_cate_n');
        $artilce_cate_t = (int)sql_efv($sql_select);



        //===========================================================
        // 중복확인
        $sql_common_s .= ", ";
        $sql_common_s .= "`bca_count_write` = '". $artilce_cate_t ."' ";

        #############################################################
        # 끝 => 게시글_수__댓글_수__파악하기
        #############################################################



        #############################################################
        # 시작 => 실제__저장하기
        #############################################################

        //===========================================================
        // 입력하는__쿼리문
        $sql_update  = "UPDATE `". $piree['cafe_board'] ."` SET ";
        $sql_update .= "`bca_1_n`         = '". $board_cate_1_n ."', ";
        $sql_update .= "`bca_2_n`         = '". $board_cate_2_n ."', ";
        $sql_update .= "`bca_cate_n_p`    = '". $board_cate_n_p ."', ";
        $sql_update .= "`bca_1_s`         = '". $board_cate_1_s ."', ";
        $sql_update .= "`bca_2_s`         = '". $board_cate_2_s ."', ";
        $sql_update .= "`bca_s_p`         = '". $board_cate_s_p ."', ";
        $sql_update .= "`bca_sub_t`       = '". $board_cate_name_sub_t ."', ";
        $sql_update .= "`bca_relo_time_n` = '". G5_SERVER_TIME ."', ";
        $sql_update .= $sql_common_s;
        $sql_update .= "WHERE `bca_cafe_n` = '". $piree_cafe_n ."' AND `bca_cate_n` = '". $board_cate_n ."'";


        //===========================================================
        // 시작 => 입력_하지__못했으면
        IF ( !sql_query($sql_update) )
        {

          //=========================================================
          // 에러
          alert("[ ". $piree_cafe_name_s ." ] 카페의 [ ". $board_cate_name_s ." ] 게시판 분류를 수정하지 못했습니다.");

        }
        // 끝 => 입력_하지__못했으면
        //===========================================================

        #############################################################
        # 끝 => 실제__저장하기
        #############################################################



        #############################################################
        # 시작 => 하위_게시판_분류_수__파악하기
        #############################################################

        //===========================================================
        // 계층_게시판_분류__하위_게시판_분류_수__알아내기
        get_sub_category_count_depth_smallint2_cafe_board($category_i_a, $board_cate_n);

        #############################################################
        # 끝 => 하위_게시판_분류_수__파악하기
        #############################################################



        #############################################################
        # 시작 => 
        #############################################################

        //===========================================================
        // 


        //===========================================================
        // 


        //===========================================================
        // 


        //===========================================================
        // 

        #############################################################
        # 끝 => 
        #############################################################


      BREAK;
      ###############################################################
      # 끝 => 수정
      ###############################################################

    }
    // 끝 => MODE__구분
    //===============================================================

    #################################################################
    # 끝 => 작업__실행
    #################################################################

  ###################################################################
  # 끝 => 처리_하기
  ###################################################################



  ###################################################################
  # 시작 => 페이지__이동
  ###################################################################

  //=================================================================
  // 이동할__페이지
  $go_url_s = "board.category.regist.form.php?piree_cafe_n=". $piree_cafe_n ."&board_cate_n=". $board_cate_n .'&mode_c=modify';


  //=================================================================
  // 에러
  goto_url($go_url_s);
  EXIT;

  ###################################################################
  # 끝 => 페이지__이동
  ###################################################################


?>