<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 For 그누보드5.5 순정

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https://piree.kr/nett_dev

  작성날짜 : 2024년 04월 14일 일요일 오후 18시 30분 / 맑음, 26.5, 건조주의보, 28, 9, 0%, 0%, 2.4ms / 양호, 33, 12, 0.005

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
              그누보드 외에 추가된 소스는~
              만든사람의 허락없이 무단으로 사용할수 없습니다.
              사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
              http://www.piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 For 그누보드5.5 순정 > 프로그램 > 피리 카페 관리 > 내 카페 > 게시판 > 게시글 쓰기
=====================================================================


*/


  ###################################################################
  # 시작 => 선_처리
  ###################################################################

  //=================================================================
  // 라이브러리__첨부
  include_once('./_common.php');

  ###################################################################
  # 끝 => 선_처리
  ###################################################################



  ###################################################################
  # 시작 => 상수__변수__배열
  ###################################################################

  //=================================================================
  //


  //=================================================================
  //

  ###################################################################
  # 끝 => 상수__변수__배열
  ###################################################################



  ###################################################################
  # 시작 => 라이브러리__파일__첨부
  ###################################################################

  //=================================================================
  // EDITOR__라이브러리__파일__첨부
  include_once(G5_EDITOR_LIB);


  //=================================================================
  // CAPTCHA__라이브러리__파일__첨부
  include_once(G5_CAPTCHA_PATH.'/captcha.lib.php' );


  //=================================================================
  // FORM__관련_파일__첨부
  include_once( piree__path($piree_prog_a[770000]['num'], 'form.lib.php') );


  //=================================================================
  // FORM__ACTION
  $piree_cafe_board_write_action_u = https_url_get( piree__url($piree_prog_a[770100]['num'], 'piree.cafe.board.write_update.php') );

  ###################################################################
  # 끝 => 라이브러리__파일__첨부
  ###################################################################



  ###################################################################
  # 시작 => 카페_정보__확인하기
  ###################################################################

  //=================================================================
  // 피리_카페__정보__확인하기
  include_once( piree__path($piree_prog_a[770100]['num'], '_CAFE.INFO.CHECK.inc.php') );

  ###################################################################
  # 끝 => 카페_정보__확인하기
  ###################################################################



  ###################################################################
  # 시작 => 동작__구분__처리
  ###################################################################

  //=================================================================
  // DEVICE__확인
  check_device($board_cate_list_a[$board_cate_n]['bca_device']);


  //=================================================================
  // 공지사항_배열
  $notice_array = explode(',', trim($board_cate_list_a[$board_cate_n]['bca_notice']));


  //=================================================================
  // 시작 => 글쓰기_수정__동작__없으면
  IF ( !($w == '' || $w == 'u' || $w == 'r') )
  {
    alert('w 값이 제대로 넘어오지 않았습니다.');
  }
  // 끝 => 글쓰기_수정__동작__없으면
  //=================================================================


  //=================================================================
  // 시작 => 동작__구분
  SWITCH ( $w )
  {

    #################################################################
    # 시작 => 수정
    #################################################################
    CASE 'u' :

      //=============================================================
      // 시작 => 게시글_번호__있으면
      IF ( $write['wr_id'] )
      {

          //=========================================================
          // 시작 => 가변 변수로 $wr_1 .. $wr_10 까지 만든다.
          FOR ( $i=1; $i<=10; $i++ )
          {
              $vvar = "wr_".$i;
              $$vvar = $write['wr_'. $i];
          }
          // 끝 => 가변 변수로 $wr_1 .. $wr_10 까지 만든다.
          //=========================================================

      }
      ELSE
      {
          alert("글이 존재하지 않습니다.\\n삭제되었거나 이동된 경우입니다.", G5_URL);
      }
      // 끝 => 게시글_번호__있으면
      //=============================================================


      //=============================================================
      // HOOK
      // run_event('bbs_write', $board, $wr_id, $w);
      run_event('cafe_board_write', $piree_cafe_n, $board_cate_n, $wr_id, $w);


      //=============================================================
      // 시작 => 김선용 1.00 : 글쓰기 권한과 수정은 별도로 처리되어야 함

      //=============================================================
      // 시작 => 김선용 1.00 : 글쓰기 권한과 수정은 별도로 처리되어야 함
      IF ( $member['mb_id'] && $write['mb_id'] === $member['mb_id'] )
      {

        #############################################################
        # 시작 => 회원__이고____내가_쓴__게시글__이면

        //===========================================================
        // 그냥_통과
        ;

      }
      ELSE IF ( $cafe_member_a['cafe_mem_level_n'] < $board_cate_list_a[$board_cate_n]['bca_write_level'] )
      {

        #############################################################
        # 시작 => 글쓰기_권한__없으면

        //===========================================================
        // 시작 => 회원__여부
        IF ( $member['mb_id'] )
        {
          alert('글을 수정할 권한이 없습니다.');
        }
        ELSE
        {
          alert('글을 수정할 권한이 없습니다.\\n\\n회원이시라면 로그인 후 이용해 보십시오.', G5_BBS_URL.'/login.php?'. $qstr.'&amp;url='.urlencode($_SERVER['SCRIPT_NAME'].'?bo_table='. $piree['cafe_board_code']));
        }
        // 끝 => 회원__여부
        //===========================================================

      }
      // 끝 => 김선용 1.00 : 글쓰기 권한과 수정은 별도로 처리되어야 함
      //=============================================================


      //=============================================================
      // 게시글_답변_코드__문자열_길이
      $len = strlen($write['wr_reply']);


      //=============================================================
      // 시작 => 게시글_답변_코드__문자열_길이__없으면
      IF ( $len < 0 )
      {
        $len = 0;
      }
      // 끝 => 게시글_답변_코드__문자열_길이__없으면
      //=============================================================


      //=============================================================
      // 게시글_답변_코드
      $reply = substr($write['wr_reply'], 0, $len);


      //=============================================================
      // 원_게시글만__가져온다
      $sql_select  = "SELECT COUNT(*) AS cnt FROM `". $piree['cafe_article'] ."` ";
      $sql_select .= "WHERE `wr_reply` like '". $reply ."%' AND `wr_id` <> '". $write['wr_id'] ."' AND `wr_num` = '". $write['wr_num'] ."' AND `wr_is_comment` = '0'";
      $row = sql_fetch($sql_select);


      //=============================================================
      // 시작 => 관리자__아니고____원_게시글__있으면
      IF ( $row['cnt'] && !piree_cafe_auth_get() )
      {
        alert('이 글과 관련된 답변글이 존재하므로 수정 할 수 없습니다.\\n\\n답변글이 있는 원글은 수정할 수 없습니다.');
      }
      // 끝 => 관리자__아니고____원_게시글__있으면
      //=============================================================


      //=============================================================
      // 코멘트 달린 원글의 수정 여부
      $sql_select  = "SELECT COUNT(*) AS cnt FROM `". $piree['cafe_article'] ."` ";
      $sql_select .= "WHERE `wr_parent` = '". $wr_id ."' AND `mb_id` <> '". $member['mb_id'] ."' AND `wr_is_comment` = '1'";
      $row = sql_fetch($sql);


      //=============================================================
      // 시작 => 관리자__아니고____수정_불가_댓글_수__있고____수정_불가_댓글_수__넘으면
      IF ( $board_cate_list_a[$board_cate_n]['bca_count_modify'] && $row['cnt'] >= $board_cate_list_a[$board_cate_n]['bca_count_modify'] && !piree_cafe_auth_get() )
      {
        alert('이 글과 관련된 댓글이 존재하므로 수정 할 수 없습니다.\\n\\n댓글이 '. $board_cate_list_a[$board_cate_n]['bca_count_modify'].'건 이상 달린 원글은 수정할 수 없습니다.');
      }
      // 끝 => 관리자__아니고____수정_불가_댓글_수__있고____수정_불가_댓글_수__넘으면
      //=============================================================


      //=============================================================
      // 제목__메시지
      $title_msg = '글수정';

    BREAK;
    #################################################################
    # 끝 => 수정
    #################################################################



    #################################################################
    # 시작 => 답변
    #################################################################
    CASE 'r' :

      //=============================================================
      // 시작 => 게시글_번호__유무
      IF ( $write['wr_id'] )
      {

          ###########################################################
          # 시작 => 게시글_번호__있으면

          //=========================================================
          // 시작 => 가변 변수로 $wr_1 .. $wr_10 까지 만든다.
          FOR ( $i=1; $i<=10; $i++ )
          {
              $vvar = "wr_".$i;
              $$vvar = $write['wr_'. $i];
          }
          // 끝 => 가변 변수로 $wr_1 .. $wr_10 까지 만든다.
          //=========================================================

      }
      ELSE
      {

          ###########################################################
          # 시작 => 게시글_번호__없으면

          alert("글이 존재하지 않습니다.\\n삭제되었거나 이동된 경우입니다.", G5_URL);

      }
      // 끝 => 게시글_번호__유무
      //=============================================================


      //=============================================================
      // HOOK
      // run_event('bbs_write', $board, $wr_id, $w);
      run_event('cafe_board_write', $piree_cafe_n, $board_cate_n, $wr_id, $w);


      //=============================================================
      // 시작 => 게시글_답변_권한__없으면
      IF ( $cafe_member_a['cafe_mem_level_n'] < $board_cate_list_a[$board_cate_n]['bca_reply_level'] )
      {

          //=========================================================
          // 시작 => 회원__여부
          IF ( $member['mb_id'] )
          {
              alert('글을 답변할 권한이 없습니다.');
          }
          ELSE
          {
              alert('답변글을 작성할 권한이 없습니다.\\n\\n회원이시라면 로그인 후 이용해 보십시오.', G5_BBS_URL.'/login.php?'. $qstr.'&amp;url='.urlencode($_SERVER['SCRIPT_NAME'].'?bo_table='. $piree['cafe_board_code']));
          }
          // 끝 => 회원__여부
          //=========================================================

      }
      // 끝 => 게시글_답변_권한__없으면
      //=============================================================


      //=============================================================
      // 내가_보유한_포인트
      $tmp_point = isset($member['mb_point']) ? $member['mb_point'] : 0;


      //=============================================================
      // 시작 => 관리자__아니고____게시글_답변_포인트__부족하면
      IF ( $tmp_point + $board_cate_list_a[$board_cate_n]['bca_write_point'] < 0 && !piree_cafe_auth_get() )
      {
          alert('보유하신 포인트('.number_format($member['mb_point']).')가 없거나 모자라서 글답변('.number_format($board_cate_list_a[$board_cate_n]['bca_comment_point']).')가 불가합니다.\\n\\n포인트를 적립하신 후 다시 글답변 해 주십시오.');
      }
      // 끝 => 관리자__아니고____게시글_답변_포인트__부족하면
      //=============================================================


      //=============================================================
      //
      // IF ( preg_match("/[^0-9]{0,1}". $wr_id ."[\r]{0,1}/", $board_cate_list_a[$board_cate_n]['bca_notice']) )


      //=============================================================
      // 시작 => 공지글__이면
      IF ( in_array((int)$wr_id, $notice_array) )
      {
          alert('공지에는 답변 할 수 없습니다.');
      }
      // 끝 => 공지글__이면
      //=============================================================


      //----------
      // 4.06.13 : 비밀글을 타인이 열람할 수 있는 오류 수정 (헐랭이, 플록님께서 알려주셨습니다.)
      // 코멘트에는 원글의 답변이 불가하므로

      //=============================================================
      // 시작 => 코멘트에는__원글의_답변이__불가
      IF ( $write['wr_is_comment'])
      {
          alert('정상적인 접근이 아닙니다.');
      }
      // 끝 => 코멘트에는__원글의_답변이__불가
      //=============================================================


      //=============================================================
      // 시작 => 비밀글__이면
      IF ( strstr($write['wr_option'], 'secret') )
      {

          //=========================================================
          // 시작 => 게시글에__회원_아이디__있으면
          IF ( $write['mb_id'] )
          {

              //=====================================================
              // 시작 => 회원의_경우는__해당_글쓴_회원__및__관리자
              IF ( !($write['mb_id'] === $member['mb_id'] || piree_cafe_auth_get()) )
              {
                  alert('비밀글에는 자신 또는 관리자만 답변이 가능합니다.');
              }
              // 끝 => 회원의_경우는__해당_글쓴_회원__및__관리자
              //=====================================================

          }
          ELSE
          {

              //=====================================================
              // 시작 => 회원__아니면
              IF ( !piree_cafe_auth_get() )
              {
                  alert('비회원의 비밀글에는 답변이 불가합니다.');
              }
              // 끝 => 회원__아니면
              //=====================================================

          }
          // 끝 => 게시글에__회원_아이디__있으면
          //=========================================================

      }
      // 끝 => 비밀글__이면
      //=============================================================


      //=============================================================
      // 게시글_배열_참조
      $reply_array = &$write;


      //=============================================================
      // 시작 => 최대_답변은___테이블에_잡아놓은__wr_reply__사이즈만큼만__가능
      IF ( strlen($reply_array['wr_reply']) == 10 )
      {
          alert('더 이상 답변하실 수 없습니다.\\n\\n답변은 10단계 까지만 가능합니다.');
      }
      // 끝 => 최대_답변은___테이블에_잡아놓은__wr_reply__사이즈만큼만__가능
      //=============================================================


      //=============================================================
      // 게시글_답변_코드__길
      $reply_len = strlen($reply_array['wr_reply']) + 1;


      //=============================================================
      // 시작 => 정렬_필드__유무
      IF ( $board_cate_list_a[$board_cate_n]['bca_reply_order'] )
      {
          $begin_reply_char = 'A';
          $end_reply_char = 'Z';
          $reply_number = +1;
          $sql_select  = "SELECT MAX(SUBSTRING(wr_reply, ". $reply_len .", 1)) AS `reply` ";
          $sql_select .= "FROM `". $piree['cafe_article'] ."` WHERE `wr_num` = '". $reply_array['wr_num'] ."' AND SUBSTRING(`wr_reply`, ". $reply_len .", 1) <> '' ";
      }
      ELSE
      {
          $begin_reply_char = 'Z';
          $end_reply_char = 'A';
          $reply_number = -1;
          $sql_select = "SELECT MIN(SUBSTRING(wr_reply, ". $reply_len .", 1)) AS `reply` ";
          $sql_select .= "FROM `". $piree['cafe_article'] ."` WHERE `wr_num` = '". $reply_array['wr_num'] ."' AND SUBSTRING(`wr_reply`, ". $reply_len .", 1) <> '' ";
      }
      // 끝 => 정렬_필드__유무
      //=============================================================


      //=============================================================
      // 시작 => 답변__이면
      IF ( $reply_array['wr_reply'] )
      {
        $sql_select .= " AND `wr_reply` LIKE '". $reply_array['wr_reply'] ."%' ";
      }
      // 끝 => 답변__이면
      //=============================================================


      //=============================================================
      // 원_게시글_ROW__가져오기
      $row = sql_fetch($sql_select);


      //=============================================================
      // 시작 => 원_게시글__답변_여부
      IF ( !$row['reply'] )
      {
          $reply_char = $begin_reply_char;
      }
      ELSE IF ( $row['reply'] == $end_reply_char )
      {
          // A~Z은 26 입니다.
          alert('더 이상 답변하실 수 없습니다.\\n\\n답변은 26개 까지만 가능합니다.');
      }
      ELSE
      {
          $reply_char = chr(ord($row['reply']) + $reply_number);
      }
      // 끝 => 원_게시글__답변_여부
      //=============================================================


      //=============================================================
      // 답변글_위치
      $reply = $reply_array['wr_reply'] . $reply_char;


      //=============================================================
      // 제목__메시지
      $title_msg = '글답변';


      //=============================================================
      // 게시글_제목
      $write['wr_subject'] = 'Re: '. $write['wr_subject'];

    BREAK;
    #################################################################
    # 끝 => 답변
    #################################################################



    #################################################################
    # 시작 => 새글쓰기
    #################################################################
    DEFAULT :

      //=============================================================
      // 시작 => 게시글 입력시에도 $wr_1 ~ $wr_10 변수 사용시 오류 나오지 않도록 가변변수 생성  (다온테마님,210806)
      FOR ( $i=1; $i<=10; $i++ )
      {
          $vvar = "wr_".$i;
          $$vvar = '';
      }
      // 끝 => 게시글 입력시에도 $wr_1 ~ $wr_10 변수 사용시 오류 나오지 않도록 가변변수 생성  (다온테마님,210806)
      //=============================================================


      //=============================================================
      // HOOK
      // run_event('bbs_write', $board, $wr_id, $w);
      run_event('cafe_board_write', $piree_cafe_n, $board_cate_n, $wr_id, $w);


      //=============================================================
      // 시작 => 새글쓰기_인데__게시글_번호__전달되어_왔으면
      IF ( $wr_id )
      {
          alert('글쓰기에는 \$wr_id 값을 사용하지 않습니다.', go_piree_cafe_board('', $piree_cafe_n, $board_cate_n));
      }
      // 끝 => 새글쓰기_인데__게시글_번호__전달되어_왔으면
      //=============================================================


      //=============================================================
      // 시작 => 게시글_쓰기__권한__없으면
      IF ( $cafe_member_a['cafe_mem_level_n'] < $board_cate_list_a[$board_cate_n]['bca_write_level'] )
      {

        //===========================================================
        // 시작 => 회원__여부
        IF ( $member['mb_id'] )
        {
            alert('글을 쓸 권한이 없습니다.');
        }
        ELSE
        {
            alert("글을 쓸 권한이 없습니다.\\n회원이시라면 로그인 후 이용해 보십시오.", G5_BBS_URL.'/login.php?'. $qstr.'&amp;url='.urlencode($_SERVER['SCRIPT_NAME'].'?bo_table='. $piree['cafe_board_code']));
        }
        // 끝 => 회원__여부
        //===========================================================

      }
      // 끝 => 게시글_쓰기__권한__없으면
      //=============================================================


      //=============================================================
      // 시작 => 음수도_true_인것을__왜_이제야_알았을까?
      IF ( $is_member )
      {

          //=========================================================
          // 나의_보유__포인트
          $tmp_point = ($member['mb_point'] > 0) ? $member['mb_point'] : 0;


          //=========================================================
          // 시작 => 관리자__아니고____게시글_작성_포인트__부족하면
          IF ( $tmp_point + $board_cate_list_a[$board_cate_n]['bca_write_point'] < 0 && !piree_cafe_auth_get() )
          {
              alert('보유하신 포인트('.number_format($member['mb_point']).')가 없거나 모자라서 글쓰기('.number_format($board_cate_list_a[$board_cate_n]['bca_write_point']).')가 불가합니다.\\n\\n포인트를 적립하신 후 다시 글쓰기 해 주십시오.');
          }
          // 끝 => 관리자__아니고____게시글_작성_포인트__부족하면
          //=========================================================

      }
      // 끝 => 음수도_true_인것을__왜_이제야_알았을까?
      //=============================================================


      //=============================================================
      // 제목__메시지
      $title_msg = '글쓰기';

    BREAK;
    #################################################################
    # 끝 => 새글쓰기
    #################################################################

  }
  // 끝 => 동작__구분
  //=================================================================

  ###################################################################
  # 끝 => 동작__구분__처리
  ###################################################################



  ###################################################################
  # 시작 => 본인__인증
  ###################################################################

  //=================================================================
  // 시작 => 관리자__아니고____게시판이____본인인증__사용하고____사이트_설정도__본인인증__사용하면
  IF ( $board_cate_list_a[$board_cate_n]['bca_use_cert'] != '' && $config['cf_cert_use'] && !piree_cafe_auth_get() )
  {

    //===============================================================
    // 시작 => 인증된__회원만__가능
    IF ( $is_guest) {
        alert('이 게시판은 본인확인 하신 회원님만 글쓰기가 가능합니다.\\n\\n회원이시라면 로그인 후 이용해 보십시오.', G5_BBS_URL.'/login.php?wr_id='. $wr_id.$qstr.'&amp;url='.urlencode(go_piree_cafe_board('', $piree_cafe_n, $board_cate_n, $wr_id) .'&amp;'. $qstr));
    }
    // 끝 => 인증된__회원만__가능
    //===============================================================


    //===============================================================
    // 시작 => 본인_인증_된__계정_중에서__di로_저장_되었을__경우에만
    IF ( strlen($member['mb_dupinfo']) == 64 && $member['mb_certify'] )
    {
        goto_url(G5_BBS_URL."/member_cert_refresh.php?url=". urlencode(go_piree_cafe_board('', $piree_cafe_n, $board_cate_n, $wr_id) .'&amp;'. $qstr));
    }
    // 끝 => 본인_인증_된__계정_중에서__di로_저장_되었을__경우에만
    //===============================================================


    //===============================================================
    // 시작 => 게시판이__본인인증__사용하고____회원이__본인인증_하지__않았으면
    IF ( $board_cate_list_a[$board_cate_n]['bca_use_cert'] == 'cert' && !$member['mb_certify'] )
    { 
        alert('이 게시판은 본인확인 하신 회원님만 글쓰기가 가능합니다.\\n\\n회원정보 수정에서 본인확인을 해주시기 바랍니다.', G5_URL);
    }
    // 끝 => 게시판이__본인인증__사용하고____회원이__본인인증_하지__않았으면
    //===============================================================


    //===============================================================
    // 시작 => 게시판이__본인인증_성인인증__사용하고____회원이__본인인증_성인인증_하지__않았으면
    IF ( $board_cate_list_a[$board_cate_n]['bca_use_cert'] == 'adult' && !$member['mb_adult'] )
    {
        alert('이 게시판은 본인확인으로 성인인증 된 회원님만 글읽기가 가능합니다.\\n\\n현재 성인인데 글읽기가 안된다면 회원정보 수정에서 본인확인을 다시 해주시기 바랍니다.', G5_URL);
    }
    // 끝 => 게시판이__본인인증_성인인증__사용하고____회원이__본인인증_성인인증_하지__않았으면
    //===============================================================

  }
  // 끝 => 관리자__아니고____게시판이____본인인증__사용하고____사이트_설정도__본인인증__사용하면
  //=================================================================

  ###################################################################
  # 끝 => 본인__인증
  ###################################################################



  ###################################################################
  # 시작 => 기타__게시판__설정
  ###################################################################

    #################################################################
    # 시작 => 변수
    #################################################################

    //===============================================================
    // 페이지_제목
    $g5['title'] = ((G5_IS_MOBILE && $board_cate_list_a[$board_cate_n]['bca_mobile_subject']) ? $board_cate_list_a[$board_cate_n]['bca_mobile_subject'] : $board_cate_list_a[$board_cate_n]['bca_cate_s']).' '. $title_msg;

    #################################################################
    # 끝 => 변수
    #################################################################



    #################################################################
    # 시작 => 공지사항
    #################################################################

    //===============================================================
    // 공지사항_체크__여부
    $notice_checked = '';


    //===============================================================
    // 공지사항__여부
    $is_notice = false;


    //===============================================================
    // 시작 => 관리자__이고____MODE__답변글__아니면
    IF ( piree_cafe_auth_get() && $w != 'r' )
    {

      //=============================================================
      // 공지사항__여부
      $is_notice = true;


      //=============================================================
      // 시작 => MODE__수정_이면
      IF ( $w == 'u' )
      {

        //===========================================================
        // 시작 => 답변__여부
        IF ( $write['wr_reply'] )
        {

            //=======================================================
            // 답변_수정시__공지사항__아님
            $is_notice = false;

        }
        ELSE
        {

            //=======================================================
            // 시작 => 공지사항__이면
            IF ( in_array((int)$wr_id, $notice_array) )
            {
                $notice_checked = 'checked';
            }
            // 끝 => 공지사항__이면
            //=======================================================

        }
        // 끝 => 답변__여부
        //===========================================================

      }
      // 끝 => MODE__수정_이면
      //=============================================================

    }
    // 끝 => 관리자__이고____MODE__답변글__아니면
    //===============================================================

    #################################################################
    # 끝 => 공지사항
    #################################################################



    #################################################################
    # 시작 => 글자수_제한__설정값
    #################################################################

    //===============================================================
    // 시작 => 관리자__이거나____DHEML__사용하면
    IF ( piree_cafe_auth_get() || $board_cate_list_a[$board_cate_n]['bca_use_dhtml_editor'])
    {
      $write_min = $write_max = 0;
    }
    ELSE
    {
      $write_min = (int)$board_cate_list_a[$board_cate_n]['bca_write_min'];
      $write_max = (int)$board_cate_list_a[$board_cate_n]['bca_write_max'];
    }
    // 끝 => 관리자__이거나____DHEML__사용하면
    //===============================================================

    #################################################################
    # 끝 => 글자수_제한__설정값
    #################################################################



    #################################################################
    # 시작 => HTML__관련
    #################################################################

    //===============================================================
    // HTML__사용_안함
    $is_html = false;


    //===============================================================
    // 시작 => HTML__사용_권한__있으면
    IF ( $cafe_member_a['cafe_mem_level_n'] >= $board_cate_list_a[$board_cate_n]['bca_html_level'] )
    {
      $is_html = true;
    }
    // 끝 => HTML__사용_권한__있으면
    //===============================================================

    #################################################################
    # 끝 => HTML__관련
    #################################################################



    #################################################################
    # 시작 => 메일__관련
    #################################################################

    //===============================================================
    // 메일__사용_여부
    $is_mail = false;


    //===============================================================
    // 답변_메일__체크__기본값
    $recv_email_checked = '';


    //===============================================================
    // 시작 => 사이트_설정__메일__사용하고____게시판_설정_메일__사용__하면
    IF ( $config['cf_email_use'] && $board_cate_list_a[$board_cate_n]['bca_use_email'] )
    {
      $is_mail = true;
    }
    // 끝 => 사이트_설정__메일__사용하고____게시판_설정_메일__사용__하면
    //===============================================================


    //===============================================================
    // 시작 => 새글쓰기__이거나____옵션중에__메일__사용_하면
    IF ( $w == '' || strstr($write['wr_option'], 'mail') )
    {
        $recv_email_checked = 'checked';
    }
    // 끝 => 새글쓰기__이거나____옵션중에__메일__사용_하면
    //===============================================================

    #################################################################
    # 끝 => 메일__관련
    #################################################################



    #################################################################
    # 시작 => 각종__사용__권한
    #################################################################

    //===============================================================
    // 비밀글_여부
    $is_secret = $board_cate_list_a[$board_cate_n]['bca_use_secret'];


    //===============================================================
    // 이름__사용__아님
    $is_name = false;


    //===============================================================
    // 패스워드__사용__아님
    $is_password = false;


    //===============================================================
    // 메일__사용__아님
    $is_email = false;


    //===============================================================
    // 홈페이지__사용__아님
    $is_homepage = false;


    //===============================================================
    // 링크
    $is_link = false;


    //===============================================================
    // 파일_업로드
    $is_file = false;


    //===============================================================
    // 파일_설명
    $is_file_content = false;


    //===============================================================
    // 시작 => 손님__이거나
    // 시작 => 관리자__이고____게시글__수정이고____게시글_작성자__아니면
    IF ( $is_guest || (piree_cafe_auth_get() && $w == 'u' && $member['mb_id'] !== $write['mb_id']) )
    {

      $is_name     = true;
      $is_password = true;
      $is_email    = true;
      $is_homepage = true;

    }
    // 끝 => 손님__이거나
    // 끝 => 관리자__이고____게시글__수정이고____게시글_작성자__아니면
    //===============================================================


    //===============================================================
    // 시작 => 링크__사용_권한__있으면
    IF ( $cafe_member_a['cafe_mem_level_n'] >= $board_cate_list_a[$board_cate_n]['bca_link_level'] )
    {
      $is_link = true;
    }
    // 끝 => 링크__사용_권한__있으면
    //===============================================================


    //===============================================================
    // 시작 => 파일_업로드__사용_권한__있으면
    IF ( $cafe_member_a['cafe_mem_level_n'] >= $board_cate_list_a[$board_cate_n]['bca_upload_level'] )
    {
      $is_file = true;
    }
    // 끝 => 파일_업로드__사용_권한__있으면
    //===============================================================


    //===============================================================
    // 시작 => 파일_설명__사용_권한__있으면
    IF ( $board_cate_list_a[$board_cate_n]['bca_use_file_content'] )
    {
      $is_file_content = true;
    }
    // 끝 => 파일_설명__사용_권한__있으면
    //===============================================================


    //===============================================================
    // 파일_업로드__가능_수
    $file_count = (int)$board_cate_list_a[$board_cate_n]['bca_upload_count'];


    //===============================================================
    // 이름
    $name = "";


    //===============================================================
    // 메일주소
    $email = "";


    //===============================================================
    // 홈페이지
    $homepage = "";


    //===============================================================
    // 글__내용
    $content = '';

    #################################################################
    # 끝 => 각종__사용__권한
    #################################################################



    #################################################################
    # 시작 => 동작__구분
    #################################################################

    //===============================================================
    // 시작 => 동작__구분
    SWITCH ( $w )
    {

      ###############################################################
      # 시작 => 수정
      ###############################################################
      CASE 'u' :

        #############################################################
        # 시작 => 패스워드__관련
        #############################################################

        //===========================================================
        // 패스워드__필수_여부____필수_아님
        $password_required = '';


        //===========================================================
        // 시작 => 관리자__아니면
        IF ( !piree_cafe_auth_get() )
        {

            //=======================================================
            // 시작 => 내가__게시글_작성자__아니면
            IF ( !($is_member && $member['mb_id'] === $write['mb_id']) )
            {

                //===================================================
                // 시작 => 패스워드__확인
                IF ( !check_password($wr_password, $write['wr_password']) )
                {
                    $is_wrong = run_replace('invalid_password', false, 'write', $write);
                    IF (!$is_wrong) alert('비밀번호가 틀립니다.');
                }
                // 끝 => 패스워드__확인
                //===================================================

            }
            // 끝 => 내가__게시글_작성자__아니면
            //=======================================================

        }
        // 끝 => 관리자__아니면
        //===========================================================

        #############################################################
        # 끝 => 패스워드__관련
        #############################################################



        #############################################################
        # 시작 => 게시글_정보__관련
        #############################################################

        //===========================================================
        // 작성자_이름
        $name = get_text(cut_str(stripslashes($write['wr_name']),20));


        //===========================================================
        // 메일주소
        $email = get_email_address($write['wr_email']);


        //===========================================================
        // 홈페이지_주소
        $homepage = get_text(stripslashes($write['wr_homepage']));


        //===========================================================
        // 시작 => 반복문____링크_수_만큼
        FOR ( $i=1; $i<=G5_LINK_COUNT; $i++ )
        {

            //=======================================================
            // 링크
            $write['wr_link'. $i] = get_text($write['wr_link'. $i]);


            //=======================================================
            // 링크__배열
            $link[$i] = $write['wr_link'. $i];

        }
        // 끝 => 반복문____링크_수_만큼
        //===========================================================


        //===========================================================
        // 시작 => 옵션__구분
        IF ( strstr($write['wr_option'], 'html1') )
        {

            //=======================================================
            // HTML__사용_여부
            $html_checked = 'checked';


            //=======================================================
            // HTML__구분
            $html_value = 'html1';

        }
        ELSE IF ( ( strstr($write['wr_option'], 'html2') ) )
        {


            //=======================================================
            // HTML__사용_여부
            $html_checked = 'checked';


            //=======================================================
            // HTML__구분
            $html_value = 'html2';

        }
        // 끝 => 옵션__구분
        //===========================================================


        //===========================================================
        // 시작 => 
        IF ( strstr($write['wr_option'], 'secret') )
        {
            $secret_checked = 'checked';
        }
        // 끝 => 
        //===========================================================


        //===========================================================
        // 파일__가져오기
        $file = get_file($piree['cafe_board_code'], $wr_id);


        //===========================================================
        // 시작 => 파일_수
        IF ($file_count < $file['count'] )
        {
            $file_count = $file['count'];
        }
        // 끝 => 파일_수
        //===========================================================


        //===========================================================
        // 시작 => 반복문____파일_수__만큼
        FOR ( $i=0;$i<$file_count;$i++ )
        {

            //=======================================================
            // 시작 => 파일__없으면
            IF ( !isset($file[$i]) )
            {

                //===================================================
                // 파일_정보__비움
                $file[$i] = array('file'=>null, 'source'=>null, 'size'=>null, 'bf_content' => null);

            }
            // 끝 => 파일__없으면
            //=======================================================

        }
        // 끝 => 반복문____파일_수__만큼
        //===========================================================


        //===========================================================
        // 게시글_내용
        $content = get_text($write['wr_content'], 0);

        #############################################################
        # 끝 => 게시글_정보__관련
        #############################################################



        #############################################################
        # 시작 => 
        #############################################################

        //===========================================================
        // 


        //===========================================================
        // 

        #############################################################
        # 끝 => 
        #############################################################

      BREAK;
      ###############################################################
      # 끝 => 수정
      ###############################################################



      ###############################################################
      # 시작 => 답변
      ###############################################################
      CASE 'r' :

        #############################################################
        # 시작 => 이름__메일주소__홈페이지
        #############################################################

        //===========================================================
        // 시작 => 회원__이면
        IF ( $is_member )
        {

            //=======================================================
            // 시작 => 게시글_작성자_이름__있으면
            IF ( isset($write['wr_name']) )
            {
              $name = get_text(cut_str(stripslashes($write['wr_name']),20));
            }
            // 끝 => 게시글_작성자_이름__있으면
            //=======================================================


            //=======================================================
            // 메일주소
            $email = get_email_address($member['mb_email']);


            //=======================================================
            // 홈페이지
            $homepage = get_text(stripslashes($member['mb_homepage']));

        }
        // 끝 => 회원__이면
        //===========================================================

        #############################################################
        # 끝 => 이름__메일주소__홈페이지
        #############################################################



        #############################################################
        # 시작 => 비밀글
        # 시작 => 패스워드__필수_여부
        # 시작 => 링크
        #############################################################

        //===========================================================
        // 시작 => 비밀글__이면
        IF ( strstr($write['wr_option'], 'secret') )
        {
            $is_secret = true;
            $secret_checked = 'checked';
        }
        // 끝 => 비밀글__이면
        //===========================================================


        //===========================================================
        // 패스워드__필수_여부____필수_맞음
        $password_required = "required";


        //===========================================================
        // 시작 => 링크_수__만큼
        FOR ( $i=1; $i<=G5_LINK_COUNT; $i++ )
        {

            //=======================================================
            // 링크__정보
            $write['wr_link'. $i] = get_text($write['wr_link'. $i]);

        }
        // 끝 => 링크_수__만큼
        //===========================================================

        #############################################################
        # 끝 => 비밀글
        # 끝 => 패스워드__필수_여부
        # 끝 => 링크
        #############################################################



        #############################################################
        # 시작 => 옵션
        #############################################################

        //===========================================================
        // 시작 => 
        IF ( !strstr($write['wr_option'], 'html') )
        {
          $content = "\n\n\n &gt; "
                   ."\n &gt; "
                   ."\n &gt; ".str_replace("\n", "\n> ", get_text($write['wr_content'], 0))
                   ."\n &gt; "
                   ."\n &gt; ";
        }

        #############################################################
        # 끝 => 옵션
        #############################################################



        #############################################################
        # 시작 => 
        #############################################################

        #############################################################
        # 끝 => 
        #############################################################

      BREAK;
      ###############################################################
      # 끝 => 답변
      ###############################################################



      ###############################################################
      # 시작 => 새글쓰기
      ###############################################################
      DEFAULT :

        #############################################################
        # 시작 => 이름__메일주소__홈페이지
        #############################################################

        //===========================================================
        // 시작 => 회원__이면
        IF ( $is_member )
        {

            //=======================================================
            // 시작 => 게시글_작성자_이름__있으면
            IF ( isset($write['wr_name']) )
            {
              $name = get_text(cut_str(stripslashes($write['wr_name']),20));
            }
            // 끝 => 게시글_작성자_이름__있으면
            //=======================================================


            //=======================================================
            // 메일주소
            $email = get_email_address($member['mb_email']);


            //=======================================================
            // 홈페이지
            $homepage = get_text(stripslashes($member['mb_homepage']));

        }
        // 끝 => 회원__이면
        //===========================================================

        #############################################################
        # 끝 => 이름__메일주소__홈페이지
        #############################################################



        #############################################################
        # 시작 => 게시글__정보__관련
        #############################################################

        //===========================================================
        // 패스워드__필수_여부____필수_맞음
        $password_required = 'required';


        //===========================================================
        // 게시글_내용
        $content = html_purifier($board_cate_list_a[$board_cate_n]['bca_insert_content']);

        #############################################################
        # 끝 => 
        #############################################################

      BREAK;
      ###############################################################
      # 끝 => 새글쓰기
      ###############################################################

    }
    // 끝 => 동작__구분
    //===============================================================

    #################################################################
    # 끝 => 동작__구분
    #################################################################



    #################################################################
    # 시작 => 게시글_정보__관련
    #################################################################

    //===============================================================
    // HTML_사용__체크
    $html_checked   = "";


    //===============================================================
    // HTML_값
    $html_value = "";


    //===============================================================
    // 비밀글_체크
    $secret_checked = "";


    //===============================================================
    // 세션__게시판
    set_session('ss_bo_table', $piree['cafe_board_code']);


    //===============================================================
    // 세션__게시글_수
    set_session('ss_wr_id', $wr_id);


    //===============================================================
    // 제목
    $subject = "";


    //===============================================================
    // 시작 => 원_게시글__제목__있으면
    IF (isset($write['wr_subject']) )
    {
      $subject = str_replace("\"", "&#034;", get_text(cut_str($write['wr_subject'], 255), 0));
    }
    // 끝 => 원_게시글__제목__있으면
    //===============================================================


    //===============================================================
    // 최대_업로드__파일_용량
    $upload_max_filesize = number_format($board_cate_list_a[$board_cate_n]['bca_upload_size']) . ' 바이트';


    //===============================================================
    // 게시판_가로_폭
    $width = $board_cate_list_a[$board_cate_n]['bca_table_width'];


    //===============================================================
    // 시작 => 게시판_가로_폭__단위__구분
    IF ( $width <= 100 )
    {
      $width .= '%';
    }
    ELSE
    {
      $width .= 'px';
    }
    // 끝 => 게시판_가로_폭__단위__구분
    //===============================================================


    //===============================================================
    // 캡챠__HTML
    $captcha_html = '';


    //===============================================================
    // 캡챠__자바스크립트
    $captcha_js = '';


    //===============================================================
    // 캡챠__사용_여부
    $is_use_captcha = ((($board_cate_list_a[$board_cate_n]['bca_use_captcha'] && $w !== 'u') || $is_guest) && !piree_cafe_auth_get()) ? 1 : 0;


    //===============================================================
    // 시작 => 캡챠__사용__하면
    IF ( $is_use_captcha )
    {

      //=============================================================
      // 캡챠__HTML
      $captcha_html = captcha_html();


      //=============================================================
      // 캡챠__자바스크립트
      $captcha_js   = chk_captcha_js();

    }
    // 끝 => 캡챠__사용__하면
    //===============================================================


    //===============================================================
    // DHTML__에디터
    $is_dhtml_editor = false;


    //===============================================================
    // DHTML__사용_여부
    $is_dhtml_editor_use = false;


    //===============================================================
    // DHTML__에디터_내용
    $editor_content_js = '';


    //===============================================================
    // 시작 => 모바일__아니거나____모바일에서__DHTML__사용_하면
    IF ( !is_mobile() || defined('G5_IS_MOBILE_DHTML_USE' ) && G5_IS_MOBILE_DHTML_USE )
    {
      $is_dhtml_editor_use = true;
    }
    // 끝 => 모바일__아니거나____모바일에서__DHTML__사용_하면
    //===============================================================


    //===============================================================
    // 시작 => 모바일에서는 G5_IS_MOBILE_DHTML_USE 설정에 따라 DHTML 에디터 적용
    IF ( $config['cf_editor'] && $is_dhtml_editor_use && $board_cate_list_a[$board_cate_n]['bca_use_dhtml_editor'] && $cafe_member_a['cafe_mem_level_n'] >= $board_cate_list_a[$board_cate_n]['bca_html_level'] )
    {

      //=============================================================
      // DHTML__에디터
      $is_dhtml_editor = true;


      //=============================================================
      // 시작 => 수정__이고
      // 시작 => 회원__아니거나____관리자__아니거나____작성자__아니면
      IF ( $w == 'u' && (! $is_member || ! piree_cafe_auth_get() || $write['mb_id'] !== $member['mb_id']) )
      {

          //=========================================================
          // kisa_취약점_제보__xss_필터_적용
          $content = get_text(html_purifier($write['wr_content']), 0);

      }
      // 끝 => 수정__이고
      // 끝 => 회원__아니거나____관리자__아니거나____작성자__아니면
      //=============================================================


      //=============================================================
      // 시작 => 에디터__폴더에____자동__저장__자바_스크립트_파일__있으면
      IF ( is_file(G5_EDITOR_PATH.'/'. $config['cf_editor'] .'/autosave.editor.js') )
      {

          //=========================================================
          // 에디터__자동__저장__자바_스크립트_파일__불러오기
          $editor_content_js = '<script src="'.G5_EDITOR_URL.'/'. $config['cf_editor'] .'/autosave.editor.js"></script>'.PHP_EOL;

      }
      // 끝 => 에디터__폴더에____자동__저장__자바_스크립트_파일__있으면
      //=============================================================

    }
    // 끝 => 모바일에서는 G5_IS_MOBILE_DHTML_USE 설정에 따라 DHTML 에디터 적용
    //===============================================================


    //===============================================================
    // 게시글_내용__HTML_에디터__적용
    $editor_html = editor_html('wr_content', $content, $is_dhtml_editor);


    //===============================================================
    // 에디터__자바_스크립트__작동__코드
    $editor_js  = '';
    $editor_js .= get_editor_js('wr_content', $is_dhtml_editor);
    $editor_js .= chk_editor_js('wr_content', $is_dhtml_editor);


    //===============================================================
    // 임시_저장된__글_수
    $autosave_count = autosave_count($member['mb_id']);

    #################################################################
    # 끝 => 게시글_정보__관련
    #################################################################

  ###################################################################
  # 끝 => 기타__게시판__설정
  ###################################################################



  ###################################################################
  # 시작 => 화면__보여주기
  ###################################################################

    #################################################################
    # 시작 => HEAD
    #################################################################

    //===============================================================
    // HEAD_SUB__첨부
    include_once( get_cafe_skin_file('path', 'basic', '_head.sub.php') );


    //===============================================================
    // 글쓰기_전_처리__파일
    @include_once ($board_cate_list_a[$board_cate_n]['board_skin_p'] .'/write.head.skin.php' );


    //===============================================================
    // 스킨_이름__표시
    include_once( get_cafe_skin_file('path', 'basic', '_head.skin.php') );

    #################################################################
    # 끝 => HEAD
    #################################################################



    #################################################################
    # 시작 => BODY
    #################################################################

    //===============================================================
    // SCRIPT__변수
?>
    <script>

      var piree_cafe_url = "<?php echo piree__url($piree_prog_a[770100]['num'], ''); ?>";

    </script>
<?php


    //===============================================================
    // add_javascript('js 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
    add_javascript('<script src="'.  piree__url($piree_prog_a[770100]['num'], 'piree.cafe.board.js')  .'"></script>', 0);


    //===============================================================
    // 글쓰기_스킨__첨부
    include_once ($board_cate_list_a[$board_cate_n]['board_skin_p'] .'/piree.cafe.write.skin.php' );

    #################################################################
    # 끝 => BODY
    #################################################################



    #################################################################
    # 시작 => TAIL
    #################################################################

    //===============================================================
    // 스킨_표시
    echo '<!-- skin : '.(G5_IS_MOBILE ? $board_cate_list_a[$board_cate_n]['bca_mobile_skin'] : $board_cate_list_a[$board_cate_n]['bca_skin']).' -->';


    //===============================================================
    // TAIL_SKIN__첨부
    include_once( get_cafe_skin_file('path', 'basic', '_tail.skin.php') );


    //===============================================================
    // 글쓰기_후_처리__파일
    @include_once ($board_cate_list_a[$board_cate_n]['board_skin_p'] .'/write.tail.skin.php' );


    //===============================================================
    // TAIL_SUB__첨부
    include_once( get_cafe_skin_file('path', 'basic', '_tail.sub.php') );

    #################################################################
    # 끝 => TAIL
    #################################################################

  ###################################################################
  # 끝 => 화면__보여주기
  ###################################################################

?>