<?php

/*
=====================================================================

  프로젝트 이름 : 피리 카페 For 그누보드5.5 순정

  만든사람 : 피리 PIREE ( tosports@naver.com )

  홈페이지 : https://piree.kr/nett_dev

  작성날짜 : 2024년 04월 14일 일요일 오후 18시 30분 / 맑음, 26.5, 건조주의보, 28, 9, 0%, 0%, 2.4ms / 양호, 33, 12, 0.005

  저 작 권 : Copyright ⓒ 2024 피리 piree.kr All right reserved
              그누보드 외에 추가된 소스는~
              만든사람의 허락없이 무단으로 사용할수 없습니다.
              사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
              http://www.piree.kr 에 문의해 주세요.

=====================================================================
 피리 카페 For 그누보드5.5 순정 > 프로그램 > 피리 카페 관리 > 내 카페 > 게시판 > 게시글 쓰기
=====================================================================


*/


  ###################################################################
  # 시작 => 선_처리
  ###################################################################

  //=================================================================
  // 라이브러리__첨부
  include_once('./_common.php');

  ###################################################################
  # 끝 => 선_처리
  ###################################################################



  ###################################################################
  # 시작 => 상수__변수__배열
  ###################################################################

  //=================================================================
  // 해당__게시판_분류__배열
  $board_cate_n_a = array();


  //=================================================================
  // 게시글_수
  $count_write = 0;


  //=================================================================
  // 댓글_수
  $count_comment = 0;

  ###################################################################
  # 끝 => 상수__변수__배열
  ###################################################################



  ###################################################################
  # 시작 => 라이브러리__파일__첨부
  ###################################################################

  //=================================================================
  // 네이버_신디케이션__관련__파일_첨부
  include_once(G5_LIB_PATH.'/naver_syndi.lib.php' );


  //=================================================================
  // CAPTCHA__라이브러리__파일__첨부
  include_once(G5_CAPTCHA_PATH.'/captcha.lib.php' );


  //=================================================================
  // 게시판_관련__라이브러리_파일__첨부
  include_once( piree__path($piree_prog_a[770100]['num'], 'piree.cafe.board.lib.inc.php') );

  ###################################################################
  # 끝 => 라이브러리__파일__첨부
  ###################################################################



  ###################################################################
  # 시작 => 카페_정보__확인하기
  ###################################################################

  //=================================================================
  // 피리_카페__정보__확인하기
  include_once( piree__path($piree_prog_a[770100]['num'], '_CAFE.INFO.CHECK.inc.php') );

  ###################################################################
  # 끝 => 카페_정보__확인하기
  ###################################################################



  ###################################################################
  # 시작 => 토큰_체크__QUERY_STRING
  ###################################################################

  //=================================================================
  // 토큰_체크
  check_write_token($piree['cafe_board_code']);


  //=================================================================
  // 
  $uid = isset($_POST['uid']) ? preg_replace('/[^0-9]/', '', $_POST['uid']) : 0;


  //=================================================================
  // 카테고리_분류__번호
  $board_cate_n = isset($_POST['board_cate_n']) ? trim($_POST['board_cate_n']) : '';
  $board_cate_n = (int)$board_cate_n;

  ###################################################################
  # 끝 => 토큰_체크__QUERY_STRING
  ###################################################################



  ###################################################################
  # 시작 => 라이브러리__파일__첨부
  ###################################################################

  //=================================================================
  // 페이지_제목
  $g5['title'] = '게시글 저장';


  //=================================================================
  // 메시지
  $msg = array();


  //=================================================================
  // 시작 => 게시판_분류__유무
  IF ( !$board_cate_n )
  {

      ###############################################################
      # 시작 => 게시판_분류__입력하지_않았으면

      //=============================================================
      // 게시판_분류__입력해라
      $msg[] = '<strong>게시판 분류</strong>를 선택하세요.';
  }
  ELSE
  {

      ###############################################################
      # 시작 => 게시판_분류__입력_했으면

      //=============================================================
      // 시작 => 게시판_분류__정보__없으면
      IF ( !$board_cate_list_a[$board_cate_n]['board_cate_s'] || $board_cate_n != $board_cate_list_a[$board_cate_n]['bca_cate_n'] )
      {
          $msg[] = '게시판 분류를 올바르게 입력하세요.';
      }
      // 끝 => 게시판_분류__정보__없으면
      //=============================================================

  }
  // 시작 => 게시판_분류__유무
  //=================================================================

  // 끝 => 게시판_설정__게시판_분류__여부
  //=================================================================


  //=================================================================
  // 게시글_제목
  $wr_subject = '';


  //=================================================================
  // 시작 => 게시글_제목__검증
  IF ( isset($_POST['wr_subject']) )
  {
    $wr_subject = substr(trim($_POST['wr_subject']),0,255);
    $wr_subject = preg_replace("#[\\\]+$#", "", $wr_subject);
  }
  // 끝 => 게시글_제목__검증
  //=================================================================


  //=================================================================
  // 시작 => 게시글_제목__입력_확인
  IF ( $wr_subject == '' )
  {
    $msg[] = '<strong>제목</strong>을 입력하세요.';
  }
  // 끝 => 게시글_제목__입력_확인
  //=================================================================


  //=================================================================
  // 게시글_내용
  $wr_content = '';


  //=================================================================
  // 시작 => 게시글_내용__검증
  IF ( isset($_POST['wr_content']) )
  {
    $wr_content = substr(trim($_POST['wr_content']),0,65536);
    $wr_content = preg_replace("#[\\\]+$#", "", $wr_content);
  }
  // 끝 => 게시글_내용__검증
  //=================================================================


  //=================================================================
  // 시작 => 게시글_내용__입력_확인
  IF ( $wr_content == '' )
  {
    $msg[] = '<strong>내용</strong>을 입력하세요.';
  }
  // 끝 => 게시글_내용__입력_확인
  //=================================================================


  //=================================================================
  // 링크__1
  $wr_link1 = '';


  //=================================================================
  // 시작 => 링크_1__검증
  IF ( isset($_POST['wr_link1']) )
  {
    $wr_link1 = substr($_POST['wr_link1'],0,1000);
    $wr_link1 = trim(strip_tags($wr_link1));
    $wr_link1 = preg_replace("#[\\\]+$#", "", $wr_link1);
  }
  // 끝 => 링크_1__검증
  //=================================================================


  //=================================================================
  // 링크__2
  $wr_link2 = '';


  //=================================================================
  // 시작 => 링크_2__검증
  IF ( isset($_POST['wr_link2']) )
  {
    $wr_link2 = substr($_POST['wr_link2'],0,1000);
    $wr_link2 = trim(strip_tags($wr_link2));
    $wr_link2 = preg_replace("#[\\\]+$#", "", $wr_link2);
  }
  // 끝 => 링크_2__검증
  //=================================================================


  //=================================================================
  // 에러_메시지
  $msg = implode('<br>', $msg);


  //=================================================================
  // 시작 => 메시지__출력하기
  IF ( $msg)
  {
    alert($msg );
  }
  // 끝 => 메시지__출력하기
  //=================================================================


  //=================================================================
  // 시작 => 게시글_내용__입력_확인
  IF ( substr_count($wr_content, '&#') > 50 )
  {
    alert('내용에 올바르지 않은 코드가 다수 포함되어 있습니다.');
    exit;
  }
  // 끝 => 게시글_내용__입력_확인
  //=================================================================


  //=================================================================
  // 파일_업로드__최대_용량
  $upload_max_filesize = ini_get('upload_max_filesize');


  //=================================================================
  // 시작 => 파일_용량__초과_확인
  IF ( empty($_POST) )
  {
    alert("파일 또는 글내용의 크기가 서버에서 설정한 값을 넘어 오류가 발생하였습니다.\\npost_max_size=". ini_get('post_max_size') ." , upload_max_filesize=". $upload_max_filesize ."\\n게시판관리자 또는 서버관리자에게 문의 바랍니다.");
  }
  // 끝 => 파일_용량__초과_확인
  //=================================================================


  //=================================================================
  // 공지_게시글_배열__분할
  $notice_array = explode(",", $board_cate_list_a[$board_cate_n]['bca_notice']);


  //=================================================================
  // 패스워드__입력_확인
  $wr_password = isset($_POST['wr_password']) ? $_POST['wr_password'] : '';


  //=================================================================
  // 게시글_내용__입력_확인
  $bf_content = isset($_POST['bf_content']) ? (array) $_POST['bf_content'] : array();


  //=================================================================
  // 옵션__HTML__입력_확인
  $_POST['html'] = isset($_POST['html']) ? clean_xss_tags($_POST['html'], 1, 1) : '';


  //=================================================================
  // 옵션__비밀글__입력_확인
  $_POST['secret'] = isset($_POST['secret']) ? clean_xss_tags($_POST['secret'], 1, 1) : '';


  //=================================================================
  // 메일_답변_받기__입력_확인
  $_POST['mail'] = isset($_POST['mail']) ? clean_xss_tags($_POST['mail'], 1, 1) : '';


  //=================================================================
  // 시작 => 수정__또는__답변__이면
  IF ( $w == 'u' || $w == 'r' )
  {

    //===============================================================
    // 원_게시글__ROW__가져오기
    $wr = get_write($piree['cafe_article'], $wr_id);


    //===============================================================
    // 시작 => 원_게시글__ROW__없으면
    IF ( !$wr['wr_id'] )
    {
        alert("글이 존재하지 않습니다.\\n글이 삭제되었거나 이동하였을 수 있습니다.");
    }
    // 끝 => 원_게시글__ROW__없으면
    //===============================================================

  }
  // 끝 => 수정__또는__답변__이면
  //=================================================================


  //=================================================================
  // 시작 => 외부에서__글을_등록할_수_있는__버그가_존재하므로__비밀글은__사용일_경우에만__가능해야_함
  IF ( !piree_cafe_auth_get() && !$board_cate_list_a[$board_cate_n]['bca_use_secret'] && (stripos($_POST['html'], 'secret') !== false || stripos($_POST['secret'], 'secret') !== false || stripos($_POST['mail'], 'secret') !== false) )
  {
	  alert('비밀글을 사용하지 않는 게시판 이므로 비밀글로 등록할 수 없습니다.');
  }
  // 끝 => 외부에서__글을_등록할_수_있는__버그가_존재하므로__비밀글은__사용일_경우에만__가능해야_함
  //=================================================================


  //=================================================================
  // 비밀글
  $secret = '';


  //=================================================================
  // 시작 => 비밀글__체크_했으면
  IF ( isset($_POST['secret']) && $_POST['secret'] )
  {

    //===============================================================
    // 시작 => 소문자_로__변경
    IF ( preg_match('#secret#', strtolower($_POST['secret']), $matches) )
    {
        $secret = $matches[0];
    }
    // 끝 => 소문자_로__변경
    //===============================================================

  }
  // 끝 => 비밀글__체크_했으면
  //=================================================================


  //=================================================================
  // 시작 => 외부에서__글을_등록할_수_있는__버그가_존재하므로__비밀글__무조건_사용일때는__관리자_아니면__공지_하고__무조건_비밀글로__등록
  IF ( !piree_cafe_auth_get() && $board_cate_list_a[$board_cate_n]['bca_use_secret'] == 2 )
  {
    $secret = 'secret';
  }
  // 끝 => 외부에서__글을_등록할_수_있는__버그가_존재하므로__비밀글__무조건_사용일때는__관리자_아니면__공지_하고__무조건_비밀글로__등록
  //=================================================================


  //=================================================================
  // HTML_사용__여부
  $html = '';


  //=================================================================
  // 시작 => HTML__체크_했으면
  IF ( isset($_POST['html']) && $_POST['html'] )
  {

    //===============================================================
    // 시작 => 소문자_로__변경
    IF (preg_match('#html(1|2)#', strtolower($_POST['html']), $matches) )
    {
        $html = $matches[0];
    }
    // 끝 => 소문자_로__변경
    //===============================================================

  }
  // 끝 => HTML__체크_했으면
  //=================================================================


  //=================================================================
  // 메일_답변
  $mail = '';


  //=================================================================
  // 시작 => 메일_답변__체크_했으면
  IF ( isset($_POST['mail']) && $_POST['mail'] )
  {

    //===============================================================
    // 시작 => 소문자_로__변경
    IF (preg_match('#mail#', strtolower($_POST['mail']), $matches))
    {
        $mail = $matches[0];
    }
    // 끝 => 소문자_로__변경
    //===============================================================

  }
  // 끝 => 메일_답변__체크_했으면
  //=================================================================


  //=================================================================
  // 공지사항__체크_여부
  $notice = '';


  //=================================================================
  // 시작 => 공지사항__체크_했으면
  IF ( isset($_POST['notice']) && $_POST['notice'] )
  {
    $notice = $_POST['notice'];
  }
  // 끝 => 공지사항__체크_했으면
  //=================================================================


  //=================================================================
  // 시작 => 반복문____10_번
  FOR ( $loop_n=1; $loop_n<=10; $loop_n++ )
  {

    //===============================================================
    // 여분_필드__이름
    $var = "wr_". $loop_n;
    $$var = "";


    //===============================================================
    // 시작 => 여분_필드__변수화
    IF ( isset($_POST['wr_'. $loop_n]) && settype($_POST['wr_'. $loop_n], 'string') )
    {
        $$var = trim($_POST['wr_'. $loop_n]);
    }
    // 끝 => 여분_필드__변수화
    //===============================================================

  }
  // 끝 => 반복문____10_번
  //=================================================================


  //=================================================================
  // 게시글_쓰기__상단__스킨_처리__파일__첨부
  @include_once($board_cate_list_a[$board_cate_n]['board_skin_p'] .'/write_update.head.skin.php' );


  //=================================================================
  // HOOK_실행
  // run_event('write_update_before', $board, $wr_id, $w, $qstr);
  run_event('cafe_board_write_update_before', $piree_cafe_n, $board_cate_n, $wr_id, $w, $qstr);


  //=================================================================
  // CAPTCHA__사용_여부
  $is_use_captcha = ((($board_cate_list_a[$board_cate_n]['bca_use_captcha'] && $w !== 'u') || $is_guest) && !piree_cafe_auth_get()) ? 1 : 0;


  //=================================================================
  // 시작 => CAPTCHA__자동등록방지_문자__틀렸으면
  IF ( $is_use_captcha && !chk_captcha() )
  {
    alert('자동등록방지 숫자가 틀렸습니다.');
  }
  // 끝 => CAPTCHA__자동등록방지_문자__틀렸으면
  //=================================================================

  ###################################################################
  # 끝 => 
  ###################################################################



  ###################################################################
  # 시작 => 
  ###################################################################

  //=================================================================
  //


  //=================================================================
  //

  ###################################################################
  # 끝 => 
  ###################################################################



  ###################################################################
  # 시작 => 동작__구분
  ###################################################################

  //=================================================================
  // 시작 => 동작__구분
  SWITCH ( $w )
  {

    #################################################################
    # 시작 => 수정
    #################################################################
    CASE 'u' :

      //=============================================================
      // 시작 => 관리자__아니면__공지_등록__불가
      // 시작 => 외부에서__글을_등록할_수_있는__버그가_존재하므로__공지는__관리자만_등록이__가능해야_함
      IF ( !piree_cafe_auth_get() && $notice )
      {
          alert('관리자만 공지할 수 있습니다.');
      }
      // 끝 => 관리자__아니면__공지_등록__불가
      // 끝 => 외부에서__글을_등록할_수_있는__버그가_존재하므로__공지는__관리자만_등록이__가능해야_함
      //=============================================================


      //=============================================================
      // 시작 => 회원_자신이__쓴글을__수정할_경우__공지가_풀리는__경우가_있음
      IF ( !piree_cafe_auth_get() && $board_cate_list_a[$board_cate_n]['bca_notice'] && in_array($wr['wr_id'], $notice_array) )
      {
          $notice = 1;
      }
      // 끝 => 회원_자신이__쓴글을__수정할_경우__공지가_풀리는__경우가_있음
      //=============================================================


      //=============================================================
      // 시작 => 김선용 1.00 : 글쓰기 권한과 수정은 별도로 처리되어야 함
      IF ( $member['mb_id'] && $wr['mb_id'] === $member['mb_id'] )
      {
          ;
      }
      ELSE IF ( $cafe_member_a['cafe_mem_level_n'] < $board_cate_list_a[$board_cate_n]['bca_write_level'] )
      {
          alert('글을 쓸 권한이 없습니다.');
      }
      // 끝 => 김선용 1.00 : 글쓰기 권한과 수정은 별도로 처리되어야 함
      //=============================================================


      //=============================================================
      // 

    BREAK;
    #################################################################
    # 끝 => 수정
    #################################################################



    #################################################################
    # 시작 => 답변
    #################################################################
    CASE 'r' :

      //=============================================================
      // 시작 => 공지사항__이면__답변할수__없다
      IF ( in_array((int)$wr_id, $notice_array) )
      {
          alert('공지에는 답변 할 수 없습니다.');
      }
      // 끝 => 공지사항__이면__답변할수__없다
      //=============================================================


      //=============================================================
      // 시작 => 답변할__권한__없음___권한__레벨__낮으면
      IF ( $cafe_member_a['cafe_mem_level_n'] < $board_cate_list_a[$board_cate_n]['bca_reply_level'] )
      {
          alert('글을 답변할 권한이 없습니다.');
      }
      // 끝 => 답변할__권한__없음___권한__레벨__낮으면
      //=============================================================


      //=============================================================
      // 게시글_배열__참조
      $reply_array = &$wr;


      //=============================================================
      // 시작 => 최대_답변은_테이블에__잡아놓은_wr_reply__사이즈만큼만__가능합니다.
      IF ( strlen($reply_array['wr_reply']) == 10 )
      {
          alert("더 이상 답변하실 수 없습니다.\\n답변은 10단계 까지만 가능합니다.");
      }
      // 끝 => 최대_답변은_테이블에__잡아놓은_wr_reply__사이즈만큼만__가능합니다
      //=============================================================


      //=============================================================
      // 답변_코드_길이
      $reply_len = strlen($reply_array['wr_reply']) + 1;


      //=============================================================
      // 시작 => 게시판__정렬_필드__유무
      IF ( $board_cate_list_a[$board_cate_n]['bca_reply_order'] )
      {

          //=========================================================
          // 답변__관련
          $begin_reply_char = 'A';
          $end_reply_char = 'Z';
          $reply_number = +1;


          //=========================================================
          // 답변_코드__알아내기
          $sql_select  = "SELECT MAX(SUBSTRING(`wr_reply`, ". $reply_len .", 1)) AS `reply` FROM `". $piree['cafe_article'] ."` ";
          $sql_select .= "WHERE `wr_num` = '". $reply_array['wr_num'] ."' AND SUBSTRING(`wr_reply`, ". $reply_len .", 1) <> '' ";

      }
      ELSE
      {

          //=========================================================
          // 답변__관련
          $begin_reply_char = 'Z';
          $end_reply_char = 'A';
          $reply_number = -1;


          //=========================================================
          // 답변_코드__알아내기
          $sql_select  = "SELECT MIN(SUBSTRING(`wr_reply`, ". $reply_len .", 1)) AS `reply` FROM `". $piree['cafe_article'] ."` ";
          $sql_select .= "WHERE `wr_num` = '". $reply_array['wr_num'] ."' AND SUBSTRING(`wr_reply`, ". $reply_len .", 1) <> '' ";

      }
      // 끝 => 게시판__정렬_필드__유무
      //=============================================================


      //=============================================================
      // 시작 => 답변_코드__있으면
      IF ( $reply_array['wr_reply'])
      {
          $sql_select .= " AND `wr_reply` LIKE '". $reply_array['wr_reply'] ."%'";
      }
      // 끝 => 답변_코드__있으면
      //=============================================================


      //=============================================================
      // 원_게시글__ROW__가져오기
      $row = sql_fetch($sql_select);


      //=============================================================
      // 시작 => 답변_코드__구분
      IF ( !$row['reply'] )
      {

          ###########################################################
          # 시작 => 답변_코드__기본값

          $reply_char = $begin_reply_char;

      }
      ELSE IF ( $row['reply'] == $end_reply_char )
      {

          ###########################################################
          # 시작 => A_Z은__26__입니다.

          alert("더 이상 답변하실 수 없습니다.\\n답변은 26개 까지만 가능합니다.");

      }
      ELSE
      {

          ###########################################################
          # 시작 => 다음__답변_코드__알아내기

          $reply_char = chr(ord($row['reply']) + $reply_number);

      }
      // 끝 => 답변_코드__구분
      //=============================================================


      //=============================================================
      // 답변_코드
      $reply = $reply_array['wr_reply'] . $reply_char;


      //=============================================================
      // 시작 => 세션__시각____있으면
      IF ( isset($_SESSION['ss_datetime']) )
      {

        //===========================================================
        // 시작 => 사이트__설정된__시각_보다____빨리__게시글_등록__했으면
        IF ( $_SESSION['ss_datetime'] >= (G5_SERVER_TIME - $config['cf_delay_sec']) && !piree_cafe_auth_get() )
        {
            alert('너무 빠른 시간내에 게시물을 연속해서 올릴 수 없습니다.');
        }
        // 끝 => 사이트__설정된__시각_보다____빨리__게시글_등록__했으면
        //===========================================================

      }
      // 끝 => 세션__시각____있으면
      //=============================================================


      //=============================================================
      // 세션__생성
      set_session("ss_datetime", G5_SERVER_TIME);


      //=============================================================
      // 

    BREAK;
    #################################################################
    # 끝 => 답변
    #################################################################



    #################################################################
    # 시작 => 새글쓰기
    #################################################################
    DEFAULT :

      //=============================================================
      // 시작 => 관리자__아니면__공지_등록__불가
      // 시작 => 외부에서__글을_등록할_수_있는__버그가_존재하므로__공지는__관리자만_등록이__가능해야_함
      IF ( !piree_cafe_auth_get() && $notice )
      {
          alert('관리자만 공지할 수 있습니다.');
      }
      // 끝 => 관리자__아니면__공지_등록__불가
      // 끝 => 외부에서__글을_등록할_수_있는__버그가_존재하므로__공지는__관리자만_등록이__가능해야_함
      //=============================================================


      //=============================================================
      // 시작 => 세션__시각____있으면
      IF ( isset($_SESSION['ss_datetime']) )
      {

        //===========================================================
        // 시작 => 사이트__설정된__시각_보다____빨리__게시글_등록__했으면
        IF ( $_SESSION['ss_datetime'] >= (G5_SERVER_TIME - $config['cf_delay_sec']) && !piree_cafe_auth_get() )
        {
            alert('너무 빠른 시간내에 게시물을 연속해서 올릴 수 없습니다.');
        }
        // 끝 => 사이트__설정된__시각_보다____빨리__게시글_등록__했으면
        //===========================================================

      }
      // 끝 => 세션__시각____있으면
      //=============================================================


      //=============================================================
      // 세션__생성
      set_session("ss_datetime", G5_SERVER_TIME);


      //=============================================================
      // 

    BREAK;
    #################################################################
    # 끝 => 새글쓰기
    #################################################################

  }
  // 끝 => 동작__구분
  //=================================================================

  ###################################################################
  # 끝 => 동작__구분
  ###################################################################



  ###################################################################
  # 시작 => 추가__처리
  ###################################################################

  //=================================================================
  // 시작 => 제목__입력__안되었으면
  IF ( !isset($_POST['wr_subject']) || !trim($_POST['wr_subject']) )
  {
    alert('제목을 입력하여 주십시오.');
  }
  // 끝 => 제목__입력__안되었으면
  //=================================================================


  //=================================================================
  // SEO_제목
  $wr_seo_title = exist_seo_title_recursive('bbs', generate_seo_title($wr_subject), $piree['cafe_article'], $wr_id);


  //=================================================================
  // 옵션__배열
  $options = array($html, $secret, $mail);


  //=================================================================
  // 게시글__옵션
  $wr_option = implode(',', array_filter(array_map('trim', $options)));

  ###################################################################
  # 끝 => 추가__처리
  ###################################################################



  ###################################################################
  # 시작 => 동작__구분
  ###################################################################

  //=================================================================
  // 시작 => 동작__구분
  SWITCH ( $w )
  {

    #################################################################
    # 시작 => 수정
    #################################################################
    CASE 'u' :

      //=============================================================
      // 시작 => 세션_확인하여__올바른_수정_방법인지__확인
      IF ( get_session('ss_bo_table') != $_POST['bo_table'] || get_session('ss_wr_id') != $_POST['wr_id'] )
      {
        alert('올바른 방법으로 수정하여 주십시오.', go_piree_cafe_board('', $piree_cafe_n, $board_cate_n));
      }
      // 끝 => 세션_확인하여__올바른_수정_방법인지__확인
      //=============================================================


      //=============================================================
      // 돌아갈_페이지
      $return_url = go_piree_cafe_board('', $piree_cafe_n, $board_cate_n, $wr_id);


      //=============================================================
      // 시작 => 관리자__카페_주인__작성자__권한__확인
      IF ( piree_cafe_auth_get() )
      {

          ###########################################################
          # 시작 => 최고관리자__또는__카페_주인__이면

          // 그냥_통과
          ;

      }
      ELSE IF ( $member['mb_id'] )
      {

          ###########################################################
          # 시작 => 회원__이면

          //=========================================================
          // 시작 => 작성자가__아니면
          IF ( $member['mb_id'] != $write['mb_id'])
          {
              alert('자신의 글이 아니므로 수정할 수 없습니다.', $return_url);
          }
          // 끝 => 작성자가__아니면
          //=========================================================

      }
      ELSE
      {

          ###########################################################
          # 시작 => 손님__이면

          //=========================================================
          // 시작 => 회원__아니면
          IF ( !$member['mb_id'] || $member['mb_id'] != $write['mb_id'] )
          {
              alert('로그인 후 수정하세요.', G5_BBS_URL.'/login.php?url='.urlencode($return_url));
          }
          // 끝 => 회원__아니면
          //=========================================================

      }
      // 끝 => 관리자__카페_주인__작성자__권한__확인
      //=============================================================


      //=============================================================
      // 게시글_수정하는__쿼리문
      $sql_update  = "UPDATE `". $piree['cafe_article'] ."` SET ";


      //=============================================================
      // 시작 => 작성자__여부
      IF ( $member['mb_id'] === $wr['mb_id'] )
      {

          ###########################################################
          # 시작 => 작성자__이면
          ###########################################################

          //=========================================================
          // 회원_아이디
          $mb_id = $member['mb_id'];


          //=========================================================
          // 회원_이름
          $wr_name = addslashes(clean_xss_tags($board_cate_list_a[$board_cate_n]['bca_use_name'] ? $member['mb_name'] : $member['mb_nick']));


          //=========================================================
          // 메일주소
          $wr_email = addslashes($member['mb_email']);


          //=========================================================
          // 홈페이지_주소
          $wr_homepage = addslashes(clean_xss_tags($member['mb_homepage']));

      }
      ELSE
      {

          ###########################################################
          # 시작 => 작성자__아니면
          ###########################################################

          //=========================================================
          // 회원_아이디
          $mb_id = $wr['mb_id'];


          //=========================================================
          // 시작 => 작성자__이름
          IF ( isset($_POST['wr_name']) && $_POST['wr_name'] )
          {
              $wr_name = clean_xss_tags(trim($_POST['wr_name']));
          }
          ELSE
          {
              $wr_name = addslashes(clean_xss_tags($wr['wr_name']));
          }
          // 끝 => 작성자__이름
          //=========================================================


          //=========================================================
          // 시작 => 작성자__메일주소
          IF ( isset($_POST['wr_email']) && $_POST['wr_email'] )
          {
              $wr_email = get_email_address(trim($_POST['wr_email']));
          }
          ELSE
          {
              $wr_email = addslashes($wr['wr_email']);
          }
          // 끝 => 작성자__메일주소
          //=========================================================


          //=========================================================
          // 시작 => 작성자__홈페이지_주소
          IF ( isset($_POST['wr_homepage']) && $_POST['wr_homepage'] )
          {
              $wr_homepage = addslashes(clean_xss_tags($_POST['wr_homepage']));
          }
          ELSE
          {
              $wr_homepage = addslashes(clean_xss_tags($wr['wr_homepage']));
          }
          // 끝 => 작성자__홈페이지_주소
          //=========================================================

      }
      // 끝 => 작성자__여부
      //=============================================================


      //=============================================================
      // 댓글_수__파악하기
      $sql_select  = "SELECT COUNT(*) FROM `". $piree['cafe_article'] ."` ";
      $sql_select .= "WHERE `wr_parent` = '". $wr_id ."' AND `wr_is_comment` = '1'";
      $comment_t = (int)sql_efv($sql_select);


      //=============================================================
      // 패스워드
      $sql_password = $wr_password ? " , `wr_password` = '". get_encrypt_string($wr_password) ."' " : "";


      //=============================================================
      // 아이피
      $sql_ip = '';


      //=============================================================
      // 시작 => 관리자__아니면
      IF ( !piree_cafe_auth_get() )
      {
          $sql_ip = " , `wr_ip` = '". $_SERVER['REMOTE_ADDR'] ."' ";
      }
      // 끝 => 관리자__아니면
      //=============================================================


      //=============================================================
      // 게시글_수정하는__쿼리문
      $sql_update  = "UPDATE `". $piree['cafe_article'] ."` SET ";
      $sql_update .= "`wr_comment`   = '". $comment_t ."', ";
      $sql_update .= "`ca_name`      = '". $ca_name ."', ";
      $sql_update .= "`wr_option`    = '". $wr_option ."', ";
      $sql_update .= "`wr_subject`   = '". $wr_subject ."', ";
      $sql_update .= "`wr_content`   = '". $wr_content ."', ";
      $sql_update .= "`wr_seo_title` = '". $wr_seo_title ."', ";
      $sql_update .= "`wr_link1`     = '". $wr_link1 ."', ";
      $sql_update .= "`wr_link2`     = '". $wr_link2 ."', ";
      $sql_update .= "`mb_id`        = '". $mb_id ."', ";
      $sql_update .= "`wr_name`      = '". $wr_name ."', ";
      $sql_update .= "`wr_email`     = '". $wr_email ."', ";
      $sql_update .= "`wr_homepage`  = '". $wr_homepage ."', ";
      $sql_update .= "`wr_1`         = '". $wr_1 ."', ";
      $sql_update .= "`wr_2`         = '". $wr_2 ."', ";
      $sql_update .= "`wr_3`         = '". $wr_3 ."', ";
      $sql_update .= "`wr_4`         = '". $wr_4 ."', ";
      $sql_update .= "`wr_5`         = '". $wr_5 ."', ";
      $sql_update .= "`wr_6`         = '". $wr_6 ."', ";
      $sql_update .= "`wr_7`         = '". $wr_7 ."', ";
      $sql_update .= "`wr_8`         = '". $wr_8 ."', ";
      $sql_update .= "`wr_9`         = '". $wr_9 ."', ";
      $sql_update .= "`wr_10`        = '". $$wr_10 ."' ";
      $sql_update .= $sql_ip;
      $sql_update .= $sql_password;


      //=============================================================
      // 게시글_수정하는__쿼리문____피리_카페__게시판__추가_칼럼
      $sql_update .= ", ";
      $sql_update .= "`wr_pi_piree_cafe_n`  = '". $piree_cafe_n ."', ";
      $sql_update .= "`wr_pi_board_cate_n`  = '". $board_cate_n ."', ";
      $sql_update .= "`wr_pi_piree_cafe_s`  = '". $piree_cafe_name_s ."', ";
      $sql_update .= "`wr_pi_board_cate_s`  = '". $board_cate_list_a[$board_cate_n]['board_cate_path_s'] ."' ";


      //=============================================================
      // 게시글_수정하는__쿼리문
      $sql_update .= "WHERE `wr_id` = '". $wr['wr_id'] ."'";


      //=============================================================
      // 시작 => 쿼리_실행
      IF ( !sql_query($sql_update) )
      {

        //===========================================================
        // 게시판__칼럼_추가____카페_번호
        $sql_alter = "ALTER TABLE `". $piree['cafe_article'] ."` ADD `wr_pi_piree_cafe_n` INT UNSIGNED NOT NULL DEFAULT '0'";
        sql_query($sql_alter, false);


        //===========================================================
        // 게시판__칼럼_추가____게시판_분류_계층_번호
        $sql_alter = "ALTER TABLE `". $piree['cafe_article'] ."` ADD `wr_pi_board_cate_n` INT UNSIGNED NOT NULL DEFAULT '0'";
        sql_query($sql_alter, false);


        //===========================================================
        // 게시판__칼럼_추가____카페_이름
        $sql_alter = "ALTER TABLE `". $piree['cafe_article'] ."` ADD `wr_pi_piree_cafe_s` VARCHAR(255) NOT NULL DEFAULT ''";
        sql_query($sql_alter, false);


        //===========================================================
        // 게시판__칼럼_추가____게시판_분류_이름
        $sql_alter = "ALTER TABLE `". $piree['cafe_article'] ."` ADD `wr_pi_board_cate_s` VARCHAR(255) NOT NULL DEFAULT ''";
        sql_query($sql_alter, false);


        //===========================================================
        // 시작 => 쿼리_실행
        IF ( !sql_query($sql_update) )
        {
          // 에러
          $msg_s = "게시글을 수정하지 못했습니다.";
          alert($msg_s);
        }
        // 끝 => 쿼리_실행
        //===========================================================

      }
      // 끝 => 쿼리_실행
      //=============================================================


      //=============================================================
      // 공지사항__가져오기
      $bca_notice = board_notice($board_cate_list_a[$board_cate_n]['bca_notice'], $wr_id, $notice);


      //=============================================================
      // 게시판_분류에__공지사항__저장하기
      $sql_update  = "UPDATE `". $piree['cafe_board'] ."` SET ";
      $sql_update .= "`bca_notice` = '". $bca_notice ."' ";
      $sql_update .= "WHERE `bca_cafe_n` = '". $piree_cafe_n ."' AND `bca_cate_n` = '". $board_cate_n ."'";
      sql_query($sql_update);


      //=============================================================
      // 게시글_ROW__가져오기
      // 글을__수정한_경우에는__제목이_달라질수도_있으니__static_variable_를__새로고침합니다.
      $write = get_write($piree['cafe_article'], $wr['wr_id'], false);

    BREAK;
    #################################################################
    # 끝 => 수정
    #################################################################



    #################################################################
    # 시작 => 새글쓰기
    # 시작 => 답변쓰기
    #################################################################
    DEFAULT :

      ###############################################################
      # 시작 => 입력사항__확인
      ###############################################################

      //=============================================================
      // 시작 => 회원__여부
      IF ( $member['mb_id'] )
      {

          //=========================================================
          // 회원__아이디
          $mb_id = $member['mb_id'];


          //=========================================================
          // 회원__이름
          $wr_name = addslashes(clean_xss_tags($board_cate_list_a[$board_cate_n]['bca_use_name'] ? $member['mb_name'] : $member['mb_nick']));


          //=========================================================
          // 패스워드
          $wr_password = '';


          //=========================================================
          // 메일주소
          $wr_email = addslashes($member['mb_email']);


          //=========================================================
          // 홈페이지_주소
          $wr_homepage = addslashes(clean_xss_tags($member['mb_homepage']));

      }
      ELSE
      {

          //=========================================================
          // 회원__아이디
          $mb_id = '';


          //=========================================================
          // 회원__이름
          // 비회원의 경우 이름이 누락되는 경우가 있음
          $wr_name = clean_xss_tags(trim($_POST['wr_name']));


          //=========================================================
          // 시작 => 이름__입력_안되었으면
          IF ( !$wr_name )
          {
              alert('이름은 필히 입력하셔야 합니다.');
          }
          // 끝 => 이름__입력_안되었으면
          //=========================================================


          //=========================================================
          // 패스워드
          $wr_password = get_encrypt_string($wr_password);


          //=========================================================
          // 메일주소
          $wr_email = get_email_address(trim($_POST['wr_email']));


          //=========================================================
          // 홈페이지_주소
          $wr_homepage = clean_xss_tags($wr_homepage);

      }
      // 끝 => 회원__여부
      //=============================================================

      ###############################################################
      # 끝 => 입력사항__확인
      ###############################################################



      ###############################################################
      # 시작 => 게시글__위치
      ###############################################################

      //=============================================================
      // 시작 => 답변하기__새글쓰기__구분
      IF ( $w == 'r' )
      {

          //=========================================================
          // 시작 => 답변의_원글이__비밀글이라면__비밀번호는__원글과_동일하게_넣는다
          IF ( $secret )
          {
              $wr_password = $wr['wr_password'];
          }
          // 끝 => 답변의_원글이__비밀글이라면__비밀번호는__원글과_동일하게_넣는다
          //=========================================================


          //=========================================================
          // 게시글_번호
          $wr_id = $wr_id . $reply;


          //=========================================================
          // 게시글_순서
          $wr_num = $write['wr_num'];


          //=========================================================
          // 게시글_답변
          $wr_reply = $reply;

      }
      ELSE
      {

          //=========================================================
          // 게시글__새_순서__가져오기
          $wr_num = get_next_num($piree['cafe_article']);


          //=========================================================
          // 게시글_답변
          $wr_reply = '';

      }
      // 끝 => 답변하기__새글쓰기__구분
      //=============================================================

      ###############################################################
      # 끝 => 게시글__위치
      ###############################################################



      ###############################################################
      # 시작 => 게시글__입력
      ###############################################################

      //=============================================================
      // 입력하는__쿼리문
      $sql_insert  = "INSERT INTO `". $piree['cafe_article'] ."` SET ";
      $sql_insert .= "`wr_num`        = '". $wr_num ."', ";
      $sql_insert .= "`wr_reply`      = '". $wr_reply ."', ";
      $sql_insert .= "`wr_comment`    = '0', ";
      $sql_insert .= "`ca_name`       = '". $ca_name ."', ";
      $sql_insert .= "`wr_option`     = '". $wr_option ."', ";
      $sql_insert .= "`wr_subject`    = '". $wr_subject ."', ";
      $sql_insert .= "`wr_content`    = '". $wr_content ."', ";
      $sql_insert .= "`wr_seo_title`  = '". $wr_seo_title ."', ";
      $sql_insert .= "`wr_link1`      = '". $wr_link1 ."', ";
      $sql_insert .= "`wr_link2`      = '". $wr_link2 ."', ";
      $sql_insert .= "`wr_link1_hit`  = '0', ";
      $sql_insert .= "`wr_link2_hit`  = '0', ";
      $sql_insert .= "`wr_hit`        = '0', ";
      $sql_insert .= "`wr_good`       = '0', ";
      $sql_insert .= "`wr_nogood`     = '0', ";
      $sql_insert .= "`mb_id`         = '". $member['mb_id'] ."', ";
      $sql_insert .= "`wr_password`   = '". $wr_password ."', ";
      $sql_insert .= "`wr_name`       = '". $wr_name ."', ";
      $sql_insert .= "`wr_email`      = '". $wr_email ."', ";
      $sql_insert .= "`wr_homepage`   = '". $wr_homepage ."', ";
      $sql_insert .= "`wr_datetime`   = '". G5_TIME_YMDHIS ."', ";
      $sql_insert .= "`wr_last`       = '". G5_TIME_YMDHIS ."', ";
      $sql_insert .= "`wr_ip`         = '". $_SERVER['REMOTE_ADDR'] ."', ";
      $sql_insert .= "`wr_1`          = '". $wr_1 ."', ";
      $sql_insert .= "`wr_2`          = '". $wr_2 ."', ";
      $sql_insert .= "`wr_3`          = '". $wr_3 ."', ";
      $sql_insert .= "`wr_4`          = '". $wr_4 ."', ";
      $sql_insert .= "`wr_5`          = '". $wr_5 ."', ";
      $sql_insert .= "`wr_6`          = '". $wr_6 ."', ";
      $sql_insert .= "`wr_7`          = '". $wr_7 ."', ";
      $sql_insert .= "`wr_8`          = '". $wr_8 ."', ";
      $sql_insert .= "`wr_9`          = '". $wr_9 ."', ";
      $sql_insert .= "`wr_10`         = '". $wr_10 ."'";


      //=============================================================
      // 입력하는__쿼리문____피리_카페__게시판__추가_칼럼
      $sql_insert .= ", ";
      $sql_insert .= "`wr_pi_piree_cafe_n`  = '". $piree_cafe_n ."', ";
      $sql_insert .= "`wr_pi_board_cate_n`  = '". $board_cate_n ."', ";
      $sql_insert .= "`wr_pi_piree_cafe_s`  = '". $piree_cafe_name_s ."', ";
      $sql_insert .= "`wr_pi_board_cate_s`  = '". $board_cate_list_a[$board_cate_n]['board_cate_path_s'] ."'";


      //=============================================================
      // 시작 => 쿼리_실행
      IF ( !sql_query($sql_insert) )
      {

        //===========================================================
        // 게시판__칼럼_추가____카페_번호
        $sql_alter = "ALTER TABLE `". $piree['cafe_article'] ."` ADD `wr_pi_piree_cafe_n` INT UNSIGNED NOT NULL DEFAULT '0'";
        sql_query($sql_alter, false);


        //===========================================================
        // 게시판__칼럼_추가____게시판_분류_계층_번호
        $sql_alter = "ALTER TABLE `". $piree['cafe_article'] ."` ADD `wr_pi_board_cate_n` INT UNSIGNED NOT NULL DEFAULT '0'";
        sql_query($sql_alter, false);


        //===========================================================
        // 게시판__칼럼_추가____카페_이름
        $sql_alter = "ALTER TABLE `". $piree['cafe_article'] ."` ADD `wr_pi_piree_cafe_s` VARCHAR(255) NOT NULL DEFAULT ''";
        sql_query($sql_alter, false);


        //===========================================================
        // 게시판__칼럼_추가____게시판_분류_이름
        $sql_alter = "ALTER TABLE `". $piree['cafe_article'] ."` ADD `wr_pi_board_cate_s` VARCHAR(255) NOT NULL DEFAULT ''";
        sql_query($sql_alter, false);


        //===========================================================
        // 시작 => 쿼리_실행
        IF ( !sql_query($sql_insert) )
        {
          // 에러
          $msg_s = "게시글을 등록하지 못했습니다.";
          alert($msg_s);
        }
        // 끝 => 쿼리_실행
        //===========================================================

      }
      // 끝 => 쿼리_실행
      //=============================================================


      //=============================================================
      // 새_게시글_번호
      $wr_id = sql_insert_id();


      //=============================================================
      // 게시글_수__증가
      $count_write++;


      //=============================================================
      // 해당__게시판_분류__배열
      $board_cate_n_a[$board_cate_n] = $wr_id;

      ###############################################################
      # 끝 => 게시글__입력
      ###############################################################



      ###############################################################
      # 시작 => 부모_아이디에__UPDATE
      ###############################################################

      //=============================================================
      // 부모_아이디에__UPDATE
      $sql_update  = "UPDATE `". $piree['cafe_article'] ."` SET ";
      $sql_update .= "`wr_parent` = '". $wr_id ."' ";
      $sql_update .= "WHERE `wr_id` = '". $wr_id ."'";
      sql_query($sql_update);

      ###############################################################
      # 끝 => 부모_아이디에__UPDATE
      ###############################################################



      ###############################################################
      # 시작 => 새글__입력
      ###############################################################

      //=============================================================
      // 새글_INSERT
      $sql_insert  = "INSERT INTO `". $g5['board_new_table'] ."` SET ";
      $sql_insert .= "`bo_table`    = '". $piree['cafe_board_code'] ."', ";
      $sql_insert .= "`wr_id`       = '". $wr_id ."', ";
      $sql_insert .= "`wr_parent`   = '". $wr_id ."', ";
      $sql_insert .= "`bn_datetime` = '". G5_TIME_YMDHIS ."', ";
      $sql_insert .= "`mb_id`       = '". $member['mb_id'] ."'";


      //=============================================================
      // 입력하는__쿼리문____피리_카페__게시판__추가_칼럼
      $sql_insert .= ", ";
      $sql_insert .= "`bn_pi_piree_cafe_n`  = '". $piree_cafe_n ."', ";
      $sql_insert .= "`bn_pi_board_cate_n`  = '". $board_cate_n ."', ";
      $sql_insert .= "`bn_pi_piree_cafe_s`  = '". $piree_cafe_name_s ."', ";
      $sql_insert .= "`bn_pi_board_cate_s`  = '". $board_cate_list_a[$board_cate_n]['board_cate_path_s'] ."'";


      //=============================================================
      // 시작 => 쿼리_실행
      IF ( !sql_query($sql_insert) )
      {

        //===========================================================
        // 새글_테이블__칼럼_추가____카페_번호
        $sql_alter = "ALTER TABLE `". $g5['board_new_table'] ."` ADD `bn_pi_piree_cafe_n` INT UNSIGNED NOT NULL DEFAULT '0'";
        sql_query($sql_alter, false);


        //===========================================================
        // 새글_테이블__칼럼_추가____게시판_분류_계층_번호
        $sql_alter = "ALTER TABLE `". $g5['board_new_table'] ."` ADD `bn_pi_board_cate_n` INT UNSIGNED NOT NULL DEFAULT '0'";
        sql_query($sql_alter, false);


        //===========================================================
        // 새글_테이블__칼럼_추가____카페_이름
        $sql_alter = "ALTER TABLE `". $g5['board_new_table'] ."` ADD `bn_pi_piree_cafe_s` VARCHAR(255) NOT NULL DEFAULT ''";
        sql_query($sql_alter, false);


        //===========================================================
        // 새글_테이블__칼럼_추가____게시판_분류_이름
        $sql_alter = "ALTER TABLE `". $g5['board_new_table'] ."` ADD `bn_pi_board_cate_s` VARCHAR(255) NOT NULL DEFAULT ''";
        sql_query($sql_alter, false);


        //===========================================================
        // 시작 => 쿼리_실행
        IF ( !sql_query($sql_insert) )
        {
          // 에러
          $msg_s = "새글 테이블에 게시글을 등록하지 못했습니다.";
          alert($msg_s);
        }
        // 끝 => 쿼리_실행
        //===========================================================

      }
      // 끝 => 쿼리_실행
      //=============================================================

      ###############################################################
      # 끝 => 새글__입력
      ###############################################################



      ###############################################################
      # 시작 => 게시글__쓰기__저장__포인트__지급
      ###############################################################

      //=============================================================
      // 시작 => 쓰기_포인트__부여
      IF ( $w == '' )
      {

          //=========================================================
          // 시작 => 공지_게시글__이면
          IF ( $notice )
          {

              //=====================================================
              // 게시판__공지사항_변수에__추가
              $bca_notice = $wr_id . ($board_cate_list_a[$board_cate_n]['bca_notice'] ? ",".$board_cate_list_a[$board_cate_n]['bca_notice'] : '');


              //=====================================================
              // 게시판_테이블__공지사항에__추가
              $sql_update  = "UPDATE `". $piree['cafe_board'] ."` SET ";
              $sql_update .= "`bca_notice` = '". $bca_notice ."' ";
              $sql_update .= "WHERE `bca_table` = '". $piree['cafe_board_code'] ."'";
              sql_query($sql_update);

          }
          // 끝 => 공지_게시글__이면
          //=========================================================


          //=========================================================
          // 포인트__거래__타이틀
          $point_trade_title_s = "[ ". $piree_cafe_name_s ." ] 카페의 [ ". $board_cate_list_a[$board_cate_n]['bca_cate_s'] ." ] 게시판에 ". $wr_id ." 글쓰기";


          //=========================================================
          // 포인트__거래
          insert_point($member['mb_id'], $board_cate_list_a[$board_cate_n]['bca_write_point'], $point_trade_title_s, $piree['cafe_board_code'], $wr_id, '쓰기');

      }
      ELSE
      {

          //=========================================================
          // 포인트__거래__타이틀
          $point_trade_title_s = "[ ". $piree_cafe_name_s ." ] 카페의 [ ". $board_cate_list_a[$board_cate_n]['bca_cate_s'] ." ] 게시판에 ". $wr_id ." 글답변";


          //=========================================================
          // 답변은__코멘트_포인트를__부여함
          // 답변_포인트가__많은_경우__코멘트_대신__답변을__하는_경우가_많음
          insert_point($member['mb_id'], $board_cate_list_a[$board_cate_n]['bca_comment_point'], $point_trade_title_s, $piree['cafe_board_code'], $wr_id, '쓰기');

      }
      // 끝 => 쓰기_포인트__부여
      //=============================================================

      ###############################################################
      # 끝 => 게시글__쓰기__저장__포인트__지급
      ###############################################################

    BREAK;
    #################################################################
    # 끝 => 새글쓰기
    # 끝 => 답변쓰기
    #################################################################

  }
  // 끝 => 동작__구분
  //=================================================================

  ###################################################################
  # 끝 => 동작__구분
  ###################################################################



  ###################################################################
  # 시작 => 추가__처리
  ###################################################################

  //=================================================================
  // 시작 => 비회원_글읽기가__가능해야_하며__비밀글이__아니어야_한다
  IF ( $board_cate_list_a[$board_cate_n]['bca_read_level'] < 2 && !$secret )
  {
      naver_syndi_ping($piree['cafe_board_code'], $wr_id);
  }
  // 끝 => 비회원_글읽기가__가능해야_하며__비밀글이__아니어야_한다
  //=================================================================

  ###################################################################
  # 끝 => 추가__처리
  ###################################################################



  ###################################################################
  # 시작 => 파일__업로드
  ###################################################################

  //=================================================================
  // 파일_개수__기본값
  $file_count = 0;


  //=================================================================
  // 파일_업로드_개수
  $upload_count = (isset($_FILES['bf_file']['name']) && is_array($_FILES['bf_file']['name'])) ? count($_FILES['bf_file']['name']) : 0;


  //=================================================================
  // 시작 => 반복문____파일_업로드_개수__만큼
  FOR ( $i=0; $i<$upload_count; $i++ )
  {

    //===============================================================
    // 시작 => 업로드_파일__이름__있으면
    IF ( $_FILES['bf_file']['name'][$i] && is_uploaded_file($_FILES['bf_file']['tmp_name'][$i]) )
    {

        //===========================================================
        // 파일_개수__증가
        $file_count++;

    }
    // 끝 => 업로드_파일__이름__있으면
    //===============================================================

  }
  // 끝 => 반복문____파일_업로드_개수__만큼
  //=================================================================


  //=================================================================
  // 시작 => 수정__과__새글쓰기__답변하기__구분
  IF ( $w == 'u' )
  {

    #################################################################
    # 시작 => 수정

    //===============================================================
    // 파일_정보__불러오기
    $file = get_file($piree['cafe_board_code'], $wr_id);


    //===============================================================
    // 시작 => 게시판_설정__파일_업로드_개수_보다_많으면
    IF ( $file_count && (int)$file['count'] > $board_cate_list_a[$board_cate_n]['bca_upload_count'] )
    {
        alert('기존 파일을 삭제하신 후 첨부파일을 '.number_format($board_cate_list_a[$board_cate_n]['bca_upload_count']).'개 이하로 업로드 해주십시오.');
    }
    // 끝 => 게시판_설정__파일_업로드_개수_보다_많으면
    //===============================================================


  }
  ELSE
  {

    #################################################################
    # 시작 => 새글쓰기__또는__답변하기

    //===============================================================
    // 시작 => 게시판_설정__파일_업로드_개수_보다_많으면
    IF ( $file_count > $board_cate_list_a[$board_cate_n]['bca_upload_count'] )
    {
        alert('첨부파일을 '.number_format($board_cate_list_a[$board_cate_n]['bca_upload_count']).'개 이하로 업로드 해주십시오.');
    }
    // 끝 => 게시판_설정__파일_업로드_개수_보다_많으면
    //===============================================================

  }
  // 끝 => 수정__과__새글쓰기__답변하기__구분
  //=================================================================


  //=================================================================
  // 디렉토리__생성합
  // 퍼미션__변경
  @mkdir(G5_DATA_PATH .'/file/'. $piree['cafe_board_code'], G5_DIR_PERMISSION);
  @chmod(G5_DATA_PATH .'/file/'. $piree['cafe_board_code'], G5_DIR_PERMISSION);


  //=================================================================
  // 임시__글자_배열
  $chars_array = array_merge(range(0,9), range('a','z'), range('A','Z'));


  //=================================================================
  // 가변_파일__업로드
  $file_upload_msg = '';


  //=================================================================
  // 파일_업로드__배열
  $upload = array();


  //=================================================================
  // 시작 => 업로드_하는__파일__있으면
  IF (isset($_FILES['bf_file']['name']) && is_array($_FILES['bf_file']['name']) )
  {

    //===============================================================
    // 시작 => 반복문____업로드_하는_파일_수__만큼
    FOR ( $loop_n=0; $loop_n<count($_FILES['bf_file']['name']); $loop_n++ )
    {

        //===========================================================
        // 업로드_된__파일__정보
        $upload[$loop_n]['file']     = '';
        $upload[$loop_n]['source']   = '';
        $upload[$loop_n]['filesize'] = 0;
        $upload[$loop_n]['image']    = array();
        $upload[$loop_n]['image'][0] = 0;
        $upload[$loop_n]['image'][1] = 0;
        $upload[$loop_n]['image'][2] = 0;
        $upload[$loop_n]['fileurl'] = '';
        $upload[$loop_n]['thumburl'] = '';
        $upload[$loop_n]['storage'] = '';


        //===========================================================
        // 시작 => 삭제에__체크가_되어있다면__파일을__삭제합니다
        IF ( isset($_POST['bf_file_del'][$loop_n]) && $_POST['bf_file_del'][$loop_n] )
        {

            //=======================================================
            // 파일_삭제_확인__배열에__TREU__추가
            $upload[$loop_n]['del_check'] = true;


            //=======================================================
            // 파일_ROW__가져오기
            $sql_select  = "SELECT * FROM `". $g5['board_file_table'] ."` ";
            $sql_select .= "WHERE `bca_table` = '". $piree['cafe_board_code'] ."' AND `wr_id` = '". $wr_id ."' AND `bf_no` = '". $loop_n ."'";
            $row = sql_fetch($sql_select);


            //=======================================================
            // HOOK__내용_변경__적용
            $delete_file = run_replace('delete_file_path', G5_DATA_PATH .'/file/'. $piree['cafe_board_code'] .'/'. str_replace('../', '', $row['bf_file']), $row);


            //=======================================================
            // 시작 => 기존__파일이_있으면__삭제
            IF ( file_exists($delete_file) )
            {
                @unlink($delete_file);
            }
            // 끝 => 기존__파일이_있으면__삭제
            //=======================================================


            //=======================================================
            // 시작 => 썸네일__삭제
            IF ( preg_match("/\.({$config['cf_image_extension']})$/i", $row['bf_file']) )
            {
                delete_board_thumbnail($piree['cafe_board_code'], $row['bf_file']);
            }
            // 끝 => 썸네일__삭제
            //=======================================================

        }
        ELSE
        {

            //=======================================================
            // 파일_삭제_확인__배열에__FALSE__추가
            $upload[$loop_n]['del_check'] = false;

        }
        // 끝 => 삭제에__체크가_되어있다면__파일을__삭제합니다
        //===========================================================


        //===========================================================
        // 첨부_저장할__파일__정보
        $tmp_file  = $_FILES['bf_file']['tmp_name'][$loop_n];
        $filesize  = $_FILES['bf_file']['size'][$loop_n];
        $filename  = $_FILES['bf_file']['name'][$loop_n];
        $filename  = get_safe_filename($filename);


        //===========================================================
        // 시작 => 서버에__설정된_값보다__큰파일을__업로드_한다면
        IF ( $filename )
        {

            //=======================================================
            // 시작 => 파일_업로드__에러__구분
            IF ( $_FILES['bf_file']['error'][$loop_n] == 1 )
            {
                $file_upload_msg .= '\"'. $filename.'\" 파일의 용량이 서버에 설정('. $upload_max_filesize.')된 값보다 크므로 업로드 할 수 없습니다.\\n';
                continue;
            }
            ELSE IF ( $_FILES['bf_file']['error'][$loop_n] != 0 )
            {
                $file_upload_msg .= '\"'. $filename.'\" 파일이 정상적으로 업로드 되지 않았습니다.\\n';
                continue;
            }
            // 끝 => 파일_업로드__에러__구분
            //=======================================================

        }
        // 시작 => 서버에__설정된_값보다__큰파일을__업로드_한다면
        //===========================================================


        //===========================================================
        // 시작 => 서버에__설정된_값보다__큰파일을__업로드_한다면
        IF ( is_uploaded_file($tmp_file) )
        {

            //=======================================================
            // 시작 => 관리자가_아니면서__설정한_업로드_사이즈보다__크다면__건너뜀
            IF ( !piree_cafe_auth_get() && $filesize > $board_cate_list_a[$board_cate_n]['bca_upload_size'] )
            {
                $file_upload_msg .= '\"'. $filename.'\" 파일의 용량('.number_format($filesize).' 바이트)이 게시판에 설정('.number_format($board_cate_list_a[$board_cate_n]['bca_upload_size']).' 바이트)된 값보다 크므로 업로드 하지 않습니다.\\n';
                continue;
            }
            // 끝 => 관리자가_아니면서__설정한_업로드_사이즈보다__크다면__건너뜀
            //=======================================================


            //=======================================================
            // 090714
            // 이미지나 플래시 파일에 악성코드를 심어 업로드 하는 경우를 방지
            // 에러메세지는 출력하지 않는다.
            //-------------------------------------------------------


            //=======================================================
            // 이미지_사이즈__가져오기
            $timg = @getimagesize($tmp_file);


            //=======================================================
            // 시작 => 파일_확장자__이미지__이면
            IF ( preg_match("/\.({$config['cf_image_extension']})$/i", $filename) ||preg_match("/\.({$config['cf_flash_extension']})$/i", $filename)  )
            {

                //===================================================
                // 시작 => 
                IF ( $timg['2'] < 1 || $timg['2'] > 18 )
                {
                    continue;
                }
                // 끝 => 
                //===================================================

            }
            // 끝 => 파일_확장자__이미지__이면
            //=======================================================


            //=======================================================
            // 업로드_된__파일__정보
            $upload[$loop_n]['image'] = $timg;


            //=======================================================
            // 시작 => 수정__이면
            // 4.00.11 - 글답변에서 파일 업로드시 원글의 파일이 삭제되는 오류를 수정
            IF ( $w == 'u' )
            {

                //===================================================
                // 존재하는__파일이_있다면__삭제합니다
                $sql_select  = "SELECT * FROM `". $g5['board_file_table'] ."` ";
                $sql_select .= "WHERE `bca_table` = '". $piree['cafe_board_code'] ."' AND `wr_id` = '". $wr_id ."' AND `bf_no` = '". $i ."'";
                $row = sql_fetch($sql_select);


                //===================================================
                // 시작 => 기존에_저장된__첨부_파일__있으면
                IF ( isset($row['bf_file']) && $row['bf_file'] )
                {

                    //===============================================
                    // 삭제할_파일
                    $delete_file = run_replace('delete_file_path', G5_DATA_PATH.'/file/'. $piree['cafe_board_code'] .'/'.str_replace('../', '', $row['bf_file']), $row);


                    //===============================================
                    // 시작 => 첨부_파일__삭제
                    IF ( file_exists($delete_file) )
                    {
                        @unlink(G5_DATA_PATH.'/file/'. $piree['cafe_board_code'] .'/'. $row['bf_file']);
                    }
                    // 끝 => 첨부_파일__삭제
                    //===============================================


                    //===============================================
                    // 시작 => 이미지_파일이면__썸네일_삭제
                    IF (preg_match("/\.({$config['cf_image_extension']})$/i", $row['bf_file']) )
                    {
                        delete_board_thumbnail($piree['cafe_board_code'], $row['bf_file']);
                    }
                    // 끝 => 이미지_파일이면__썸네일_삭제
                    //===============================================

                }
                // 끝 => 기존에_저장된__첨부_파일__있으면
                //===================================================

            }
            // 끝 => 수정__이면
            //=======================================================


            //=======================================================
            // 업로드_파일__원래_파일명
            $upload[$loop_n]['source'] = $filename;
            $upload[$loop_n]['filesize'] = $filesize;


            //=======================================================
            // 아래의_문자열이__들어간_파일은__-x_를_붙여서__웹경로를_알더라도__실행을__하지_못하도록_함
            $filename = preg_replace("/\.(php|pht|phtm|htm|cgi|pl|exe|jsp|asp|inc|phar)/i", "$0-x", $filename);


            //=======================================================
            // 배열__섞기
            shuffle($chars_array);


            //=======================================================
            // 배열__문자열_화
            $shuffle = implode('', $chars_array);


            //=======================================================
            // 첨부파일_첨부시__첨부파일명에__공백이_포함되어_있으면__일부_PC에서__보이지_않거나__다운로드_되지_않는__현상이_있습니다._(길상여의_님_090925)
            $upload[$loop_n]['file'] = md5(sha1($_SERVER['REMOTE_ADDR'])).'_'.substr($shuffle,0,8).'_'.replace_filename($filename);


            //=======================================================
            // 첨부파일__경로
            $dest_file = G5_DATA_PATH.'/file/'. $piree['cafe_board_code'] .'/'. $upload[$loop_n]['file'];


            //=======================================================
            // 업로드가_안된다면__에러메세지_출력하고__죽어버립니다.
            $error_code = move_uploaded_file($tmp_file, $dest_file) or die($_FILES['bf_file']['error'][$loop_n]);


            //=======================================================
            // 올라간_파일의__퍼미션을__변경합니다.
            chmod($dest_file, G5_FILE_PERMISSION);

            $dest_file = run_replace('write_update_upload_file', $dest_file, $board, $wr_id, $w);
            $upload[$loop_n] = run_replace('write_update_upload_array', $upload[$loop_n], $dest_file, $board, $wr_id, $w);

        }
        // 끝 => 서버에__설정된_값보다__큰파일을__업로드_한다면
        //===========================================================

    }
    // 끝 => 반복문____업로드_하는_파일_수__만큼
    //===============================================================

  }
  // 끝 => 업로드_하는__파일__있으면
  //=================================================================


  //=================================================================
  // 시작 => 반복문____업로드된__파일__수_만큼
  // 나중에 테이블에 저장하는 이유는 $wr_id 값을 저장해야 하기 때문입니다.
  FOR ( $loop_n=0; $loop_n<count($upload); $loop_n++ )
  {

    //===============================================================
    // 업로드_파일_정보
    $upload[$loop_n]['source'] = sql_real_escape_string($upload[$loop_n]['source']);
    $bf_content[$loop_n]       = isset($bf_content[$loop_n])         ? sql_real_escape_string($bf_content[$loop_n]) : '';
    $bf_width                  = isset($upload[$loop_n]['image'][0]) ? (int) $upload[$loop_n]['image'][0]           : 0;
    $bf_height                 = isset($upload[$loop_n]['image'][1]) ? (int) $upload[$loop_n]['image'][1]           : 0;
    $bf_type                   = isset($upload[$loop_n]['image'][2]) ? (int) $upload[$loop_n]['image'][2]           : 0;


    //===============================================================
    // 시작 => 업로드_파일_정보__있으면
    IF ( $upload[$loop_n]['source'] )
    {

        //===========================================================
        // 업로드_파일__ROW_유무__알아내기
        $sql_select  = "SELECT COUNT(*) FROM `". $g5['board_file_table'] ."` ";
        $sql_select .= "WHERE `bca_table` = '". $piree['cafe_board_code'] ."' and wr_id = '". $wr_id ."' and bf_no = '". $loop_n ."'";
        $exist_t = sql_efv($sql_select);


        //===========================================================
        // 시작 => 업로드_파일__ROW__유무
        IF ( $exist_t > 0 )
        {

            #########################################################
            # 시작 => 업로드_파일__ROW__있으면
            #########################################################

            //=======================================================
            // 시작 => 삭제에__체크가_있거나__파일이_있다면__업데이트를__합니다.
            // 그렇지_않다면__내용만__업데이트_합니다.
            IF ( $upload[$loop_n]['del_check'] || $upload[$loop_n]['file'])
            {

                //===================================================
                // ROW__수정하는__쿼리문
                $sql_update  = "UPDATE `". $g5['board_file_table'] ."` SET ";
                $sql_update .= "`bf_source`          = '". $upload[$loop_n]['source'] ."', ";
                $sql_update .= "`bf_file`            = '". $upload[$loop_n]['file'] ."', ";
                $sql_update .= "`bf_content`         = '". $bf_content[$loop_n] ."', ";
                $sql_update .= "`bf_fileurl`         = '". $upload[$loop_n]['fileurl'] ."', ";
                $sql_update .= "`bf_thumburl`        = '". $upload[$loop_n]['thumburl'] ."', ";
                $sql_update .= "`bf_storage`         = '". $upload[$loop_n]['storage'] ."', ";
                $sql_update .= "`bf_filesize`        = '". (int)$upload[$loop_n]['filesize'] ."', ";
                $sql_update .= "`bf_width`           = '". $bf_width ."', ";
                $sql_update .= "`bf_height`          = '". $bf_height ."', ";
                $sql_update .= "`bf_type`            = '". $bf_type ."', ";
                $sql_update .= "`bf_datetime`        = '". G5_TIME_YMDHIS ."', ";
                $sql_update .= "`bf_pi_piree_cafe_n` = '". $piree_cafe_n ."', ";
                $sql_update .= "`bf_pi_board_cate_n` = '". $board_cate_n ."', ";
                $sql_update .= "`bf_pi_piree_cafe_s` = '". addslashes($piree_cafe_name_s) ."', ";
                $sql_update .= "`bf_pi_board_cate_s` = '". addslashes($board_cate_list_a[$board_cate_n]['board_cate_path_s']) ."' ";
                $sql_update .= "WHERE bca_table` = '". $piree['cafe_board_code'] ."' AND wr_id` = '". $wr_id ."' AND bf_no` = '". $loop_n ."'";


                //===================================================
                // 쿼리_실행
                sql_query($sql_update);

            }
            ELSE
            {

                //===================================================
                // ROW__수정하는__쿼리문
                $sql_update  = "UPDATE `". $g5['board_file_table'] ."` SET ";
                $sql_update .= "`bf_content` = '". $bf_content[$loop_n] ."' ";
                $sql_update .= "WHERE `bca_table` = '". $piree['cafe_board_code'] ."' AND `wr_id` = '". $wr_id ."' AND `bf_no` = '". $loop_n ."'";


                //===================================================
                // 쿼리_실행
                sql_query($sql_update);

            }
            // 끝 => 삭제에__체크가_있거나__파일이_있다면__업데이트를__합니다.
            //=======================================================

            #########################################################
            # 끝 => 업로드_파일__ROW__있으면
            #########################################################

        }
        ELSE
        {


            #########################################################
            # 시작 => 업로드_파일__ROW__없으면
            #########################################################

            //=======================================================
            // 입력하는__쿼리문
            $sql_insert  = "INSERT INTO `". $g5['board_file_table'] ."` SET ";
            $sql_insert .= "`bo_table`           = '". $piree['cafe_board_code'] ."', ";
            $sql_insert .= "`wr_id`              = '". $wr_id ."', ";
            $sql_insert .= "`bf_no`              = '". $loop_n ."', ";
            $sql_insert .= "`bf_source`          = '". $upload[$loop_n]['source'] ."', ";
            $sql_insert .= "`bf_file`            = '". $upload[$loop_n]['file'] ."', ";
            $sql_insert .= "`bf_content`         = '". $bf_content[$loop_n] ."', ";
            $sql_insert .= "`bf_fileurl`         = '". $upload[$loop_n]['fileurl'] ."', ";
            $sql_insert .= "`bf_thumburl`        = '". $upload[$loop_n]['thumburl'] ."', ";
            $sql_insert .= "`bf_storage`         = '". $upload[$loop_n]['storage'] ."', ";
            $sql_insert .= "`bf_download`        = '0', ";
            $sql_insert .= "`bf_filesize`        = '". (int)$upload[$loop_n]['filesize'] ."', ";
            $sql_insert .= "`bf_width`           = '". $bf_width ."', ";
            $sql_insert .= "`bf_height`          = '". $bf_height ."', ";
            $sql_insert .= "`bf_type`            = '". $bf_type ."', ";
            $sql_insert .= "`bf_datetime`        = '". G5_TIME_YMDHIS ."', ";
            $sql_insert .= "`bf_pi_piree_cafe_n` = '". $piree_cafe_n ."', ";
            $sql_insert .= "`bf_pi_board_cate_n` = '". $board_cate_n ."', ";
            $sql_insert .= "`bf_pi_piree_cafe_s` = '". addslashes($piree_cafe_name_s) ."', ";
            $sql_insert .= "`bf_pi_board_cate_s` = '". addslashes($board_cate_list_a[$board_cate_n]['board_cate_path_s']) ."'";
            sql_query($sql_insert);


            //=======================================================
            // HOOK
            run_event('write_update_file_insert', $piree['cafe_board_code'], $wr_id, $upload[$loop_n], $w);

            #########################################################
            # 끝 => 업로드_파일__ROW__없으면
            #########################################################

        }
        // 끝 => 업로드_파일__ROW__유무
        //===========================================================

    }
    // 끝 => 업로드_파일_정보__있으면
    //===============================================================

  }
  // 끝 => 반복문____업로드된__파일__수_만큼
  //=================================================================


  //=================================================================
  // 업로드된 파일 내용에서 가장 큰 번호를 얻어 거꾸로 확인해 가면서
  // 파일 정보가 없다면 테이블의 내용을 삭제합니다.
  $sql_select  = "SELECT MAX`(bf_no`) AS `max_bf_no` FROM `". $g5['board_file_table'] ."` ";
  $sql_select .= "WHERE `bca_table` = '". $piree['cafe_board_code'] ."' AND `wr_id` = '". $wr_id ."'";
  $row = sql_fetch($sql_select);


  //=================================================================
  // 시작 => 반복문____첨부_파일_수__만큼
  FOR ( $loop_n=(int)$row['max_bf_no']; $loop_n>=0; $loop_n-- )
  {

    //===============================================================
    // 첨부파일__파일__가져오기
    $sql_select  = "SELECT `bf_file` FROM `". $g5['board_file_table'] ."` ";
    $sql_select .= "WHERE `bca_table` = '". $piree['cafe_board_code'] ."' AND `wr_id` = '". $wr_id ."' AND `bf_no` = '". $loop_n ."'";
    $row2 = sql_fetch($sql_select);


    //===============================================================
    // 시작 => 정보가_있다면__빠집니다
    IF ( isset($row2['bf_file']) && $row2['bf_file'] )
    {
      break;
    }
    // 끝 => 정보가_있다면__빠집니다
    //===============================================================


    //===============================================================
    // 그렇지_않다면_정보를__삭제_합니다.
    $sql_delete  = "DELETE FROM `". $g5['board_file_table'] ."` ";
    $sql_delete .= "WHERE `bca_table` = '". $piree['cafe_board_code'] ."' AND `wr_id` = '". $wr_id ."' AND `bf_no` = '". $loop_n ."'";
    sql_query($sql_delete);

  }
  // 끝 => 반복문____첨부_파일_수__만큼
  //=================================================================


  //=================================================================
  // 파일의_개수를__파악한다.
  $sql_select  = "SELECT COUNT(*) FROM `". $g5['board_file_table'] ."` ";
  $sql_select .= "WHERE `bo_table` = '". $piree['cafe_board_code'] ."' AND `wr_id` = '". $wr_id ."'";
  $file_t = sql_efv($sql_select);


  //=================================================================
  // 파일의_개수를__게시물에__업데이트_한다.
  $sql_update  = "UPDATE `". $piree['cafe_article'] ."` SET ";
  $sql_update .= "`wr_file` = '". $file_t ."' ";
  $sql_update .= "WHERE `wr_id` = '". $wr_id ."'";
  sql_query($sql_update);

  ###################################################################
  # 끝 => 파일__업로드
  ###################################################################



  ###################################################################
  # 시작 => 마지막__처리
  ###################################################################

  //=================================================================
  // 자동_저장된__레코드를__삭제한다.
  $sql_delete  = "DELETE FROM `". $g5['autosave_table'] ."` ";
  $sql_delete .= "WHERE `as_uid` = '". $uid ."'";
  sql_query($sql_delete);


  //=================================================================
  // 시작 => 비밀글__이면
  // 비밀글이라면_세션에_비밀글의__아이디를_저장한다
  // 자신의_글은__다시_비밀번호를__묻지_않기_위함
  IF ( $secret )
  {
    set_session("ss_secret_". $piree['cafe_board_code'] ."_". $wr_num, TRUE);
  }
  // 끝 => 비밀글__이면
  //=================================================================


  //=================================================================
  // 사용자 코드 실행
  @include_once($board_cate_list_a[$board_cate_n]['board_skin_p'] .'/write_update.skin.php' );
  @include_once($board_cate_list_a[$board_cate_n]['board_skin_p'] .'/write_update.tail.skin.php' );


  //=================================================================
  // 캐시_삭제
  delete_cache_latest($piree['cafe_board_code']);

  ###################################################################
  # 끝 => 마지막__처리
  ###################################################################



  ###################################################################
  # 시작 => 게시글_수__새로고침
  ###################################################################

  //=================================================================
  // 카페__게시판_분류별로__게시글_수__새로고침
  cafe_article_count_reload($piree_cafe_n, $member['mb_id'], $board_cate_n_a, 'plus', $count_write);

  ###################################################################
  # 끝 => 삭제__처리하기
  ###################################################################



  ###################################################################
  # 시작 => 페이지__이동
  ###################################################################

  //=================================================================
  // 이동할__페이지
  // $redirect_url = run_replace('write_update_move_url', short_url_clean(G5_HTTP_BBS_URL.'/piree.cafe.board.php?bca_table='. $piree['cafe_board_code'].'&amp;wr_id='. $wr_id.$qstr), $board, $wr_id, $w, $qstr, $file_upload_msg);
  // $redirect_url = piree__url($piree_prog_a[770100]['num'], 'piree.cafe.board.php') .'?piree_cafe_n='. $piree_cafe_n .'&board_cate_n='. $board_cate_n .'&bo_table='. $piree['cafe_board_code'] .'&amp;wr_id='. $wr_id.$qstr;
  $redirect_url = go_piree_cafe_board('', $piree_cafe_n, $board_cate_n, $write['wr_parent'], $wr_id) .'&bo_table='. $piree['cafe_board_code'] .'&amp;'. $qstr;


  //=================================================================
  // HOOK__실행
  run_event('write_update_after', $board, $wr_id, $w, $qstr, $redirect_url);


  //=================================================================
  // 시작 => 파일_업로드__메시지__유무
  IF ( $file_upload_msg )
  {
    alert($file_upload_msg, $redirect_url);
  }
  ELSE
  {
    goto_url($redirect_url);
  }
  // 끝 => 파일_업로드__메시지__유무
  //=================================================================

  ###################################################################
  # 끝 => 페이지__이동
  ###################################################################

?>