<?php
include_once('./_common.php');
//240910



if(!sql_query(" DESC sz_chat_messages ", false)) {
    sql_query(" CREATE TABLE `sz_chat_messages` (
                  `cm_id` int(11) NOT NULL AUTO_INCREMENT,
                  `mb_id` varchar(20) NOT NULL DEFAULT '',
                  `cm_message` varchar(255) NOT NULL DEFAULT '',
                  `cm_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
                  PRIMARY KEY (`cm_id`)
                ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ", false);
}



?>
<!DOCTYPE html>
<html lang="ko">

<head>
    <meta charset="UTF-8">
    <title>채팅방</title>
    <style>
        * {
            -webkit-box-sizing: border-box;
            -moz-box-sizing: border-box;
            box-sizing: border-box;
        }

        html,
        body {
            background: #fff;
            height: 100%;
            overflow: hidden;
        }

        body {
            margin: 0;
            padding: 0;
            font-weight: 400;
            font-size: 1rem;
            line-height: 1.58;
            color: #333;
            height: 100%;
        }

        #chat-box {
            padding: 10px;
            height: 90vh;
            overflow-y: scroll;
        }

        .clearfix:after {
            display: block;
            content: "";
            clear: both;
        }

        .form-control {
            width: 100%;
            min-height: 38px;
            font-size: 15px;
            border: 1px solid #c8c8c8;
        }

        input {
            outline: none;
            width: 100%;
            height: 32px;
            font-size: 15px;
            border: 0;
            border-radius: 0px;
            padding-left: 10px;
            height: 10vh;
        }

        .date {
            color: #696969;
            font-size: 11px;
            letter-spacing: -0.04em;
        }

    </style>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>

<body>

    <div id="chat-box"></div>
    <div class="input-group clearfix">
        <input type="text" name="message" id="chat-input" placeholder="<?php echo $is_guest?"채팅 회원만 가능합니다.":"메시지를 입력하세요."; ?>" autocomplete="off" class="form-control" />
    </div>


    <script>
        $(document).ready(function() {

            function loadMessages() {
                $.ajax({
                    url: 'get_messages.php',
                    method: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        var chatBox = $('#chat-box');
                        chatBox.empty();
                        $.each(data, function(index, message) {
                            chatBox.append('<div><strong>' + message.nick + '</strong>&nbsp;:&nbsp;&nbsp;' + message.message + '&nbsp;&nbsp;' + message.datetime + '</div>');
                        });
                        chatBox.scrollTop(chatBox[0].scrollHeight);
                    }
                });
            }

            function sendMessage() {
                <?php if ($member['mb_id']){ ?>
                var message = $('#chat-input').val();
                if (message.trim() === '') return;

                $.ajax({
                    url: 'save_message.php',
                    method: 'POST',
                    data: {
                        message: message
                    },
                    success: function(response) {
                        if (response == "success") {
                            $('#chat-input').val('');
                            loadMessages();
                        } else {
                            alert('메시지를 보낼 수 없습니다.');
                        }
                    }
                });
                <?php }else{ ?>
                alert("로그인 하십시오.");
                $('#chat-input').val('');
                <?php } ?>
            }

            $('#chat-input').keypress(function(e) {
                if (e.which == 13 && !e.shiftKey) {
                    e.preventDefault();
                    sendMessage();
                }
            });

            $('#send-btn').on('click', function() {
                sendMessage();
            });

            setInterval(loadMessages, 1000);
        });

    </script>

</body>

</html>
