<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// return;

// php 버전이 7.2 보다 낮으면 사용할수 없습니다.
if (version_compare(PHP_VERSION, '8.1', '<')) {
    return;
}

/* css js 압축 작동이 안되게 하려면 위의 return 코드의 주석을 풀면 압축이 안됩니다. */
/* 또는 config.php 파일에서 상수 G5_USE_CACHE 의 값을 false 또는 0 으로 수정하면 압축이 안됩니다.  */

if (! (defined('G5_USE_CACHE') && G5_USE_CACHE)) return;

include_once G5_PLUGIN_PATH . '/vokuhtmlmin/vendor/autoload.php'; // Composer로 설치한 경우

use voku\helper\HtmlMin;

class G5VokuHtmlMin
{
    public static function getInstance()
    {
        static $instance = null;
        if (null === $instance) {
            $instance = new self();
        }

        return $instance;
    }

    public static function singletonMethod()
    {
        return self::getInstance();
    }

    public function __construct()
    {
        $this->add_hooks();
    }

    public function add_hooks()
    {
        add_replace('html_process_buffer', array($this, 'buffer'), 10, 1);
    }

    public function buffer($buffer)
    {

        $htmlMin = new HtmlMin();

        //$htmlMin->doRemoveComments()->doOptimizeAttributes(); // 옵션 설정

        $htmlMin->doRemoveComments(true)
            ->doOptimizeAttributes(true)
            ->doRemoveWhitespaceAroundTags(true);

        $htmlMinibuffer = $htmlMin->minify($buffer);

        return $htmlMinibuffer;
    }
}

$GLOBALS['g5_voku_htmlmin'] = G5VokuHtmlMin::getInstance();
