<?php
include_once('./_common.php');

class Exam {
    private $questions = [];
    private $answers = [];

    public function addQuestion($question, $options, $correctAnswer) {
        $this->questions[] = [
            'question' => $question,
            'options' => $options,
            'correctAnswer' => $correctAnswer
        ];
    }

    public function getQuestions() {
        return $this->questions;
    }

    public function checkAnswers($userAnswers) {
        $score = 0;
        foreach ($this->questions as $index => $question) {
            if ($userAnswers[$index] == $question['correctAnswer']) {
                $score++;
            }
        }
        return $score;
    }
}

$exam = new Exam();

// 문제 시작
$exam->addQuestion("최고의 웹저작도구는 무엇인가요?", ["1. 그누보드", "2. 워드프레스", "3. 제로보드"], 1);
$exam->addQuestion("영카트를 만든 회사는?", ["1. 구글", "2. 네이버", "3. 에스아이알소프트"], 3);
$exam->addQuestion("AI는 무엇의 약자인가요?", ["1. Amazon India", "2. alphabet Icon", "3. Artificial Intelligence"], 3);
// 문제 끝

include_once(G5_PATH.'/head.php');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $userAnswers = $_POST['answers'];
    $score = $exam->checkAnswers($userAnswers);
    echo "당신의 점수는: " . $score . " / " . count($exam->getQuestions());
} else {
    $questions = $exam->getQuestions();
    echo '<form method="POST">';
    foreach ($questions as $index => $question) {
        echo '<h3 style="margin:10px 0;">' . $question['question'] . '</h3>';
        foreach ($question['options'] as $optionIndex => $option) {
            echo '<input type="radio" name="answers[' . $index . ']" value="' . ($optionIndex + 1) . '">&nbsp;' . $option . '<br>';
        }
    }
    echo '<br><input type="submit" class="btn btn_submit" value="제출">';
    echo '</form>';
}

include_once(G5_PATH.'/tail.php');