<?php
include_once("./_common.php");

$g5['title'] = '사다리 게임';
include_once("./_head.php");
?>

<link rel="stylesheet" href="app.css">
  <form method="post" id="app-intro" class="container app-page __active">
    <h1>사다리게임</h1>
    <p class="sadari-info">
      모든 데이터는 <span class="highlight">,</span> 로 구분할 수 있습니다.<br>
      게임참여자와 게임상품은 수량이 일치해야 합니다.<br>
      게임참여자가 3명이라면 게임상품도 반드시 3개만 입력하세요.
    </p>
    <div class="form-group">
      <label for="start-data" class="form-label">게임참여자</label>
      <input class="form-input" placeholder="게임참여자를 입력해주세요" type="text" id="start-data" required>
      <p>예: 이순신, 강감찬, 김유정</p>
    </div>
    <div class="form-group">
      <label for="end-data" class="form-label">게임상품</label>
      <input class="form-input" placeholder="게임상품을 입력해주세요" type="text" id="end-data" required>
      <p>예: 500원, 꽝, 1만원</p>
    </div>

    <footer class="app-form-footer">
      <button type="submit" class="css-button-sliding-to-left--sky">확인</button>
    </footer>
  </form>

  <div id="app-result" class="app-page">
    <h2 class="mb-2">사다리게임(결과)</h2>
    <p class="sadari-info">
      사다리결과를 이미지로 만들어 컴퓨터에 저장할 수 있습니다.<br>
      저장된 이미지는 카톡 등을 이용하여 공유할 수 있습니다.<br>
      '결과이미지만들기'로 먼저 사다리결과를 이미지로 만들고 '결과다운로드'로 pc에 저장하세요.
    </p>
    <div class="sadari-result" id="sadari-result">
      <div id="sadari-start-data" class="result-row"></div>
      <div class="result-line-wrapper">
        <canvas id="sadari-line" class="result-line"></canvas>
      </div>
      <div id="sadari-end-data" class="result-row"></div>
    </div>

    <footer class="app-form-footer">
      <div class="btn-group">
        <input id="btn-Preview-Image" class="css-button-sliding-to-left--sky" type="button" value="결과이미지만들기"/>
        <a id="result-download" class="css-button-sliding-to-left--sky" href="#">결과다운로드</a>
        <button type="submit" id="app-reset" class="css-button-sliding-to-left--red">재시작</button>
      </div>
    </footer>
    <div id="previewImage">
    </div>
  </div>

<script src="js/Animation.class.js"></script>
<script src="js/colorGenerator.js"></script>
<script src="js/Canvas.class.js"></script>
<script src="js/Sadari.class.js"></script>
<script src="js/SadariView.class.js"></script>
<script src="js/SadariMaker.class.js"></script>
<script src="js/app.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/0.4.1/html2canvas.js"></script>
<script>
$(document).ready(function(){


var element = $("#sadari-result"); // global variable
var getCanvas; // global variable

    $("#btn-Preview-Image").on('click', function () {
         html2canvas(element, {
         onrendered: function (canvas) {
                $("#previewImage").append(canvas);
                getCanvas = canvas;
             }
         });
    });

	$("#result-download").on('click', function () {
    var imgageData = getCanvas.toDataURL("image/png");
    // Now browser starts downloading it instead of just showing it
    var newData = imgageData.replace(/^data:image\/png/, "data:application/octet-stream");
    $("#result-download").attr("download", "sadari_result.png").attr("href", newData);
	});

});

</script>
<?php include_once('./_tail.php');