!function (window, document) {
	"use strict";
	document.addEventListener('DOMContentLoaded', () => {

		const sadariView = new SadariView();
		const sadariCanvas = new SimpleCanvas(sadariView.getCanvas());
		let sadariApp, sadariMaker;

		const openApp = ({startData = [], endData = []}) => {
			try {
				sadariApp = new Sadari(startData, endData);
				window.sadariMaker = sadariMaker = new SadariMaker(sadariApp, sadariCanvas, sadariView);

				sadariView.resultPageOpen();
				sadariView.createStartData(sadariApp.getStartData());
				sadariView.createEndData(sadariApp.getEndData());
				sadariMaker.showAnimation();

			} catch (e) {
				alert(e.message);
			//	throw e;
			}
		};

		sadariView.getForm().addEventListener("submit", (event) => {
			event.preventDefault();
			const startData = sadariView.getInput("#start-data");
			const endData = sadariView.getInput("#end-data");
			openApp({
				startData: startData.value.split(","),
				endData: endData.value.split(",")
			});
		});

		const badgeColorMatch = (event) => {
			const target = event.target;
			if (target.classList.contains("result-data-value")) {
				if (target.infoData) {
					const startItems = sadariView.getStartData();
					const endItems = sadariView.getEndData();
					const startData = startItems[target.infoData.startIndex];
					const endData = endItems[target.infoData.endIndex];

					switch (event.type) {
						case "mouseover":
							startData.style.backgroundColor =
							endData.style.backgroundColor = String(sadariMaker.colorGenerator.get(target.infoData.startIndex));
							startData.classList.add("__hover");
							endData.classList.add("__hover");
							break;
						case "mouseout":
							startData.style.backgroundColor = endData.style.backgroundColor = "";
							startData.classList.remove("__hover");
							endData.classList.remove("__hover");
							break;
					}
				}
			}
		};

		sadariView.getResult().addEventListener("mouseover", badgeColorMatch);
		sadariView.getResult().addEventListener("mouseout", badgeColorMatch);

		sadariView.getAppResetBtn().addEventListener("click", (e) => {
			//sadariView.getForm().reset();
			e.preventDefault();
			sadariView.introPageOpen();
			sadariMaker.reset();
		});

	});
}(window, window.document);
