<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// 게시글 정보 가져오기
$post_content = strip_tags($view['wr_content']); // HTML 태그 제거
$post_title = $view['wr_subject'];
$post_author = $view['wr_name'];

// API에 전송할 프롬프트 구성
$prompt = "다음 게시글이 스팸인지 분석해주세요. 제목: {$post_title}, 작성자: {$post_author}, 내용: {$post_content}";
$prompt .= "\n\n스팸이면 '스팸', 정상글이면 '정상'이라고만 답변해주세요.";

// API 요청 데이터 준비
$data = array(
    'messages' => array(
        array(
            'role' => 'user',
            'content' => $prompt
        )
    ),
    'model' => 'llama-3.3-70b-versatile',
    'temperature' => 0.1 // 일관된 결과를 위해 낮은 temperature 설정
);

// API 설정
$url = 'https://api.groq.com/openai/v1/chat/completions';
$api_key = 'groq에서 발급받은 api키 삽입

// cURL 초기화 및 설정
$ch = curl_init();
curl_setopt_array($ch, array(
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($data),
    CURLOPT_HTTPHEADER => array(
        'Authorization: Bearer ' . $api_key,
        'Content-Type: application/json'
    )
));

// API 요청 실행
$response = curl_exec($ch);

// 응답 처리
if (!curl_errno($ch)) {
    $result = json_decode($response, true);
    
    // API 응답에서 판단 결과 추출
    if (isset($result['choices'][0]['message']['content'])) {
        $ai_response = strtolower(trim($result['choices'][0]['message']['content']));
        
        // 스팸으로 판단된 경우 경고 메시지 출력
        if ($ai_response === '스팸') {
            echo '<div class="alert alert-danger" style="padding: 15px; margin: 20px 0; border: 1px solid #d9534f; border-radius: 4px; color: #d9534f; background-color: #f2dede;">';
            echo '<strong>주의!</strong> 이 게시글은 스팸으로 의심됩니다.';
            echo '</div>';
            
        }
    }
}

// cURL 세션 종료
curl_close($ch);
?>