<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

function editor_html($id, $content, $is_dhtml_editor=true)
{
    global $g5, $config, $w, $board, $write;
    static $js = true;

    if( 
        $is_dhtml_editor && $content && 
        (
        (!$w && (isset($board['bo_insert_content']) && !empty($board['bo_insert_content'])))
        || ($w == 'u' && isset($write['wr_option']) && strpos($write['wr_option'], 'html') === false )
        )
    ){       //글쓰기 기본 내용 처리
        if( preg_match('/\r|\n/', $content) && $content === strip_tags($content, '<a><strong><b>') ) {  //textarea로 작성되고, html 내용이 없다면
            $content = nl2br($content);
        }
    }

    $editor_url = G5_EDITOR_URL.'/'.$config['cf_editor'];
    ft_nonce_create('jodit');
    $html = "";
    $randomtime = rand(0, 1000);
    if ($is_dhtml_editor && $js) {
    	$html = <<<eot
			<span class="sound_only">웹에디터 시작</span>
			<link rel="stylesheet" href="$editor_url/css/jodit.fat.min.css">
			<script src="$editor_url/js/jodit.fat.min.js"></script>
			<script src="$editor_url/js/ace.js"></script>
			<script src="$editor_url/js/theme-github.min.js"></script>
			<script src="$editor_url/js/mode-html.min.js"></script>
			<script src="$editor_url/js/beautify.min.js"></script>
			<script src="$editor_url/js/beautify-html.min.js"></script>
			<textarea id="$id" name="$id">$content</textarea>
			<script src="$editor_url/jodit.config.js?$randomtime"></script>
			<script>
			var joditGnuObj = {};
			joditGnuObj["$id"] = createJoditGnuEditor("$id");
			</script>
			<span class="sound_only">웹 에디터 끝</span>
		eot;
        $js = false;
    }
    return $html;
}


// textarea 로 값을 넘긴다. javascript 반드시 필요
function get_editor_js($id, $is_dhtml_editor=true)
{
	global $config;
	if ($is_dhtml_editor) {
		$editor_url = G5_EDITOR_URL.'/'.$config['cf_editor'];
		return <<<eot
		if(joditGnuObj["$id"].value){
			let isSuccess = false;
			$.ajax({
				url: "$editor_url/savebase64img.php",
				type: "POST",
				data: {
					"$id": joditGnuObj["$id"].value
				},
				dataType: "html",
				async: false,
				cache: false,
				success: function(data, textStatus) {
					document.querySelector("#$id").value = data.trim();
					console.log(document.querySelector("#$id").value);
					isSuccess = true;
				},
				error: function(a,b,c){
					alert("에러가 발생했습니다.");
				}
			});
			if(!isSuccess){
				alert(55);
				return false;
			}
		}
		
		
		eot;
	} else {
		return "var {$id}_editor = document.getElementById('{$id}');\n";
	}
}


//  textarea 의 값이 비어 있는지 검사
function chk_editor_js($id, $is_dhtml_editor=true)
{
    if ($is_dhtml_editor) {
    	return <<<eot
		const jodittaval = document.querySelector("#$id").value;
		if(!jodittaval
			|| ['&nbsp;','<p>&nbsp;</p>','<p><br></p>','<p></p>','<br>'].indexOf(jodittaval) !== -1){
			alert("내용을 입력해 주십시오.");
			joditGnuObj["$id"].focus();
			return false;
		}
		eot;
    } else {
        return "if (!{$id}_editor.value) { alert(\"내용을 입력해 주십시오.\"); {$id}_editor.focus(); return false; }\n";
    }
}

/*
https://github.com/timostamm/NonceUtil-PHP 난스(nonce)는 임의로 생성되는 암호화 토큰으로 재생 공격을 방지하는 데 사용됩니다.
*/

if (!defined('FT_NONCE_UNIQUE_KEY'))
    define( 'FT_NONCE_UNIQUE_KEY' , sha1($_SERVER['SERVER_SOFTWARE'].G5_MYSQL_USER.session_id().G5_TABLE_PREFIX) );

if (!defined('FT_NONCE_SESSION_KEY'))
    define( 'FT_NONCE_SESSION_KEY' , substr(md5(FT_NONCE_UNIQUE_KEY), 5) );

if (!defined('FT_NONCE_DURATION'))
    define( 'FT_NONCE_DURATION' , 60 * 60 ); // 300 makes link or form good for 5 minutes from time of generation,  300은 5분간 유효, 60 * 60 은 1시간

if (!defined('FT_NONCE_KEY'))
    define( 'FT_NONCE_KEY' , '_nonce' );

// This method creates a key / value pair for a url string
if(!function_exists('ft_nonce_create_query_string')){
    function ft_nonce_create_query_string( $action = '' , $user = '' ){
        return FT_NONCE_KEY."=".ft_nonce_create( $action , $user );
    }
}

if(!function_exists('ft_get_secret_key')){
    function ft_get_secret_key($secret){
        return md5(FT_NONCE_UNIQUE_KEY.$secret);
    }
}

// This method creates an nonce. It should be called by one of the previous two functions.
if(!function_exists('ft_nonce_create')){
    function ft_nonce_create( $action = '',$user='', $timeoutSeconds=FT_NONCE_DURATION ){
    	
    	$secret = ft_get_secret_key($action.$user);
    	$salt = ft_nonce_generate_hash();
    	$time = time();
    	$maxTime = $time + $timeoutSeconds;
    	$nonce = $salt . "|" . $maxTime . "|" . sha1( $salt . $secret . $maxTime );
    	
    	set_session('nonce_'.FT_NONCE_SESSION_KEY, $nonce);
    	error_log (__FILE__.' '.__LINE__.' ======================== '.$nonce);
    	return $nonce;
    	
    }
}

// This method validates an nonce
if(!function_exists('ft_nonce_is_valid')){
    function ft_nonce_is_valid( $nonce, $action = '', $user='' ){

        $secret = ft_get_secret_key($action.$user);
        error_log (__FILE__.' '.__LINE__.' '.$secret);

		if (is_string($nonce) == false) {
			return false;
		}
		$a = explode('|', $nonce);
		error_log (__FILE__.' '.__LINE__.' '.count($a));
		if (count($a) != 3) {
			return false;
		}
		$salt = $a[0];
		$maxTime = intval($a[1]);
		$hash = $a[2];
		$back = sha1( $salt . $secret . $maxTime );
		error_log(__FILE__.' '.__LINE__.' '.$hash);
		error_log(__FILE__.' '.__LINE__.' '.$back);
		if ($back != $hash) {
			return false;
		}
		error_log(__FILE__.' '.__LINE__.' '.time());
		error_log(__FILE__.' '.__LINE__.' '.$maxTime);
		if (time() > $maxTime) {
			return false;
		}
		return true;
    }
}

// This method generates the nonce timestamp
if(!function_exists('ft_nonce_generate_hash')){
    function ft_nonce_generate_hash(){
		$length = 10;
		$chars='1234567890qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM';
		$ll = strlen($chars)-1;
		$o = '';
		while (strlen($o) < $length) {
			$o .= $chars[ rand(0, $ll) ];
		}
		return $o;
    }
}
