function createJoditGnuEditor(joditTaId){
	// Initialize Jodit editor
	const joditeditor = new Jodit('#'+joditTaId, {
		language: 'ko',
		height: 300,
		toolbarAdaptive: false, // 툴바가 창 크기에 반응하지 않도록 설정
		toolbarSticky: false,
		showCharsCounter: false,
		showWordsCounter: false,
		showXPathInStatusbar: false,
		toolbarButtonSize: "small",//small,middle,large
		placeholder: '',
		removeButtons: [],
		colorPickerDefaultTab: 'color',//텍스트 컬러를 먼저 보이게 설정
		pastePlain: false,//붙혀넣기시 서식유지
		askBeforePasteHTML: false,//붙혀넣기시 '원본유지' 팝업표시제거
		//Jodit.defaultOptions.buttons
		buttons: [
			'font', 'fontsize', '|',
			'bold', 'strikethrough', 'underline', 'italic', '|',
			'ul', 'ol', 'outdent', 'indent', '|',
			'brush', 'paragraph', '|',
			'image', 'table', 'link', '|',
			'align', 'undo', 'redo', '|',
			'hr', 'eraser', 'fullsize', '|','source',
		],
		controls: {
			font: {
				list: {
					'Nanum Gothic,sans-serif': '나눔고딕'
				}
			},
			fontsize: {
				list: {
					'8pt': '8','9pt': '9','10pt': '10','11pt': '11','12pt': '12','13pt': '13','14pt': '14',
					'15pt': '15','16pt': '16','17pt': '17','18pt': '18','19pt': '19','20pt': '20',
					'25pt': '25','26pt': '26','27pt': '27',
					'36pt': '36'
				}
			}
		},
		events: {
			afterInit: function () {
				console.log("afterInit");
			},
			error: function (error) {
				console.error('Jodit Editor initialization error:', error);
			}
		},
		uploader: {
			insertImageAsBase64URI: true
		}
	});
	return joditeditor;
}

//blob to base64
function joditBlobToBase64(){
	document.querySelectorAll(".jodit-wysiwyg img").forEach(e=>{
		//console.log(e,e.src.startsWith("blob"));
		if(e.src.startsWith("blob")){
			objectUrlToBase64(e.src)
			.then(base64 => {
				e.src = base64;
			})
			.catch(error => {
				console.error('Error:', error);
			});
		}
	});
}
//th,td border add -  본인에 맞게 적절히 수정이 필요한 함수입니다.
function defaultTdStyle(node){
	if(!node.style.borderColor){
		node.style.borderColor = "#ccc";
	}
	node.style.borderWidth = '1px';
	node.style.borderStyle = 'solid';
	node.style.padding = '2px 5px';
}
function joditTableBorder(){
	document.querySelectorAll(".jodit-wysiwyg table th").forEach(node=>{
		defaultTdStyle(node);
	});
	document.querySelectorAll(".jodit-wysiwyg table td").forEach(node=>{
		defaultTdStyle(node);
	});
}
function objectUrlToBase64(objectUrl) {
	return new Promise((resolve, reject) => {
		// 1. objectUrl에서 Blob 객체 가져오기
		fetch(objectUrl)
		.then(response => response.blob())
		.then(blob => {
		// 2. Blob을 base64로 변환
		const reader = new FileReader();
		reader.onloadend = () => {
		  const base64String = reader.result;
		  resolve(base64String);
		};
		reader.onerror = reject;
		reader.readAsDataURL(blob);
	  }).catch(reject);
	});
}

var blobInterval = setInterval(function(){
	joditBlobToBase64();//주기적으로 blob을 base64로 변경해줍니다.
	joditTableBorder();//주기적으로 th,td에 border 를 추가합니다.
},400);