<?php
include_once('../../../common.php');
if (!function_exists('ft_nonce_is_valid')) {
	include_once('./editor.lib.php');
}
function isValidImage($imageData) {
	// 임시 파일 생성
	$tempFile = tempnam(sys_get_temp_dir(), 'image_');
	
	try {
		// 이미지 데이터를 임시 파일에 저장
		file_put_contents($tempFile, $imageData);
		
		// getimagesize()로 이미지 정보 확인
		$imageInfo = @getimagesize($tempFile);
		
		// 이미지 정보 검증
		if ($imageInfo === false) {
			return false;
		}
		
		// 추가 검증 (선택적)
		$width = $imageInfo[0];
		$height = $imageInfo[1];
		$mimeType = $imageInfo['mime'];
		
		// 최소/최대 크기 제한 예시 (옵션)
		if ($width < 10 || $height < 10 || $width > 10000 || $height > 10000) {
			return false;
		}
		
		// 허용된 MIME 타입 제한 (옵션)
		$allowedMimeTypes = [
			'image/jpeg',
			'image/png',
			'image/gif',
			'image/webp'
		];
		
		if (!in_array($mimeType, $allowedMimeTypes)) {
			return false;
		}
		
		return true;
	} catch (Exception $e) {
		// 예외 발생 시 false 반환
		return false;
	} finally {
		// 임시 파일 삭제
		if (file_exists($tempFile)) {
			unlink($tempFile);
		}
	}
}

function convertBase64ImageToFile($htmlContent) {
	// base64 이미지 태그 추출을 위한 정규식
	$pattern = '/<img\s+[^>]*src=["\'](data:image\/\w+;base64,[^"\']+)["\'][^>]*>/i';
	
	// 모든 base64 이미지 태그 찾기
	preg_match_all($pattern, $htmlContent, $matches);
	
	// 업로드 디렉토리 설정 (존재하지 않으면 생성)
	//$uploadDir = 'uploads/';
	$uploadDir = G5_DATA_PATH.'/'.G5_EDITOR_DIR.'/'.date('ym',G5_SERVER_TIME);
	if (!file_exists($uploadDir)) {
		//mkdir($uploadDir, 0777, true);
		mkdir($uploadDir, G5_DIR_PERMISSION, true);
		@chmod($uploadDir, G5_DIR_PERMISSION);
	}
	
	// 추출된 이미지 태그 순회
	foreach ($matches[0] as $index => $fullTag) {
		$base64Src = $matches[1][$index];
		
		// MIME 타입 및 데이터 추출
		preg_match('/^data:image\/(\w+);base64,/', $base64Src, $typeMatches);
		
		if (count($typeMatches) === 2) {
			$imageType = $typeMatches[1];
			
			// base64 데이터 추출 및 디코딩
			$base64Data = substr($base64Src, strpos($base64Src, ',') + 1);
			$imageData = base64_decode($base64Data);
			
			// 이미지 유효성 검사
			if (!isValidImage($imageData)) {
				// 유효하지 않은 이미지 로그 또는 오류 처리
				error_log("Invalid image detected: " . substr($base64Src, 0, 100) . '...');
				continue; // 다음 이미지로 넘어감
			}
			
			// 고유한 파일명 생성
			$fileName = uniqid('',true) . '.' . $imageType;
			$filefullpath = $uploadDir.'/'.$fileName;
			
			// 이미지 파일로 저장
			if (file_put_contents($filefullpath, $imageData)) {
				// 새 이미지 태그 생성 (src 변경)
				$newTag = str_replace(
					$base64Src,
					G5_DATA_URL.'/'.G5_EDITOR_DIR.'/'.date('ym',G5_SERVER_TIME).'/'.$fileName,
					$fullTag
					);
				
				// 원본 HTML에서 태그 대체
				$htmlContent = str_replace($fullTag, $newTag, $htmlContent);
			} else {
				// 파일 저장 실패 시 로그
				error_log("Failed to save image: " . $fileName);
			}
		}
	}
	
	return $htmlContent;
}

// 사용 예시
/* $htmlContent = '
<div>
    <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAA..." alt="sample1">
    <img src="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAg..." alt="sample2">
    <p>이미지 설명</p>
</div>'; */
//난스(nonce)는 임의로 생성되는 암호화 토큰으로 재생 공격을 방지하는 데 사용됩니다.
if (!ft_nonce_is_valid(get_session('nonce_' . FT_NONCE_SESSION_KEY), 'jodit')) {
	exit;
}
else{
	$processedHtml = convertBase64ImageToFile(stripslashes($_POST['wr_content']??''));
	echo $processedHtml;
}
