<?php
$mobileMode = preg_match("/phone|samsung|lgtel|mobile|[^A]skt|nokia|blackberry|android|sony/i", $_SERVER['HTTP_USER_AGENT']);
$bibleText = "./krv.txt";
$bibleImage = "./krv.jpg";
$bibleStyle = $mobileMode ? "select" : "list";
?>
<!DOCTYPE html>

<html lang="ko">

<head>

<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<meta name="theme-color" content="#eeeeee">
<meta http-equiv="imagetoolbar" content="no">
<meta property="og:image" content="./og_image.png">

<link rel="icon" href="./favicon.png">
<link rel="stylesheet" href="//cdn.jsdelivr.net/font-nanum/1.0/nanumbarungothic/nanumbarungothic.css">

<title>개역한글 성경전서</title>

<style>
#bibleDiv { max-width:1000px; margin:0 auto; }
#textBible, .bible-select, .title-td, .text-div, .list-table, .number-button, .list-td { font-size:16px; color:#000000; font-family:'Nanum Barun Gothic'; }
#textBible { padding:6px; background-color:#ffffff; margin-top:6px; border:1px solid #cccccc; }
#selectTable { width:100%; table-layout:fixed; background-color:#cccccc; margin-bottom:6px; }
#headGroup table, #footGroup table { width:100%; table-layout:fixed; } 
.bible-select { width:100%; height:45px; cursor:pointer; text-align-last:center; font-weight:bold; padding:0px 12px 0px 12px; background-color:#eeeeee; border:none; outline:none; -webkit-appearance:none; }
.bible-option { background-color:#eeeeee; }
.title-td { text-align:center; font-weight:bold; background-color:#eeeeee; padding:12px; }
.text-div { margin-top:6px; }
.list-table { width:100%; font-weight:bold; background-color:#eeeeee; padding:12px; border:1px solid #cccccc; }
.number-button { cursor:pointer; padding:6px 0px 6px 0px; text-align:center; background-color:#ffffff; margin-top:1px; border:1px solid #cccccc; box-sizing:border-box; }
.list-td { text-align:center; background-color:#ffffff; padding:8px; }
body::-webkit-scrollbar { width:10px; height:10px; }
body::-webkit-scrollbar-thumb { background-color:#aaaaaa; border-radius:10px; }
body::-webkit-scrollbar-track { background-color:#ffffff; }
</style>

<script>
const $_ONE = (one) => document.querySelector(one);
bibleXhr = new XMLHttpRequest();
bibleXhr.open("GET", "<?php echo $bibleText; ?>");
bibleXhr.onload = function() {
	bibleTotal = bibleXhr.responseText.split("\n");
	$_ONE("#bibleDiv").style.display = "block";
	function startMode() {
		$_ONE("#headGroup").style.display = $_ONE("#footGroup").style.display = "none";
		$_ONE("#headNext").style.display = $_ONE("#headPrev").style.display = $_ONE("#footNext").style.display = $_ONE("#footPrev").style.display = "none";
		if (bibleStyle === "list") $_ONE("#selectTable").style.display = "none";
		else $_ONE("#oldTd_1").style.display = $_ONE("#oldTd_2").style.display = $_ONE("#newTd_1").style.display = $_ONE("#newTd_2").style.display = "none"; 	
		if (arguments[0] === 0) {
			$_ONE("#titleBible").innerText = "성경전서";
			$_ONE("#textBible").style.padding = "6px";
			$_ONE("#textBible").innerHTML = "<img src='<?php echo $bibleImage; ?>' style='width:100%;display:block'>";
			for (bible66 = 1; bible66 <= 66; bible66++) $_ONE("#bible_" + bible66).style.backgroundColor = '#ffffff';
			$_ONE("#oldSelect").value = $_ONE("#newSelect").value = "성경선택";
			$_ONE("#oldSelect").style.backgroundColor = $_ONE("#newSelect").style.backgroundColor = "#eeeeee";
			scrollTo({top:0, behavior:"smooth"});
		}
		else if (arguments[0] === 67) $_ONE("#bible_" + <?php echo rand(1, 66); ?>).onclick();
		else $_ONE("#bible_" + arguments[0]).onclick();
	}
	startMode(startContent);
	$_ONE("#startTd").addEventListener("click", () => startMode(startContent));
}
bibleXhr.send();
function totalButton() {
	document.write("<tr id='" + arguments[0] + "_0'>");
	for (btn = 1; btn <= 150; btn++) {
		if (btn === 10) document.write("<td><div id='" + arguments[0] + "Btn_" + btn + "' class='number-button' style='margin-top:0px'>" + btn + "</div></td></tr><tr id='" + arguments[0] + "_1'>");
		else if (btn < 10) document.write("<td style='padding-right:1px'><div id='" + arguments[0] + "Btn_" + btn + "' class='number-button' style='margin-top:0px'>" + btn + "</div></td>");
		else if (btn > 10 && btn % 10 === 0 && btn < 150) document.write("<td><div id='" + arguments[0] + "Btn_" + btn + "' class='number-button'>" + btn + "</div></td></tr><tr id='" + arguments[0] + "_" + btn / 10 + "'>");
		else if (btn === 150) document.write("<td><div id='" + arguments[0] + "Btn_" + btn + "' class=number-button>" + btn + "</div></td>");
		else document.write("<td style='padding-right:1px'><div id='" + arguments[0] + "Btn_" + btn + "' class='number-button'>" + btn + "</div></td>");
	}
	document.write("</tr>");
}
</script>

</head>

<body>

<div id="bibleDiv" style="display:none">
	<table id="selectTable" cellpadding="0" cellspacing="1">
		<td><select id="oldSelect" class="bible-select"><option style="display:none" value="성경선택">구약성경 선택하기</option></select></td>
		<td><select id="newSelect" class="bible-select"><option style="display:none" value="성경선택">신약성경 선택하기</option></select></td>
	</table>
	<table style="width:100%" cellpadding="0" cellspacing="0">
		<td id="oldTd_1" style="width:150px;vertical-align:top"><table style="width:100%;background-color:#cccccc" cellpadding="0" cellspacing="1"><td class="title-td">구약성경</td></table></td>
		<td id="oldTd_2" style="width:6px"></td>
		<td style="width:auto;vertical-align:top">
			<table class="list-table" cellpadding="0" cellspacing="0">
				<td style="text-align:left;width:20%"><span id="headPrev" style="cursor:pointer">◀◀ 이전</span></td>
				<td id="titleBible" style="text-align:center;width:60%">성경전서</td>
				<td style="text-align:right;width:20%"><span id="headNext" style="cursor:pointer">다음 ▶▶</span></td>
			</table>
			<div id="headGroup" style="margin-top:6px"><table cellpadding="0" cellspacing="0"><script>totalButton("tt")</script></table></div>
			<div id="textBible"></div>
			<div id="footGroup" style="margin-top:6px"><table cellpadding="0" cellspacing="0"><script>totalButton("bt")</script></table></div>
			<div style="margin-top:6px">
				<table class="list-table" cellpadding="0" cellspacing="0">
					<td style="text-align:left;width:20%"><span id="footPrev" style="cursor:pointer">◀◀ 이전</span></td>
					<td id="startTd" style="text-align:center;width:60%;cursor:pointer">처음으로</td>
					<td style="text-align:right;width:20%"><span id="footNext" style="cursor:pointer">다음 ▶▶</span></td>
				</table>
			</div>
		</td>
		<td id="newTd_1" style="width:6px"></td>
		<td id="newTd_2" style="width:150px;vertical-align:top"><table style="width:100%;background-color:#cccccc" cellpadding="0" cellspacing="1"><td class="title-td">신약성경</td></table></td>
	</table>
</div>

<script>
bibleStyle = "<?php echo $bibleStyle; ?>";
headVisible = "cut";
footVisible = "yes";
startContent = Number("0");
psalmsMode = unitNumber = 0;
order_1 = ["창세기", "창", 50]; order_2 = ["출애굽기", "출", 40]; order_3 = ["레위기", "레", 27]; order_4 = ["민수기", "민", 36]; order_5 = ["신명기", "신", 34];
order_6 = ["여호수아", "수", 24]; order_7 = ["사사기", "삿", 21]; order_8 = ["룻기", "룻", 4]; order_9 = ["사무엘상", "삼상", 31]; order_10 = ["사무엘하", "삼하", 24];
order_11 = ["열왕기상", "왕상", 22]; order_12 = ["열왕기하", "왕하", 25]; order_13 = ["역대상", "대상", 29]; order_14 = ["역대하", "대하", 36]; order_15 = ["에스라", "스", 10];
order_16 = ["느헤미야", "느", 13]; order_17 = ["에스더", "에", 10]; order_18 = ["욥기", "욥", 42]; order_19 = ["시편", "시", 150]; order_20 = ["잠언", "잠", 31];
order_21 = ["전도서", "전", 12]; order_22 = ["아가", "아", 8]; order_23 = ["이사야", "사", 66]; order_24 = ["예레미야", "렘", 52]; order_25 = ["예레미야애가", "애", 5];
order_26 = ["에스겔", "겔", 48]; order_27 = ["다니엘", "단", 12]; order_28 = ["호세아", "호", 14]; order_29 = ["요엘", "욜", 3]; order_30 = ["아모스", "암", 9];
order_31 = ["오바댜", "옵", 1]; order_32 = ["요나", "욘", 4]; order_33 = ["미가", "미", 7]; order_34 = ["나훔", "나", 3]; order_35 = ["하박국", "합", 3];
order_36 = ["스바냐", "습", 3]; order_37 = ["학개", "학", 2]; order_38 = ["스가랴", "슥", 14]; order_39 = ["말라기", "말", 4]; // 구약 39권
order_40 = ["마태복음", "마", 28]; order_41 = ["마가복음", "막", 16]; order_42 = ["누가복음", "눅", 24]; order_43 = ["요한복음", "요", 21]; order_44 = ["사도행전", "행", 28];
order_45 = ["로마서", "롬", 16]; order_46 = ["고린도전서", "고전", 16]; order_47 = ["고린도후서", "고후", 13]; order_48 = ["갈라디아서", "갈", 6]; order_49 = ["에베소서", "엡", 6];
order_50 = ["빌립보서", "빌", 4]; order_51 = ["골로새서", "골", 4]; order_52 = ["데살로니가전서", "살전", 5]; order_53 = ["데살로니가후서", "살후", 3]; order_54 = ["디모데전서", "딤전", 6];
order_55 = ["디모데후서", "딤후", 4]; order_56 = ["디도서", "딛", 3]; order_57 = ["빌레몬서", "몬", 1]; order_58 = ["히브리서", "히", 13]; order_59 = ["야고보서", "약", 5];
order_60 = ["베드로전서", "벧전", 5]; order_61 = ["베드로후서", "벧후", 3]; order_62 = ["요한일서", "요일", 5]; order_63 = ["요한이서", "요이", 1]; order_64 = ["요한삼서", "요삼", 1];
order_65 = ["유다서", "유", 1]; order_66 = ["요한계시록", "계", 22]; // 신약 27권
function bibleData() {
	plusNum = 0;
	$_ONE("#textBible").innerHTML = "";
	$_ONE("#textBible").style.padding = "16px";
	$_ONE("#titleBible").innerText = arguments[0] + (psalmsMode ? "편" : "장") + " (총 " + arguments[1] + (psalmsMode ? "편" : "장") + ")";
	for (bible = 0; bible < bibleTotal.length; bible++) {
		if (bibleTotal[bible].indexOf(arguments[2] + ":") === 0) {
			pointText = bibleTotal[bible].split(":")[1];
			divText = !plusNum ? " style='margin-top:0px'" : "";
			plusNum = 1;
			$_ONE("#textBible").innerHTML = $_ONE("#textBible").innerHTML + "<div class='text-div'" + divText + ">" + pointText + "</div>";
		}
	}
	for (btn = 1; btn <= 150; btn++) {
		$_ONE("#ttBtn_" + btn).style.backgroundColor = btn == arguments[3] ? "#f7d7e4" : "#ffffff";
		$_ONE("#btBtn_" + btn).style.backgroundColor = $_ONE("#ttBtn_" + btn).style.backgroundColor;
	}
}
for (old39 = 1; old39 <= 39; old39++) {
	$_ONE("#oldSelect").innerHTML += "<option class='bible-option' value=" + old39 + ">" + this['order_' + old39][0] + "</option>";
	$_ONE("#oldTd_1 table").innerHTML += "<tr><td id='bible_" + old39 + "' class='list-td' style='cursor:pointer'>" + this['order_' + old39][0] + "</td></tr>";
}
for (new27 = 40; new27 <= 66; new27++) {
	$_ONE("#newSelect").innerHTML += "<option class='bible-option' value=" + new27 + ">" + this['order_' + new27][0] + "</option>";
	$_ONE("#newTd_2 table").innerHTML += "<tr><td id='bible_" + new27 + "' class='list-td' style='cursor:pointer'>" + this['order_' + new27][0] + "</td></tr>";
}
$_ONE("#headPrev").onclick = $_ONE("#footPrev").onclick = function() {
	unitNumber = unitNumber - 1;
	if (unitNumber < Math.ceil(globalNumber / 10)) $_ONE("#ttBtn_" + (unitNumber * 10 + 1)).onclick();
}
$_ONE("#headNext").onclick = $_ONE("#footNext").onclick = function() {
	unitNumber = unitNumber + 1;		
	if (unitNumber < Math.ceil(globalNumber / 10)) $_ONE("#ttBtn_" + (unitNumber * 10 + 1)).onclick();
}
for (bible66 = 1; bible66 <= 66; bible66++) {
	$_ONE("#bible_" + bible66).choice = bible66; 
	$_ONE("#bible_" + bible66).bibleTitle = this["order_" + bible66][0];
	$_ONE("#bible_" + bible66).bibleBody = this["order_" + bible66][1];
	$_ONE("#bible_" + bible66).bibleNumber = this["order_" + bible66][2];
	$_ONE("#bible_" + bible66).onclick = function() {
		psalmsMode = this.choice === 19;
		globalText = this.bibleTitle + " ";
		globalBody = this.bibleBody;
		globalNumber = this.bibleNumber;
		$_ONE("#headGroup").style.display = headVisible === "no" ? "none" : "block";
		$_ONE("#footGroup").style.display = footVisible === "no" ? "none" : "block";
		for (btn = 1; btn <= 150; btn++) {
			$_ONE("#ttBtn_" + btn).style.display = (btn <= globalNumber) ? "block" : "none";
			$_ONE("#btBtn_" + btn).style.display = $_ONE("#ttBtn_" + btn).style.display;
		}
		for (bible66 = 1; bible66 <= 66; bible66++) $_ONE("#bible_" + bible66).style.backgroundColor = bible66 === this.choice ? "#f7d7e4" : "#ffffff";
		globalOrder = this.choice;
		$_ONE("#ttBtn_1").onclick();
		if (this.choice <= 39) {
			$_ONE("#oldSelect").value = this.choice;
			$_ONE("#oldSelect").style.backgroundColor = "#f7d7e4";
			$_ONE("#newSelect").value = "성경선택";
			$_ONE("#newSelect").style.backgroundColor = "#eeeeee";
		}
		else {
			$_ONE("#oldSelect").value = "성경선택";
			$_ONE("#oldSelect").style.backgroundColor = "#eeeeee";
			$_ONE("#newSelect").value = this.choice;
			$_ONE("#newSelect").style.backgroundColor = "#f7d7e4";
		}
	}
}
$_ONE("#oldSelect").onchange = $_ONE("#newSelect").onchange = function() {
	$_ONE("#bible_" + this.value).onclick();
}
for (btn = 1; btn <= 150; btn++) {
	$_ONE("#ttBtn_" + btn).onclick = $_ONE("#btBtn_" + btn).onclick = function() {
		bibleData(globalText + this.innerText, globalNumber, globalBody + this.innerText, this.innerText);
		unitNumber = Math.ceil(this.innerText / 10) - 1;			
		if (headVisible === "cut") {
			$_ONE("#headNext").style.display = unitNumber === Math.ceil(globalNumber / 10) - 1 ? "none" : "block";
			$_ONE("#headPrev").style.display = unitNumber === 0 ? "none" : "block";
			for (tr15 = 0; tr15 < 15; tr15++) $_ONE("#tt_" + tr15).style.display = unitNumber == tr15 ? "" : "none";
			if (footVisible === "cut") {
				$_ONE("#footNext").style.display = unitNumber === Math.ceil(globalNumber / 10) - 1 ? "none" : "block";
				$_ONE("#footPrev").style.display = unitNumber === 0 ? "none" : "block";
				for (tr15 = 0; tr15 < 15; tr15++) $_ONE("#bt_" + tr15).style.display = unitNumber == tr15 ? "" : "none";
			}
		}
		if (footVisible === "cut") {
			$_ONE("#footNext").style.display = unitNumber === Math.ceil(globalNumber / 10) - 1 ? "none" : "block";
			$_ONE("#footPrev").style.display = unitNumber === 0 ? "none" : "block";
			for (tr15 = 0; tr15 < 15; tr15++) $_ONE("#bt_" + tr15).style.display = unitNumber == tr15 ? "" : "none";
			if (headVisible === "cut") {
				$_ONE("#headNext").style.display = unitNumber === Math.ceil(globalNumber / 10) - 1 ? "none" : "block";
				$_ONE("#headPrev").style.display = unitNumber === 0 ? "none" : "block";
				for (tr15 = 0; tr15 < 15; tr15++) $_ONE("#tt_" + tr15).style.display = unitNumber == tr15 ? "" : "none";
			}
		}
		scrollTo({top:0, behavior:"smooth"});			
	}
}
</script>

</body>

</html>