
/*=================================================================================================
 * MARI HOME   ---------------"--<@
 *-------------------------------------------------------------------------------------------------
 * @코드 명칭 : 마리 멀티 업로더 ( 가제 ) 
 * @요약 정보 : 파일의 마임 타입등을 비교할 때 사용
 * @파일 이름 : mime_types.js
 * @웹용 주소 : 글쓰기등 업로드가 필요한 곳, 파일 탐색기와 같이 파일 미리보기가 필요한 곳에서 외부 파일(js파일)로 호출됨 
 * @호출 파일 : multi_uploader_code.js에서 주로 호출
 * @서버 위치 : 마리홈 ( ),  그누보드 ( plugin/multi_uploader/ )
 * @소스 제작 : repter ( 예뜨락 ), 홈페이지 ( https  ://marihome.net ) 
 * @제작 날짜 : 2023.08.01 ( 최초 제작 시작일 )
 * @소스 설명 : mime_types => 업로드시 파일의 마임 타입과 비교 올바른 타입의 파일인지 검사, file_ext_list => 어떠한 파일인지 설명
 * @지원 언어 : 한국어, 영어, 프랑스어, 독일어, 러시아어, 스페인어,  아랍어, 일본어, 중국어, 베트남어, 몽골어, 태국어
 * @기타 사항 : ChatGPT를 통해 파일 종류를 만듦 파일명 132여개 [ 기준 :: 2024-11-21(목) ]
 *             종류를 늘리려 했으나 자꾸 파일명 중복 혹은 충분하지 못한 갯수등으로 풍부한 갯수 등록이 안되 적정량만 추출해서 만들었습니다
 *             언어가 깨진 글자로 보인다면 에디터의 글꼴을 바꿔서 볼것 중국어 일본어등이 지원되는 폰트여야 해당 글자가 보입니다
 *             한국어 이외의 언어에서는 다소 어색한 부분이 있을수 있습니다 이에 따른 수정 부분이 있으면 개발자에게 알려주세요 
 *             추후 수정된 부분을 업데이트에 포함 시키겠습니다 :: 12개국 외 언어 추가 환영!!
 *
 *             당분간 필요한 업그레이드를 통해서 소스 변경이 자주 일어날 수 있습니다
 *             자바스크립트 형태 : 객체 리터럴 ( Object Literal )
 *             변수 => 프로퍼티 (Property)   : 프로퍼티 값
 *             함수 => 메서드 (Method)
 * @최종 수정 : 2025.03.26
 * @버전 명시 : 0.9
 *-------------------------------------------------------------------------------------------------
 * Copyright 2023. repter All Rights Reserved.
**===============================================================================================*/ 

const mime_types = {
        // 텍스트 파일 유형
        conf       : 'text/plain',
        css        : 'text/css',
        csv        : 'text/csv',
        htaccess   : 'application/x-httpd-conf', 
        html       : 'text/html',
        htm        : 'text/html',
        ini        : 'text/plain',
        json       : 'application/json',
        json5      : 'application/json',
        js         : 'application/javascript',
        log        : 'text/plain',
        markdown   : 'text/markdown',
        md         : 'text/markdown',
        sql        : 'application/sql',
        sqlite     : 'application/x-sqlite3',
        txt        : 'text/plain',
        xml        : 'application/xml',
        yaml       : 'application/x-yaml',
        yml        : 'application/x-yaml',

        // 이미지 파일 유형
        avif       : 'image/avif',
        bmp        : 'image/bmp',
        gif        : 'image/gif',
        heic       : 'image/heic',
        heif       : 'image/heif',
        ico        : 'image/x-icon',
        jp2        : 'image/jp2',
        jpx        : 'image/jpx',
        jpeg       : 'image/jpeg',
        jpg        : 'image/jpeg',
        png        : 'image/png',
        psd        : 'image/vnd.adobe.photoshop',
        svg        : 'image/svg+xml',
        tif        : 'image/tiff',
        tiff       : 'image/tiff',
        webp       : 'image/webp',
        wmf        : 'image/x-wmf',
            
        // 오디오 파일 유형
        aac        : 'audio/aac',
        amr        : 'audio/amr',
        flac       : 'audio/flac',
        m4a        : 'audio/mp4',
        mp3        : 'audio/mpeg',
        mpa        : 'audio/mpeg',
        ogg        : 'audio/ogg',
        oga        : 'audio/ogg',
        opus       : 'audio/opus',
        wav        : 'audio/wav',
        wma        : 'audio/x-ms-wma',

        // 비디오 파일 유형
        asf        : 'video/x-ms-asf',
        avi        : 'video/x-msvideo',
        flv        : 'video/x-flv',
        m3u8       : 'application/vnd.apple.mpegurl',
        mkv        : 'video/x-matroska',
        mp4        : 'video/mp4',
        mpeg       : 'video/mpeg',
        mpg        : 'video/mpeg',
        mov        : 'video/quicktime',
        mxf        : 'application/mxf',   // MXF 파일 형식 추가 (방송 및 프로덕션용)
        ogv        : 'video/ogg',
        rm         : 'application/vnd.rn-realmedia',
        ts         : 'video/mp2t', 
        vob        : 'video/dvd',         // VOB 파일 형식 추가 (DVD 비디오 포맷)
        webm       : 'video/webm',
        wmv        : 'video/x-ms-wmv',

        // 압축된 파일 유형
        '7z'       : 'application/x-7z-compressed',
        apk        : 'application/vnd.android.package-archive',
        bin        : 'application/octet-stream',
        bz         : 'application/x-bzip',
        bz2        : 'application/x-bzip2',
        cab        : 'application/vnd.ms-cab-compressed',
        dmg        : 'application/x-apple-diskimage',
        epub       : 'application/epub+zip',
        exe        : 'application/x-msdownload',
        gz         : 'application/gzip',
        iso        : 'application/x-iso9660-image',
        jar        : 'application/java-archive',
        mobi       : 'application/x-mobipocket-ebook',
        pdf        : 'application/pdf',
        rar        : 'application/vnd.rar',
        tar        : 'application/x-tar',
        tgz        : 'application/gzip',
        war        : 'application/java-archive',
        xz         : 'application/x-xz',
        zip        : 'application/zip',
        zst        : 'application/zstd',

        // 오피스 문서 파일 유형
        doc        : 'application/msword',
        docx       : 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        hwp        : 'application/x-hwp',
        hwp        : 'application/hancom-hwp',
        hwpx       : 'application/hwp+zip', 
        key        : 'application/keynote',
        numbers    : 'application/numbers',
        odt        : 'application/vnd.oasis.opendocument.text',
        ods        : 'application/vnd.oasis.opendocument.spreadsheet',
        odp        : 'application/vnd.oasis.opendocument.presentation',
        pages      : 'application/pages',
        ppt        : 'application/vnd.ms-powerpoint',
        pptx       : 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
        rtf        : 'application/rtf',
        tex        : 'application/x-tex',
        xls        : 'application/vnd.ms-excel',
        xlsx       : 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',

        // 폰트 파일 유형
        eot        : 'application/vnd.ms-fontobject',
        otf        : 'font/otf',
        sfnt       : 'font/sfnt',
        ttf        : 'font/ttf',
        woff       : 'font/woff',
        woff2      : 'font/woff2',

        // 프로그래밍 언어 파일 유형
        c          : 'text/x-c',
        cpp        : 'text/x-c++',
        go         : 'text/x-go',
        java       : 'text/x-java-source',
        jsx        : 'text/jsx',
        php        : 'application/x-php',
        py         : 'text/x-python',
        rb         : 'text/x-ruby',
        sh         : 'application/x-sh',
        swift      : 'application/x-swift',
        kotlin     : 'text/x-kotlin',

        // 기타 파일 유형
        dockerfile : 'text/plain',
        bash       : 'application/x-bash',
        pl         : 'application/x-perl',
        cgi        : 'application/x-httpd-cgi',
        toml       : 'application/x-toml',
        crx        : 'application/x-chrome-extension',
        deb        : 'application/x-deb',
        eml        : 'message/rfc822',
        ics        : 'text/calendar',
        lz         : 'application/x-lzip',
        lzma       : 'application/x-lzma',
        msg        : 'application/vnd.ms-outlook',
        pkpass     : 'application/vnd.apple.pkpass',
        torrent    : 'application/x-bittorrent',
        rpm        : 'application/x-redhat-package-manager',
        swf        : 'application/x-shockwave-flash',
        wasm       : 'application/wasm',
};

const file_ext_list = {
    
   // 한국어
   ko   : {
        // 텍스트 파일 유형
        conf       : '구성 파일',
        css        : 'CSS 파일',
        csv        : 'CSV 파일',
        htaccess   : ".htaccess 서버 설정 파일", 
        html       : 'HTML 파일',
        htm        : 'HTML 파일',
        ini        : '초기화 파일',
        json       : 'JSON 파일',
        json5      : 'JSON5 파일',
        js         : 'JavaScript 파일',
        log        : '로그 파일',
        markdown   : '마크다운 파일',
        md         : '마크다운 파일', 
        sql        : "SQL 데이터베이스 파일", 
        sqlite     : "SQLite 데이터베이스 파일", 
        txt        : '텍스트 파일',
        xml        : 'XML 파일',
        yaml       : 'YAML 파일',
        yml        : 'YAML 파일',

        // 이미지 파일 유형
        avif       : 'AVIF 이미지 파일',
        bmp        : 'BMP 이미지 파일',
        gif        : 'GIF 이미지 파일',
        heic       : 'HEIC 이미지 파일',
        heif       : 'HEIF 이미지 파일',
        ico        : '아이콘 이미지 파일',
        jp2        : 'JPEG 2000 이미지 파일',
        jpx        : 'JPEG 2000 이미지 파일',
        jpeg       : 'JPEG 이미지 파일',
        jpg        : 'JPEG 이미지 파일',
        png        : 'PNG 이미지 파일',
        psd        : '포토샵 이미지 파일',
        svg        : 'SVG 이미지 파일',
        tif        : 'TIFF 이미지 파일',
        tiff       : 'TIFF 이미지 파일',
        webp       : 'WebP 이미지 파일',
        wmf        : 'Windows 벡터 그래픽 파일',

        // 오디오 파일 유형
        aac        : 'AAC 오디오 파일',
        amr        : 'AMR 오디오 파일',
        flac       : 'FLAC 오디오 파일',
        m4a        : 'M4A 오디오 파일',
        mp3        : 'MP3 오디오 파일',
        mpa        : 'MPA 오디오 파일',
        ogg        : 'OGG 오디오 파일',
        oga        : 'OGG 오디오 파일',
        opus       : 'Opus 오디오 파일',
        wav        : 'WAV 오디오 파일',
        wma        : 'WMA 오디오 파일',
            
        // 비디오 파일 유형 
        asf        : 'ASF 비디오 파일',
        avi        : 'AVI 비디오 파일',
        flv        : 'FLV 비디오 파일',
        m3u8       : 'M3U8 비디오 스트리밍 파일',
        mkv        : 'MKV 비디오 파일',
        mp4        : 'MP4 비디오 파일',
        mpeg       : 'MPEG 비디오 파일',
        mpg        : 'MPEG 비디오 파일',
        mov        : 'QuickTime 비디오 파일',
        mxf        : 'MXF 파일 형식 추가 (방송 및 프로덕션용)',
        ogv        : 'OGG 비디오 파일',
        rm         : 'RealMedia 비디오 파일',
        ts         : 'MPEG-TS 비디오 파일',
        vob        : 'VOB 파일 형식 추가 (DVD 비디오 포맷)',
        webm       : 'WebM 비디오 파일',
        wmv        : 'WMV 비디오 파일',

        // 압축된 파일 유형
        '7z'       : '오픈 소스 압축 파일',
        apk        : '안드로이드 애플리케이션 파일',
        bin        : '이진 데이터 파일',
        bz         : 'Bzip 압축 파일',
        bz2        : 'Bzip2 압축 파일',
        cab        : 'MS CAB 압축 파일',
        dmg        : '디스크 이미지 파일',
        epub       : 'EPUB 전자책 파일',
        exe        : '실행 파일',
        gz         : 'Gzip 압축 파일',
        iso        : 'ISO 이미지 파일',
        jar        : 'Java 아카이브 파일',
        mobi       : 'MOBI 전자책 파일',
        pdf        : 'PDF 문서 파일',
        rar        : 'RAR 압축 파일',
        tar        : 'TAR 아카이브 파일',
        tgz        : 'TAR.GZ 압축 파일',
        war        : 'Java 아카이브 파일',
        xz         : 'XZ 압축 파일',
        zip        : 'ZIP 압축 파일',
        zst        : 'Zstandard 압축 파일',

        // 오피스 문서 파일 유형
        doc        : 'MS 워드 문서 파일',
        docx       : 'MS 워드 OpenXML 문서 파일',
        hwp        : '한글 97 이후 파일', 
        hwpx       : '한글 XML 기반 파일 (한컴오피스 2018 이후)',
        key        : '애플 키노트 파일',
        numbers    : '애플 넘버스 파일',
        odt        : 'OpenDocument 텍스트 파일',
        ods        : 'OpenDocument 스프레드시트 파일',
        odp        : 'OpenDocument 프레젠테이션 파일',
        pages      : '애플 페이지 파일',
        ppt        : 'MS 파워포인트 파일',
        pptx       : 'MS 파워포인트 OpenXML 파일',
        rtf        : 'RTF 텍스트 파일',
        tex        : 'TeX 텍스트 파일',
        xls        : 'MS 엑셀 파일',
        xlsx       : 'MS 엑셀 OpenXML 파일',

        // 폰트 파일 유형
        eot        : '임베디드 OpenType 폰트 파일',
        otf        : 'OpenType 폰트 파일',
        sfnt       : 'SFNT 폰트 형식 파일',
        ttf        : 'TrueType 폰트 파일',
        woff       : '웹 Open 폰트 형식 파일',
        woff2      : '웹 Open 폰트 형식 2 파일',

        // 프로그래밍 언어 파일 유형
        c          : 'C 소스 코드 파일',
        cpp        : 'C++ 소스 코드 파일',
        go         : 'Go 소스 코드 파일',
        java       : 'Java 소스 코드 파일',
        jsx        : 'JavaScript JSX 파일',
        php        : 'PHP 파일',
        py         : 'Python 소스 코드 파일',
        rb         : 'Ruby 소스 코드 파일',
        sh         : '쉘 스크립트 파일',
        swift      : 'Swift 소스 코드 파일', 
        kotlin     : 'Kotlin 소스 코드 파일',

        // 기타 파일 유형
        dockerfile : "Dockerfile",
        bash       : "Bash 스크립트 파일", 
        pl         : "Perl 서버 스크립트 파일",
        cgi        : "CGI 스크립트 파일",
        toml       : "TOML 구성 파일",   
        crx        : 'Chrome 확장 파일',
        deb        : 'Debian 패키지 파일',
        eml        : '이메일 메시지 파일',
        ics        : '캘린더 파일',
        lz         : 'Lzip 압축 파일',
        lzma       : 'LZMA 압축 파일',
        msg        : 'Outlook 메시지 파일',
        pkpass     : 'Apple Wallet 패스북 파일',
        torrent    : 'BitTorrent 파일',
        rpm        : 'RedHat 패키지 파일',
        swf        : 'Shockwave Flash 파일',
        wasm       : 'WebAssembly 바이너리 파일',
    },

    // 영어
    en  : {
        // Text file types
        conf       : 'Configuration File',
        css        : 'CSS File',
        csv        : 'CSV File',
        htaccess   : ".htaccess Server Configuration File", 
        html       : 'HTML File',
        htm        : 'HTML File',
        ini        : 'Initialization File',
        json       : 'JSON File',
        json5      : 'JSON5 File',
        js         : 'JavaScript File',
        log        : 'Log File',
        markdown   : 'Markdown File',
        md         : 'Markdown File', 
        sql        : "SQL Database File", 
        sqlite     : "SQLite Database File", 
        txt        : 'Text File',
        xml        : 'XML File',
        yaml       : 'YAML File',
        yml        : 'YAML File',

        // Image file types
        avif       : 'AVIF Image File',
        bmp        : 'BMP Image File',
        gif        : 'GIF Image File',
        heic       : 'HEIC Image File',
        heif       : 'HEIF Image File',
        ico        : 'Icon Image File',
        jp2        : 'JPEG 2000 Image File',
        jpx        : 'JPEG 2000 Image File',
        jpeg       : 'JPEG Image File',
        jpg        : 'JPEG Image File',
        png        : 'PNG Image File',
        psd        : 'Photoshop Image File',
        svg        : 'SVG Image File',
        tif        : 'TIFF Image File',
        tiff       : 'TIFF Image File',
        webp       : 'WebP Image File',
        wmf        : 'Windows Vector Graphics File',

        // Audio file types
        aac        : 'AAC Audio File',
        amr        : 'AMR Audio File',
        flac       : 'FLAC Audio File',
        m4a        : 'M4A Audio File',
        mp3        : 'MP3 Audio File',
        mpa        : 'MPA Audio File',
        ogg        : 'OGG Audio File',
        oga        : 'OGG Audio File',
        opus       : 'Opus Audio File',
        wav        : 'WAV Audio File',
        wma        : 'WMA Audio File',

        // Video file types
        asf        : 'ASF video file',
        avi        : 'AVI video file',
        flv        : 'FLV video file',
        m3u8       : 'M3U8 video streaming file',
        mkv        : 'MKV video file',
        mp4        : 'MP4 video file',
        mpeg       : 'MPEG video file',
        mpg        : 'MPEG video file',
        mov        : 'QuickTime video file',
        mxf        : 'MXF file format (for broadcasting and production)',
        ogv        : 'OGG video file',
        rm         : 'RealMedia video file',
        ts         : 'MPEG-TS video file',
        vob        : 'VOB file format (DVD video format)',
        webm       : 'WebM video file',
        wmv        : 'WMV video file',

        // Compressed file types
        '7z'       : 'Open source compression file',
        apk        : 'Android Application File',
        bin        : 'Binary Data File',
        bz         : 'Bzip Compressed File',
        bz2        : 'Bzip2 Compressed File',
        cab        : 'MS CAB Compressed File',
        dmg        : 'Disk Image File',
        epub       : 'EPUB eBook File',
        exe        : 'Executable File',
        gz         : 'Gzip Compressed File',
        iso        : 'ISO Image File',
        jar        : 'Java Archive File',
        mobi       : 'MOBI eBook File',
        pdf        : 'PDF Document File',
        rar        : 'RAR Compressed File',
        tar        : 'TAR Archive File',
        tgz        : 'TAR.GZ Compressed File',
        war        : 'Java Archive File',
        xz         : 'XZ Compressed File',
        zip        : 'ZIP Compressed File',
        zst        : 'Zstandard Compressed File',

        // Office document file types
        doc        : 'MS Word Document File',
        docx       : 'MS Word OpenXML Document File',
        hwp        : 'Hangul 97 and later file',
        hwpx       : 'Hangul XML-based file (from Hancom Office 2018)',
        key        : 'Apple Keynote File',
        numbers    : 'Apple Numbers File',
        odt        : 'OpenDocument Text File',
        ods        : 'OpenDocument Spreadsheet File',
        odp        : 'OpenDocument Presentation File',
        pages      : 'Apple Pages File',
        ppt        : 'MS PowerPoint File',
        pptx       : 'MS PowerPoint OpenXML File',
        rtf        : 'RTF Text File',
        tex        : 'TeX Text File',
        xls        : 'MS Excel File',
        xlsx       : 'MS Excel OpenXML File',

        // Font file types
        eot        : 'Embedded OpenType Font File',
        otf        : 'OpenType Font File',
        sfnt       : 'SFNT Font Format File',
        ttf        : 'TrueType Font File',
        woff       : 'Web Open Font Format File',
        woff2      : 'Web Open Font Format 2 File',

        // Programming language file types
        c          : 'C Source Code File',
        cpp        : 'C++ Source Code File',
        go         : 'Go Source Code File',
        java       : 'Java Source Code File',
        jsx        : 'JavaScript JSX File',
        php        : 'PHP File',
        py         : 'Python Source Code File',
        rb         : 'Ruby Source Code File',
        sh         : 'Shell Script File',
        swift      : 'Swift Source Code File', 
        kotlin     : 'Kotlin Source Code File',

        // Other file types
        dockerfile : "Dockerfile", 
        bash       : "Bash Script File", 
        pl         : "Perl Server Script File",
        cgi        : "CGI Script File",
        toml       : "TOML Configuration File",   
        crx        : 'Chrome Extension File',
        deb        : 'Debian Package File',
        eml        : 'Email Message File',
        ics        : 'Calendar File',
        lz         : 'Lzip Compressed File',
        lzma       : 'LZMA Compressed File',
        msg        : 'Outlook Message File',
        pkpass     : 'Apple Wallet Passbook File',
        torrent    : 'BitTorrent File',
        rpm        : 'RedHat Package File',
        swf        : 'Shockwave Flash File',
        wasm       : 'WebAssembly Binary File',

    },

    // 프랑스어
    fr  : {
        // Types de fichiers texte
        conf       : 'Fichier de configuration',
        css        : 'Fichier CSS',
        csv        : 'Fichier CSV',
        htaccess   : "Fichier de configuration du serveur .htaccess", 
        html       : 'Fichier HTML',
        htm        : 'Fichier HTML',
        ini        : 'Fichier d\'initialisation',
        json       : 'Fichier JSON',
        json5      : 'Fichier JSON5',
        js         : 'Fichier JavaScript',
        log        : 'Fichier journal',
        markdown   : 'Fichier Markdown',
        md         : 'Fichier Markdown', 
        sql        : "Fichier de base de données SQL", 
        sqlite     : "Fichier de base de données SQLite", 
        txt        : 'Fichier texte',
        xml        : 'Fichier XML',
        yaml       : 'Fichier YAML',
        yml        : 'Fichier YAML',

        // Types de fichiers image
        avif       : 'Fichier image AVIF',
        bmp        : 'Fichier image BMP',
        gif        : 'Fichier image GIF',
        heic       : 'Fichier image HEIC',
        heif       : 'Fichier image HEIF',
        ico        : 'Fichier d\'icône image',
        jp2        : 'Fichier image JPEG 2000',
        jpx        : 'Fichier image JPEG 2000',
        jpeg       : 'Fichier image JPEG',
        jpg        : 'Fichier image JPEG',
        png        : 'Fichier image PNG',
        psd        : 'Fichier image Photoshop',
        svg        : 'Fichier image SVG',
        tif        : 'Fichier image TIFF',
        tiff       : 'Fichier image TIFF',
        webp       : 'Fichier image WebP',
        wmf        : 'Fichier graphique vectoriel Windows',


        // Types de fichiers audio
        aac        : 'Fichier audio AAC',
        amr        : 'Fichier audio AMR',
        flac       : 'Fichier audio FLAC',
        m4a        : 'Fichier audio M4A',
        mp3        : 'Fichier audio MP3',
        mpa        : 'Fichier audio MPA',
        ogg        : 'Fichier audio OGG',
        oga        : 'Fichier audio OGG',
        opus       : 'Fichier audio Opus',
        wav        : 'Fichier audio WAV',
        wma        : 'Fichier audio WMA',

        // Types de fichiers vidéo
        asf        : 'Fichier vidéo ASF',
        avi        : 'Fichier vidéo AVI',
        flv        : 'Fichier vidéo FLV',
        m3u8       : 'Fichier de streaming vidéo M3U8',
        mkv        : 'Fichier vidéo MKV',
        mp4        : 'Fichier vidéo MP4',
        mpeg       : 'Fichier vidéo MPEG',
        mpg        : 'Fichier vidéo MPEG',
        mov        : 'Fichier vidéo QuickTime',
        mxf        : 'Format de fichier MXF (pour diffusion et production)',
        ogv        : 'Fichier vidéo OGG',
        rm         : 'Fichier vidéo RealMedia',
        ts         : 'Fichier vidéo MPEG-TS',
        vob        : 'Format de fichier VOB (format vidéo DVD)',
        webm       : 'Fichier vidéo WebM',
        wmv        : 'Fichier vidéo WMV',


        // Types de fichiers compressés
        '7z'       : 'Fichier de compression open source',
        apk        : 'Fichier d\'application Android',
        bin        : 'Fichier de données binaires',
        bz         : 'Fichier compressé Bzip',
        bz2        : 'Fichier compressé Bzip2',
        cab        : 'Fichier compressé MS CAB',
        dmg        : 'Fichier image disque',
        epub       : 'Fichier électronique EPUB',
        exe        : 'Fichier exécutable',
        gz         : 'Fichier compressé Gzip',
        iso        : 'Fichier image ISO',
        jar        : 'Fichier archive Java',
        mobi       : 'Fichier électronique MOBI',
        pdf        : 'Fichier PDF',
        rar        : 'Fichier compressé RAR',
        tar        : 'Fichier archive TAR',
        tgz        : 'Fichier compressé TAR.GZ',
        war        : 'Fichier archive Java',
        xz         : 'Fichier compressé XZ',
        zip        : 'Fichier compressé ZIP',
        zst        : 'Fichier compressé Zstandard',

        // Types de fichiers de documents Office
        doc        : 'Fichier document MS Word',
        docx       : 'Fichier document MS Word OpenXML',
        hwp        : 'Fichier Hancom 97 et ultérieur',
        hwpx       : 'Fichier basé sur XML Hancom (depuis Hancom Office 2018)',
        key        : 'Fichier Keynote d\'Apple',
        numbers    : 'Fichier Numbers d\'Apple',
        odt        : 'Fichier texte OpenDocument',
        ods        : 'Fichier tableur OpenDocument',
        odp        : 'Fichier présentation OpenDocument',
        pages      : 'Fichier Pages d\'Apple',
        ppt        : 'Fichier PowerPoint MS',
        pptx       : 'Fichier PowerPoint MS OpenXML',
        rtf        : 'Fichier texte RTF',
        tex        : 'Fichier texte TeX',
        xls        : 'Fichier Excel MS',
        xlsx       : 'Fichier Excel MS OpenXML',

        // Types de fichiers de polices
        eot        : 'Fichier de police OpenType embarqué',
        otf        : 'Fichier de police OpenType',
        sfnt       : 'Fichier de format de police SFNT',
        ttf        : 'Fichier de police TrueType',
        woff       : 'Fichier de format de police web Open',
        woff2      : 'Fichier de format de police web Open 2',

        // Types de fichiers de programmation
        c          : 'Fichier source C',
        cpp        : 'Fichier source C++',
        go         : 'Fichier source Go',
        java       : 'Fichier source Java',
        jsx        : 'Fichier JSX JavaScript',
        php        : 'Fichier PHP',
        py         : 'Fichier source Python',
        rb         : 'Fichier source Ruby',
        sh         : 'Fichier script Shell',
        swift      : 'Fichier source Swift', 
        kotlin     : 'Fichier source Kotlin',

        // Autres types de fichiers
        dockerfile : "Dockerfile", 
        bash       : "Fichier script Bash", 
        pl         : "Fichier script serveur Perl",
        cgi        : "Fichier script CGI",
        toml       : "Fichier de configuration TOML",   
        crx        : 'Fichier d\'extension Chrome',
        deb        : 'Fichier de paquet Debian',
        eml        : 'Fichier de message électronique',
        ics        : 'Fichier calendrier',
        lz         : 'Fichier compressé Lzip',
        lzma       : 'Fichier compressé LZMA',
        msg        : 'Fichier de message Outlook',
        pkpass     : 'Fichier Apple Wallet Passbook',
        torrent    : 'Fichier BitTorrent',
        rpm        : 'Fichier de paquet RedHat',
        swf        : 'Fichier Flash Shockwave',
        wasm       : 'Fichier binaire WebAssembly',
    },

    // 독일어  
    de  : {
        // Textdateitypen
        conf       : 'Konfigurationsdatei',
        css        : 'CSS-Datei',
        csv        : 'CSV-Datei',
        htaccess   : ".htaccess Serverkonfigurationsdatei",
        html       : 'HTML-Datei',
        htm        : 'HTML-Datei',
        ini        : 'Initialisierungsdatei',
        json       : 'JSON-Datei',
        json5      : 'JSON5-Datei',
        js         : 'JavaScript-Datei',
        log        : 'Protokolldatei',
        markdown   : 'Markdown-Datei',
        md         : 'Markdown-Datei',
        sql        : 'SQL-Datenbankdatei',
        sqlite     : 'SQLite-Datenbankdatei',
        txt        : 'Textdatei',
        xml        : 'XML-Datei',
        yaml       : 'YAML-Datei',
        yml        : 'YAML-Datei',

        // Bilddateitypen
        avif       : 'AVIF-Bilddatei',
        bmp        : 'BMP-Bilddatei',
        gif        : 'GIF-Bilddatei',
        heic       : 'HEIC-Bilddatei',
        heif       : 'HEIF-Bilddatei',
        ico        : 'Icon-Bilddatei',
        jp2        : 'JPEG 2000-Bilddatei',
        jpx        : 'JPEG 2000-Bilddatei',
        jpeg       : 'JPEG-Bilddatei',
        jpg        : 'JPEG-Bilddatei',
        png        : 'PNG-Bilddatei',
        psd        : 'Photoshop-Bilddatei',
        svg        : 'SVG-Bilddatei',
        tif        : 'TIFF-Bilddatei',
        tiff       : 'TIFF-Bilddatei',
        webp       : 'WebP-Bilddatei',
        wmf        : 'Windows Vektor-Grafikdatei',


        // Audiodateitypen
        aac        : 'AAC-Audiodatei',
        amr        : 'AMR-Audiodatei',
        flac       : 'FLAC-Audiodatei',
        m4a        : 'M4A-Audiodatei',
        mp3        : 'MP3-Audiodatei',
        mpa        : 'MPA-Audiodatei',
        ogg        : 'OGG-Audiodatei',
        oga        : 'OGG-Audiodatei',
        opus       : 'Opus-Audiodatei',
        wav        : 'WAV-Audiodatei',
        wma        : 'WMA-Audiodatei',

        // Videodateitypen
        asf        : 'ASF-Videodatei',
        avi        : 'AVI-Videodatei',
        flv        : 'FLV-Videodatei',
        m3u8       : 'M3U8-Videostreaming-Datei',
        mkv        : 'MKV-Videodatei',
        mp4        : 'MP4-Videodatei',
        mpeg       : 'MPEG-Videodatei',
        mpg        : 'MPEG-Videodatei',
        mov        : 'QuickTime-Videodatei',
        mxf        : 'MXF-Dateiformat (für Rundfunk und Produktion)',
        ogv        : 'OGG-Videodatei',
        rm         : 'RealMedia-Videodatei',
        ts         : 'MPEG-TS-Videodatei',
        vob        : 'VOB-Dateiformat (DVD-Videoformat)',
        webm       : 'WebM-Videodatei',
        wmv        : 'WMV-Videodatei',


        // Komprimierte Dateitypen
        '7z'       : 'Open-Source-Komprimierungsdatei',
        apk        : 'Android-Anwendungsdatei',
        bin        : 'Binärdatei',
        bz         : 'Bzip-Komprimierungsdatei',
        bz2        : 'Bzip2-Komprimierungsdatei',
        cab        : 'MS CAB-Komprimierungsdatei',
        dmg        : 'Disk-Image-Datei',
        epub       : 'EPUB-E-Book-Datei',
        exe        : 'Ausführbare Datei',
        gz         : 'Gzip-Komprimierungsdatei',
        iso        : 'ISO-Image-Datei',
        jar        : 'Java-Archivdatei',
        mobi       : 'MOBI-E-Book-Datei',
        pdf        : 'PDF-Dokumentdatei',
        rar        : 'RAR-Komprimierungsdatei',
        tar        : 'TAR-Archivdatei',
        tgz        : 'TAR.GZ-Komprimierungsdatei',
        war        : 'Java-Archivdatei',
        xz         : 'XZ-Komprimierungsdatei',
        zip        : 'ZIP-Komprimierungsdatei',
        zst        : 'Zstandard-Komprimierungsdatei',

        // Office-Dokumentdateitypen
        doc        : 'MS Word-Dokumentdatei',
        docx       : 'MS Word OpenXML-Dokumentdatei',
        hwp        : 'Hangul 97 und spätere Datei',
        hwpx       : 'Hangul XML-basierte Datei (seit Hancom Office 2018)',
        key        : 'Apple Keynote-Datei',
        numbers    : 'Apple Numbers-Datei',
        odt        : 'OpenDocument-Textdatei',
        ods        : 'OpenDocument-Tabellenkalkulationsdatei',
        odp        : 'OpenDocument-Präsentationsdatei',
        pages      : 'Apple Pages-Datei',
        ppt        : 'MS PowerPoint-Datei',
        pptx       : 'MS PowerPoint OpenXML-Datei',
        rtf        : 'RTF-Textdatei',
        tex        : 'TeX-Textdatei',
        xls        : 'MS Excel-Datei',
        xlsx       : 'MS Excel OpenXML-Datei',

        // Schriftdateitypen
        eot        : 'Eingebettete OpenType-Schriftdatei',
        otf        : 'OpenType-Schriftdatei',
        sfnt       : 'SFNT-Schriftformat-Datei',
        ttf        : 'TrueType-Schriftdatei',
        woff       : 'Web Open Font Format-Datei',
        woff2      : 'Web Open Font Format 2-Datei',

        // Programmiersprachen-Dateitypen
        c          : 'C-Quellcodedatei',
        cpp        : 'C++-Quellcodedatei',
        go         : 'Go-Quellcodedatei',
        java       : 'Java-Quellcodedatei',
        jsx        : 'JavaScript JSX-Datei',
        php        : 'PHP-Datei',
        py         : 'Python-Quellcodedatei',
        rb         : 'Ruby-Quellcodedatei',
        sh         : 'Shell-Skript-Datei',
        swift      : 'Swift-Quellcodedatei',
        kotlin     : 'Kotlin-Quellcodedatei',

        // Sonstige Dateitypen
        dockerfile : "Dockerfile",
        bash       : "Bash-Skriptdatei",
        pl         : "Perl-Server-Skriptdatei",
        cgi        : "CGI-Skriptdatei",
        toml       : "TOML-Konfigurationsdatei",
        crx        : 'Chrome-Erweiterungsdatei',
        deb        : 'Debian-Paketdatei',
        eml        : 'E-Mail-Nachrichtendatei',
        ics        : 'Kalenderdatei',
        lz         : 'Lzip-Komprimierungsdatei',
        lzma       : 'LZMA-Komprimierungsdatei',
        msg        : 'Outlook-Nachrichtendatei',
        pkpass     : 'Apple Wallet Passbook-Datei',
        torrent    : 'BitTorrent-Datei',
        rpm        : 'RedHat-Paketdatei',
        swf        : 'Shockwave Flash-Datei',
        wasm       : 'WebAssembly-Binärdatei',
    },

    // 러시아어
    ru  : {
        // Текстовые файлы
        conf       : 'Конфигурационный файл',
        css        : 'CSS файл',
        csv        : 'CSV файл',
        htaccess   : ".htaccess файл настроек сервера", 
        html       : 'HTML файл',
        htm        : 'HTML файл',
        ini        : 'Файл инициализации',
        json       : 'JSON файл',
        json5      : 'JSON5 файл',
        js         : 'JavaScript файл',
        log        : 'Лог файл',
        markdown   : 'Markdown файл',
        md         : 'Markdown файл', 
        sql        : "SQL файл базы данных", 
        sqlite     : "SQLite файл базы данных", 
        txt        : 'Текстовый файл',
        xml        : 'XML файл',
        yaml       : 'YAML файл',
        yml        : 'YAML файл',

        // Изображения
        avif       : 'AVIF изображение',
        bmp        : 'BMP изображение',
        gif        : 'GIF изображение',
        heic       : 'HEIC изображение',
        heif       : 'HEIF изображение',
        ico        : 'Иконка',
        jp2        : 'JPEG 2000 изображение',
        jpx        : 'JPEG 2000 изображение',
        jpeg       : 'JPEG изображение',
        jpg        : 'JPEG изображение',
        png        : 'PNG изображение',
        psd        : 'PSD изображение',
        svg        : 'SVG изображение',
        tif        : 'TIFF изображение',
        tiff       : 'TIFF изображение',
        webp       : 'WebP изображение',
        wmf        : 'Файл векторной графики Windows',


        // Аудиофайлы
        aac        : 'AAC аудио файл',
        amr        : 'AMR аудио файл',
        flac       : 'FLAC аудио файл',
        m4a        : 'M4A аудио файл',
        mp3        : 'MP3 аудио файл',
        mpa        : 'MPA аудио файл',
        ogg        : 'OGG аудио файл',
        oga        : 'OGG аудио файл',
        opus       : 'Opus аудио файл',
        wav        : 'WAV аудио файл',
        wma        : 'WMA аудио файл',

        // Видеофайлы 
        asf        : 'Видеофайл ASF',
        avi        : 'Видеофайл AVI',
        flv        : 'Видеофайл FLV',
        m3u8       : 'Файл видеостриминга M3U8',
        mkv        : 'Видеофайл MKV',
        mp4        : 'Видеофайл MP4',
        mpeg       : 'Видеофайл MPEG',
        mpg        : 'Видеофайл MPEG',
        mov        : 'Видеофайл QuickTime',
        mxf        : 'Формат файла MXF (для вещания и производства)',
        ogv        : 'Видеофайл OGG',
        rm         : 'Видеофайл RealMedia',
        ts         : 'Видеофайл MPEG-TS',
        vob        : 'Формат файла VOB (формат видео DVD)',
        webm       : 'Видеофайл WebM',
        wmv        : 'Видеофайл WMV',

        // Архивы
        '7z'       : 'Файл сжатия с открытым исходным кодом',
        apk        : 'Android приложение',
        bin        : 'Двоичный файл',
        bz         : 'Bzip архив',
        bz2        : 'Bzip2 архив',
        cab        : 'MS CAB архив',
        dmg        : 'Образ диска',
        epub       : 'EPUB электронная книга',
        exe        : 'Исполняемый файл',
        gz         : 'Gzip архив',
        iso        : 'ISO образ',
        jar        : 'Java архив',
        mobi       : 'MOBI электронная книга',
        pdf        : 'PDF документ',
        rar        : 'RAR архив',
        tar        : 'TAR архив',
        tgz        : 'TAR.GZ архив',
        war        : 'Java архив',
        xz         : 'XZ архив',
        zip        : 'ZIP архив',
        zst        : 'Zstandard архив',

        // Офисные файлы
        doc        : 'MS Word файл',
        docx       : 'MS Word OpenXML файл',
        hwp        : 'Файл Hangul 97 и более поздних версий',
        hwpx       : 'Файл на основе XML Hancom (с Hancom Office 2018)',        
        key        : 'Apple Keynote файл',
        numbers    : 'Apple Numbers файл',
        odt        : 'OpenDocument текстовый файл',
        ods        : 'OpenDocument таблица',
        odp        : 'OpenDocument презентация',
        pages      : 'Apple Pages файл',
        ppt        : 'MS PowerPoint файл',
        pptx       : 'MS PowerPoint OpenXML файл',
        rtf        : 'RTF текстовый файл',
        tex        : 'TeX текстовый файл',
        xls        : 'MS Excel файл',
        xlsx       : 'MS Excel OpenXML файл',

        // Шрифты
        eot        : 'Embedded OpenType шрифт',
        otf        : 'OpenType шрифт',
        sfnt       : 'SFNT шрифт',
        ttf        : 'TrueType шрифт',
        woff       : 'Web Open шрифт',
        woff2      : 'Web Open шрифт 2',

        // Программирование
        c          : 'C исходный код',
        cpp        : 'C++ исходный код',
        go         : 'Go исходный код',
        java       : 'Java исходный код',
        jsx        : 'JavaScript JSX файл',
        php        : 'PHP файл',
        py         : 'Python исходный код',
        rb         : 'Ruby исходный код',
        sh         : 'Shell скрипт',
        swift      : 'Swift исходный код', 
        kotlin     : 'Kotlin исходный код',

        // Прочие файлы
        dockerfile : "Dockerfile", 
        bash       : "Bash скрипт", 
        pl         : "Perl серверный скрипт",
        cgi        : "CGI скрипт",
        toml       : "TOML конфигурационный файл",   
        crx        : 'Chrome расширение',
        deb        : 'Debian пакет',
        eml        : 'Email сообщение',
        ics        : 'Календарный файл',
        lz         : 'Lzip архив',
        lzma       : 'LZMA архив',
        msg        : 'Outlook сообщение',
        pkpass     : 'Apple Wallet Passbook файл',
        torrent    : 'BitTorrent файл',
        rpm        : 'RedHat пакет',
        swf        : 'Shockwave Flash файл',
        wasm       : 'WebAssembly бинарный файл',
    },
        
    // 스페인어
    es  : {
        // Archivos de texto
        conf       : 'Archivo de configuración',
        css        : 'Archivo CSS',
        csv        : 'Archivo CSV',
        htaccess   : "Archivo de configuración .htaccess",
        html       : 'Archivo HTML',
        htm        : 'Archivo HTML',
        ini        : 'Archivo de inicialización',
        json       : 'Archivo JSON',
        json5      : 'Archivo JSON5',
        js         : 'Archivo JavaScript',
        log        : 'Archivo de log',
        markdown   : 'Archivo Markdown',
        md         : 'Archivo Markdown',
        sql        : "Archivo SQL de base de datos",
        sqlite     : "Archivo SQL de base de datos SQLite",
        txt        : 'Archivo de texto',
        xml        : 'Archivo XML',
        yaml       : 'Archivo YAML',
        yml        : 'Archivo YAML',

        // Imágenes
        avif       : 'Imagen AVIF',
        bmp        : 'Imagen BMP',
        gif        : 'Imagen GIF',
        heic       : 'Imagen HEIC',
        heif       : 'Imagen HEIF',
        ico        : 'Icono',
        jp2        : 'Imagen JPEG 2000',
        jpx        : 'Imagen JPEG 2000',
        jpeg       : 'Imagen JPEG',
        jpg        : 'Imagen JPEG',
        png        : 'Imagen PNG',
        psd        : 'Imagen PSD',
        svg        : 'Imagen SVG',
        tif        : 'Imagen TIFF',
        tiff       : 'Imagen TIFF',
        webp       : 'Imagen WebP',
        wmf        : 'Archivo de gráficos vectoriales de Windows',


        // Archivos de audio
        aac        : 'Archivo de audio AAC',
        amr        : 'Archivo de audio AMR',
        flac       : 'Archivo de audio FLAC',
        m4a        : 'Archivo de audio M4A',
        mp3        : 'Archivo de audio MP3',
        mpa        : 'Archivo de audio MPA',
        ogg        : 'Archivo de audio OGG',
        oga        : 'Archivo de audio OGG',
        opus       : 'Archivo de audio Opus',
        wav        : 'Archivo de audio WAV',
        wma        : 'Archivo de audio WMA',

        // Archivos de video
        asf        : 'Archivo de video ASF',
        avi        : 'Archivo de video AVI',
        flv        : 'Archivo de video FLV',
        m3u8       : 'Archivo de transmisión de video M3U8',
        mkv        : 'Archivo de video MKV',
        mp4        : 'Archivo de video MP4',
        mpeg       : 'Archivo de video MPEG',
        mpg        : 'Archivo de video MPEG',
        mov        : 'Archivo de video QuickTime',
        mxf        : 'Formato de archivo MXF (para transmisión y producción)',
        ogv        : 'Archivo de video OGG',
        rm         : 'Archivo de video RealMedia',
        ts         : 'Archivo de video MPEG-TS',
        vob        : 'Formato de archivo VOB (formato de video DVD)',
        webm       : 'Archivo de video WebM',
        wmv        : 'Archivo de video WMV',

        // Archivos comprimidos
        '7z'       : 'Archivo de compresión de código abierto',
        apk        : 'Aplicación Android',
        bin        : 'Archivo binario',
        bz         : 'Archivo Bzip',
        bz2        : 'Archivo Bzip2',
        cab        : 'Archivo CAB de MS',
        dmg        : 'Imagen de disco',
        epub       : 'Libro electrónico EPUB',
        exe        : 'Archivo ejecutable',
        gz         : 'Archivo Gzip',
        iso        : 'Imagen ISO',
        jar        : 'Archivo Java',
        mobi       : 'Libro electrónico MOBI',
        pdf        : 'Documento PDF',
        rar        : 'Archivo RAR',
        tar        : 'Archivo TAR',
        tgz        : 'Archivo TAR.GZ',
        war        : 'Archivo Java WAR',
        xz         : 'Archivo XZ',
        zip        : 'Archivo ZIP',
        zst        : 'Archivo Zstandard',

        // Archivos de oficina
        doc        : 'Archivo MS Word',
        docx       : 'Archivo MS Word OpenXML',
        hwp        : 'Archivo de Hangul 97 y posteriores',
        hwpx       : 'Archivo basado en XML de Hangul (desde Hancom Office 2018)',
        key        : 'Archivo Apple Keynote',
        numbers    : 'Archivo Apple Numbers',
        odt        : 'Archivo de texto OpenDocument',
        ods        : 'Hoja de cálculo OpenDocument',
        odp        : 'Presentación OpenDocument',
        pages      : 'Archivo Apple Pages',
        ppt        : 'Archivo MS PowerPoint',
        pptx       : 'Archivo MS PowerPoint OpenXML',
        rtf        : 'Archivo de texto RTF',
        tex        : 'Archivo de texto TeX',
        xls        : 'Archivo MS Excel',
        xlsx       : 'Archivo MS Excel OpenXML',

        // Fuentes
        eot        : 'Fuente OpenType incrustada',
        otf        : 'Fuente OpenType',
        sfnt       : 'Fuente SFNT',
        ttf        : 'Fuente TrueType',
        woff       : 'Fuente Web Open',
        woff2      : 'Fuente Web Open 2',

        // Programación
        c          : 'Código fuente C',
        cpp        : 'Código fuente C++',
        go         : 'Código fuente Go',
        java       : 'Código fuente Java',
        jsx        : 'Archivo JavaScript JSX',
        php        : 'Archivo PHP',
        py         : 'Código fuente Python',
        rb         : 'Código fuente Ruby',
        sh         : 'Script Shell',
        swift      : 'Código fuente Swift', 
        kotlin     : 'Código fuente Kotlin',

        // Otros archivos
        dockerfile : "Dockerfile", 
        bash       : "Script Bash", 
        pl         : "Script Perl",
        cgi        : "Script CGI",
        toml       : "Archivo de configuración TOML",   
        crx        : 'Extensión de Chrome',
        deb        : 'Paquete Debian',
        eml        : 'Mensaje de correo electrónico',
        ics        : 'Archivo de calendario',
        lz         : 'Archivo Lzip',
        lzma       : 'Archivo LZMA',
        msg        : 'Mensaje Outlook',
        pkpass     : 'Archivo Passbook de Apple Wallet',
        torrent    : 'Archivo BitTorrent',
        rpm        : 'Paquete RedHat',
        swf        : 'Archivo Flash Shockwave',
        wasm       : 'Archivo binario WebAssembly',
    },

    // 아랍어
    ar : {
        // أنواع الملفات النصية
        conf       : 'ملف التكوين',
        css        : 'ملف CSS',
        csv        : 'ملف CSV',
        htaccess   : "ملف إعدادات الخادم .htaccess", 
        html       : 'ملف HTML',
        htm        : 'ملف HTML',
        ini        : 'ملف الإعدادات',
        json       : 'ملف JSON',
        json5      : 'ملف JSON5',
        js         : 'ملف JavaScript',
        log        : 'ملف السجل',
        markdown   : 'ملف Markdown',
        md         : 'ملف Markdown', 
        sql        : "ملف قاعدة بيانات SQL", 
        sqlite     : "ملف قاعدة بيانات SQLite", 
        txt        : 'ملف نصي',
        xml        : 'ملف XML',
        yaml       : 'ملف YAML',
        yml        : 'ملف YAML',

        // أنواع الملفات الصور
        avif       : 'ملف صورة AVIF',
        bmp        : 'ملف صورة BMP',
        gif        : 'ملف صورة GIF',
        heic       : 'ملف صورة HEIC',
        heif       : 'ملف صورة HEIF',
        ico        : 'ملف صورة أيقونة',
        jp2        : 'ملف صورة JPEG 2000',
        jpx        : 'ملف صورة JPEG 2000',
        jpeg       : 'ملف صورة JPEG',
        jpg        : 'ملف صورة JPEG',
        png        : 'ملف صورة PNG',
        psd        : 'ملف صورة Photoshop',
        svg        : 'ملف صورة SVG',
        tif        : 'ملف صورة TIFF',
        tiff       : 'ملف صورة TIFF',
        webp       : 'ملف صورة WebP',
        wmf        : 'ملف الرسومات المتجهة لـ Windows',

        // أنواع الملفات الصوتية
        aac        : 'ملف صوتي AAC',
        amr        : 'ملف صوتي AMR',
        flac       : 'ملف صوتي FLAC',
        m4a        : 'ملف صوتي M4A',
        mp3        : 'ملف صوتي MP3',
        mpa        : 'ملف صوتي MPA',
        ogg        : 'ملف صوتي OGG',
        oga        : 'ملف صوتي OGG',
        opus       : 'ملف صوتي Opus',
        wav        : 'ملف صوتي WAV',
        wma        : 'ملف صوتي WMA',
            
        // أنواع الملفات الفيديو
        asf        : 'ملف فيديو ASF',
        avi        : 'ملف فيديو AVI',
        flv        : 'ملف فيديو FLV',
        m3u8       : 'ملف بث فيديو M3U8',
        mkv        : 'ملف فيديو MKV',
        mp4        : 'ملف فيديو MP4',
        mpeg       : 'ملف فيديو MPEG',
        mpg        : 'ملف فيديو MPEG',
        mov        : 'ملف فيديو QuickTime',
        mxf        : 'صيغة ملف MXF (للإنتاج والبث)',
        ogv        : 'ملف فيديو OGG',
        rm         : 'ملف فيديو RealMedia',
        ts         : 'ملف فيديو MPEG-TS',
        vob        : 'صيغة ملف VOB (صيغة فيديو DVD)',
        webm       : 'ملف فيديو WebM',
        wmv        : 'ملف فيديو WMV',

        // أنواع الملفات المضغوطة 
        '7z'       : 'ملف ضغط مفتوح المصدر',
        apk        : 'ملف تطبيق أندرويد',
        bin        : 'ملف بيانات ثنائي',
        bz         : 'ملف ضغط Bzip',
        bz2        : 'ملف ضغط Bzip2',
        cab        : 'ملف ضغط MS CAB',
        dmg        : 'ملف صورة قرص',
        epub       : 'ملف كتاب إلكتروني EPUB',
        exe        : 'ملف تنفيذي',
        gz         : 'ملف ضغط Gzip',
        iso        : 'ملف صورة ISO',
        jar        : 'ملف أرشيف Java',
        mobi       : 'ملف كتاب إلكتروني MOBI',
        pdf        : 'ملف مستند PDF',
        rar        : 'ملف ضغط RAR',
        tar        : 'ملف أرشيف TAR',
        tgz        : 'ملف ضغط TAR.GZ',
        war        : 'ملف أرشيف Java',
        xz         : 'ملف ضغط XZ',
        zip        : 'ملف ضغط ZIP',
        zst        : 'ملف ضغط Zstandard',

        // أنواع ملفات مستندات المكتب
        doc        : 'ملف مستند MS Word',
        docx       : 'ملف مستند MS Word OpenXML',
        hwp        : 'ملف هانغول 97 وما بعده',
        hwpx       : 'ملف يعتمد على XML من هانغول (من Hancom Office 2018)',
        key        : 'ملف Keynote من Apple',
        numbers    : 'ملف Numbers من Apple',
        odt        : 'ملف نصي OpenDocument',
        ods        : 'ملف جدول بيانات OpenDocument',
        odp        : 'ملف عرض تقديمي OpenDocument',
        pages      : 'ملف Pages من Apple',
        ppt        : 'ملف PowerPoint من MS',
        pptx       : 'ملف PowerPoint من MS OpenXML',
        rtf        : 'ملف نصي RTF',
        tex        : 'ملف نصي TeX',
        xls        : 'ملف Excel من MS',
        xlsx       : 'ملف Excel من MS OpenXML',

        // أنواع ملفات الخطوط
        eot        : 'ملف خط OpenType مضمن',
        otf        : 'ملف خط OpenType',
        sfnt       : 'ملف خط SFNT',
        ttf        : 'ملف خط TrueType',
        woff       : 'ملف خط ويب Open Font',
        woff2      : 'ملف خط ويب Open Font 2',

        // أنواع ملفات البرمجة
        c          : 'ملف شفرة مصدر C',
        cpp        : 'ملف شفرة مصدر C++',
        go         : 'ملف شفرة مصدر Go',
        java       : 'ملف شفرة مصدر Java',
        jsx        : 'ملف JavaScript JSX',
        php        : 'ملف PHP',
        py         : 'ملف شفرة مصدر Python',
        rb         : 'ملف شفرة مصدر Ruby',
        sh         : 'ملف سكربت Shell',
        swift      : 'ملف شفرة مصدر Swift', 
        kotlin     : 'ملف شفرة مصدر Kotlin',

        // أنواع أخرى من الملفات
        dockerfile : "ملف Dockerfile", 
        bash       : "ملف سكربت Bash", 
        pl         : "ملف سكربت Perl",
        cgi        : "ملف سكربت CGI",
        toml       : "ملف تكوين TOML",   
        crx        : 'ملف إضافة Chrome',
        deb        : 'ملف حزمة Debian',
        eml        : 'ملف رسالة بريد إلكتروني',
        ics        : 'ملف تقويم',
        lz         : 'ملف ضغط Lzip',
        lzma       : 'ملف ضغط LZMA',
        msg        : 'ملف رسالة Outlook',
        pkpass     : 'ملف Apple Wallet Passbook',
        torrent    : 'ملف BitTorrent',
        rpm        : 'ملف حزمة RedHat',
        swf        : 'ملف Shockwave Flash',
        wasm       : 'ملف WebAssembly ثنائي',
    },

    
    // 일본어
    ja   : {
        // テキストファイル
        conf       : '設定ファイル',
        css        : 'CSSファイル',
        csv        : 'CSVファイル',
        htaccess   : ".htaccess設定ファイル",
        html       : 'HTMLファイル',
        htm        : 'HTMLファイル',
        ini        : '初期化ファイル',
        json       : 'JSONファイル',
        json5      : 'JSON5ファイル',
        js         : 'JavaScriptファイル',
        log        : 'ログファイル',
        markdown   : 'Markdownファイル',
        md         : 'Markdownファイル',
        sql        : 'データベースSQLファイル',
        sqlite     : 'SQLiteデータベースSQLファイル',
        txt        : 'テキストファイル',
        xml        : 'XMLファイル',
        yaml       : 'YAMLファイル',
        yml        : 'YAMLファイル',

        // 画像
        avif       : 'AVIF画像',
        bmp        : 'BMP画像',
        gif        : 'GIF画像',
        heic       : 'HEIC画像',
        heif       : 'HEIF画像',
        ico        : 'アイコン',
        jp2        : 'JPEG 2000画像',
        jpx        : 'JPEG 2000画像',
        jpeg       : 'JPEG画像',
        jpg        : 'JPEG画像',
        png        : 'PNG画像',
        psd        : 'PSD画像',
        svg        : 'SVG画像',
        tif        : 'TIFF画像',
        tiff       : 'TIFF画像',
        webp       : 'WebP画像',
        wmf        : 'Windows ベクター グラフィックス ファイル',

        // 音声ファイル
        aac        : 'AAC音声ファイル',
        amr        : 'AMR音声ファイル',
        flac       : 'FLAC音声ファイル',
        m4a        : 'M4A音声ファイル',
        mp3        : 'MP3音声ファイル',
        mpa        : 'MPA音声ファイル',
        ogg        : 'OGG音声ファイル',
        oga        : 'OGG音声ファイル',
        opus       : 'Opus音声ファイル',
        wav        : 'WAV音声ファイル',
        wma        : 'WMA音声ファイル',

        // 動画ファイル 
        asf        : 'ASFビデオファイル',
        avi        : 'AVIビデオファイル',
        flv        : 'FLVビデオファイル',
        m3u8       : 'M3U8ビデオストリーミングファイル',
        mkv        : 'MKVビデオファイル',
        mp4        : 'MP4ビデオファイル',
        mpeg       : 'MPEGビデオファイル',
        mpg        : 'MPEGビデオファイル',
        mov        : 'QuickTimeビデオファイル',
        mxf        : 'MXFファイル形式（放送および制作用）',
        ogv        : 'OGGビデオファイル',
        rm         : 'RealMediaビデオファイル',
        ts         : 'MPEG-TSビデオファイル',
        vob        : 'VOBファイル形式（DVDビデオフォーマット）',
        webm       : 'WebMビデオファイル',
        wmv        : 'WMVビデオファイル',

        // 圧縮ファイル
        '7z'       : 'オープンソース圧縮ファイル',
        apk        : 'Androidアプリケーション',
        bin        : 'バイナリファイル',
        bz         : 'Bzipアーカイブ',
        bz2        : 'Bzip2アーカイブ',
        cab        : 'MS CABアーカイブ',
        dmg        : 'ディスクイメージ',
        epub       : 'EPUB電子書籍',
        exe        : '実行可能ファイル',
        gz         : 'Gzipアーカイブ',
        iso        : 'ISOイメージファイル',
        jar        : 'Javaアーカイブ',
        mobi       : 'MOBI電子書籍',
        pdf        : 'PDFファイル',
        rar        : 'RARアーカイブ',
        tar        : 'TARアーカイブ',
        tgz        : 'TAR.GZアーカイブ',
        war        : 'Java WARアーカイブ',
        xz         : 'XZアーカイブ',
        zip        : 'ZIPアーカイブ',
        zst        : 'Zstandardアーカイブ',

        // オフィスファイル
        doc        : 'MS Wordファイル',
        docx       : 'MS Word OpenXMLファイル',
        hwp        : 'ハングル 97 以降のファイル',
        hwpx       : 'ハングル XML ベースのファイル（Hancom Office 2018 以降）',
        key        : 'Apple Keynoteファイル',
        numbers    : 'Apple Numbersファイル',
        odt        : 'OpenDocumentテキストファイル',
        ods        : 'OpenDocumentスプレッドシート',
        odp        : 'OpenDocumentプレゼンテーション',
        pages      : 'Apple Pagesファイル',
        ppt        : 'MS PowerPointファイル',
        pptx       : 'MS PowerPoint OpenXMLファイル',
        rtf        : 'RTFテキストファイル',
        tex        : 'TeXテキストファイル',
        xls        : 'MS Excelファイル',
        xlsx       : 'MS Excel OpenXMLファイル',

        // フォントファイル
        eot        : '埋め込みOpenTypeフォント',
        otf        : 'OpenTypeフォント',
        sfnt       : 'SFNTフォント',
        ttf        : 'TrueTypeフォント',
        woff       : 'Web Openフォント',
        woff2      : 'Web Openフォント2',

        // プログラミングコード
        c          : 'Cソースコード',
        cpp        : 'C++ソースコード',
        go         : 'Goソースコード',
        java       : 'Javaソースコード',
        jsx        : 'JavaScript JSXファイル',
        php        : 'PHPファイル',
        py         : 'Pythonソースコード',
        rb         : 'Rubyソースコード',
        sh         : 'シェルスクリプト',
        swift      : 'Swiftソースコード',
        kotlin     : 'Kotlinソースコード',

        // その他のファイル
        dockerfile : "Dockerfile",
        bash       : "Bashスクリプト",
        pl         : "Perlスクリプト",
        cgi        : "CGIスクリプト",
        toml       : "TOML設定ファイル",
        crx        : 'Chrome拡張機能',
        deb        : 'Debianパッケージ',
        eml        : 'メールメッセージ',
        ics        : 'カレンダーファイル',
        lz         : 'Lzipアーカイブ',
        lzma       : 'LZMAアーカイブ',
        msg        : 'Outlookメッセージ',
        pkpass     : 'Apple Wallet Passbookファイル',
        torrent    : 'BitTorrentファイル',
        rpm        : 'RedHatパッケージ',
        swf        : 'Shockwave Flashファイル',
        wasm       : 'WebAssemblyバイナリファイル',
    },
        
    // 중국어
    zh  : {
        // 文本文件
        conf       : '配置文件',
        css        : 'CSS文件',
        csv        : 'CSV文件',
        htaccess   : ".htaccess配置文件",
        html       : 'HTML文件',
        htm        : 'HTML文件',
        ini        : '初始化文件',
        json       : 'JSON文件',
        json5      : 'JSON5文件',
        js         : 'JavaScript文件',
        log        : '日志文件',
        markdown   : 'Markdown文件',
        md         : 'Markdown文件',
        sql        : '数据库SQL文件',
        sqlite     : 'SQLite数据库SQL文件',
        txt        : '文本文件',
        xml        : 'XML文件',
        yaml       : 'YAML文件',
        yml        : 'YAML文件',

        // 图片
        avif       : 'AVIF图片',
        bmp        : 'BMP图片',
        gif        : 'GIF图片',
        heic       : 'HEIC图片',
        heif       : 'HEIF图片',
        ico        : '图标文件',
        jp2        : 'JPEG 2000图片',
        jpx        : 'JPEG 2000图片',
        jpeg       : 'JPEG图片',
        jpg        : 'JPEG图片',
        png        : 'PNG图片',
        psd        : 'PSD图片',
        svg        : 'SVG图片',
        tif        : 'TIFF图片',
        tiff       : 'TIFF图片',
        webp       : 'WebP图片',
        wmf        : 'Windows 矢量图形文件',

        // 音频文件
        aac        : 'AAC音频文件',
        amr        : 'AMR音频文件',
        flac       : 'FLAC音频文件',
        m4a        : 'M4A音频文件',
        mp3        : 'MP3音频文件',
        mpa        : 'MPA音频文件',
        ogg        : 'OGG音频文件',
        oga        : 'OGG音频文件',
        opus       : 'Opus音频文件',
        wav        : 'WAV音频文件',
        wma        : 'WMA音频文件',

        // 视频文件
        asf        : 'ASF视频文件',
        avi        : 'AVI视频文件',
        flv        : 'FLV视频文件',
        m3u8       : 'M3U8视频流文件',
        mkv        : 'MKV视频文件',
        mp4        : 'MP4视频文件',
        mpeg       : 'MPEG视频文件',
        mpg        : 'MPEG视频文件',
        mov        : 'QuickTime视频文件',
        mxf        : 'MXF文件格式（广播和制作用）',
        ogv        : 'OGG视频文件',
        rm         : 'RealMedia视频文件',
        ts         : 'MPEG-TS视频文件',
        vob        : 'VOB文件格式（DVD视频格式）',
        webm       : 'WebM视频文件',
        wmv        : 'WMV视频文件',

        // 压缩文件
        '7z'       : '开源压缩文件',
        apk        : 'Android应用程序',
        bin        : '二进制文件',
        bz         : 'Bzip归档',
        bz2        : 'Bzip2归档',
        cab        : 'MS CAB归档',
        dmg        : '磁盘映像文件',
        epub       : 'EPUB电子书',
        exe        : '可执行文件',
        gz         : 'Gzip归档',
        iso        : 'ISO映像文件',
        jar        : 'Java归档',
        mobi       : 'MOBI电子书',
        pdf        : 'PDF文件',
        rar        : 'RAR归档',
        tar        : 'TAR归档',
        tgz        : 'TAR.GZ归档',
        war        : 'Java WAR归档',
        xz         : 'XZ归档',
        zip        : 'ZIP归档',
        zst        : 'Zstandard归档',

        // 办公文件
        doc        : 'MS Word文件',
        docx       : 'MS Word OpenXML文件',
        hwp        : '韩文 97 及之后文件',
        hwpx       : '基于 XML 的韩文文件（自 Hancom Office 2018 起）',
        key        : 'Apple Keynote文件',
        numbers    : 'Apple Numbers文件',
        odt        : 'OpenDocument文本文件',
        ods        : 'OpenDocument电子表格',
        odp        : 'OpenDocument演示文稿',
        pages      : 'Apple Pages文件',
        ppt        : 'MS PowerPoint文件',
        pptx       : 'MS PowerPoint OpenXML文件',
        rtf        : 'RTF文本文件',
        tex        : 'TeX文本文件',
        xls        : 'MS Excel文件',
        xlsx       : 'MS Excel OpenXML文件',

        // 字体文件
        eot        : '嵌入式OpenType字体',
        otf        : 'OpenType字体',
        sfnt       : 'SFNT字体',
        ttf        : 'TrueType字体',
        woff       : 'Web Open字体',
        woff2      : 'Web Open字体2',

        // 编程代码文件
        c          : 'C源代码',
        cpp        : 'C++源代码',
        go         : 'Go源代码',
        java       : 'Java源代码',
        jsx        : 'JavaScript JSX文件',
        php        : 'PHP文件',
        py         : 'Python源代码',
        rb         : 'Ruby源代码',
        sh         : 'Shell脚本文件',
        swift      : 'Swift源代码',
        kotlin     : 'Kotlin源代码',

        // 其他文件
        dockerfile : "Dockerfile",
        bash       : "Bash脚本",
        pl         : "Perl脚本",
        cgi        : "CGI脚本",
        toml       : "TOML配置文件",
        crx        : 'Chrome扩展',
        deb        : 'Debian软件包',
        eml        : '电子邮件文件',
        ics        : '日历文件',
        lz         : 'Lzip归档',
        lzma       : 'LZMA归档',
        msg        : 'Outlook邮件',
        pkpass     : 'Apple Wallet Passbook文件',
        torrent    : 'BitTorrent文件',
        rpm        : 'RedHat软件包',
        swf        : 'Shockwave Flash文件',
        wasm       : 'WebAssembly二进制文件',
    },
    
    // 베트남어 
    vi  : {
        // Tệp văn bản
        conf       : 'Tệp cấu hình',
        css        : 'Tệp CSS',
        csv        : 'Tệp CSV',
        htaccess   : "Tệp cấu hình .htaccess",
        html       : 'Tệp HTML',
        htm        : 'Tệp HTML',
        ini        : 'Tệp cấu hình',
        json       : 'Tệp JSON',
        json5      : 'Tệp JSON5',
        js         : 'Tệp JavaScript',
        log        : 'Tệp nhật ký',
        markdown   : 'Tệp Markdown',
        md         : 'Tệp Markdown',
        sql        : 'Tệp SQL cơ sở dữ liệu',
        sqlite     : 'Tệp SQL cơ sở dữ liệu SQLite',
        txt        : 'Tệp văn bản',
        xml        : 'Tệp XML',
        yaml       : 'Tệp YAML',
        yml        : 'Tệp YAML',

        // Hình ảnh
        avif       : 'Hình ảnh AVIF',
        bmp        : 'Hình ảnh BMP',
        gif        : 'Hình ảnh GIF',
        heic       : 'Hình ảnh HEIC',
        heif       : 'Hình ảnh HEIF',
        ico        : 'Tệp biểu tượng',
        jp2        : 'Hình ảnh JPEG 2000',
        jpx        : 'Hình ảnh JPEG 2000',
        jpeg       : 'Hình ảnh JPEG',
        jpg        : 'Hình ảnh JPEG',
        png        : 'Hình ảnh PNG',
        psd        : 'Hình ảnh PSD',
        svg        : 'Hình ảnh SVG',
        tif        : 'Hình ảnh TIFF',
        tiff       : 'Hình ảnh TIFF',
        webp       : 'Hình ảnh WebP',
        wmf        : 'Tệp đồ họa vector Windows',

        // Tệp âm thanh
        aac        : 'Tệp âm thanh AAC',
        amr        : 'Tệp âm thanh AMR',
        flac       : 'Tệp âm thanh FLAC',
        m4a        : 'Tệp âm thanh M4A',
        mp3        : 'Tệp âm thanh MP3',
        mpa        : 'Tệp âm thanh MPA',
        ogg        : 'Tệp âm thanh OGG',
        oga        : 'Tệp âm thanh OGG',
        opus       : 'Tệp âm thanh Opus',
        wav        : 'Tệp âm thanh WAV',
        wma        : 'Tệp âm thanh WMA',

        // Tệp video
        asf        : 'Tệp video ASF',
        avi        : 'Tệp video AVI',
        flv        : 'Tệp video FLV',
        m3u8       : 'Tệp phát trực tuyến video M3U8',
        mkv        : 'Tệp video MKV',
        mp4        : 'Tệp video MP4',
        mpeg       : 'Tệp video MPEG',
        mpg        : 'Tệp video MPEG',
        mov        : 'Tệp video QuickTime',
        mxf        : 'Định dạng tệp MXF (cho phát sóng và sản xuất)',
        ogv        : 'Tệp video OGG',
        rm         : 'Tệp video RealMedia',
        ts         : 'Tệp video MPEG-TS',
        vob        : 'Định dạng tệp VOB (định dạng video DVD)',
        webm       : 'Tệp video WebM',
        wmv        : 'Tệp video WMV',

        // Tệp nén
        '7z'       : 'Нээлттэй эхийн шахалтын файл',
        apk        : 'Ứng dụng Android',
        bin        : 'Tệp nhị phân',
        bz         : 'Lưu trữ Bzip',
        bz2        : 'Lưu trữ Bzip2',
        cab        : 'Lưu trữ MS CAB',
        dmg        : 'Tệp ảnh đĩa',
        epub       : 'Sách điện tử EPUB',
        exe        : 'Tệp thực thi',
        gz         : 'Lưu trữ Gzip',
        iso        : 'Tệp ảnh ISO',
        jar        : 'Lưu trữ Java',
        mobi       : 'Sách điện tử MOBI',
        pdf        : 'Tệp PDF',
        rar        : 'Lưu trữ RAR',
        tar        : 'Lưu trữ TAR',
        tgz        : 'Lưu trữ TAR.GZ',
        war        : 'Lưu trữ Java WAR',
        xz         : 'Lưu trữ XZ',
        zip        : 'Lưu trữ ZIP',
        zst        : 'Lưu trữ Zstandard',

        // Tệp văn phòng
        doc        : 'Tệp MS Word',
        docx       : 'Tệp MS Word OpenXML',
        hwp        : 'Tệp Hangul 97 và các phiên bản sau',
        hwpx       : 'Tệp dựa trên XML Hangul (từ Hancom Office 2018)',
        key        : 'Tệp Apple Keynote',
        numbers    : 'Tệp Apple Numbers',
        odt        : 'Tệp văn bản OpenDocument',
        ods        : 'Tệp bảng tính OpenDocument',
        odp        : 'Tệp thuyết trình OpenDocument',
        pages      : 'Tệp Apple Pages',
        ppt        : 'Tệp MS PowerPoint',
        pptx       : 'Tệp MS PowerPoint OpenXML',
        rtf        : 'Tệp văn bản RTF',
        tex        : 'Tệp văn bản TeX',
        xls        : 'Tệp MS Excel',
        xlsx       : 'Tệp MS Excel OpenXML',

        // Tệp phông chữ
        eot        : 'Phông chữ OpenType nhúng',
        otf        : 'Phông chữ OpenType',
        sfnt       : 'Phông chữ SFNT',
        ttf        : 'Phông chữ TrueType',
        woff       : 'Phông chữ Web Open',
        woff2      : 'Phông chữ Web Open 2',

        // Tệp mã nguồn
        c          : 'Mã nguồn C',
        cpp        : 'Mã nguồn C++',
        go         : 'Mã nguồn Go',
        java       : 'Mã nguồn Java',
        jsx        : 'Tệp JavaScript JSX',
        php        : 'Tệp PHP',
        py         : 'Mã nguồn Python',
        rb         : 'Mã nguồn Ruby',
        sh         : 'Tệp script Shell',
        swift      : 'Mã nguồn Swift',
        kotlin     : 'Mã nguồn Kotlin',

        // Tệp khác
        dockerfile : "Dockerfile",
        bash       : "Tệp script Bash",
        pl         : "Tệp script Perl",
        cgi        : "Tệp script CGI",
        toml       : "Tệp cấu hình TOML",
        crx        : 'Tệp mở rộng Chrome',
        deb        : 'Gói phần mềm Debian',
        eml        : 'Tệp email',
        ics        : 'Tệp lịch',
        lz         : 'Lưu trữ Lzip',
        lzma       : 'Lưu trữ LZMA',
        msg        : 'Tệp email Outlook',
        pkpass     : 'Tệp Apple Wallet Passbook',
        torrent    : 'Tệp BitTorrent',
        rpm        : 'Gói phần mềm RedHat',
        swf        : 'Tệp Flash Shockwave',
        wasm       : 'Tệp nhị phân WebAssembly',
    },

    //몽골어
    mn  : {
         // Текст файлууд
        conf       : 'Тохиргооны файл',
        css        : 'CSS файл',
        csv        : 'CSV файл',
        htaccess   : "Тохиргооны .htaccess файл",
        html       : 'HTML файл',
        htm        : 'HTML файл',
        ini        : 'Тохиргооны файл',
        json       : 'JSON файл',
        json5      : 'JSON5 файл',
        js         : 'JavaScript файл',
        log        : 'Тамгын файл',
        markdown   : 'Markdown файл',
        md         : 'Markdown файл',
        sql        : 'Мэдээллийн сангийн SQL файл',
        sqlite     : 'SQLite мэдээллийн сангийн SQL файл',
        txt        : 'Текст файл',
        xml        : 'XML файл',
        yaml       : 'YAML файл',
        yml        : 'YAML файл',

        // Зураг
        avif       : 'AVIF зураг',
        bmp        : 'BMP зураг',
        gif        : 'GIF зураг',
        heic       : 'HEIC зураг',
        heif       : 'HEIF зураг',
        ico        : 'Иконы файл',
        jp2        : 'JPEG 2000 зураг',
        jpx        : 'JPEG 2000 зураг',
        jpeg       : 'JPEG зураг',
        jpg        : 'JPEG зураг',
        png        : 'PNG зураг',
        psd        : 'PSD зураг',
        svg        : 'SVG зураг',
        tif        : 'TIFF зураг',
        tiff       : 'TIFF зураг',
        webp       : 'WebP зураг',
        wmf        : 'Windows вектор график файл',

        // Дууны файл
        aac        : 'AAC дууны файл',
        amr        : 'AMR дууны файл',
        flac       : 'FLAC дууны файл',
        m4a        : 'M4A дууны файл',
        mp3        : 'MP3 дууны файл',
        mpa        : 'MPA дууны файл',
        ogg        : 'OGG дууны файл',
        oga        : 'OGG дууны файл',
        opus       : 'Opus дууны файл',
        wav        : 'WAV дууны файл',
        wma        : 'WMA дууны файл',

        // Видео файл
        asf        : 'ASF видео файл',
        avi        : 'AVI видео файл',
        flv        : 'FLV видео файл',
        m3u8       : 'M3U8 видео стрийминг файл',
        mkv        : 'MKV видео файл',
        mp4        : 'MP4 видео файл',
        mpeg       : 'MPEG видео файл',
        mpg        : 'MPEG видео файл',
        mov        : 'QuickTime видео файл',
        mxf        : 'MXF файл формат (телевизийн болон үйлдвэрлэлийн зориулалттай)',
        ogv        : 'OGG видео файл',
        rm         : 'RealMedia видео файл',
        ts         : 'MPEG-TS видео файл',
        vob        : 'VOB файл формат (DVD видео формат)',
        webm       : 'WebM видео файл',
        wmv        : 'WMV видео файл',

        // Шифрлэгдсэн файл
        '7z'       : 'Tệp nén mã nguồn mở',
        apk        : 'Android програм',
        bin        : 'Хоёртын файл',
        bz         : 'Bzip архив',
        bz2        : 'Bzip2 архив',
        cab        : 'MS CAB архив',
        dmg        : 'Дискийн дүрс файл',
        epub       : 'EPUB цахим ном',
        exe        : 'Гүйцэтгэх файл',
        gz         : 'Gzip архив',
        iso        : 'ISO дүрс файл',
        jar        : 'Java архив',
        mobi       : 'MOBI цахим ном',
        pdf        : 'PDF файл',
        rar        : 'RAR архив',
        tar        : 'TAR архив',
        tgz        : 'TAR.GZ архив',
        war        : 'Java WAR архив',
        xz         : 'XZ архив',
        zip        : 'ZIP архив',
        zst        : 'Zstandard архив',

        // Оффисын файл
        doc        : 'MS Word файл',
        docx       : 'MS Word OpenXML файл',
        hwp        : 'Hangul 97 болон дараагийн хувилбарын файл',
        hwpx       : 'Hangul XML суурилсан файл (Hancom Office 2018-с эхлэн)',
        key        : 'Apple Keynote файл',
        numbers    : 'Apple Numbers файл',
        odt        : 'OpenDocument текст файл',
        ods        : 'OpenDocument хүснэгт файл',
        odp        : 'OpenDocument танилцуулга файл',
        pages      : 'Apple Pages файл',
        ppt        : 'MS PowerPoint файл',
        pptx       : 'MS PowerPoint OpenXML файл',
        rtf        : 'RTF текст файл',
        tex        : 'TeX текст файл',
        xls        : 'MS Excel файл',
        xlsx       : 'MS Excel OpenXML файл',

        // Фонт файлууд
        eot        : 'Эмбэдэгдсэн OpenType фонт',
        otf        : 'OpenType фонт',
        sfnt       : 'SFNT фонт',
        ttf        : 'TrueType фонт',
        woff       : 'Web Open фонт',
        woff2      : 'Web Open фонт 2',

        // Кодын файлууд
        c          : 'C код',
        cpp        : 'C++ код',
        go         : 'Go код',
        java       : 'Java код',
        jsx        : 'JavaScript JSX файл',
        php        : 'PHP код',
        py         : 'Python код',
        rb         : 'Ruby код',
        sh         : 'Shell скрипт файл',
        swift      : 'Swift код',
        kotlin     : 'Kotlin код',

        // Бусад файл
        dockerfile : "Docker файл",
        bash       : "Bash скрипт файл",
        pl         : "Perl скрипт файл",
        cgi        : "CGI скрипт файл",
        toml       : "TOML тохиргооны файл",
        crx        : 'Chrome өргөтгөл файл',
        deb        : 'Debian програмын багц',
        eml        : 'Цахим шуудан файл',
        ics        : 'Календарийн файл',
        lz         : 'Lzip архив',
        lzma       : 'LZMA архив',
        msg        : 'Outlook цахим шуудан файл',
        pkpass     : 'Apple Wallet Passbook файл',
        torrent    : 'BitTorrent файл',
        rpm        : 'RedHat програмын багц',
        swf        : 'Flash Shockwave файл',
        wasm       : 'WebAssembly хоёртын файл',
    },

    // 태국어
    th  : {
        // ไฟล์ข้อความ
        conf       : 'ไฟล์การตั้งค่า',
        css        : 'ไฟล์ CSS',
        csv        : 'ไฟล์ CSV',
        htaccess   : 'ไฟล์การตั้งค่า .htaccess',
        html       : 'ไฟล์ HTML',
        htm        : 'ไฟล์ HTML',
        ini        : 'ไฟล์การตั้งค่า',
        json       : 'ไฟล์ JSON',
        json5      : 'ไฟล์ JSON5',
        js         : 'ไฟล์ JavaScript',
        log        : 'ไฟล์ล็อก',
        markdown   : 'ไฟล์ Markdown',
        md         : 'ไฟล์ Markdown',
        sql        : 'ไฟล์ SQL ฐานข้อมูล',
        sqlite     : 'ไฟล์ SQL ฐานข้อมูล SQLite',
        txt        : 'ไฟล์ข้อความ',
        xml        : 'ไฟล์ XML',
        yaml       : 'ไฟล์ YAML',
        yml        : 'ไฟล์ YAML',

        // รูปภาพ
        avif       : 'ไฟล์รูปภาพ AVIF',
        bmp        : 'ไฟล์รูปภาพ BMP',
        gif        : 'ไฟล์รูปภาพ GIF',
        heic       : 'ไฟล์รูปภาพ HEIC',
        heif       : 'ไฟล์รูปภาพ HEIF',
        ico        : 'ไฟล์ไอคอน',
        jp2        : 'ไฟล์รูปภาพ JPEG 2000',
        jpx        : 'ไฟล์รูปภาพ JPEG 2000',
        jpeg       : 'ไฟล์รูปภาพ JPEG',
        jpg        : 'ไฟล์รูปภาพ JPEG',
        png        : 'ไฟล์รูปภาพ PNG',
        psd        : 'ไฟล์รูปภาพ PSD',
        svg        : 'ไฟล์รูปภาพ SVG',
        tif        : 'ไฟล์รูปภาพ TIFF',
        tiff       : 'ไฟล์รูปภาพ TIFF',
        webp       : 'ไฟล์รูปภาพ WebP',
        wmf        : 'ไฟล์กราฟิกเวกเตอร์ของ Windows',

        // ไฟล์เสียง
        aac        : 'ไฟล์เสียง AAC',
        amr        : 'ไฟล์เสียง AMR',
        flac       : 'ไฟล์เสียง FLAC',
        m4a        : 'ไฟล์เสียง M4A',
        mp3        : 'ไฟล์เสียง MP3',
        mpa        : 'ไฟล์เสียง MPA',
        ogg        : 'ไฟล์เสียง OGG',
        oga        : 'ไฟล์เสียง OGG',
        opus       : 'ไฟล์เสียง Opus',
        wav        : 'ไฟล์เสียง WAV',
        wma        : 'ไฟล์เสียง WMA',

        // ไฟล์วิดีโอ
        asf        : 'ไฟล์วิดีโอ ASF',
        avi        : 'ไฟล์วิดีโอ AVI',
        flv        : 'ไฟล์วิดีโอ FLV',
        m3u8       : 'ไฟล์สตรีมมิ่งวิดีโอ M3U8',
        mkv        : 'ไฟล์วิดีโอ MKV',
        mp4        : 'ไฟล์วิดีโอ MP4',
        mpeg       : 'ไฟล์วิดีโอ MPEG',
        mpg        : 'ไฟล์วิดีโอ MPEG',
        mov        : 'ไฟล์วิดีโอ QuickTime',
        mxf        : 'รูปแบบไฟล์ MXF (สำหรับการออกอากาศและการผลิต)',
        ogv        : 'ไฟล์วิดีโอ OGG',
        rm         : 'ไฟล์วิดีโอ RealMedia',
        ts         : 'ไฟล์วิดีโอ MPEG-TS',
        vob        : 'รูปแบบไฟล์ VOB (รูปแบบวิดีโอ DVD)',
        webm       : 'ไฟล์วิดีโอ WebM',
        wmv        : 'ไฟล์วิดีโอ WMV',

        // ไฟล์ที่ถูกเข้ารหัส
        '7z'       : 'ไฟล์บีบอัดแบบโอเพนซอร์ส',
        apk        : 'ไฟล์แอป Android',
        bin        : 'ไฟล์ไบนารี',
        bz         : 'ไฟล์บีzip',
        bz2        : 'ไฟล์บีzip2',
        cab        : 'ไฟล์บีzip MS',
        dmg        : 'ไฟล์อิมเมจดิสก์',
        epub       : 'ไฟล์ eBook EPUB',
        exe        : 'ไฟล์โปรแกรม',
        gz         : 'ไฟล์ Gzip',
        iso        : 'ไฟล์อิมเมจ ISO',
        jar        : 'ไฟล์ Java',
        mobi       : 'ไฟล์ eBook MOBI',
        pdf        : 'ไฟล์ PDF',
        rar        : 'ไฟล์ RAR',
        tar        : 'ไฟล์ TAR',
        tgz        : 'ไฟล์ TAR.GZ',
        war        : 'ไฟล์ WAR Java',
        xz         : 'ไฟล์ XZ',
        zip        : 'ไฟล์ ZIP',
        zst        : 'ไฟล์ Zstandard',

        // ไฟล์สำนักงาน
        doc        : 'ไฟล์ MS Word',
        docx       : 'ไฟล์ MS Word OpenXML',
        hwp        : 'ไฟล์ Hangul 97 และเวอร์ชันที่ใหม่กว่า',
        hwpx       : 'ไฟล์ที่ใช้ฐาน XML Hangul (ตั้งแต่ Hancom Office 2018)',
        key        : 'ไฟล์ Apple Keynote',
        numbers    : 'ไฟล์ Apple Numbers',
        odt        : 'ไฟล์ OpenDocument Text',
        ods        : 'ไฟล์ OpenDocument Spreadsheet',
        odp        : 'ไฟล์ OpenDocument Presentation',
        pages      : 'ไฟล์ Apple Pages',
        ppt        : 'ไฟล์ MS PowerPoint',
        pptx       : 'ไฟล์ MS PowerPoint OpenXML',
        rtf        : 'ไฟล์ RTF',
        tex        : 'ไฟล์ TeX',
        xls        : 'ไฟล์ MS Excel',
        xlsx       : 'ไฟล์ MS Excel OpenXML',

        // ฟอนต์
        eot        : 'ฟอนต์ Embedded OpenType',
        otf        : 'ฟอนต์ OpenType',
        sfnt       : 'ฟอนต์ SFNT',
        ttf        : 'ฟอนต์ TrueType',
        woff       : 'ฟอนต์ Web Open',
        woff2      : 'ฟอนต์ Web Open 2',

        // ไฟล์โค้ด
        c          : 'โค้ด C',
        cpp        : 'โค้ด C++',
        go         : 'โค้ด Go',
        java       : 'โค้ด Java',
        jsx        : 'ไฟล์ JavaScript JSX',
        php        : 'โค้ด PHP',
        py         : 'โค้ด Python',
        rb         : 'โค้ด Ruby',
        sh         : 'ไฟล์สคริปต์ Shell',
        swift      : 'โค้ด Swift',
        kotlin     : 'โค้ด Kotlin',

        // ไฟล์อื่นๆ
        dockerfile : 'ไฟล์ Docker',
        bash       : 'ไฟล์สคริปต์ Bash',
        pl         : 'ไฟล์สคริปต์ Perl',
        cgi        : 'ไฟล์สคริปต์ CGI',
        toml       : 'ไฟล์การตั้งค่า TOML',
        crx        : 'ไฟล์ส่วนขยาย Chrome',
        deb        : 'ไฟล์แพ็คเกจโปรแกรม Debian',
        eml        : 'ไฟล์อีเมล',
        ics        : 'ไฟล์ปฏิทิน',
        lz         : 'ไฟล์บีzip',
        lzma       : 'ไฟล์ LZMA',
        msg        : 'ไฟล์อีเมล Outlook',
        pkpass     : 'ไฟล์ Apple Wallet Passbook',
        torrent    : 'ไฟล์ BitTorrent',
        rpm        : 'ไฟล์แพ็คเกจโปรแกรม RedHat',
        swf        : 'ไฟล์ Flash Shockwave',
        wasm       : 'ไฟล์ WebAssembly'
    },

};
