
/*=================================================================================================
 * MARI HOME   ---------------"--<@
 *-------------------------------------------------------------------------------------------------
 * @코드 명칭 : 마리 멀티 업로더 ( 가제 ) 
 * @요약 정보 : 등록된 멀티 업로더를 가동 시키며 중요한 부분은 보호 처리한다
 * @파일 이름 : multi_uploader.js
 * @웹용 주소 : 글쓰기등 업로드가 필요한 곳, 파일 탐색기와 같이 파일 미리보기가 필요한 곳에서 외부 파일(js파일)로 호출됨 
 * @호출 파일 : multi_uploader_code.js에서 주로 호출
 * @서버 위치 : 마리홈 ( ),  그누보드 ( plugin/multi_uploader/ )
 * @소스 제작 : repter ( 예뜨락 ), 홈페이지 ( https://marihome.net ) 
 * @제작 날짜 : 2023.08.01 ( 최초 제작 시작일 )
 * @소스 설명 : 필요한 부분은 보호 처리하고 실행부인 init()를 통해서 돔을 생성하고 각종 이벤트등을 등록한다
 * @기타 사항 : 당분간 필요한 업그레이드를 통해서 소스 변경이 자주 일어날 수 있습니다 
 *           자바스크립트 형태 : 객체 리터럴 ( Object Literal )
 *           변수 => 프로퍼티 (Property)   : 프로퍼티 값
 *           함수 => 메서드 (Method)
 * @파일 종류 : 순서대로 호출 파일에 외부 스크립트 태그로 등록 :: 파일명 변경 혹은 추가 또는 삭제가 될 수 있습니다 2025-02-21(금)
 *
 *           lang/language.js                      ( 언어 파일 )
 *           js/mime_types.js                      ( 파일 마임 타입, 파일 설명 )
 *           js/multi_uploader_util.js             ( 필요 기능 프로퍼티 모음 )
 *           js/multi_uploader_helper.js           ( 업로더에서 필요한 작은 기능 메서드들 )
 *           js/multi_uploader_layout.js           ( 업로더에 필요한 레이아웃 )
 *           js/multi_uploader_setDataAttribute.js ( 파일의 속성을 등록하거나 필요한 속성을 불러온다 )
 *           js/multi_uploader_dragAction.js       ( 파일의 드래그나 그와 관련된 행위를 한다 ) 
 *           js/multi_uploader_code.js             ( 업로더의 중요 코드를 등록하고 init()를 통해 가동한다 )
 *           js/multi_uploader.js                  ( 업로더의 중요한 부분을 보호하고 init()을 호출해서 업로더를 가동한다 )
 * @최종 수정 : 2025.03.26
 * @버전 명시 : 0.9
 *-------------------------------------------------------------------------------------------------
 * Copyright 2023. repter All Rights Reserved.
**===============================================================================================*/ 

/*===============================================
 * isAdmin 프로퍼티를 추가하고 보호
**---------------------------------------------*/ 
if (use_cms === 'marihome' || use_cms === 'gnuboard') {
    const isAdminValue = use_cms === 'marihome' ? member_grade === 'SUPER_ADMIN' : g5_is_admin === 'super';
    Object.defineProperty(MARI.file_uploder.code, 'isAdmin', {
        value: isAdminValue,
        writable: false,
        configurable: false
    });
}


/*===============================================
 * 읽기 전용으로 만들어 프로퍼티 값을 외부에서 바꿀수 없도록 보호
**---------------------------------------------*/
// 즉시 실행 함수로 MARI.file_uploder.code의 속성을 읽기 전용으로 설정
(function() {
    // MARI.file_uploder.code가 완전히 로드되었는지 확인후 실행
    const checkAndSetReadOnlyObj = () => {
        const obj = MARI.file_uploder.code;

        // 객체가 존재하는지 확인
        if (obj && typeof obj === 'object') { 
            // 읽기 전용으로 만들 프로퍼티들의 이름을 배열로 설정
            const readOnlyProps = [
                'defaultExtensions1', 
                'defaultExtensions2',
                'multiSelect', 
                'validClasses',
            ];

            readOnlyProps.forEach(prop => {
                if (obj.hasOwnProperty(prop)) {
                    Object.defineProperty(obj, prop, {
                        writable: false, // 수정 불가능
                        configurable: false // 삭제/재정의 불가능
                    });

                    // 배열인 경우
                    if (Array.isArray(obj[prop])) {
                        Object.freeze(obj[prop]); // 배열 변경 불가
                        obj[prop].forEach(item => {
                            if (typeof item === 'object' && item !== null) {
                                Object.freeze(item); // 배열의 객체 요소 변경 불가
                            }
                        });
                    } 
                    // 객체인 경우
                    else if (typeof obj[prop] === 'object' && obj[prop] !== null) {
                        Object.freeze(obj[prop]); // 객체 변경 불가
                    }
                }
            });
        } else {
            console.log("객체가 생성 되지 않았습니다");
        }
    };

    // DOMContentLoaded 이벤트를 사용하여 DOM이 완전히 로드된 후 실행
    document.addEventListener('DOMContentLoaded', () => {
        // 주기적으로 MARI.file_uploder.code가 초기화될 때까지 확인
        const intervalId = setInterval(() => {
            if (MARI.file_uploder && MARI.file_uploder.code) {
                checkAndSetReadOnlyObj();  
                clearInterval(intervalId); // 더 이상 필요 없으므로 클리어
            }
        }, 100); // 100ms 간격으로 확인
    });

})();

// 문서 로드후 스크립트 호출 : 2023.06.22
window.addEventListener('load', () =>{
	if(typeof(window.MARI.file_uploder) !== "undefined") { // 업로드 관련 스크립트를 호출한다  
        MARI.file_uploder.code.init(); 
	} 
});
 
