
/*=================================================================================================
 * MARI HOME   ---------------"--<@
 *-------------------------------------------------------------------------------------------------
 * @코드 명칭 : 마리 멀티 업로더 ( 가제 ) 
 * @요약 정보 : 업로더 레이아웃, 리스트에 필요한 변수 모음 
 * @파일 이름 : multi_uploader_layout.js
 * @웹용 주소 : 글쓰기등 업로드가 필요한 곳, 파일 탐색기와 같이 파일 미리보기가 필요한 곳에서 외부 파일(js파일)로 호출됨 
 * @호출 파일 : multi_uploader_code.js에 스프레드 연산자로 등록되어 호출됨
 * @서버 위치 : 마리홈 ( ),  그누보드 ( plugin/multi_uploader/ )
 * @소스 제작 : repter ( 예뜨락 ), 홈페이지 ( https://marihome.net ) 
 * @제작 날짜 : 2023.08.01 ( 최초 제작 시작일 )
 * @소스 설명 : 업로더에서 레이아웃을 등록할 때 사용한다, 추후 스킨화를 할 수 있다
 * @기타 사항 : 당분간 필요한 업그레이드를 통해서 소스 변경이 자주 일어날 수 있습니다 
 *           자바스크립트 형태 : 객체 리터럴 ( Object Literal )
 *           변수 => 프로퍼티 (Property)   : 프로퍼티 값
 *           함수 => 메서드 (Method)
 * @최종 수정 : 2025.03.26
 * @버전 명시 : 0.9
 *-------------------------------------------------------------------------------------------------
 * Copyright 2023. repter All Rights Reserved.
**===============================================================================================*/ 

// 글로벌 변수 지정
if(typeof(window.MARI) === "undefined") { (function(global) { global.MARI = {}; })(window || global); }
if(typeof(window.MARI.file_uploder) === "undefined") { (function(global) { global.MARI.file_uploder = {}; })(window || global); }
if(typeof(window.MARI.file_uploder.layout) === "undefined") { // 등록이 되지 않았다면 등록

    /**
     * layout에 사용 가능한 레이아웃을 담아두고 필요한 부분을 가져다 사용한다
     * 추후 여러개의 레이아웃이 담길수도 있다
     */ 
	MARI.file_uploder.layout  = {
        /**
         * 업로더 레이아웃 형태 (추후 보강 작업 해줄것)
         */
        moduleLayout : 'default', // 현재 2025-02-21(금) 레이아웃이 하나밖에 없으므로 의미가 없음:: 추후 레이아웃을 좀 더 제공할 수도 있음


        /**
         * 업로더 레이아웃 리턴
         */
        mainLayout : function(){

            let obj_util = MARI.file_uploder.util;
            let obj_this = MARI.file_uploder.code;
            let objLang  = MARI.file_uploder.langObj[obj_this.country];  // 언어 객체에서 선택된 언어 가져오기
            let getLocal = obj_util.getFromLocalStorage('uploaderData'); // 채크 박스 등록된 갯수만큼 아래서 마련해야 한다
            let check1 = '', check2 = '', check3 = '', check4 = '', check5 = '', check6 = '';
            if(getLocal){
                check1 = getLocal.useRuler      === 'yes' ? 'checked' : '';
                check2 = getLocal.useGridLine   === 'yes' ? 'checked' : '';
                check3 = getLocal.useGuidesLine === 'yes' ? 'checked' : ''; 
                check4 = getLocal.autoPlay      === 'yes' ? 'checked' : '';
                check5 = getLocal.debergView    === 'yes' ? 'checked' : '';
                check6 = getLocal.imgNaviView   === 'yes' ? 'checked' : '';
            }

			let main_dom   = '';
			main_dom +=' <div class="loader_main">';
			main_dom +='	<div class="row">';
			main_dom +='		<div class="left">';
			main_dom +='			<div class="n_del_bt">';
			main_dom +='				<button type="button" class="btn1">';
			main_dom +='				<i class="trash"></i>';
			main_dom +='                 '+objLang.layout1;
			main_dom +='				</button>';
			main_dom +='				<div class="n_del_bt_wrap" style="display: none;">';
			main_dom +='					<div class="n_del_bt_alt">';
			main_dom +='					    <div class="n_del_bt_alt_cont">'; 
			main_dom +='                        '+objLang.layout2;
			main_dom +='					    </div>';
			main_dom +='					</div>';
			main_dom +='				</div>';
			main_dom +='			</div>'; 
//    //	main_dom +='			<div class="n_edit_bt">';
//    //	main_dom +='				<button type="button" class="edit_bt btn1"> '+objLang.layout3;
//    //	main_dom +='				</button>';
//    //	main_dom +='			</div>';
			main_dom +='		</div>';
			main_dom +='		<div class="right">';
			main_dom +='			<div class="help_key1"><span class="gray">Shift</span></div>';
			main_dom +='			<div class="help_key2"><span class="gray">Ctrl</span></div>';
			main_dom +='			<div class="file_opt_btn_panel">';
			main_dom +='				<div class="file_opt_btn_panel_div">';
			main_dom +='					<div class="select_div">';
			main_dom +='						<div class="colum">';
			main_dom +='							<i class="file_view_type_bt0"></i>';
			main_dom +='							<span class="blind">'+objLang.layout4+'</span>';//선택된 형태로 보기
			main_dom +='						</div>';
			main_dom +='						<div class="colum">';
			main_dom +='							<i class="triangel"></i>';
			main_dom +='							<span class="blind">'+objLang.layout5+'</span>';//파일 형태 옵션창 열기
			main_dom +='						</div>';
			main_dom +='					</div>';
			main_dom +='					<div class="open_div" title="'+objLang.layout6+'" over="" style="display: none;">';//파일 형태 옵션 창
			main_dom +='						<div class="shape1" title="'+objLang.layout7+'">';//아주 큰 아이콘으로 보기
			main_dom +='							<i class="file_view_type_bt1"></i>';
			main_dom +='							<span class="title">'+objLang.layout7+'</span>';//아주 큰 아이콘으로 보기
			main_dom +='						</div>';
			main_dom +='						<div class="shape2" title="'+objLang.layout8+'">';//큰 아이콘으로 보기
			main_dom +='							<i class="file_view_type_bt2"></i>';
			main_dom +='							<span class="title">'+objLang.layout8+'</span>';//큰 아이콘으로 보기
			main_dom +='						</div>';
			main_dom +='						<div class="shape3" title="'+objLang.layout9+'">';//보통 아이콘으로 보기
			main_dom +='							<i class="file_view_type_bt3"></i>';
			main_dom +='							<span class="title">'+objLang.layout9+'</span>';//보통 아이콘으로 보기
			main_dom +='						</div>';
			main_dom +='						<div class="shape4" title="'+objLang.layout10+'">';//작은 아이콘으로 보기
			main_dom +='							<i class="file_view_type_bt4"></i>';
			main_dom +='							<span class="title">'+objLang.layout10+'</span>';//작은 아이콘으로 보기
			main_dom +='						</div>';
			main_dom +='						<div class="shape5" title="'+objLang.layout11+'">';//목록으로 보기
			main_dom +='							<i class="file_view_type_bt5"></i>';
			main_dom +='							<span class="title">'+objLang.layout11+'</span>';//목록으로 보기
			main_dom +='						</div>';
			main_dom +='						<div class="shape6" title="'+objLang.layout12+'">';//자세히 보기
			main_dom +='							<i class="file_view_type_bt6"></i>';
			main_dom +='							<span class="title">'+objLang.layout12+'</span>';//자세히 보기
			main_dom +='						</div>';
			main_dom +='						<div class="shape7" title="'+objLang.layout13+'">';//타일로 보기
			main_dom +='							<i class="file_view_type_bt7"></i>';
			main_dom +='							<span class="title">'+objLang.layout13+'</span>';//타일로 보기
			main_dom +='						</div>';
			main_dom +='						<div class="shape8" title="'+objLang.layout14+'">';//내용으 보기
			main_dom +='							<i class="file_view_type_bt8"></i>';
			main_dom +='							<span class="title">'+objLang.layout14+'</span>';//내용으 보기
			main_dom +='						</div>';
			main_dom +='					</div>';
			main_dom +='					<span class="line_bar"></span>';
			main_dom +='					<button type="button" class="file_view_type1" title="'+objLang.layout15+'">';//미리 보기 창
			main_dom +='						<i class="preview_view_bt"></i>';
			main_dom +='						<span class="blind">'+objLang.layout16+'</span>';//파일 미리 보기 창 열고 닫기
			main_dom +='					</button>';
			main_dom +='					<button type="button" class="file_view_type2" title="'+objLang.layout17+'">';//세부 정보 창
			main_dom +='						<i class="detail_view_bt"></i>';
			main_dom +='						<span class="blind">'+objLang.layout16+'</span>';//파일 미리 보기 창 열고 닫기
			main_dom +='					</button>';
			main_dom +='					<span class="line_bar"></span>';
			main_dom +='					<button type="button" class="file_zone_full_view" title="'+objLang.layout18+'">';//창 크기 키우기
			main_dom +='						<i class="full_screen"></i>';
			main_dom +='						<span class="blind">'+objLang.layout18+'</span>';
			main_dom +='					</button>';
			main_dom +='				    <button type="button" class="moreBar" title="'+objLang.layout19+'">';//옵션 더 보기
			main_dom +='				        <i class="moreLine"></i>';
			main_dom +='						<span class="blind">'+objLang.layout19+'</span>';//옵션 더 보기
			main_dom +='				    </button>'; 
			main_dom +='					<div class="open_div2" title="'+objLang.layout20+'" over="">'; //각종 옵션 선택 창
			main_dom +='						<div class="open_on">';
			main_dom +='							<label class="opt_label"><input class="opt_check1" type="checkbox" '+check1+'>';
			main_dom +='							<span class="title">'+objLang.layout21+'</span></label>';//눈금자( 픽셀 잣대 )
			main_dom +='						</div>';
			main_dom +='						<div class="open_on">';
			main_dom +='							<label class="opt_label"><input class="opt_check2" type="checkbox" '+check2+'>';
			main_dom +='							<span class="title">'+objLang.layout22+'</span></label>';//눈금선( 격자.모눈자 )
			main_dom +='						</div>';
			main_dom +='						<div class="open_on">';
			main_dom +='							<label class="opt_label"><input class="opt_check3" type="checkbox" '+check3+'>';
			main_dom +='							<span class="title">'+objLang.layout23+'</span></label>';//안내선( 십자선 )
			main_dom +='						</div>';
			main_dom +='						<div class="open_on">';
			main_dom +='							<label class="opt_label">';
			main_dom +='							<input type="checkbox" class="opt_check4" '+check4+'>';
			main_dom +='							<span class="title">'+objLang.layout24+'</span></label>';//♬ mp3 선택시 자동 재생
			main_dom +='						</div>';
            
            if( MARI.file_uploder.code.isAdmin === true){ 
			main_dom +='						<div class="open_on">';
			main_dom +='							<label class="opt_label">';
			main_dom +='							<input type="checkbox" class="opt_check5" '+check5+'>';
			main_dom +='							<span class="title">'+objLang.layout25+'</span></label>';//콘솔창에 디버깅 표시
			main_dom +='						</div>';
            }
			main_dom +='						<div class="open_on">';
			main_dom +='							<label class="opt_label">';
			main_dom +='							<input type="checkbox" class="opt_check6" '+check6+'>';
			main_dom +='							<span class="title">'+objLang.layout26+'</span></label>';//미리보기 네비게이션 표시
			main_dom +='						</div>';
			main_dom +='						<div class="open_on">'; 
			main_dom +='							<i class="help_ion"></i><span class="title" onclick="alert(\''+objLang.layout27+'\');">'+objLang.layout28+'</span>';//준비중입니다  도움말
			main_dom +='						</div>';
			main_dom +='				    </div>';
			main_dom +='				</div>';
			main_dom +='			</div>'; 
			main_dom +='		</div>';
			main_dom +='		<div class="clear"></div>';
			main_dom +='	</div>';
            
            if(obj_this.resizeHeightAct === true){
		 	main_dom +='    <div class="resizeWd_handle">↔</div>'; // 좌우 리사이즈 
            } 
            
			main_dom +='	<div class="file_zone"> ';
			main_dom +='	    <div class="module_bg"></div>';
			main_dom +='		<div class="file_editor">';
			main_dom +='			<div class="loader_menu"></div>';
			main_dom +='		</div>';  
			main_dom +='		<div class="file_zone_header">';  //추가 div 2024-11-27(수) 추가
			main_dom +='		</div>';
			main_dom +='		<div class="file_zone_body">';
			main_dom +='			<div class="drop_zone">';
			main_dom +='		        <div class="file_list_header">'; 
			main_dom +='			        <div class="upload_img_header">';
		 	main_dom +='			            <span>'+objLang.layout29+'</span>'; //이미지
			main_dom +='			            <div class="move_handle"></div>';
			main_dom +='			        </div>';
			main_dom +='			        <div class="file_name_in_header">'; 
		 	main_dom +='			            <span>'+objLang.layout30+'</span>'; //파일명
			main_dom +='			            <div class="move_handle"></div>';
			main_dom +='		            </div>';
			main_dom +='		            <div class="file_make_in_header">';
			main_dom +='			            <span>'+objLang.layout31+'</span>';//만든 날짜
			main_dom +='			            <div class="move_handle"></div>';
			main_dom +='		            </div>';
			main_dom +='		            <div class="file_type_in_header">';
			main_dom +='			            <span>'+objLang.layout32+'</span>';//유형
			main_dom +='			            <div class="move_handle"></div>';
			main_dom +='		            </div>'; 
			main_dom +='		            <div class="file_pic_size_in_header">';
			main_dom +='			            <span>'+objLang.layout33+'</span>';//사진 크기
			main_dom +='			            <div class="move_handle"></div>';
			main_dom +='		            </div>';
			main_dom +='		            <div class="file_size_in_header">'; 
			main_dom +='			            <span>'+objLang.layout34+'</span>';//파일 크기
			main_dom +='			            <div class="move_handle"></div>';
			main_dom +='		            </div>';
			main_dom +='		            <div class="modified_date_in_header">'; 
			main_dom +='			            <span>'+objLang.layout35+'</span>';//수정한 날짜
			main_dom +='			            <div class="move_handle"></div>';
			main_dom +='			        </div>'; 
			main_dom +='		        </div>';  //file_list_header
			main_dom +=' 				<div class="file_main">';
			main_dom +=' 					<ul class="file_list">';
			main_dom +=' 						<li class="file_up_msg">';
			main_dom +=' 							<div class="msg_in">';
			main_dom +=' 								<i class="file_image"></i>';
			main_dom +=' 								'+objLang.layout36; //더블클릭 또는 파일을 마우스로 끌어 오세요
			main_dom +=' 							</div>';
			main_dom +=' 						</li>';
			main_dom +=' 					</ul>';
			main_dom +=' 				</div>';
			main_dom +='			</div>';
			main_dom +=' 	 	    <div class="drag_bar">';
			main_dom +=' 	   	        <div class="drag_bar_cover">';
			main_dom +=' 				    <div class="drag_bar_line"></div>';
			main_dom +=' 			    </div>';
			main_dom +=' 			</div>';
			main_dom +='			<div class="file_info">'; 
			main_dom +=' 				<div class="file_view_dp">';
            main_dom +=' 				    <div class="view_preview">'; 
            main_dom +='            	        <!--// preview     -->'; 
            main_dom +=' 				        <span class="msg">'+objLang.layout37+'</span>';//미리 볼 파일을 선택하십시오.
            main_dom +=' 			 	   </div>';
            main_dom +=' 			 	   <div class="view_detail">';
            main_dom +='              	      <!--// detail     -->'; 
            main_dom +='           	         <span class="msg">'+objLang.layout38+'</span>'; //상세 정보를 볼 파일을 선택하십시오.
            main_dom +='       	             <span class="msg">'+objLang.layout39+'</span>'; // 0개 항목 
            main_dom +=' 				    </div>';
			main_dom +=' 				</div>'; 
			main_dom +='			</div>';
			main_dom +='		</div>'; // file_zone_body
			main_dom +='		<div class="file_zone_foot">';
			main_dom +='		</div>'; // file_zone_foot 
			main_dom +='		<div class="file_zone_bottom">'; 
			main_dom +='		    <div class="file_zone_bottom_in">';
			main_dom +='		        <div class="loader_foot_right">';
			main_dom +=' 			        <button type="button" class="file_view_type3" title="'+objLang.layout40+'">';//미리 보기 창
			main_dom +=' 			            <i class="preview_view_bt"></i>';
			main_dom +=' 			            <span class="blind">'+objLang.layout41+'</span>';//파일 미리 보기 창 열고 닫기
			main_dom +=' 			        </button>'; 
			main_dom +=' 			        <button type="button" class="file_view_type4" title="'+objLang.layout42+'">';//세부 정보 창
			main_dom +=' 			            <i class="detail_view_bt"></i>';
			main_dom +=' 			            <span class="blind">'+objLang.layout43+'</span>';//파일 미리 보기 창 열고 닫기
			main_dom +=' 			        </button>'; 
			if(obj_this.resizeWdHtAct === true){
			main_dom +=' 			        <div class="resize_handle">'; 
			main_dom +=' 			            <span class="resize_icon3">◢</span>'; 
			main_dom +=' 			        </div>';
			}
            
			main_dom +='		        </div>';
			main_dom +='                <div class="status_bar"></div>'; // 선택한 파일의 기본 정보 
			main_dom +='		    </div>';
            // 디버깅 레이어와 버튼
            if( MARI.file_uploder.code.isAdmin === true){ 
			main_dom +='	    	<div class="file_historyDiv" divOpen="no" testdd="-----------------여기">'; 
			main_dom +='	    	    <div class="openBt">open</div>'; 
			main_dom +='	    	    <div class="file_historyBg">';
			main_dom +='	    	        <div class="file_historyBgpannel"></div>'; // 바탕 드래그 되지 않도록하기 위해 사용
			main_dom +='	    	        <div class="file_historyBlurpannel"></div>';
			main_dom +='	    	        <div class="file_history">';
			main_dom +='		                <ul class="historyIn">'+objLang.layout44+'</ul>'; //정보 출력
			main_dom +='	    	        </div>';
			main_dom +='	    	        <div class="colorInfo">';
			main_dom +=' 			            <div class="leftDiv">';
			main_dom +=' 			                <span class="circle bg_white"></span> '+objLang.layout45+'';//일반적인
			main_dom +=' 			                <span class="circle bg_blue"></span> '+objLang.layout46+'';//업로드 파일
			main_dom +=' 			                <span class="circle bg_orange"></span> '+objLang.layout47+'';//수정
			main_dom +=' 			                <span class="circle bg_red"></span> '+objLang.layout48+''; //삭제
			main_dom +=' 			                <span class="circle bg_yellow"></span> '+objLang.layout49+'';//경고
			main_dom +=' 			                <span class="circle bg_pink"></span> '+objLang.layout50+'';//배열 정보
			main_dom +='	    	            </div>'; 
			main_dom +=' 			            <div class="rightDiv">'; 
         // main_dom +=' 			                <button type="button" onclick="alert(\''+objLang.layout51+'\');return false;"><span class="square bg_check on"></span>'+objLang.layout52+'</button>';// 준비중 입니다1-1 히스토리
         // main_dom +=' 			                <button type="button" onclick="alert(\''+objLang.layout53+'\');return false;"><span class="square bg_check"></span>'+objLang.layout54+'</button>';//준비중 입니다2  파일 정보
			main_dom +=' 			            </div>';
			main_dom +=' 			            <div class="clearDiv"></div>';
			main_dom +='	    	        </div>';
			main_dom +='	    	    </div>';
			main_dom +='	    	</div>';
            }
			main_dom +='		</div>'; // file_zone_bottom

            if(obj_this.resizeHeightAct === true){
			main_dom +='    <div class="resizeHt_handle">↕</div>'; // 상하 리사이즈 핸들바
            }

			if(obj_this.resizeWdHtAct === true){
			main_dom +='        <div class="resize_handle_curver">'; 
			main_dom +='            <span class="resize_icon3">◢</span>'; 
			main_dom +='        </div>';
			}

			main_dom +='	</div>';     // file_zone 
			main_dom +='	<div class="row">';
			main_dom +='	    <div class="left">';
			main_dom +='	        <label><!--// 배열형인 cmt_multi_file[]을 일반형으로 -->';
			main_dom +='	            <input type="file" name="bf_multi_file[]"  class="frm_file">'; // 파일을 담는 주 파일 업로더
			main_dom +='	            <input type="file" name="thumbnail_file[]" class="frm_file" multiple accept="image/jpeg, image/png">'; // 썸네일 파일을 담는 업로더
			main_dom +='	            <input type="hidden" name="multi_upload_data">'; // 파일외 기타 데이터
			main_dom +='	        </label>';
			main_dom +='	        <button type="button" class="upload_button btn1">';
			main_dom +='	            <i class="file_image"></i> FILE ADD'; 
			main_dom +='	            <div class="total_in_file_img">';
			main_dom +='	                <div class="total_in_file">';
			main_dom +='	                '+objLang.layout55+'';//    <span class="total_in_file_cnt">0</span>개 업로드;
			main_dom +='	                </div>';
			main_dom +='	            </div>';
			main_dom +='	        </button>';
//			main_dom +='	        <button type="button" class="btn1" onclick="alert(\''+objLang.layout56+'.\');return false;">';//준비중입니다1
//			main_dom +='	            <i class="file_image"></i> MYBOX';
//			main_dom +='	        </button>';
			main_dom +='	    </div>';
			main_dom +='	    <div class="right">';
			main_dom +='	        <div class="file_size_print">';
			main_dom +='	            '+objLang.layout57+' : <span class="up_size_num">0</span><span class="up_size_units">KB</span> / <span class="up_size_limit_num">'+obj_this.limitTotalSize+'</span><span class="total_size_units">MB</span>';//파일 업로드
			main_dom +='	        </div>';
			main_dom +='	    </div>';
			main_dom +='	    <div class="clear"></div>';
			main_dom +='	</div>';
			main_dom +=' </div>';
  
            return main_dom;

        },


        /**
         * 파일 리스트 레이아웃 리턴
         */
        listLayout : function(eq_idx, dataCode){

            let obj_this    = MARI.file_uploder.code;
            let objLang     = MARI.file_uploder.langObj[obj_this.country];  // 언어 객체에서 선택된 언어 가져오기
            let listCls     = obj_this.one_file_cls.substr(1);
            let thumbBtStr  = obj_this.thumb_bt_cls.substr(1);
            let delBtStr    = obj_this.del_bt_cls.substr(1);
            let unknownImg  = obj_this.moduleUrl +'/images/file_type1/unknown.png'; 
            let unknownIcon = obj_this.moduleUrl +'/images/file_kind/unknown.gif'; 
            let loadingIcon = obj_this.moduleUrl +'/images/loading.gif'; 
            let listShape   = obj_this.list_shape[eq_idx].replace(/\D/g, ""); // 현재 업로드에 적용된 shape타입에서 숫자만 가져온다
            let shapeNum    = parseInt(listShape, 10) - 1;                    // 배열에서 찾아야 하기에 1을 빼준다
            let loader_type = obj_this.loaderType[shapeNum];                  // 리스트 모양 만큼 그에 맞는 로딩중 이미지가 배열에 들어가 있는데 배열 값으로 가져온다
			let list_dom    = '';
            list_dom +='<li class="'+listCls+'" data-code="'+dataCode+'">';
            list_dom +='	<div class="one_file_before_bar"></div>';
            list_dom +='	<div class="spinner_cover">';
            list_dom +='		<div class="spinner_in_div">'; 
            list_dom +='			<div class="loader '+loader_type+'"></div>';
            list_dom +='		</div>';
            list_dom +='	</div>';
            list_dom +='    <div class="contentDiv">'; //추가 div 2024-10-29(화) 효과를 위해 덧입혔음
            list_dom +='		<span class="'+thumbBtStr+'">'+objLang.layout58+'</span>';//대표
            list_dom +='		<span class="'+delBtStr+'">Del</span>';
            list_dom +='	    <div class="upload_img_wrap">';
            list_dom +='		    <div class="upload_thumb_wrap">';
            list_dom +='		    <img src="'+unknownImg+'" class="upload_thumb">';
            list_dom +='		    </div>';
            list_dom +='	    </div>';
            list_dom +='	    <div class="file_name_in">';
            list_dom +='            <img src="'+unknownIcon+'" class="file_icon">'; 
            list_dom +='            <span class="file_name" draggable="false">'+objLang.layout59+'</span>';  //파일명
            list_dom +='	    </div>';
            list_dom +='	    <div class="file_make_in">';
            list_dom +='            <span>'+objLang.layout60+' : </span><em>'+objLang.layout60+'</em>';//만든 날짜
            list_dom +='	    </div>';
            list_dom +='	    <div class="file_type_in">';
            list_dom +='            <span>'+objLang.layout61+' : </span><em>'+objLang.layout61+'</em>';//파일 유형
            list_dom +='	    </div>';
            list_dom +='	    <div class="file_pic_size_in">';
            list_dom +='            <span>'+objLang.layout62+' : </span><em >'+objLang.layout628+'</em>';//사진 크기
            list_dom +='	    </div>';
            list_dom +='	    <div class="file_size_in">'; 
            list_dom +='            <span>'+objLang.layout63+': </span><em>'+objLang.layout63+'</em>';//파일 크기 
            list_dom +='	    </div>';
            list_dom +='	    <div class="modified_date_in">'; 
            list_dom +='            <span>'+objLang.layout64+' : </span><em>'+objLang.layout64+'</em>';//수정한 날짜
            list_dom +='	    </div>';
            list_dom +='	    <div class="choice_div"></div>';
            list_dom +='	    <canvas class="progressBar" style="display: none;"> </canvas>';
            list_dom +='	    <video class="list_video" style="display: none;"> </video>';
            list_dom +='    </div>';
            list_dom +='    <div class="one_file_after_bar"></div>';
            list_dom +='</li>';

            return list_dom;

        },


        /**
         * 사용금지 파일명 팝업
         */
        altPopUpLayer : function(eq_idx) {
            let obj_this = MARI.file_uploder.code;
            let objLang  = MARI.file_uploder.langObj[obj_this.country];  // 언어 객체에서 선택된 언어 가져오기  
            let dom = '';
			dom += '<div class="altPopUpLayer">';
			dom += '<div class="txt">'+objLang.layout65+'<br>\\ / : * ? " < > | </div>';//파일 이름에는 다음 문자를 사용할 수 없습니다.
			dom += '</div>';

            return dom;

        },


        /**
         * 미리보기 눈금자 :: 픽셀 잣대
         */
        rulerDom : function(eq_idx) {
            const obj_util   = MARI.file_uploder.util;
            const obj_this   = MARI.file_uploder.code;
            const objLang    = MARI.file_uploder.langObj[obj_this.country];  // 언어 객체에서 선택된 언어 가져오기  
            const loaderMain = obj_this.loader_main_obj(eq_idx);
            const getLocal   = obj_util.getFromLocalStorage('uploaderData'); 
            let cssDsp1      = (getLocal && getLocal.useRuler == 'yes') ? 'block' : 'none';
            let dom = '';
			dom += '<div class="rulerCont" style="display:'+cssDsp1+'">'; 
			dom += '    <div class="rulerX">';  
            let j=0;
            for(let i=0; i< 50; i++){
			    dom += '    <div class="rulerNumX"><span>'+j+'</span></div>';
                j = j+50;
            }
			dom += '    </div>'; 
			dom += '    <div class="rulerY">';  
            let n=0;
            for(let m=0; m< 50; m++){
			    dom += '    <div class="rulerNumY"><span>'+n+'</span></div>';
                n = n+50;
            }
			dom += '    </div>';  
			dom += '</div>';

            return dom;

        },


        /**
         * 미리보기 눈금선 :: 격자.모눈자
         */
        gridLinesDom : function(eq_idx) {
            const obj_util   = MARI.file_uploder.util;
            const obj_this   = MARI.file_uploder.code;   
            const objLang    = MARI.file_uploder.langObj[obj_this.country];  // 언어 객체에서 선택된 언어 가져오기  
            const loaderMain = obj_this.loader_main_obj(eq_idx);
            const getLocal   = obj_util.getFromLocalStorage('uploaderData'); 
            let cssDsp2      = (getLocal && getLocal.useGridLine == 'yes') ? 'block' : 'none';// 격자( 모눈자 ) 사용 유무

            let dom = ''; 
			dom += '<div class="gridLines" style="display:'+cssDsp2+'">';
			dom += '    <div class="lineBg"></div>';
			dom += '    <div class="lines"></div>';  
			dom += '    <div class="verticalRuler"></div>';   // 수직
			dom += '    <div class="horizontalRuler"></div>'; // 수평
			dom += '</div>';

            return dom;

        },


        /**
         * 미리보기 안내선 :: 십자선
        **/
        guidesLineDome : function(eq_idx){
            const obj_util   = MARI.file_uploder.util;
            const obj_this   = MARI.file_uploder.code;   
            const objLang    = MARI.file_uploder.langObj[obj_this.country];  // 언어 객체에서 선택된 언어 가져오기  
            const loaderMain = obj_this.loader_main_obj(eq_idx);
            const getLocal   = obj_util.getFromLocalStorage('uploaderData'); 
            let cssDsp3      = (getLocal && getLocal.useGuidesLine == 'yes') ? 'block' : 'none';// 눈금자( 잣대 ) 사용 유무

            let dom = '';
			dom += '<div class="guidesLine" style="display:'+cssDsp3+'">';
			dom += '    <div class="verticalGuide"></div>';
			dom += '    <div class="horizontalGuide"></div>';
			dom += '    <div class="position-display"><span class="pos">X</span> : <span class="pixel">0px</span></div>';
			dom += '</div>';

            return dom;

        },


        /**
         * 미리보기 이미지 확대,축소 콘트롤러
         */
        imgController: function(eq_idx) {
            let obj_this   = MARI.file_uploder.code;  
            let objLang    = MARI.file_uploder.langObj[obj_this.country];  // 언어 객체에서 선택된 언어 가져오기  
            let dom     = '';
            let loopNum = '';
            if(obj_this.imgMaxZoomValue>100) {// 퍼센트 게이지의 막대를 몇개를 넣을지에 대해
                loopNum = (obj_this.imgMaxZoomValue / 100 ); // 100%마다 막대 800% => 8개
            } else {
                loopNum = (obj_this.imgMaxZoomValue / 10 );  // 10%마다 막대 100% => 10개
            }
 
            dom += '<div class="preview_img_control">';
            dom += '    <div class="bgPannel"></div>'; // 이미지 콘트롤러 반투명 판넬
            dom += '    <div class="imgViewNavi">';
            dom += '        <div class="naviThumbnail">'; 
            dom += '        </div>';   
            dom += '        <div class="naviGuide">';
            dom += '            <img class="naviImg" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" alt="'+objLang.layout66+'">';//네비게이션 이미지
            dom += '        </div>';
            dom += '        <div class="naviPointer">';
            dom += '            <div class="naviPointerBg"></div>';
            dom += '            <div class="naviPointerCursor"></div>';
            dom += '        </div>';
            dom += '    </div>';
            dom += '    <div class="imgCtrPannel">';
            dom += '        <div class="imgViewBt">';  
            dom += '            <button type="button" class="view_typeBt" title="'+objLang.layout67+'">'; //화면에 맞춤
            dom += '                <i class="view_type_bt"></i>'; 
            dom += '                <span class="blind">'+objLang.layout68+'</span> '; //확대 ( 축소 ) 또는 100 크기로 보기
            dom += '            </button>'; 
            dom += '        </div>';
            // 미리보기 이미지 확대/축소 셀렉트 레이어
            dom += '        <div class="imgRatioSelectMenu">'; 
            // 미리보기 이미지 확대/축소 셀렉트 레이어:: 옵션부
            dom += '            <select  class="selectMenu">'; 
            dom += '                <option value="800"> 800%</option>';
            dom += '                <option value="700"> 700%</option>';
            dom += '                <option value="600"> 600%</option>';
            dom += '                <option value="500"> 500%</option>';
            dom += '                <option value="400"> 400%</option>';
            dom += '                <option value="300"> 300%</option>';
            dom += '                <option value="200"> 200%</option>';
            dom += '                <option value="100"> 100%</option>';
            dom += '                <option value="75"> 75%</option>';
            dom += '                <option value="50"> 50%</option>';
            dom += '                <option value="25"> 25%</option>';
            dom += '                <option value="10"> 10%</option>';  
            dom += '            </select>';  
            dom += '            <input type="text" class="selectInput">';    
            dom += '        </div>';
            dom += '        <div class="imgCtrL_on"></div>';
            dom += '        <div class="slider">'; 
            dom += '            <div class="bar">';
            for(let i=0; i<=loopNum; i++){
                dom += '            <div class="tick" style="left:'+((i/loopNum)*100)+'%"></div>';
            }
            dom += '            </div>';
            dom += '            <div class="slider-track">';
            dom += '                <div class="slider-percent">';
            dom += '                </div>';
            dom += '            </div>';
            dom += '            <div class="slider-handle">'; 
            dom += '                <div class="slider-value">0%</div>'; 
            dom += '            </div>';
            dom += '        </div>';
            dom += '        <div class="imgCtrR_on"></div>';
            dom += '    </div>';
            dom += '</div>';

            return dom;

        },


        /**
         *  업로더 내부 바탕 안내글 
         */
        infoMsg : function(eq_idx, totalCnt){
            let obj_this   = MARI.file_uploder.code; 
            let objLang    = MARI.file_uploder.langObj[obj_this.country];  // 언어 객체에서 선택된 언어 가져오기  
            let loaderMain = obj_this.loader_main_obj(eq_idx);
            // 안내글 
            if(totalCnt == 0){
                let msg_dom = '';
                msg_dom +='<li class="file_up_msg">';
                msg_dom +=' <div class="msg_in">';
                msg_dom +=' <i class="file_image"></i>';
                msg_dom +='     '+objLang.layout69+'';//더블클릭 또는 파일을 마우스로 끌어 오세요
                msg_dom +=' </div>';
                msg_dom +='</li>';

                // 돔 추가 ( html 문자열을 넣는 형태로 생성한다 )
                let fileList = loaderMain.querySelector(obj_this.file_list_cls);  
                fileList.insertAdjacentHTML('beforeend', msg_dom); 
            }

        },

		/*=================================================
		 * 8-2.마우스 오버시 해당 파일의 정보 넣어서 오픈한다
		**-----------------------------------------------*/ 
		info_layer_make : function(event, msgInfo){
			let obj_this         = MARI.file_uploder.code;  
            let objLang          = MARI.file_uploder.langObj[obj_this.country];  // 언어 객체에서 선택된 언어 가져오기  
            let file_zone_cls    = obj_this.info_div_cls;
            let info_div_cls     = obj_this.info_div_cls;
            let info_cls         = info_div_cls.substr(1);   
            let eq_idx           = obj_this.event_eq(event);    //사용 가능하게 설정된 업로더에서의 인덱스   
            let loaderMain       = obj_this.loader_main_obj(eq_idx);
            let info_dom         = loaderMain.querySelectorAll(info_div_cls); 
			let info_msg         = '';
			let msg1 = msgInfo.altmsg1;
			let msg2 = msgInfo.altmsg2;
			let msg3 = msgInfo.altmsg3;
			let msg4 = msgInfo.altmsg4;
			let msg5 = msgInfo.altmsg5;
			let msg6 = msgInfo.altmsg6; 

			if(msg1)
			info_msg += '<p><span>'+objLang.layout70+'</span><span>:</span><span class="altmsg1"> '+msg1+' </span></p>';//파일 이름

			if(msg2)
			info_msg += '<p><span>'+objLang.layout71+'</span><span>:</span><span class="altmsg2"> '+msg2+' </span></p>';//파일 형식

			if(msg3)
			info_msg += '<p><span>'+objLang.layout72+'</span><span>:</span><span class="altmsg3"> '+msg3+' </span></p>';//파일 크기

			if(msg4)
			info_msg += '<p><span>'+objLang.layout73+'</span><span>:</span><span class="altmsg4"> '+msg4+' </span></p>';//수정 날짜

			if(msg5)
			info_msg += '<p><span>'+objLang.layout74+'</span><span>:</span><span class="altmsg5"> '+msg5+' </span></p>';//원본 넓이

			if(msg6)
			info_msg += '<p><span>'+objLang.layout75+'</span><span>:</span><span class="altmsg6"> '+msg6+' </span></p>';//원본 크기

			let file_info_dom = '<div class="'+info_cls+'" >'+info_msg+'</div>'; 
 
            // 기존 정보 레이어 삭제
            const fileInfoDivs = document.querySelectorAll('.file_info_div');
            fileInfoDivs.forEach(div => div.remove());

            // 새로운 정보 레이어 삽입
            const filePreviewElements = document.querySelectorAll(obj_this.loader_main_cls);
            const targetElement = filePreviewElements[eq_idx];
            if (targetElement) {
                const newFileInfoDiv = document.createElement('div');
                newFileInfoDiv.setAttribute('id', 'info_layer'); // 업로더 아이디 설정
                newFileInfoDiv.innerHTML = file_info_dom; // `file_info_dom`을 문자열로 가정  
                targetElement.insertAdjacentElement('afterend', newFileInfoDiv); 
            }
            
		},



	};// end property  
}// end if(typeof(window.MARI.file_uploder.layout) === "undefined") {
