/*=================================================================================================
**  language 변수
**  2025-03-26(수) :: 마리홈에서 형식을 빌어서 사용
**-------------------------------------------------------------------------------------------------
**  [ 사용법 ] 
**
**	1.소스코드 =>
**
**		사용처, 파일명을 주석으로 기재
**		langObj.파일명 기반 변수 ={
**			"txt1"  : "값1",
**			"txt2"  : "값2"
**		}
**		var 파일명 기반 변수 = langObj.파일명 기반 변수;
**                                                                                                    
**	2.호출 =>
**                                                                
**		2-1 일반 언어 텍스트로 호출 ( txt 는 파일 확장자명이 아니라 객체 리터럴 변수명임 )
**              alert(파일명 기반 변수.txt),    alert(파일명 기반 변수[txt]);                     
**		2-2  함수 또는 변수를 필요로 하는 경우 아래와 같이 리턴
**              alert(파일명 기반 변수.txt(변수));
**-------------------------------------------------------------------------------------------------
**
**	[ example ]
**
**  1.소스코드 =>
**
**		// 사용처  : 회원가입, 아이디,패스워드 찾기
**		// 호출파일 : pw_id_search.js
**		langObj.pw_id={
**			"txt1"    : "분 ",
**			"txt2"    : "초",
**		     "txt3"    :function(obj){  // ( 언어에 변수처리가 필요할 경우 )
**			      return '[ 필수 입력 ] '+ obj + '을 입력해 주세요';
**	          },
**		}
**		var pw_id = langObj.pw_id;
**
**  2.호출 =>
**
**        2-1. 일반 언어 텍스트로 호출 
**		      alert(tooltip_msg.txt1);
** 
**        2-2. 함수 또는 변수를 필요로 하는 경우 아래와 같이 리턴
**              tooltip_msg.txt4(emt_name);
**
**-----------------------------------------------------------------------------------------------*/
// 글로벌 변수 지정
if(typeof(window.MARI) === "undefined") { (function(global) { global.MARI = {}; })(window || global); }
if(typeof(window.MARI.file_uploder) === "undefined") { (function(global) { global.MARI.file_uploder = {}; })(window || global); }
if(typeof(window.MARI.file_uploder.langObj) === "undefined") { // 등록이 되지 않았다면 등록

     /**
      * layout에 사용 가능한 레이아웃을 담아두고 필요한 부분을 가져다 사용한다
      * 추후 여러개의 레이아웃이 담길수도 있다
     **/ 
    MARI.file_uploder.langObj  = {
        ko : { // 한국어 
            'txt1' : function(obj1, obj2){  //multi_uploader_code.js
                 return '🚨 '+obj1+'번째 업로더의 리스트 shape 타입이 올바르지 않습니다\n올바른 타입명을 사용하세요\n\n사용중인 shape명 : '+obj2; 
            }, 
            'txt2' : function(obj1, obj2){
                 return '🚨 파일 업로드를 사용하기 위해서는 수정용 파일을 담을 배열인 \'modifyFile_Ary\'가 정의되어야 합니다';
            },
            'txt3' : '🚨 파일 업로드는 업로드 버튼을 사용하거나\n파일 드랍 공간에 드랍하세요',
            'txt4' : '🚨 준비중입니다',
            'txt5' : function(obj1, obj2, obj3, obj4, obj5){
                 let msg1  = '';
                 msg1 += '🚨 파일은 ' + obj1 + '개 이하로만 업로드할 수 있습니다!!!\n\n';
                 msg1 += '     리스트에 업로드된 갯수 : ' + obj2 +'개\n';
                 msg1 += '     현재 업로드를 위해 선택된 갯수 : ' + obj3 +'개\n';
                 msg1 += '     업로드 할수 있는 '+ obj4 +'개를 제외한\n';
                 msg1 += '     마지막 '+ obj5 +'개는 업로드에서 제외 됩니다';
                 return msg1;
            },
            'txt6' : function(obj1, obj2, obj3){
            let msg2  = '';
                 msg2 += '🚨 업로드 제한 갯수 이상 업로드가 되어 있습니다\n더 이상 업로드를 할 수 없습니다\n\n';
                 if(obj1 && obj2)
                 msg2 += '     업로드 게시판 : ' + obj1 + ' ( ' + obj2 + ' )\n';
                 msg2 += '     관리자가 설정한 업로드 제한 갯수 : ' + obj3 + '개';
                 return msg2;
            },
            'txt7' : function(obj1, obj2){  
                 let msg  = '';
                 msg += '🚨 파일 크기가 큽니다 줄이거나 다른 파일을 올리세요\n';
                 msg += '     파일명 : ' + obj1 + ' ( 약 ' + obj2 + 'MB 오버 )';
                 return msg;
            }, 
            'txt8' : function(obj1, obj2, obj3, obj4){  
                 let msg = '';
                 msg += '🚨 전체 업로드 사이즈가 너무 큽니다\n\n';
                 msg += '     합계 업로드 : ' + obj1 + obj2  + '\n';
                 msg += '     오버 사이즈 : ' + obj3 + ' ( '+ obj4 +'byte )\n';
                 msg += '     다른 파일을 삭제하거나 용량을 줄이세요\n';
                 return msg;
            }, 
            'txt9' : function(obj1, obj2){    
                 return '🚨 '+obj1 + ' 파일은 사용할 수 없습니다.\n\n업로드 가능한 파일\n[ '+obj2+' ]';
            }, 
            'txt10' : '🚨 파일명에 허용되지 않은 문자가 포함되어 있습니다.', 
            'txt11' : '🚨 파일 업로드에 문제가 있습니다.', 
            'txt12' : function(obj1){    
                return '🚨 '+listIdx + ' 알 수 없는 속성의 파일입니다.\n확인 후 올려 주세요';
            },  
            'txt13' : function(obj1){    
                 return '🚨 [ ' + obj1 + ' ] 등록되지 않은 속성의 파일입니다';
            },

            // multi_uploader_dragAction.js
            'txt101' : '🚨 target_idx 값이 맞지 않습니다',

            //multi_uploader_helper.js
            'txt201' : '🚨 파일명에 확장자가 없습니다. 올바른 파일명을 입력하세요.',
            'txt202' : '     올바른 확장자를 입력하세요. 확장자가 올바르지 않습니다.',
            'txt203' : '     최소 한 글자 이상의 파일명을 입력하세요.',
            'txt204' : function(obj1, obj2){    
                 return '🚨 '+obj1 + ' | ' + obj2 + ' 파일의 확장명을 변경하면 사용할 수 없게 될 수도 있습니다.\n변경하시겠습니까?';
            },
            'txt205' : '🚨 파일명이 255자를 초과할 수 없습니다.',
            'txt206' : function(obj1, obj2){    
                 return '🚨 중복된 파일명이 존재합니다\n\n' + obj1 + '파일명이 존재하므로 \n'+obj2+'으로 변경합니다';
            },
                
            //multi_uploader_setDataAttribute.js
            'txt601' : function(obj1, obj2){    
                 return '🚨 setFileInfo::'+ obj1 +'|'+ obj2 +'dataCodes값을 찾을수 없습니다1';
            },
            'txt602' : function(obj1, setFileExt){    
                return '🚨 '+obj1 + ' datas 객체가 유효하지 않습니다.';
            },
 
            
            
            'layout1'  : '선택한 <span class="del_file_cnt">0</span>개 파일 삭제',
            'layout2'  : '선택된 파일이 없습니다.',
            'layout3'  : '수정',
            'layout4'  : '선택된 형태로 보기',
            'layout5'  : '파일 형태 옵션창 열기',
            'layout6'  : '파일 형태 옵션 창', 
            'layout7'  : '아주 큰 아이콘으로 보기', 
            'layout8'  : '큰 아이콘으로 보기',
            'layout9'  : '보통 아이콘으로 보기',
            'layout10' : '작은 아이콘으로 보기',
            'layout11' : '목록으로 보기',
            'layout12' : '자세히 보기',
            'layout13' : '타일로 보기',
            'layout14' : '내용으 보기',
            'layout15' : '미리 보기 창',
            'layout16' : '파일 미리 보기 창 열고 닫기',
            'layout17' : '세부 정보 창',
            'layout18' : '창 크기 키우기',
            'layout19' : '옵션 더 보기',
            'layout20' : '각종 옵션 선택 창',
            'layout21' : '눈금자( 픽셀 잣대 )',
            'layout22' : '눈금선( 격자.모눈자 )',
            'layout23' : '안내선( 십자선 )',
            'layout24' : '♬ mp3 선택시 자동 재생',
            'layout25' : '콘솔창에 디버깅 표시',
            'layout26' : '미리보기 네비게이션 표시',
            'layout27' : '준비중입니다',
            'layout28' : '도움말',
            'layout29' : '이미지',
            'layout30' : '파일명',
            'layout31' : '만든 날짜',
            'layout32' : '유형',
            'layout33' : '사진 크기',
            'layout34' : '파일 크기',
            'layout35' : '수정한 날짜',
            'layout36' : '더블클릭 또는 파일을 마우스로 끌어 오세요',
            'layout37' : '미리 볼 파일을 선택하십시오.',
            'layout38' : '상세 정보를 볼 파일을 선택하십시오.',
            'layout39' : '0개 항목',
            'layout40' : '미리 보기 창',
            'layout41' : '파일 미리 보기 창 열고 닫기',
            'layout42' : '세부 정보 창',
            'layout43' : '파일 미리 보기 창 열고 닫기',
            'layout44' : '정보 출력',
            'layout45' : '일반적인',
            'layout46' : '업로드 파일',
            'layout47' : '수정',
            'layout48' : '삭제',
            'layout49' : '경고',
            'layout50' : '배열 정보',
            'layout51' : '준비중 입니다1-1',
            'layout52' : '히스토리',
            'layout53' : '준비중 입니다2',
            'layout54' : '파일 정보',
            'layout55' : '<span class="total_in_file_cnt">0</span>개 업로드',
            'layout56' : '준비중입니다1', 
            'layout57' : '파일 업로드',
            'layout58' : '대표',
            'layout59' : '파일명',
            'layout60' : '만든 날짜',
            'layout61' : '파일 유형',
            'layout62' : '사진 크기',
            'layout63' : '파일 크기',
            'layout64' : '수정한 날짜',
            'layout65' : '파일 이름에는 다음 문자를 사용할 수 없습니다.',
                
            
            'layout66' : '네비게이션 이미지',
            'layout67' : '화면에 맞춤',
            'layout68' : '확대 ( 축소 ) 또는 100 크기로 보기',
            'layout69' : '더블클릭 또는 파일을 마우스로 끌어 오세요',
            'layout70' : '파일 이름',
            'layout71' : '파일 형식',
            'layout72' : '파일 크기',
            'layout73' : '수정 날짜',
            'layout74' : '원본 넓이',
            'layout75' : '원본 크기',
            
        },
              
          
          

           
        /*=========================================================================================
         * 영어권
        **---------------------------------------------------------------------------------------*/
        en: { // English
            'txt1': function(obj1, obj2) {  
                return '🚨 '+obj1 + 'th uploader list shape type is incorrect\nPlease use the correct type name\n\nCurrent shape name in use: ' + obj2;
            },
            'txt2': function(obj1, obj2) {
                return '🚨 To use file upload, an array \'modifyFile_Ary\' for the file to be modified must be defined';
            },
            'txt3': '🚨 You can upload files by using the upload button or by dragging and dropping them into the drop area',
            'txt4': '🚨 Preparing...',
            'txt5': function(obj1, obj2, obj3, obj4, obj5) {
                let msg1 = '';
                msg1 += '🚨 You can only upload up to ' + obj1 + ' files!!!\n\n';
                msg1 += '     Number of files already uploaded: ' + obj2 + '\n';
                msg1 += '     Number of files currently selected for upload: ' + obj3 + '\n';
                msg1 += '     The remaining ' + obj4 + ' files can be uploaded\n';
                msg1 += '     The last ' + obj5 + ' files will be excluded from the upload';
                return msg1;
            },
            'txt6': function(obj1, obj2, obj3) {
                let msg2 = '';
                msg2 += '🚨 The upload limit has been exceeded\nNo further uploads are allowed\n\n';
                if (obj1 && obj2) 
                    msg2 += '     Upload board: ' + obj1 + ' ( ' + obj2 + ' )\n';
                msg2 += '     Admin-defined upload limit: ' + obj3 + ' files';
                return msg2;
            },
            'txt7': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 The file size is too large, please reduce the size or upload a different file\n';
                msg += '     File name: ' + obj1 + ' ( about ' + obj2 + 'MB over )';
                return msg;
            },
            'txt8': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 The total upload size is too large\n\n';
                msg += '     Total uploaded size: ' + obj1 + obj2 + '\n';
                msg += '     Exceeded size: ' + obj3 + ' ( ' + obj4 + ' byte )\n';
                msg += '     Please delete other files or reduce the file size';
                return msg;
            },
            'txt9': function(obj1, obj2) {
                return '🚨 ' + obj1 + ' file cannot be used.\n\nAllowed uploadable files: [ ' + obj2 + ' ]';
            },
            'txt10': '🚨 The file name contains forbidden characters',
            'txt11': '🚨 There is an issue with uploading the file',
            'txt12': function(obj1) {
                return '🚨 '+listIdx + ' The file has an unknown property.\nPlease check and upload again';
            },
            'txt13': function(obj1) {
                return '🚨 [ ' + obj1 + ' ] is a file with an unregistered property';
            },
            'txt101': '🚨 The target_idx value is incorrect',
            'txt201': '🚨 The file name has no extension. Please enter a valid file name',
            'txt202': '     Please enter a valid extension. The extension is incorrect',
            'txt203': '     Please enter a file name that is at least one character long',
            'txt204': function(obj1, obj2) {
                return '🚨 '+obj1 + ' | ' + obj2 + ' Changing the file extension may make it unusable.\nDo you want to change it?';
            },
            'txt205': '🚨 The file name cannot exceed 255 characters',
            'txt206': function(obj1, obj2) {
                return '🚨 Duplicate file name exists\n\nSince the file name ' + obj1 + ' already exists, it will be changed to ' + obj2;
            },
            'txt601': function(obj1, obj2) {
                return '🚨 setFileInfo::' + obj1 + ' | ' + obj2 + ' Could not find dataCodes value';
            },
            'txt602': function(obj1, setFileExt) {
                return '🚨 '+obj1 + ' The datas object is invalid';
            },
        },

        /*=========================================================================================
         * 프랑스어
        **---------------------------------------------------------------------------------------*/
        fr: { // Français
            'txt1': function(obj1, obj2) {  //multi_uploader_code.js
                return '🚨 Le type de la liste de l\'uploader ' + obj1 + ' est incorrect\nVeuillez utiliser le bon nom de type\n\nNom du type utilisé : ' + obj2;
            },
            'txt2': function(obj1, obj2) {
                return '🚨 Pour utiliser l\'upload de fichiers, un tableau \'modifyFile_Ary\' pour les fichiers à modifier doit être défini';
            },
            'txt3': '🚨 Vous pouvez télécharger des fichiers en utilisant le bouton de téléchargement ou en déposant des fichiers dans la zone de dépôt',
            'txt4': '🚨 Préparation en cours',
            'txt5': function(obj1, obj2, obj3, obj4, obj5) {
                let msg1 = '';
                msg1 += '🚨 Vous pouvez télécharger au maximum ' + obj1 + ' fichiers!!!\n\n';
                msg1 += '     Nombre de fichiers déjà téléchargés : ' + obj2 + ' fichiers\n';
                msg1 += '     Nombre de fichiers actuellement sélectionnés pour téléchargement : ' + obj3 + ' fichiers\n';
                msg1 += '     Seuls ' + obj4 + ' fichiers peuvent être téléchargés, les ' + obj5 + ' derniers fichiers seront exclus du téléchargement';
                return msg1;
            },
            'txt6': function(obj1, obj2, obj3) {
                let msg2 = '';
                msg2 += '🚨 Le nombre de fichiers téléchargés dépasse la limite autorisée\nPlus de fichiers ne peuvent être téléchargés\n\n';
                if (obj1 && obj2)
                    msg2 += '     Tableau de téléchargement : ' + obj1 + ' ( ' + obj2 + ' )\n';
                msg2 += '     Nombre limite de fichiers téléchargés défini par l\'administrateur : ' + obj3 + ' fichiers';
                return msg2;
            },
            'txt7': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 Le fichier est trop volumineux, veuillez le réduire ou télécharger un autre fichier\n';
                msg += '     Nom du fichier : ' + obj1 + ' ( environ ' + obj2 + 'MB de trop )';
                return msg;
            },
            'txt8': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 La taille totale du téléchargement est trop grande\n\n';
                msg += '     Taille totale téléchargée : ' + obj1 + obj2 + '\n';
                msg += '     Taille excédentaire : ' + obj3 + ' ( ' + obj4 + ' octets )\n';
                msg += '     Veuillez supprimer d\'autres fichiers ou réduire la taille du fichier';
                return msg;
            },
            'txt9': function(obj1, obj2) {
                return '🚨 Le fichier ' + obj1 + ' ne peut pas être utilisé.\n\nFichiers téléchargeables autorisés\n[ ' + obj2 + ' ]';
            },
            'txt10': '🚨 Le nom du fichier contient des caractères interdits',
            'txt11': '🚨 Il y a un problème avec le téléchargement du fichier',
            'txt12': function(obj1) {
                return '🚨 ' + listIdx + ' Le fichier a un attribut inconnu.\nVeuillez vérifier avant de le télécharger';
            },
            'txt13': function(obj1) {
                return '🚨 [ ' + obj1 + ' ] est un fichier avec un attribut non enregistré';
            },
            'txt101': '🚨 La valeur de target_idx est incorrecte',
            'txt201': '🚨 Le nom du fichier ne contient pas d\'extension. Veuillez entrer un nom de fichier valide.',
            'txt202': '     Veuillez entrer une extension valide. L\'extension est incorrecte.',
            'txt203': '     Veuillez entrer un nom de fichier d\'au moins un caractère.',
            'txt204': function(obj1, obj2) {
                return '🚨 ' + obj1 + ' | ' + obj2 + ' Si vous changez l\'extension du fichier, il pourrait ne pas être utilisable.\nVoulez-vous le changer ?';
            },
            'txt205': '🚨 Le nom du fichier ne peut pas dépasser 255 caractères.',
            'txt206': function(obj1, obj2) {
                return '🚨 Un nom de fichier dupliqué existe\n\nÉtant donné que le nom de fichier ' + obj1 + ' existe déjà, il sera changé en ' + obj2;
            },
            'txt601': function(obj1, obj2) {
                return '🚨 setFileInfo::' + obj1 + ' | ' + obj2 + ' Impossible de trouver la valeur de dataCodes';
            },
            'txt602': function(obj1, setFileExt) {
                return '🚨 ' + obj1 + ' L\'objet datas n\'est pas valide';
            },
        },
 
          
        /*=========================================================================================
         * 독어
        **---------------------------------------------------------------------------------------*/
        de: { // Deutsch
            'txt1': function(obj1, obj2) {  
                return '🚨 '+obj1 + 'ter Uploader: Der Listentyp "Shape" ist ungültig.\nBitte verwenden Sie einen gültigen Typnamen.\n\nVerwendeter Shape-Name: ' + obj2;
            },
            'txt2': function(obj1, obj2) {
                return '🚨 Um den Datei-Upload zu verwenden, muss ein Array namens "modifyFile_Ary" für geänderte Dateien definiert sein.';
            },
            'txt3': '🚨 Laden Sie Dateien entweder über die Schaltfläche "Hochladen" hoch\noder ziehen Sie sie in den Upload-Bereich.',
            'txt4': '🚨 In Vorbereitung',
            'txt5': function(obj1, obj2, obj3, obj4, obj5) {
                let msg1 = '';
                msg1 += '🚨 Es können maximal ' + obj1 + ' Dateien hochgeladen werden!!!\n\n';
                msg1 += '     Bereits hochgeladen: ' + obj2 + ' Dateien\n';
                msg1 += '     Aktuell ausgewählt: ' + obj3 + ' Dateien\n';
                msg1 += '     Maximal hochladbar: ' + obj4 + ' Dateien\n';
                msg1 += '     Die letzten ' + obj5 + ' Dateien werden nicht hochgeladen.';
                return msg1;
            },
            'txt6': function(obj1, obj2, obj3) {
                let msg2 = '';
                msg2 += '🚨 Die maximale Anzahl an Uploads wurde überschritten.\nWeitere Uploads sind nicht möglich.\n\n';
                if (obj1 && obj2) 
                    msg2 += '     Upload-Bereich: ' + obj1 + ' ( ' + obj2 + ' )\n';
                msg2 += '     Maximal erlaubte Uploads: ' + obj3 + ' Dateien';
                return msg2;
            },
            'txt7': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 Die Datei ist zu groß. Bitte verkleinern oder eine andere Datei hochladen.\n';
                msg += '     Dateiname: ' + obj1 + ' ( ca. ' + obj2 + ' MB überschritten )';
                return msg;
            },
            'txt8': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 Die Gesamtgröße des Uploads ist zu groß.\n\n';
                msg += '     Hochgeladene Gesamtgröße: ' + obj1 + obj2 + '\n';
                msg += '     Überschrittene Größe: ' + obj3 + ' ( ' + obj4 + ' Byte )\n';
                msg += '     Bitte löschen Sie einige Dateien oder verkleinern Sie die Größe.';
                return msg;
            },
            'txt9': function(obj1, obj2) {
                return '🚨 ' + obj1 + ' Datei kann nicht verwendet werden.\n\nErlaubte Dateitypen:\n[ ' + obj2 + ' ]';
            },
            'txt10': '🚨 Der Dateiname enthält nicht erlaubte Zeichen.',
            'txt11': '🚨 Es gibt ein Problem mit dem Datei-Upload.',
            'txt12': function(obj1) {
                return '🚨 '+listIdx + ' Unbekannte Dateieigenschaft.\nBitte überprüfen und erneut hochladen.';
            },
            'txt13': function(obj1) {
                return '🚨 [ ' + obj1 + ' ] Datei mit nicht registrierter Eigenschaft.';
            },
            'txt101': '🚨 Der Wert von "target_idx" ist nicht korrekt.',
            'txt201': '🚨 Der Dateiname enthält keine Erweiterung. Bitte geben Sie einen gültigen Dateinamen ein.',
            'txt202': '     Bitte geben Sie eine gültige Erweiterung ein. Die aktuelle Erweiterung ist ungültig.',
            'txt203': '     Der Dateiname muss mindestens ein Zeichen enthalten.',
            'txt204': function(obj1, obj2) {
                return '🚨 '+obj1 + ' | ' + obj2 + ' Wenn Sie die Dateierweiterung ändern, kann die Datei möglicherweise nicht mehr verwendet werden.\nMöchten Sie die Änderung vornehmen?';
            },
            'txt205': '🚨 Der Dateiname darf 255 Zeichen nicht überschreiten.',
            'txt206': function(obj1, obj2) {
                return '🚨 Es gibt einen doppelten Dateinamen\n\nDa der Dateiname ' + obj1 + ' bereits existiert, wird er in ' + obj2 + ' geändert';
            },
            'txt601': function(obj1, obj2) {
                return '🚨 setFileInfo::' + obj1 + ' | ' + obj2 + ' dataCodes-Wert nicht gefunden.';
            },
            'txt602': function(obj1, setFileExt) {
                return '🚨 '+obj1 + ' Das "datas"-Objekt ist ungültig.';
            },
        },

        
        /*=========================================================================================
         * 러시아어
        **---------------------------------------------------------------------------------------*/
        ru: { // Русский
            'txt1': function(obj1, obj2) {  
                return '🚨 '+obj1 + '-й загрузчик: неверный тип списка "shape".\nИспользуйте правильное название типа.\n\nИспользуемый shape: ' + obj2;
            },
            'txt2': function(obj1, obj2) {
                return '🚨 Для использования загрузки файлов необходимо определить массив "modifyFile_Ary" для редактируемых файлов.';
            },
            'txt3': '🚨 Загрузите файлы с помощью кнопки загрузки\nили перетащите их в область загрузки.',
            'txt4': '🚨 В разработке',
            'txt5': function(obj1, obj2, obj3, obj4, obj5) {
                let msg1 = '';
                msg1 += '🚨 Можно загружать не более ' + obj1 + ' файлов!!!\n\n';
                msg1 += '     Уже загружено: ' + obj2 + ' файлов\n';
                msg1 += '     Выбрано для загрузки: ' + obj3 + ' файлов\n';
                msg1 += '     Доступно для загрузки: ' + obj4 + ' файлов\n';
                msg1 += '     Последние ' + obj5 + ' файлов не будут загружены.';
                return msg1;
            },
            'txt6': function(obj1, obj2, obj3) {
                let msg2 = '';
                msg2 += '🚨 Превышено максимальное количество загрузок.\nДальнейшая загрузка невозможна.\n\n';
                if (obj1 && obj2) 
                    msg2 += '     Доска загрузки: ' + obj1 + ' ( ' + obj2 + ' )\n';
                msg2 += '     Максимально разрешенное количество загрузок: ' + obj3 + ' файлов';
                return msg2;
            },
            'txt7': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 Размер файла слишком велик. Уменьшите его или выберите другой файл.\n';
                msg += '     Имя файла: ' + obj1 + ' ( превышает примерно ' + obj2 + ' МБ )';
                return msg;
            },
            'txt8': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 Общий размер загрузки слишком велик.\n\n';
                msg += '     Общий размер загруженных файлов: ' + obj1 + obj2 + '\n';
                msg += '     Превышенный размер: ' + obj3 + ' ( ' + obj4 + ' байт )\n';
                msg += '     Удалите ненужные файлы или уменьшите их размер.';
                return msg;
            },
            'txt9': function(obj1, obj2) {
                return '🚨 Файл ' + obj1 + ' не может быть использован.\n\nРазрешенные форматы файлов:\n[ ' + obj2 + ' ]';
            },
            'txt10': '🚨 Имя файла содержит запрещенные символы.',
            'txt11': '🚨 Произошла ошибка при загрузке файла.',
            'txt12': function(obj1) {
                return '🚨 '+listIdx + ' Неизвестный атрибут файла.\nПроверьте файл перед загрузкой.';
            },
            'txt13': function(obj1) {
                return '🚨 [ ' + obj1 + ' ] Файл с незарегистрированным атрибутом.';
            },
            'txt101': '🚨 Значение "target_idx" некорректно.',
            'txt201': '🚨 В имени файла отсутствует расширение. Введите правильное имя файла.',
            'txt202': '     Введите корректное расширение. Неправильный формат файла.',
            'txt203': '     Имя файла должно содержать хотя бы один символ.',
            'txt204': function(obj1, obj2) {
                return '🚨 '+obj1 + ' | ' + obj2 + ' Изменение расширения файла может сделать его недоступным.\nВы уверены, что хотите изменить?';
            },
            'txt205': '🚨 Имя файла не может превышать 255 символов.',
            'txt206': function(obj1, obj2) {
                return '🚨 Существует дублирующееся имя файла\n\nТак как файл с именем ' + obj1 + ' уже существует, он будет переименован в ' + obj2;
            },
            'txt601': function(obj1, obj2) {
                return '🚨 setFileInfo::' + obj1 + ' | ' + obj2 + ' Не удалось найти значение dataCodes.';
            },
            'txt602': function(obj1, setFileExt) {
                return '🚨 '+obj1 + ' Объект "datas" недействителен.';
            },
        },

        
        /*=========================================================================================
         * 아랍어
        **---------------------------------------------------------------------------------------*/
        ar: { // العربية
            'txt1': function(obj1, obj2) {  
                return '🚨 '+obj1 + ' - رقم تحميل غير صحيح لقائمة نوع "shape".\nيرجى استخدام النوع الصحيح.\n\nالنوع المستخدم: ' + obj2;
            },
            'txt2': function(obj1, obj2) {
                return '🚨 لتحميل الملفات، يجب تعريف مصفوفة "modifyFile_Ary" التي تحتوي على الملفات المعدلة.';
            },
            'txt3': '🚨 يمكنك تحميل الملفات باستخدام زر التحميل\nأو عن طريق سحبها إلى منطقة التحميل.',
            'txt4': '🚨 تحت الإعداد',
            'txt5': function(obj1, obj2, obj3, obj4, obj5) {
                let msg1 = '';
                msg1 += '🚨 يمكنك تحميل ' + obj1 + ' ملف كحد أقصى!!!\n\n';
                msg1 += '     عدد الملفات المحملة في القائمة: ' + obj2 + ' ملف\n';
                msg1 += '     عدد الملفات المحددة حاليًا: ' + obj3 + ' ملف\n';
                msg1 += '     سيتم استبعاد ' + obj5 + ' ملف من التحميل.';
                return msg1;
            },
            'txt6': function(obj1, obj2, obj3) {
                let msg2 = '';
                msg2 += '🚨 تم تحميل أكثر من الحد الأقصى المسموح به.\nلا يمكن تحميل المزيد من الملفات.\n\n';
                if (obj1 && obj2) 
                    msg2 += '     لوحة التحميل: ' + obj1 + ' ( ' + obj2 + ' )\n';
                msg2 += '     الحد الأقصى المسموح به من قبل المسؤول: ' + obj3 + ' ملفات';
                return msg2;
            },
            'txt7': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 حجم الملف كبير جدًا. قلل حجمه أو اختر ملفًا آخر.\n';
                msg += '     اسم الملف: ' + obj1 + ' ( يتجاوز بحوالي ' + obj2 + 'MB )';
                return msg;
            },
            'txt8': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 حجم التحميل الإجمالي كبير جدًا.\n\n';
                msg += '     إجمالي حجم التحميل: ' + obj1 + obj2 + '\n';
                msg += '     الحجم الزائد: ' + obj3 + ' ( ' + obj4 + ' بايت )\n';
                msg += '     يرجى حذف بعض الملفات أو تقليص حجمها.';
                return msg;
            },
            'txt9': function(obj1, obj2) {
                return '🚨 الملف ' + obj1 + ' غير صالح.\n\nالملفات المسموح بها هي:\n[ ' + obj2 + ' ]';
            },
            'txt10': '🚨 اسم الملف يحتوي على أحرف غير مسموح بها.',
            'txt11': '🚨 هناك مشكلة في تحميل الملف.',
            'txt12': function(obj1) {
                return '🚨 '+listIdx + ' الملف يحتوي على خاصية غير معروفة.\nيرجى التحقق من الملف قبل تحميله.';
            },
            'txt13': function(obj1) {
                return '🚨 [ ' + obj1 + ' ] ملف يحتوي على خاصية غير مسجلة.';
            },
            'txt101': '🚨 قيمة "target_idx" غير صحيحة.',
            'txt201': '🚨 اسم الملف لا يحتوي على امتداد. يرجى إدخال اسم ملف صحيح.',
            'txt202': '     يرجى إدخال امتداد صحيح. الامتداد غير صحيح.',
            'txt203': '     يجب إدخال اسم ملف يتكون من حرف واحد على الأقل.',
            'txt204': function(obj1, obj2) {
                return '🚨 '+obj1 + ' | ' + obj2 + ' تغيير امتداد الملف قد يجعله غير صالح.\nهل تريد تغيير الامتداد؟';
            },
            'txt205': '🚨 اسم الملف لا يمكن أن يتجاوز 255 حرفًا.',
            'txt206': function(obj1, obj2) {
                return '🚨 هناك اسم ملف مكرر\n\nبما أن الملف باسم ' + obj1 + ' موجود بالفعل، سيتم تغييره إلى ' + obj2;
            },
            'txt601': function(obj1, obj2) {
                return '🚨 setFileInfo::' + obj1 + ' | ' + obj2 + ' لا يمكن العثور على قيمة dataCodes.';
            },
            'txt602': function(obj1, setFileExt) {
                return '🚨 '+obj1 + ' كائن "datas" غير صالح.';
            },
        },

        
        /*=========================================================================================
         * 일본어
        **---------------------------------------------------------------------------------------*/
        ja: { // 日本語
            'txt1': function(obj1, obj2) {  
                return obj1 + '🚨 番目のアップローダーのリスト形状タイプが正しくありません\n正しいタイプ名を使用してください\n\n使用中のタイプ名: ' + obj2;
            },
            'txt2': function(obj1, obj2) {
                return '🚨 ファイルをアップロードするには、修正用ファイルを格納する配列「modifyFile_Ary」が定義されている必要があります';
            },
            'txt3': '🚨 ファイルアップロードはアップロードボタンを使用するか\nファイルドロップエリアにドロップしてください',
            'txt4': '🚨 準備中です',
            'txt5': function(obj1, obj2, obj3, obj4, obj5) {
                let msg1 = '';
                msg1 += '🚨 ファイルは ' + obj1 + ' 個以下のみアップロードできます!!!\n\n';
                msg1 += '     リストにアップロードされた数: ' + obj2 + '個\n';
                msg1 += '     現在アップロードするために選択された数: ' + obj3 + '個\n';
                msg1 += '     アップロードできる' + obj4 + '個を除外し\n';
                msg1 += '     最後の' + obj5 + '個はアップロードから除外されます';
                return msg1;
            },
            'txt6': function(obj1, obj2, obj3) {
                let msg2 = '';
                msg2 += '🚨 アップロード制限数以上がアップロードされています\nこれ以上アップロードできません\n\n';
                if (obj1 && obj2) 
                    msg2 += '     アップロード掲示板: ' + obj1 + ' ( ' + obj2 + ' )\n';
                msg2 += '     管理者が設定したアップロード制限数: ' + obj3 + '個';
                return msg2;
            },
            'txt7': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 ファイルのサイズが大きすぎます。縮小するか、別のファイルをアップロードしてください\n';
                msg += '     ファイル名: ' + obj1 + ' ( 約 ' + obj2 + 'MB オーバー )';
                return msg;
            },
            'txt8': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 全体のアップロードサイズが大きすぎます\n\n';
                msg += '     合計アップロード: ' + obj1 + obj2 + '\n';
                msg += '     オーバーサイズ: ' + obj3 + ' ( ' + obj4 + 'バイト )\n';
                msg += '     他のファイルを削除するか、容量を減らしてください';
                return msg;
            },
            'txt9': function(obj1, obj2) {
                return '🚨 ' + obj1 + ' ファイルは使用できません。\n\nアップロード可能なファイル\n[ ' + obj2 + ' ]';
            },
            'txt10': '🚨 ファイル名に許可されていない文字が含まれています。',
            'txt11': '🚨 ファイルのアップロードに問題があります。',
            'txt12': function(obj1) {
                return '🚨 '+listIdx + ' 不明な属性のファイルです。\n確認後にアップロードしてください';
            },
            'txt13': function(obj1) {
                return '🚨 [ ' + obj1 + ' ] 登録されていない属性のファイルです';
            },
            'txt101': '🚨 target_idxの値が正しくありません',
            'txt201': '🚨 ファイル名に拡張子がありません。正しいファイル名を入力してください。',
            'txt202': '     正しい拡張子を入力してください。拡張子が正しくありません。',
            'txt203': '     最低1文字以上のファイル名を入力してください。',
            'txt204': function(obj1, obj2) {
                return '🚨 '+obj1 + ' | ' + obj2 + ' ファイルの拡張子を変更すると使用できなくなる可能性があります。\n変更しますか？';
            },
            'txt205': '🚨 ファイル名は255文字を超えることはできません。',
            'txt206': function(obj1, obj2) {
                return '🚨 重複したファイル名が存在します\n\n' + obj1 + 'というファイル名が存在するため、\n' + obj2 + 'に変更されます';
            },
            'txt601': function(obj1, obj2) {
                return '🚨 setFileInfo::' + obj1 + ' | ' + obj2 + 'dataCodes値が見つかりません';
            },
            'txt602': function(obj1, setFileExt) {
                return '🚨 '+obj1 + ' datasオブジェクトが無効です。';
            },
        },

        
        /*=========================================================================================
         * 중국어
        **---------------------------------------------------------------------------------------*/
        zh: { // 中文
            'txt1': function(obj1, obj2) {  
                return '🚨 '+obj1 + '号上传器的列表形状类型不正确\n请使用正确的类型名\n\n正在使用的类型名: ' + obj2;
            },
            'txt2': function(obj1, obj2) {
                return '🚨 要使用文件上传功能，必须定义一个存储修改文件的数组 "modifyFile_Ary"';
            },
            'txt3': '🚨 文件上传请使用上传按钮，或将文件拖放到上传区域',
            'txt4': '🚨 正在准备中',
            'txt5': function(obj1, obj2, obj3, obj4, obj5) {
                let msg1 = '';
                msg1 += '🚨 文件最多只能上传 ' + obj1 + ' 个!!!\n\n';
                msg1 += '     已上传的数量: ' + obj2 + '个\n';
                msg1 += '     当前选择上传的数量: ' + obj3 + '个\n';
                msg1 += '     除去最多上传的' + obj4 + '个\n';
                msg1 += '     最后的' + obj5 + '个将被排除在上传之外';
                return msg1;
            },
            'txt6': function(obj1, obj2, obj3) {
                let msg2 = '';
                msg2 += '🚨 已经上传超过上传限制数量\n无法再上传\n\n';
                if (obj1 && obj2) 
                    msg2 += '     上传板块: ' + obj1 + ' ( ' + obj2 + ' )\n';
                msg2 += '     管理员设置的上传限制数量: ' + obj3 + '个';
                return msg2;
            },
            'txt7': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 文件大小太大，请缩小文件或上传其他文件\n';
                msg += '     文件名: ' + obj1 + ' ( 超过约 ' + obj2 + 'MB )';
                return msg;
            },
            'txt8': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 总体上传大小太大\n\n';
                msg += '     总上传: ' + obj1 + obj2 + '\n';
                msg += '     超出大小: ' + obj3 + ' ( ' + obj4 + '字节 )\n';
                msg += '     请删除其他文件或减小文件大小';
                return msg;
            },
            'txt9': function(obj1, obj2) {
                return '🚨 ' + obj1 + ' 文件不能使用。\n\n可以上传的文件\n[ ' + obj2 + ' ]';
            },
            'txt10': '🚨 文件名包含不允许的字符。',
            'txt11': '     文件上传出现问题。',
            'txt12': function(obj1) {
                return '🚨 '+listIdx + ' 文件有未知的属性。\n请检查后再上传';
            },
            'txt13': function(obj1) {
                return '🚨 [ ' + obj1 + ' ] 是未注册属性的文件';
            },
            'txt101': 'target_idx 值不正确',
            'txt201': '🚨 文件名没有扩展名，请输入正确的文件名。',
            'txt202': '     请输入正确的扩展名，扩展名不正确。',
            'txt203': '     请至少输入一个字符以上的文件名。',
            'txt204': function(obj1, obj2) {
                return '🚨 '+obj1 + ' | ' + obj2 + ' 文件的扩展名更改后可能无法使用。\n您确定要更改吗？';
            },
            'txt205': '🚨 文件名不能超过255个字符。',
            'txt206': function(obj1, obj2) {
                return '🚨 存在重复的文件名\n\n由于存在' + obj1 + '文件名，\n将更改为' + obj2;
            },
            'txt601': function(obj1, obj2) {
                return '🚨 setFileInfo::' + obj1 + ' | ' + obj2 + 'dataCodes值无法找到';
            },
            'txt602': function(obj1, setFileExt) {
                return '🚨 '+obj1 + ' datas对象无效。';
            },
        },

        
        /*=========================================================================================
         * 베트남어
        **---------------------------------------------------------------------------------------*/
        vi: { // Tiếng Việt
            'txt1': function(obj1, obj2) {  
                return '🚨 Danh sách của uploader ' + obj1 + ' có loại hình không hợp lệ\nVui lòng sử dụng tên loại hợp lệ\n\nTên loại đang sử dụng: ' + obj2;
            },
            'txt2': function(obj1, obj2) {
                return '🚨 Để sử dụng tính năng tải lên tệp, bạn phải định nghĩa một mảng "modifyFile_Ary" chứa các tệp để chỉnh sửa';
            },
            'txt3': '🚨 Để tải lên tệp, vui lòng sử dụng nút tải lên hoặc kéo tệp vào khu vực tải lên',
            'txt4': '🚨 Đang chuẩn bị',
            'txt5': function(obj1, obj2, obj3, obj4, obj5) {
                let msg1 = '';
                msg1 += '🚨 Chỉ có thể tải lên tối đa ' + obj1 + ' tệp!!!\n\n';
                msg1 += '     Số lượng đã tải lên: ' + obj2 + ' tệp\n';
                msg1 += '     Số lượng tệp hiện tại đã chọn để tải lên: ' + obj3 + ' tệp\n';
                msg1 += '     Số lượng tệp có thể tải lên là ' + obj4 + ' tệp, các tệp còn lại sẽ bị loại bỏ\n';
                msg1 += '     Cuối cùng ' + obj5 + ' tệp sẽ bị loại khỏi quá trình tải lên';
                return msg1;
            },
            'txt6': function(obj1, obj2, obj3) {
                let msg2 = '';
                msg2 += '🚨 Số lượng tải lên vượt quá giới hạn\nKhông thể tải lên thêm nữa\n\n';
                if (obj1 && obj2) 
                    msg2 += '     Khu vực tải lên: ' + obj1 + ' ( ' + obj2 + ' )\n';
                msg2 += '     Giới hạn tải lên do quản trị viên thiết lập: ' + obj3 + ' tệp';
                return msg2;
            },
            'txt7': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 Tệp quá lớn, hãy giảm kích thước hoặc tải lên tệp khác\n';
                msg += '     Tên tệp: ' + obj1 + ' ( Vượt quá ' + obj2 + 'MB )';
                return msg;
            },
            'txt8': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 Tổng kích thước tải lên quá lớn\n\n';
                msg += '     Tổng kích thước tải lên: ' + obj1 + obj2 + '\n';
                msg += '     Kích thước vượt quá: ' + obj3 + ' ( ' + obj4 + ' byte )\n';
                msg += '     Vui lòng xóa tệp khác hoặc giảm kích thước tệp';
                return msg;
            },
            'txt9': function(obj1, obj2) {
                return '🚨 ' + obj1 + ' tệp không thể sử dụng.\n\nTệp có thể tải lên\n[ ' + obj2 + ' ]';
            },
            'txt10': '🚨 Tên tệp chứa ký tự không hợp lệ.',
            'txt11': '🚨 Có vấn đề với việc tải lên tệp.',
            'txt12': function(obj1) {
                return '🚨 '+listIdx + ' Tệp có thuộc tính không xác định.\nVui lòng kiểm tra và tải lên lại';
            },
            'txt13': function(obj1) {
                return '🚨 [ ' + obj1 + ' ] là tệp có thuộc tính chưa đăng ký';
            },
            'txt101': '🚨 Giá trị target_idx không chính xác',
            'txt201': '🚨 Tệp không có phần mở rộng. Vui lòng nhập tên tệp hợp lệ.',
            'txt202': '     Vui lòng nhập phần mở rộng hợp lệ. Phần mở rộng không hợp lệ.',
            'txt203': '     Vui lòng nhập tên tệp dài ít nhất một ký tự.',
            'txt204': function(obj1, obj2) {
                return '🚨 '+obj1 + ' | ' + obj2 + ' Đổi phần mở rộng tệp có thể khiến tệp không sử dụng được.\nBạn có chắc chắn muốn thay đổi không?';
            },
            'txt205': '🚨 Tên tệp không thể vượt quá 255 ký tự.',
            'txt206': function(obj1, obj2) {
                return '🚨 Tồn tại tên tệp trùng lặp\n\nVì tên tệp ' + obj1 + ' đã tồn tại, sẽ thay đổi thành ' + obj2;
            },
            'txt601': function(obj1, obj2) {
                return '🚨 setFileInfo::' + obj1 + ' | ' + obj2 + ' không thể tìm thấy giá trị dataCodes';
            },
            'txt602': function(obj1, setFileExt) {
                return '🚨 '+obj1 + 'Đối tượng datas không hợp lệ.';
            },
        },

        
        /*=========================================================================================
         * 몽골어
        **---------------------------------------------------------------------------------------*/
        mn: { // Монгол хэл
            'txt1': function(obj1, obj2) {  
                return '🚨 '+obj1 + ' дахь uploader-ийн жагсаалтын төрлийн төрөл буруу байна\nЗөв төрлийн нэрийг ашиглана уу\n\nОдоо ашиглаж буй төрлийн нэр: ' + obj2;
            },
            'txt2': function(obj1, obj2) {
                return '🚨 Файл татаж авахын тулд засварлах зориулалттай файлуудын "modifyFile_Ary" массивыг тодорхойлох шаардлагатай';
            },
            'txt3': '🚨 Файл татаж авахын тулд татах товчийг ашиглах эсвэл файл хаягдлын талбайд файлыг хаяна уу',
            'txt4': '🚨 Бэлдэж байна',
            'txt5': function(obj1, obj2, obj3, obj4, obj5) {
                let msg1 = '';
                msg1 += '🚨 Татаж авах боломжтой файлын тоо ' + obj1 + ' дотор байна!!!\n\n';
                msg1 += '     Жагсаалтанд татаж авсан тоо: ' + obj2 + ' файл\n';
                msg1 += '     Одоо татаж авах сонгосон тоо: ' + obj3 + ' файл\n';
                msg1 += '     Татаж авах боломжтой ' + obj4 + ' файл, үлдсэн\n';
                msg1 += '     сүүлийн ' + obj5 + ' файлыг татаж авах боломжгүй байна';
                return msg1;
            },
            'txt6': function(obj1, obj2, obj3) {
                let msg2 = '';
                msg2 += '🚨 Татаж авах хязгаарын тоо хэтэрсэн байна\nДахин татаж авах боломжгүй байна\n\n';
                if (obj1 && obj2) 
                    msg2 += '     Татаж авах самбар: ' + obj1 + ' ( ' + obj2 + ' )\n';
                msg2 += '     Захиргааны тохируулсан татаж авах хязгаарын тоо: ' + obj3 + ' файл';
                return msg2;
            },
            'txt7': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 Файл хэмжээ их байна, хэмжээ бууруулж эсвэл өөр файл тавиарай\n';
                msg += '     Файлын нэр: ' + obj1 + ' ( ойролцоогоор ' + obj2 + 'MB илүү )';
                return msg;
            },
            'txt8': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 Нийт файл татаж авах хэмжээ хэтэрсэн байна\n\n';
                msg += '     Нийт татаж авах хэмжээ: ' + obj1 + obj2 + '\n';
                msg += '     Хэтэрсэн хэмжээ: ' + obj3 + ' ( ' + obj4 + ' byte )\n';
                msg += '     Өөр файл устгах эсвэл хэмжээ бууруулах шаардлагатай байна';
                return msg;
            },
            'txt9': function(obj1, obj2) {
                return '🚨 ' + obj1 + ' файлыг ашиглах боломжгүй.\n\nТатаж авах боломжтой файлууд\n[ ' + obj2 + ' ]';
            },
            'txt10': '🚨 Файлын нэрд зөвшөөрөгдсөн тэмдэгтүүд орсон байна.',
            'txt11': '🚨 Файл татаж авахад асуудал гарсан байна.',
            'txt12': function(obj1) {
                return '🚨 '+listIdx + ' Тодорхойгүй шинж чанартай файл байна.\nШалгаж дараа нь оруулна уу';
            },
            'txt13': function(obj1) {
                return '🚨 [ ' + obj1 + ' ] нь бүртгэгдээгүй шинж чанартай файл байна';
            },
            'txt101': '🚨 target_idx утга буруу байна',
            'txt201': '🚨 Файлд өргөтгөл байхгүй байна. Зөв файл нэрийг оруулна уу.',
            'txt202': '     Зөв өргөтгөлийг оруулна уу. Өргөтгөл буруу байна.',
            'txt203': '     Ядаж нэг тэмдэгттэй файл нэр оруулна уу.',
            'txt204': function(obj1, obj2) {
                return obj1 + ' | ' + obj2 + ' файл өргөтгөлийг өөрчлөхөд ашиглах боломжгүй болно.\nӨөрчлөх үү?';
            },
            'txt205': '🚨 Файлын нэр 255 тэмдэгтээс хэтрэхгүй байх ёстой.',
            'txt206': function(obj1, obj2) {
                return '🚨 Давхардсан файлын нэр байна\n\n' + obj1 + ' нэртэй файл аль хэдийн оршиж байгаа тул\n' + obj2 + ' болгож өөрчлөнө';
            },
            'txt601': function(obj1, obj2) {
                return '🚨 setFileInfo::' + obj1 + ' | ' + obj2 + ' dataCodes утгыг олж чадсангүй';
            },
            'txt602': function(obj1, setFileExt) {
                return '🚨 '+obj1 + ' datas объект хэвийн биш байна.';
            },
        },

        
        /*=========================================================================================
         * 태국어
        **---------------------------------------------------------------------------------------*/
        th: { // ภาษาไทย
            'txt1': function(obj1, obj2) {  
                return '🚨 '+obj1 + ' อัพโหลดรายการชนิดไม่ถูกต้อง\nกรุณาใช้ชื่อชนิดที่ถูกต้อง\n\nชื่อชนิดที่ใช้ตอนนี้: ' + obj2;
            },
            'txt2': function(obj1, obj2) {
                return '🚨 การอัพโหลดไฟล์จำเป็นต้องมีการกำหนดอาเรย์ \'modifyFile_Ary\' สำหรับไฟล์ที่จะแก้ไข';
            },
            'txt3': '🚨 การอัพโหลดไฟล์สามารถทำได้โดยการใช้ปุ่มอัพโหลดหรือลากไฟล์ไปวางในพื้นที่การลากไฟล์',
            'txt4': '🚨 กำลังเตรียมการ',
            'txt5': function(obj1, obj2, obj3, obj4, obj5) {
                let msg1 = '';
                msg1 += '🚨 คุณสามารถอัพโหลดไฟล์ได้ไม่เกิน ' + obj1 + ' ไฟล์เท่านั้น!!!\n\n';
                msg1 += '     จำนวนไฟล์ที่อัพโหลดแล้ว: ' + obj2 + ' ไฟล์\n';
                msg1 += '     จำนวนไฟล์ที่เลือกสำหรับอัพโหลดตอนนี้: ' + obj3 + ' ไฟล์\n';
                msg1 += '     จะสามารถอัพโหลดได้ ' + obj4 + ' ไฟล์ที่เหลือ\n';
                msg1 += '     ไฟล์สุดท้าย ' + obj5 + ' ไฟล์จะไม่ได้รับการอัพโหลด';
                return msg1;
            },
            'txt6': function(obj1, obj2, obj3) {
                let msg2 = '';
                msg2 += '🚨 จำนวนไฟล์ที่อัพโหลดเกินขีดจำกัด\nไม่สามารถอัพโหลดได้อีก\n\n';
                if (obj1 && obj2) 
                    msg2 += '     กระดานอัพโหลด: ' + obj1 + ' ( ' + obj2 + ' )\n';
                msg2 += '     ขีดจำกัดจำนวนไฟล์ที่กำหนดโดยผู้ดูแลระบบ: ' + obj3 + ' ไฟล์';
                return msg2;
            },
            'txt7': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 ขนาดไฟล์ใหญ่เกินไป กรุณาลดขนาดหรือลองอัพโหลดไฟล์อื่น\n';
                msg += '     ชื่อไฟล์: ' + obj1 + ' ( เกินประมาณ ' + obj2 + 'MB )';
                return msg;
            },
            'txt8': function(obj1, obj2) {
                let msg = '';
                msg += '🚨 ขนาดรวมของไฟล์ที่อัพโหลดใหญ่เกินไป\n\n';
                msg += '     ขนาดรวมของไฟล์ที่อัพโหลด: ' + obj1 + obj2 + '\n';
                msg += '     ขนาดที่เกิน: ' + obj3 + ' ( ' + obj4 + ' byte )\n';
                msg += '     กรุณาลบไฟล์อื่นหรือปรับขนาดไฟล์';
                return msg;
            },
            'txt9': function(obj1, obj2) {
                return '🚨 ' + obj1 + ' ไฟล์ไม่สามารถใช้ได้.\n\nไฟล์ที่สามารถอัพโหลดได้\n[ ' + obj2 + ' ]';
            },
            'txt10': '🚨 ชื่อไฟล์มีอักขระที่ไม่อนุญาต',
            'txt11': '🚨 มีปัญหาในการอัพโหลดไฟล์',
            'txt12': function(obj1) {
                return '🚨 '+listIdx + ' ไฟล์นี้มีคุณสมบัติที่ไม่รู้จัก\nกรุณาตรวจสอบแล้วอัพโหลดใหม่';
            },
            'txt13': function(obj1) {
                return '🚨 [ ' + obj1 + ' ] ไฟล์มีคุณสมบัติที่ไม่ได้ลงทะเบียน';
            },
            'txt101': '🚨 ค่าของ target_idx ไม่ถูกต้อง',
            'txt201': '🚨 ไฟล์ไม่มีนามสกุล กรุณากรอกชื่อไฟล์ที่ถูกต้อง',
            'txt202': '🚨 กรุณากรอกนามสกุลที่ถูกต้อง นามสกุลไม่ถูกต้อง',
            'txt203': '🚨 กรุณากรอกชื่อไฟล์ที่มีความยาวอย่างน้อยหนึ่งตัวอักษร',
            'txt204': function(obj1, obj2) {
                return '🚨 '+obj1 + ' | ' + obj2 + ' การเปลี่ยนนามสกุลไฟล์อาจทำให้ไม่สามารถใช้งานได้\nคุณต้องการเปลี่ยนแปลงหรือไม่?';
            },
            'txt205': '🚨 ชื่อไฟล์ไม่สามารถเกิน 255 ตัวอักษรได้',
            'txt206': function(obj1, obj2) {
                return '🚨 มีชื่อไฟล์ที่ซ้ำกัน\n\nเนื่องจากมีไฟล์ชื่อ ' + obj1 + ' อยู่แล้ว\nจึงจะเปลี่ยนชื่อเป็น ' + obj2;
            },
            'txt601': function(obj1, obj2) {
                return '🚨 setFileInfo::' + obj1 + ' | ' + obj2 + ' ไม่พบค่า dataCodes';
            },
            'txt602': function(obj1, setFileExt) {
                return '🚨 '+obj1 + ' ออบเจ็กต์ datas ไม่ถูกต้อง';
            },
        }, 
        
        
     }// end langObj
}// end if

 

 