<?php
declare(strict_types=1);

use Damoang\G5Plugin\Reaction\Controllers\ReactionController;
use Damoang\G5Plugin\Reaction\Models\ReactionModel;

require_once '../../../common.php';

if (!headers_sent()) {
    header('Content-Type: application/json');
}

(function ($member) {
    $request_raw = file_get_contents('php://input');
    $requestData = json_decode($request_raw, true);

    $reactionMode = $requestData['reactionMode'] ?? 'add';
    $reaction = $requestData['reaction'] ?? '';
    $targetId = $requestData['targetId'] ?? '';
    $parentId = $requestData['parentId'] ?? '';

    try {
        ReactionController::react($member, $reactionMode, $reaction, $targetId, $parentId);
    } catch (\Exception $e) {
        echo json_encode([
            'error' => -1,
            'message' => $e->getMessage(),
        ], JSON_PRETTY_PRINT);
        exit;
    }

    // 요청 처리 후 대상의 리액션 데이터 반환
    $reactions = ReactionModel::getReactions($targetId, $member['mb_id'])[$targetId] ?? [];

    echo json_encode([
        'error' => 0,
        'reactions' => $reactions,
    ], JSON_PRETTY_PRINT);
})($GLOBALS['member']);
