<?php
declare(strict_types=1);

use Damoang\G5Plugin\Reaction\Reaction;

if (!defined('_GNUBOARD_')) {
    exit();
}

require_once __DIR__ . '/vendor/autoload.php';

define('DA_PLUGIN_REACTION_VERSION', '1.0.2');
define('DA_PLUGIN_REACTION_VERSION_ID', 10001);
define('DA_PLUGIN_REACTION_PATH', __DIR__);
define('DA_PLUGIN_REACTION_DIR', basename(DA_PLUGIN_REACTION_PATH));
define('DA_PLUGIN_REACTION_URL', \G5_PLUGIN_URL . '/' . DA_PLUGIN_REACTION_DIR);

add_event('tail_sub', function () {
    Reaction::head();
});

// TODO
add_event('bbs_delete', function ($write, $board) {
    // 글 삭제 시 리액션 삭제
}, G5_HOOK_DEFAULT_PRIORITY, 2);

// TODO
add_event('bbs_delete_comment', function ($comment_id, $board) {
    // 댓글 삭제 시 리액션 삭제
}, G5_HOOK_DEFAULT_PRIORITY, 2);

add_replace('admin_dbupgrade', function ($is_check) {
    global $config;

    $table = G5_TABLE_PREFIX . 'da_reaction';
    if (!sql_query("DESC {$table}", false)) {
        sql_query("CREATE TABLE IF NOT EXISTS `{$table}` (
            `id` bigint unsigned NOT NULL AUTO_INCREMENT,
            `parent_id` varchar(250) CHARACTER SET ascii NOT NULL,
            `target_id` varchar(250) CHARACTER SET ascii NOT NULL,
            `reaction` varchar(250) CHARACTER SET ascii NOT NULL,
            `reaction_count` int DEFAULT '0',
            PRIMARY KEY (`id`),
            UNIQUE KEY `u_reaction` (`target_id`,`reaction`),
            KEY `i_parent_id` (`parent_id`)
        ) ENGINE=InnoDB", true);

        $is_check = true;
    }

    $table = G5_TABLE_PREFIX . 'da_reaction_choose';
    if (!sql_query("DESC {$table} ", false)) {
        sql_query("CREATE TABLE IF NOT EXISTS `{$table}` (
            `id` int unsigned NOT NULL AUTO_INCREMENT,
            `member_id` varchar(50) CHARACTER SET ascii NOT NULL,
            `parent_id` varchar(250) CHARACTER SET ascii NOT NULL,
            `target_id` varchar(250) CHARACTER SET ascii NOT NULL,
            `reaction` varchar(250) CHARACTER SET ascii NOT NULL,
            `created_at` datetime NOT NULL,
            PRIMARY KEY (`id`),
            UNIQUE KEY `u_reaction` (`member_id`,`target_id`,`reaction`),
            KEY `i_parent_id` (`member_id`,`parent_id`)
        ) ENGINE=InnoDB", true);

        $is_check = true;
    }

    return $is_check;
}, G5_HOOK_DEFAULT_PRIORITY, 1);
