<?php
declare(strict_types=1);

namespace Damoang\G5Plugin\Reaction\Controllers;

use Damoang\G5Plugin\Reaction\Models\ReactionModel;
use Damoang\G5Plugin\Reaction\Reaction;
use Damoang\G5Plugin\Reaction\ReactionHelper;
use Exception;

class ReactionController
{
    /**
     * 리액션 추가 및 취소
     *
     * @param string[] $member
     */
    public static function react(array $member, string $reactionMode, string $reaction, string $targetId, string $parentId): bool
    {
        if (!$member['mb_id']) {
            throw new Exception('로그인 후 이용 가능합니다.');
        }

        ReactionHelper::validateReactionId($reaction);
        ReactionHelper::validateTargetId($targetId);
        if ($parentId) {
            ReactionHelper::validateTargetId($parentId);
        }

        // 리액션 제한 확인
        $reactable = ReactionModel::reactable($targetId, $reaction, $member);

        if ($reactionMode === 'toggle' && $reactable ^ Reaction::REACTABLE_ADD) {
            return ReactionModel::revokeReaction($member['mb_id'], $reaction, $targetId);
        } else if ($reactable & Reaction::REACTABLE_ADD) {
            return ReactionModel::addReaction($member['mb_id'], $reaction, $targetId, $parentId);
        }

        return false;
    }
}
