<?php
declare(strict_types=1);

namespace Damoang\G5Plugin\Reaction;

use Damoang\G5Plugin\Reaction\Exceptions\ReactionIdTooLongException;
use Damoang\G5Plugin\Reaction\Exceptions\TargetIdTooLongException;
use Damoang\G5Plugin\Reaction\Models\ReactionModel;
use Damoang\G5Plugin\Reaction\Models\ReactionModelMysqli;
use Damoang\G5Plugin\Reaction\Models\ReactionModelPDO;
use Exception;

/**
 * @template TReactionItem of array{
 *     reaction: string,
 *     category: string,
 *     reactionId: string,
 *     count: int,
 *     choose: bool,
 * }
 */
class Reaction
{
    public const NOT_REACTABLE = 0;
    public const REACTABLE_ADD = 1;
    public const REACTABLE_REVOKE = 2;
    public const REACTABLE = 3;

    /** @var string */
    public static $tableReaction = \G5_TABLE_PREFIX . 'da_reaction';
    /** @var string */
    public static $tableChoose = \G5_TABLE_PREFIX . 'da_reaction_choose';

    /**
     * @return \mysqli
     */
    public static function db()
    {
        return $GLOBALS['g5']['connect_db'];
    }

    /**
     * FIXME: 코드 분리
     */
    public static function head(): void
    {
        global $bo_table, $wr_id, $member, $is_admin;

        $boardId = $bo_table ?? null;
        $documentId = $wr_id ?? null;
        $memberId = $member['mb_id'] ?? null;

        if (!$boardId || !$documentId || !$GLOBALS['view']) {
            return;
        }

        $filestamp = filemtime(DA_PLUGIN_REACTION_PATH . '/public/assets/da_reaction.js');
        add_javascript('<script defer src="' . DA_PLUGIN_REACTION_URL . '/public/assets/da_reaction.js?ver=' . $filestamp . '"></script>');
        $filestamp = filemtime(DA_PLUGIN_REACTION_PATH . '/public/assets/da_reaction.css');
        add_stylesheet('<link rel="stylesheet" href="' . DA_PLUGIN_REACTION_URL . '/public/assets/da_reaction.css?ver=' . $filestamp . '" />');

        if (
            !($_ENV['DA_ALPINEJS'] ?? false)
            && !defined('DA_ALPINEJS')
        ) {
            define('DA_ALPINEJS', DA_PLUGIN_REACTION_URL . '/public/assets/alpinejs.3.14.8.min.js');
            add_javascript('<script defer src="' . DA_ALPINEJS . '"></script>', 10000);
        }

        // 현재 글의 리액션 데이터
        $reactionData = ReactionModel::getReactionsByParentId(ReactionHelper::generateIdDocument($boardId, $GLOBALS['view']), $memberId);

        $usedReactions = [];
        foreach ($reactionData as $target) {
            foreach ($target as $item) {
                $usedReactions[] = $item['reaction'];
                if (stripos($item['reaction'], 'import-image:') === 0) {
                    $importedImages[] = $item['reaction'];
                }
            }
        }

        $data = [
            'categories' => [
                ['category' => 'emoji', 'title' => '이모지', 'renderType' => 'emoji'],
                ['category' => 'image', 'title' => '이미지', 'renderType' => 'image'],
                ['category' => 'import-image', 'title' => '이미지', 'renderType' => 'image'],
            ],
            'emoticons' => [
            ],
            'alias' => [],
        ];
        $data = run_replace('daReaction:load-data', $data, $usedReactions);
        if (!$data['emoticons']) {
            $data['emoticons'] = [
                ['reaction' => 'emoji:1f44d'], // 👍
                ['reaction' => 'emoji:1f44e'], // 👎
                ['reaction' => 'emoji:1f606'], // 😆
                ['reaction' => 'emoji:1f62e'], // 😮
                ['reaction' => 'emoji:1f622'], // 😢
                ['reaction' => 'emoji:1f621'], // 😡
            ];
        }
        $data['emoticons'] = array_merge($data['emoticons'], ReactionHelper::getImportImages());

        $categories = json_encode($data['categories']);
        $emoticons = json_encode($data['emoticons']);
        $alias = json_encode($data['alias']);
        $endpoints = json_encode([
            'react' => DA_PLUGIN_REACTION_URL . '/public/proc.react.php',
        ]);
        $reactionData = json_encode($reactionData);

        $memberInfo = json_encode([
            'memberId' => $memberId,
            'isAdmin' => $is_admin,
        ]);

        $script = <<<SCRIPT
        <script>
        document.addEventListener('daReaction:init', function (e) {
            const daReaction = e.detail;
            daReaction.setMemberInfo({$memberInfo});
            daReaction.setEndpoints({$endpoints});
            daReaction.addCategories({$categories});
            daReaction.addEmoticons({$emoticons});
            daReaction.addAlias({$alias});
            daReaction.setReactions({$reactionData});
        });
        </script>
        SCRIPT;

        add_javascript($script, 100);

        // TODO 템플릿 분리
        $template = <<<'HTML'
            <div x-data="daReactionPopover" class="da-reaction-popover" x-show="open" tabindex="-1" aria-hidden="true" x-ref="daReactionPopover" x-cloak x-transition @click.outside="open = false">
                <div class="da-reaction">
                    <template x-for="item in emoticons" :key="item.reaction">
                        <span role="button" tabindex="0" class="da-reaction__badge" @click="react(item.reaction, 'add')" @keyup.enter="react(item.reaction, 'add')">
                            <template x-if="item.renderType === 'emoji'">
                                <span class="da-reaction__emoji" x-text="item.emoji"></span>
                            </template>
                            <template x-if="item.renderType === 'image'">
                                <img x-bind:src="item.url" loading="lazy" :alt="`이모티콘: ${item.reaction}`" />
                            </template>
                        </span>
                    </template>
                </div>
            </div>
        HTML;

        add_replace('html_process_buffer', function ($buffer) use ($template) {
            return str_replace('</body>', "{$template}\n</body>", $buffer);
        });
    }
}
