<?php
include_once('./_common.php');

// 포인트 선물 테이블 생성 - 자동 생성을 위한 코드
if(!isset($g5['g5_point_gift_moa'])) {
    $g5['g5_point_gift_moa'] = G5_TABLE_PREFIX.'point_gift_moa';
    $sql = " CREATE TABLE IF NOT EXISTS {$g5['g5_point_gift_moa']} (
        pg_id int(11) NOT NULL AUTO_INCREMENT,
        pg_datetime datetime NOT NULL DEFAULT current_timestamp(),
        pg_sender_mb_id varchar(20) NOT NULL COMMENT '포인트 선물한 회원 아이디',
        pg_receiver_mb_id varchar(20) NOT NULL COMMENT '포인트 받은 회원 아이디',
        pg_point int(11) NOT NULL DEFAULT 0 COMMENT '선물한 포인트',
        pg_content text NULL COMMENT '메시지',
        pg_wr_id int(11) NOT NULL DEFAULT 0 COMMENT '관련 게시글 번호',
        pg_bo_table varchar(20) NOT NULL COMMENT '관련 게시판',
        PRIMARY KEY (pg_id),
        KEY sender_idx (pg_sender_mb_id),
        KEY receiver_idx (pg_receiver_mb_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 ";
    sql_query($sql, false);
}

if (!$is_member) {
    alert('회원만 포인트를 선물할 수 있습니다.');
}

$recv_mb_id = isset($_POST['me_recv_mb_id']) ? trim($_POST['me_recv_mb_id']) : '';
$point = isset($_POST['point']) ? (int)preg_replace('/[^0-9]/', '', $_POST['point']) : 0;
$content = isset($_POST['content']) ? clean_xss_tags($_POST['content'], 1, 1) : '';
$bo_table = isset($_POST['bo_table']) ? clean_xss_tags($_POST['bo_table'], 1, 1) : '';
$wr_id = isset($_POST['wr_id']) ? (int)$_POST['wr_id'] : 0;

// 빈값 체크
if (!$recv_mb_id) {
    alert('받는 회원아이디가 지정되지 않았습니다.');
}

// 최소/최대 포인트 체크
if ($point < 100) {
    alert('최소 100 포인트 이상 선물할 수 있습니다.');
}

if ($point > 1000000) {
    alert('최대 1,000,000 포인트까지 선물할 수 있습니다.');
}

// 자신에게 선물 불가
if ($member['mb_id'] == $recv_mb_id) {
    alert('자신에게는 포인트를 선물할 수 없습니다.');
}

// 보유 포인트 체크
if ($member['mb_point'] < $point) {
    alert('보유하신 포인트가 부족합니다.');
}

// 받는 회원 정보 확인
$sql = " select mb_id, mb_nick, mb_email, mb_point from {$g5['member_table']} where mb_id = '$recv_mb_id' ";
$row = sql_fetch($sql);
if (!$row['mb_id']) {
    alert('존재하지 않는 회원입니다.');
}

// 포인트 차감 (선물한 사람)
insert_point($member['mb_id'], -1 * $point, "{$row['mb_nick']}님에게 포인트 선물_".G5_TIME_YMDHIS, '@gift', $row['mb_id'], "$bo_table,$wr_id,".G5_TIME_YMDHIS."");

// 포인트 지급 (받는 사람)
insert_point($row['mb_id'], $point, "{$member['mb_nick']}님으로부터 포인트 선물_".G5_TIME_YMDHIS, '@receive', $member['mb_id'], "$bo_table,$wr_id,".G5_TIME_YMDHIS."");

// 선물 내역 저장
$sql = " insert into {$g5['g5_point_gift_moa']} 
            set pg_datetime = '".G5_TIME_YMDHIS."',
                pg_sender_mb_id = '{$member['mb_id']}',
                pg_receiver_mb_id = '{$row['mb_id']}',
                pg_point = '{$point}',
                pg_content = '{$content}',
                pg_wr_id = '{$wr_id}',
                pg_bo_table = '{$bo_table}' ";
sql_query($sql);

// -------------------- 쪽지 전송 코드 추가 시작 --------------------
// 자동 쪽지 발송을 위한 메시지 구성
$formatted_point = number_format($point);
$me_memo = "[포인트 선물 알림]\n\n";
$me_memo .= "{$member['mb_nick']}님이 {$formatted_point}포인트를 선물하셨습니다.\n\n";

// 사용자가 메시지를 입력했다면 추가
if ($content) {
    $me_memo .= "메시지: {$content}\n\n";
}

$me_memo .= "선물 일시: ".G5_TIME_YMDHIS."\n";
if ($bo_table && $wr_id) {
    $me_memo .= "관련 게시글: ".G5_BBS_URL."/board.php?bo_table={$bo_table}&wr_id={$wr_id}";
}

// 쪽지 저장을 위한 me_id 생성
$tmp_row = sql_fetch(" select max(me_id) as max_me_id from {$g5['memo_table']} ");
$me_id = $tmp_row['max_me_id'] + 1;

// 받는 회원 쪽지 INSERT (받은 쪽지함에 저장)
$sql = " insert into {$g5['memo_table']} 
            ( me_recv_mb_id, me_send_mb_id, me_send_datetime, me_memo, me_read_datetime, me_type, me_send_ip ) 
            values 
            ( '{$row['mb_id']}', '{$member['mb_id']}', '".G5_TIME_YMDHIS."', '{$me_memo}', '0000-00-00 00:00:00', 'recv', '{$_SERVER['REMOTE_ADDR']}' ) ";
sql_query($sql);

// 쪽지 ID 가져오기
if ($me_id = sql_insert_id()) {
    // 보내는 회원 쪽지 INSERT (보낸 쪽지함에 저장)
    $sql = " insert into {$g5['memo_table']} 
                ( me_recv_mb_id, me_send_mb_id, me_send_datetime, me_memo, me_read_datetime, me_send_id, me_type, me_send_ip ) 
                values 
                ( '{$row['mb_id']}', '{$member['mb_id']}', '".G5_TIME_YMDHIS."', '{$me_memo}', '0000-00-00 00:00:00', '$me_id', 'send', '{$_SERVER['REMOTE_ADDR']}' ) ";
    sql_query($sql);
}

// 실시간 쪽지 알림 업데이트
$sql = " update {$g5['member_table']} set mb_memo_call = '{$member['mb_id']}', mb_memo_cnt = '".get_memo_not_read($row['mb_id'])."' where mb_id = '{$row['mb_id']}' ";
sql_query($sql);
// -------------------- 쪽지 전송 코드 추가 끝 --------------------

// 알림 메시지 전송 (SMS, 메일 등이 설정되어 있을 경우)
// 메일 알림
/****************
if ($config['cf_email_use'] && $row['mb_email']) {
    $subject = '['.$config['cf_title'].'] '.$member['mb_nick'].' 님이 포인트를 선물하셨습니다.';
    
    ob_start();
    include_once(G5_BBS_PATH.'/point_gift_mail.php');
    $content = ob_get_contents();
    ob_end_clean();
    
    mailer($config['cf_admin_email_name'], $config['cf_admin_email'], $row['mb_email'], $subject, $content, 1);
}
****************/

alert("{$row['mb_nick']}님에게 {$point}포인트를 선물했습니다. 쪽지도 함께 전송되었습니다.", G5_HTTP_BBS_URL."/board.php?bo_table={$bo_table}&wr_id={$wr_id}");
?>