<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가

/**
 * 그누보드5 포인트 선물 플러그인
 * 게시판 view 페이지에서 글 작성자에게 포인트 선물하기 기능을 제공합니다.
 */

// 포인트 선물 테이블 생성
function point_gift_moa_create_table() {
    global $g5;
    
    $g5['g5_point_gift_moa'] = G5_TABLE_PREFIX.'point_gift_moa';
    
    $sql = " CREATE TABLE IF NOT EXISTS {$g5['g5_point_gift_moa']} (
        pg_id int(11) NOT NULL AUTO_INCREMENT,
        pg_datetime datetime NOT NULL DEFAULT current_timestamp(),
        pg_sender_mb_id varchar(20) NOT NULL COMMENT '포인트 선물한 회원 아이디',
        pg_receiver_mb_id varchar(20) NOT NULL COMMENT '포인트 받은 회원 아이디',
        pg_point int(11) NOT NULL DEFAULT 0 COMMENT '선물한 포인트',
        pg_content text NULL COMMENT '메시지',
        pg_wr_id int(11) NOT NULL DEFAULT 0 COMMENT '관련 게시글 번호',
        pg_bo_table varchar(20) NOT NULL COMMENT '관련 게시판',
        PRIMARY KEY (pg_id),
        KEY sender_idx (pg_sender_mb_id),
        KEY receiver_idx (pg_receiver_mb_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 ";
    
    sql_query($sql, false);
}

// 테이블 생성 실행
point_gift_moa_create_table();

// 선물 모달 추가하기
function point_gift_moa_add_modal($view, $bo_table, $wr_id, $member) {
    ob_start();
    ?>
    <!-- 포인트 선물 모달 시작 -->
    <div id="giftPointModal" class="gift-point-modal">
        <div class="gift-point-container">
            <div class="gift-point-title">포인트 선물하기</div>
            <div class="gift-point-desc">
                <p>최소 선물 포인트: 100 포인트</p>
                <p>최대 선물 포인트: 1,000,000 포인트</p>
                <p>내 보유 포인트: <?php echo number_format($member['mb_point']); ?> 포인트</p>
            </div>
            <div class="gift-point-form-container">
                <form name="fgiftform" id="fgiftform" action="<?php echo G5_HTTPS_BBS_URL; ?>/point_gift_update_moa.php" method="post" autocomplete="off">
                    <input type="hidden" name="me_recv_mb_id" value="<?php echo $view['mb_id']; ?>">
                    <input type="hidden" name="bo_table" value="<?php echo $bo_table; ?>">
                    <input type="hidden" name="wr_id" value="<?php echo $wr_id; ?>">
                    <div class="gift-point-form">
                        <ul>
                            <li>
                                <label for="point" class="gift-point-label">선물할 포인트</label>
                                <input type="text" name="point" id="point" required class="gift-point-input" placeholder="선물할 포인트 금액을 입력하세요">
                            </li>
                            <li>
                                <label for="content" class="gift-point-label">메시지 (선택사항)</label>
                                <textarea name="content" id="content" class="gift-point-textarea" placeholder="선물과 함께 보낼 메시지를 입력하세요"></textarea>
                            </li>
                        </ul>
                    </div>
                    <div class="gift-point-btn-wrap">
                        <button type="submit" class="gift-point-submit">선물하기</button>
                        <button type="button" class="gift-point-close" id="closeGiftPoint">취소</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- 포인트 선물 모달 끝 -->
    <?php
    return ob_get_clean();
}

// 선물 내역 표시
function point_gift_moa_display_history($view, $bo_table, $wr_id) {
    global $g5;
    
    ob_start();
    
    // 페이징 처리
    $gifts_per_page = 5;
    $gifts_page = isset($_GET['gifts_page']) ? intval($_GET['gifts_page']) : 1;
    $gifts_start = ($gifts_page - 1) * $gifts_per_page;
    
    // 총 선물 내역 수
    $sql = " select count(*) as cnt 
             from {$g5['g5_point_gift_moa']} 
             where pg_receiver_mb_id = '{$view['mb_id']}' 
             and pg_bo_table = '{$bo_table}' 
             and pg_wr_id = '{$wr_id}' ";
    $row = sql_fetch($sql);
    $total_gifts = $row['cnt'];
    
    if($total_gifts > 0) {
        $total_pages = ceil($total_gifts / $gifts_per_page);
        
        // 현재 페이지의 선물 내역 가져오기
        $sql = " select a.*, b.mb_nick as sender_nick
                 from {$g5['g5_point_gift_moa']} a
                 left join {$g5['member_table']} b on a.pg_sender_mb_id = b.mb_id 
                 where a.pg_receiver_mb_id = '{$view['mb_id']}' 
                 and a.pg_bo_table = '{$bo_table}' 
                 and a.pg_wr_id = '{$wr_id}' 
                 order by a.pg_datetime desc
                 limit {$gifts_start}, {$gifts_per_page} ";
        $result = sql_query($sql);
        
        echo '
        <div class="gift-point-history">
            <h3>포인트 선물 내역</h3>
            <table class="gift-point-history-table">
                <thead>
                    <tr>
                        <th>선물한 분</th>
                        <th>포인트</th>
                        <th>메시지</th>
                        <th>날짜</th>
                    </tr>
                </thead>
                <tbody>';
        
        for($i=0; $row=sql_fetch_array($result); $i++) {
            echo '
                <tr>
                    <td class="gift-point-sender">'.$row['sender_nick'].'</td>
                    <td class="gift-point-amount">'.number_format($row['pg_point']).' P</td>
                    <td>'.($row['pg_content'] ? $row['pg_content'] : '-').'</td>
                    <td class="gift-point-date">'.date('y.m.d H:i', strtotime($row['pg_datetime'])).'</td>
                </tr>';
        }
        
        echo '
                </tbody>
            </table>';
        
        // 페이징 링크 생성
        if($total_pages > 1) {
            echo '<div class="gift-point-paginate">';
            
            // 현재 URL에서 gifts_page 파라미터만 변경
            $current_url = preg_replace('/&?gifts_page=[0-9]*/', '', $_SERVER['REQUEST_URI']);
            $join_char = (strpos($current_url, '?') !== false) ? '&' : '?';
            
            // 이전 페이지
            if($gifts_page > 1) {
                echo '<a href="'.$current_url.$join_char.'gifts_page='.($gifts_page-1).'">이전</a>';
            }
            
            // 페이지 번호
            $start_page = max(1, $gifts_page - 2);
            $end_page = min($total_pages, $gifts_page + 2);
            
            for($i=$start_page; $i<=$end_page; $i++) {
                $active = ($i == $gifts_page) ? 'active' : '';
                echo '<a href="'.$current_url.$join_char.'gifts_page='.$i.'" class="'.$active.'">'.$i.'</a>';
            }
            
            // 다음 페이지
            if($gifts_page < $total_pages) {
                echo '<a href="'.$current_url.$join_char.'gifts_page='.($gifts_page+1).'">다음</a>';
            }
            
            echo '</div>';
        }
        
        echo '</div>';
    }
    
    return ob_get_clean();
}

// 포인트 선물 스크립트
function point_gift_moa_script() {
    ob_start();
    ?>
    <script>
    $(function() {
        // 포인트 선물 모달 열기
        $("#openGiftPoint").click(function() {
            $("#giftPointModal").addClass("active");
        });
        
        // 포인트 선물 모달 닫기
        $("#closeGiftPoint").click(function() {
            $("#giftPointModal").removeClass("active");
        });
        
        // 모달 외부 클릭 시 닫기
        $(document).on("click", function(e) {
            if($(e.target).hasClass("gift-point-modal")) {
                $("#giftPointModal").removeClass("active");
            }
        });
        
        // 포인트 선물 폼 제출
        $("#fgiftform").submit(function(e) {
            var point = parseInt($("#point").val().replace(/[^0-9]/g, ""));
            
            if (isNaN(point) || point < 100) {
                alert("최소 100 포인트 이상 선물할 수 있습니다.");
                $("#point").focus();
                return false;
            }
            
            if (point > 1000000) {
                alert("최대 1,000,000 포인트까지 선물할 수 있습니다.");
                $("#point").focus();
                return false;
            }
            
            // 보유 포인트 체크
            var mb_point = <?php echo $GLOBALS['member']['mb_point']; ?>;
            if (point > mb_point) {
                alert("보유하신 포인트가 부족합니다.");
                $("#point").focus();
                return false;
            }
            
            if (!confirm("<?php echo $GLOBALS['view']['wr_name']; ?>님에게 " + point.toLocaleString() + "포인트를 선물하시겠습니까?")) {
                return false;
            }
            
            return true;
        });
        
        // 천 단위 구분 기능
        $("#point").on('input', function(e) {
            var value = $(this).val().replace(/[^0-9]/g, "");
            if (value) {
                $(this).val(parseInt(value).toLocaleString());
            }
        });
    });
    </script>
    <?php
    return ob_get_clean();
}

// 포인트 선물 스타일
function point_gift_moa_style() {
    ob_start();
    ?>
    <!-- 포인트 선물 모달 스타일 -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Noto+Sans+KR:wght@400;500;700&display=swap">
    <style>
    /* 포인트 선물 모달 스타일 */
    .gift-point-modal {
      display: none;
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background-color: rgba(0, 0, 0, 0.5);
      z-index: 9999;
      align-items: center;
      justify-content: center;
    }

    .gift-point-modal.active {
      display: flex;
    }

    .gift-point-container {
      max-width: 500px;
      width: 90%;
      padding: 20px;
      font-family: 'Noto Sans KR', sans-serif;
      border-radius: 10px;
      box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
      background-color: #fff;
      animation: fadeIn 0.5s ease-out;
    }

    /* 타이틀 스타일 */
    .gift-point-title {
      background: linear-gradient(135deg, #ff3b30, #c70039);
      padding: 15px 20px;
      margin: 10px 0 20px 0;
      border-radius: 8px;
      font-size: 20px;
      font-weight: bold;
      color: white;
      text-align: center;
      box-shadow: 0 4px 6px rgba(199, 0, 57, 0.2);
      position: relative;
    }

    .gift-point-title:before {
      content: "🎁";
      margin-right: 10px;
      font-size: 22px;
    }

    /* 안내 섹션 */
    .gift-point-desc {
      background: #f9f2f2;
      border-left: 4px solid #c70039;
      padding: 15px 20px;
      margin: 15px 0;
      border-radius: 4px;
      line-height: 1.6em;
    }

    .gift-point-desc p {
      padding: 0;
      line-height: 1.8em;
      font-size: 15px;
      color: #333;
    }

    /* 폼 스타일 */
    .gift-point-form ul {
      padding: 0;
      margin: 25px 0;
    }

    .gift-point-form li {
      margin-bottom: 20px !important;
      list-style-type: none;
    }

    .gift-point-input {
      width: 100%;
      padding: 12px 15px;
      border: 1px solid #ddd;
      border-radius: 6px;
      font-size: 15px;
      transition: all 0.3s ease;
      box-sizing: border-box;
    }

    .gift-point-input:focus {
      border-color: #ff3b30;
      box-shadow: 0 0 0 2px rgba(255, 59, 48, 0.2);
      outline: none;
    }

    .gift-point-input::placeholder {
      color: #aaa;
    }

    /* 버튼 스타일 */
    .gift-point-btn-wrap {
      display: flex;
      justify-content: center;
      gap: 10px;
      margin-top: 20px;
    }

    .gift-point-submit {
      background: linear-gradient(to right, #ff3b30, #c70039);
      color: white;
      border: none;
      padding: 12px 25px;
      border-radius: 6px;
      font-size: 16px;
      font-weight: bold;
      cursor: pointer;
      transition: all 0.3s ease;
      box-shadow: 0 4px 6px rgba(199, 0, 57, 0.2);
    }

    .gift-point-submit:hover {
      background: linear-gradient(to right, #d9302a, #a80030);
      transform: translateY(-2px);
      box-shadow: 0 6px 8px rgba(199, 0, 57, 0.3);
    }

    .gift-point-close {
      background: #f2f2f2;
      color: #555;
      border: 1px solid #ddd;
      padding: 12px 25px;
      border-radius: 6px;
      font-size: 16px;
      font-weight: bold;
      cursor: pointer;
      transition: all 0.3s ease;
    }

    .gift-point-close:hover {
      background: #e6e6e6;
    }

    /* 입력 라벨 */
    .gift-point-label {
      display: block;
      margin-bottom: 8px;
      font-size: 14px;
      color: #333;
      font-weight: bold;
    }

    /* 애니메이션 효과 */
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(10px); }
      to { opacity: 1; transform: translateY(0); }
    }

    /* 반응형 조정 */
    @media (max-width: 480px) {
      .gift-point-container {
        padding: 15px;
      }
      
      .gift-point-submit, .gift-point-close {
        padding: 10px 20px;
        font-size: 15px;
      }
    }

    /* 선물 버튼 추가 */
    .gift-point-btn {
      display: inline-block;
      padding: 6px 12px;
      background: linear-gradient(to right, #ff3b30, #c70039);
      color: white;
      border-radius: 4px;
      font-size: 12px;
      margin-left: 10px;
      cursor: pointer;
      transition: all 0.3s ease;
    }

    .gift-point-btn:hover {
      background: linear-gradient(to right, #d9302a, #a80030);
      transform: translateY(-2px);
    }

    /* 포인트 선물 내역 스타일 */
    .gift-point-history {
      margin-top: 30px;
      border-top: 1px solid #eee;
      padding-top: 20px;
    }

    .gift-point-history h3 {
      font-size: 18px;
      margin: 0 0 15px 0;
      color: #333;
      font-weight: bold;
    }

    .gift-point-history-table {
      width: 100%;
      border-collapse: collapse;
    }

    .gift-point-history-table th,
    .gift-point-history-table td {
      padding: 12px 8px;
      text-align: center;
      border-bottom: 1px solid #eee;
    }

    .gift-point-history-table th {
      background: #f7f7f7;
      font-size: 14px;
      color: #555;
    }

    .gift-point-history-table td {
      font-size: 14px;
    }

    .gift-point-sender {
      font-weight: bold;
      color: #c70039;
    }

    .gift-point-amount {
      font-weight: bold;
      color: #ff3b30;
    }

    .gift-point-date {
      color: #888;
      font-size: 13px;
    }

    .gift-point-paginate {
      margin-top: 15px;
      text-align: center;
    }

    .gift-point-paginate a {
      display: inline-block;
      padding: 5px 10px;
      margin: 0 2px;
      border: 1px solid #ddd;
      border-radius: 3px;
      font-size: 13px;
      color: #555;
    }

    .gift-point-paginate a.active {
      background: #ff3b30;
      color: #fff;
      border-color: #ff3b30;
    }

    .gift-point-no-data {
      text-align: center;
      padding: 30px 0;
      color: #888;
    }

    .gift-point-textarea {
      width: 100%;
      min-height: 80px;
      padding: 12px 15px;
      border: 1px solid #ddd;
      border-radius: 6px;
      font-size: 15px;
      margin-bottom: 10px;
      transition: all 0.3s ease;
      box-sizing: border-box;
      resize: vertical;
      font-family: 'Noto Sans KR', sans-serif;
    }

    .gift-point-textarea:focus {
      border-color: #ff3b30;
      box-shadow: 0 0 0 2px rgba(255, 59, 48, 0.2);
      outline: none;
    }
    </style>
    <?php
    return ob_get_clean();
}
