<?php
// 출력 버퍼링 시작
ob_start();

// API URL
$url = "https://opentdb.com/api.php?amount=5&encode=base64";

// cURL을 사용하여 API 데이터 가져오기
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

// JSON 데이터 디코딩
$data = json_decode($response, true);

// Base64 디코딩
foreach ($data['results'] as &$question) {
    $question['question'] = base64_decode($question['question']);
    $question['correct_answer'] = base64_decode($question['correct_answer']);
    foreach ($question['incorrect_answers'] as &$incorrect) {
        $incorrect = base64_decode($incorrect);
    }
}

include_once('../common.php');

// 최근 게임 통계 가져오기 (10개)
$recent_stats = array();
if (!$is_guest) {
    $sql = "SELECT * FROM g5_quiz_stats ORDER BY play_date DESC LIMIT 10";
    $result = sql_query($sql);
    while ($row = sql_fetch_array($result)) {
        $recent_stats[] = $row;
    }
}

// 퀴즈 HTML 생성
?>
<audio id="ticktock_sound" src="ticktock.mp3"></audio>
<div id="timer"><font color="red">남은 시간: <span id="time">180</span>초</font></div>

<?php if (!$is_guest): ?>
<div class="user-stats">
    현재 사용자: <strong><?php echo $member['mb_nick']; ?></strong> | 
    보유 포인트: <strong><?php echo number_format($member['mb_point']); ?></strong>점
</div>
<?php endif; ?>

<?php foreach ($data['results'] as $index => $quiz): ?>
<div class="quiz-item" id="quiz-<?php echo $index; ?>">
    <h3><?php echo ($index + 1) . ". " . htmlspecialchars($quiz['question']); ?></h3>
    <?php
    $answers = array_merge([$quiz['correct_answer']], $quiz['incorrect_answers']);
    shuffle($answers);
    foreach ($answers as $answer): ?>
    <label>
        <input type="radio" name="answer_<?php echo $index; ?>" value="<?php echo htmlspecialchars($answer); ?>"
               onclick="checkAnswer(<?php echo $index; ?>, '<?php echo addslashes(htmlspecialchars($answer)); ?>', '<?php echo addslashes(htmlspecialchars($quiz['correct_answer'])); ?>')">
        <?php echo htmlspecialchars($answer); ?>
    </label><br>
    <?php endforeach; ?>
    <p id="result-<?php echo $index; ?>" style="display: none;"></p>
</div>
<?php endforeach;?>

<button onclick="calculateScore()">점수 계산</button>
<div id="final-score" style="display: none;"></div>

<?php if (!$is_guest): ?>
<div id="save-score-container" style="display: none;">
    <p>게임 결과를 저장하고 포인트를 받으시겠습니까?</p>
    <button onclick="saveGameStats()">결과 저장 및 포인트 받기</button>
</div>
<?php else: ?>
<div id="login-message" style="display: none; margin-top: 20px; color: #cc0000;">
    <p>로그인 후 게임 결과를 저장하고 포인트를 받을 수 있습니다.</p>
    <a href="<?php echo G5_BBS_URL ?>/login.php">로그인하기</a>
</div>
<?php endif; ?>

<button onclick="loadMoreQuizzes()">다음 퀴즈 로드</button>

<!-- 최근 게임 통계 -->
<div class="stats-container">
    <div class="stats-title">최근 게임 통계</div>
    <table class="stats-table">
        <thead>
            <tr>
                <th>닉네임</th>
                <th>맞은 문제 수</th>
                <th>획득 점수</th>
                <th>게임 시간(초)</th>
                <th>날짜/시간</th>
            </tr>
        </thead>
        <tbody id="stats-table-body">
            <?php foreach ($recent_stats as $stat): ?>
            <tr>
                <td><?php echo htmlspecialchars($stat['nickname']); ?></td>
                <td><?php echo $stat['correct_answers']; ?></td>
                <td><?php echo number_format($stat['score']); ?></td>
                <td><?php echo $stat['play_time']; ?></td>
                <td><?php echo substr($stat['play_date'], 0, 16); ?></td>
            </tr>
            <?php endforeach; ?>
            <?php if (empty($recent_stats)): ?>
            <tr>
                <td colspan="5">게임 통계가 없습니다.</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php
// 출력 버퍼 내용 가져오기 및 비우기
$output = ob_get_clean();

// 출력
echo $output;
?>