<?php
// API URL
$url = "https://opentdb.com/api.php?amount=5&encode=base64";

// cURL을 사용하여 API 데이터 가져오기
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

// JSON 데이터 디코딩
$data = json_decode($response, true);

// Base64 디코딩
foreach ($data['results'] as &$question) {
    $question['question'] = base64_decode($question['question']);
    $question['correct_answer'] = base64_decode($question['correct_answer']);
    foreach ($question['incorrect_answers'] as &$incorrect) {
        $incorrect = base64_decode($incorrect);
    }
}

include_once('../common.php');

// 게임 통계 저장 테이블 생성 (이미 존재하지 않는 경우)
$sql = "CREATE TABLE IF NOT EXISTS g5_quiz_stats (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mb_id VARCHAR(20) NOT NULL,
    nickname VARCHAR(255) NOT NULL,
    correct_answers INT NOT NULL,
    score INT NOT NULL,
    play_time INT NOT NULL,
    play_date DATETIME DEFAULT CURRENT_TIMESTAMP
)";
sql_query($sql);

// 최근 게임 통계 가져오기 (10개)
$recent_stats = array();
if (!$is_guest) {
    $sql = "SELECT * FROM g5_quiz_stats ORDER BY play_date DESC LIMIT 10";
    $result = sql_query($sql);
    while ($row = sql_fetch_array($result)) {
        $recent_stats[] = $row;
    }
}
?>

<!DOCTYPE html>
<html lang="ko">
<head>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php
    include_once('../common.php');
    $g5['title'] = "나는 퀴즈왕!";
    include_once(G5_PATH.'/_head.php');
    ?>    
    <style>
    .quiz-container {
        font-family: Arial, sans-serif;
        max-width: 800px;
        margin: 0 auto;
        padding: 20px;
        border: 1px solid #ddd;
        border-radius: 10px;
        background-color: #f9f9f9;
    }
    .quiz-item {
        margin-bottom: 20px;
        padding: 15px;
        border-bottom: 1px solid #eee;
    }
    .quiz-item:last-child {
        border-bottom: none;
    }
    .quiz-item h3 {
        margin-top: 0;
    }
    label {
        display: block;
        margin: 5px 0;
    }
    input[type="radio"] {
        margin-right: 10px;
    }
    .stats-container {
        margin-top: 30px;
        padding: 15px;
        background-color: #f0f8ff;
        border: 1px solid #add8e6;
        border-radius: 10px;
    }
    .stats-title {
        font-size: 18px;
        font-weight: bold;
        margin-bottom: 10px;
        color: #0066cc;
    }
    .stats-table {
        width: 100%;
        border-collapse: collapse;
    }
    .stats-table th, .stats-table td {
        padding: 8px;
        text-align: center;
        border: 1px solid #ddd;
    }
    .stats-table th {
        background-color: #0066cc;
        color: white;
    }
    .stats-table tr:nth-child(even) {
        background-color: #f2f2f2;
    }
    .user-stats {
        margin-top: 20px;
        padding: 10px;
        background-color: #e6ffe6;
        border-radius: 5px;
    }
    #save-score-container {
        margin-top: 20px;
        padding: 15px;
        background-color: #fff9e6;
        border: 1px solid #ffd699;
        border-radius: 10px;
        display: none;
    }
    </style>
</head>
<body>   

    <div class="quiz-container">

        <audio id="ticktock_sound" src="ticktock.mp3"></audio>
        <div id="timer"><font color="red">남은 시간: <span id="time">180</span>초</font>
		
			<!-- 구글 번역기 -->      
<li id="google_translate_element"></li>
<script src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
<script type="text/javascript">    
    window.onload = function googleTranslateElementInit() {new google.translate.TranslateElement({pageLanguage: '' , includedLanguages : 'ko,en,es,de,fr,ja,ru,zh-TW,zh-CN,vi,hi'}, 'google_translate_element');}  
    </script>
<!-- 구글 번역기 -->
		
		</div>
        
        <?php if (!$is_guest): ?>
        <div class="user-stats">
            현재 사용자: <strong><?php echo $member['mb_nick']; ?></strong> | 
            보유 포인트: <strong><?php echo number_format($member['mb_point']); ?></strong>점
        </div>
        <?php endif; ?>
        
        <?php foreach ($data['results'] as $index => $quiz): ?>
        <div class="quiz-item" id="quiz-<?php echo $index; ?>">
            <h3><?php echo ($index + 1) . ". " . $quiz['question']; ?></h3>
            <?php
            $answers = array_merge([$quiz['correct_answer']], $quiz['incorrect_answers']);
            shuffle($answers);
            foreach ($answers as $answer): ?>
            <label>
                <input type="radio" name="answer_<?php echo $index; ?>" value="<?php echo $answer; ?>"
                       onclick="checkAnswer(<?php echo $index; ?>, '<?php echo addslashes($answer); ?>', '<?php echo addslashes($quiz['correct_answer']); ?>')">
                <?php echo $answer; ?>
            </label><br>
            <?php endforeach; ?>
            <p id="result-<?php echo $index; ?>" style="display: none;"></p>
        </div>
        <?php endforeach; ?>
        
        <button onclick="calculateScore()">점수 계산</button>
        <div id="final-score" style="display: none;"></div>
        
        <?php if (!$is_guest): ?>
        <div id="save-score-container" style="display: none;">
            <p>게임 결과를 저장하고 포인트를 받으시겠습니까?</p>
            <button onclick="saveGameStats()">결과 저장 및 포인트 받기</button>
        </div>
        <?php else: ?>
        <div id="login-message" style="display: none; margin-top: 20px; color: #cc0000;">
            <p>로그인 후 게임 결과를 저장하고 포인트를 받을 수 있습니다.</p>
            <a href="<?php echo G5_BBS_URL ?>/login.php">로그인하기</a>
        </div>
        <?php endif; ?>
        
        <button onclick="loadMoreQuizzes()">다음 퀴즈 로드</button>
        
        <!-- 최근 게임 통계 -->
        <div class="stats-container">
            <div class="stats-title">최근 게임 통계</div>
            <table class="stats-table">
                <thead>
                    <tr>
                        <th>닉네임</th>
                        <th>맞은 문제 수</th>
                        <th>획득 점수</th>
                        <th>게임 시간(초)</th>
                        <th>날짜/시간</th>
                    </tr>
                </thead>
                <tbody id="stats-table-body">
                    <?php foreach ($recent_stats as $stat): ?>
                    <tr>
                        <td><?php echo $stat['nickname']; ?></td>
                        <td><?php echo $stat['correct_answers']; ?></td>
                        <td><?php echo number_format($stat['score']); ?></td>
                        <td><?php echo $stat['play_time']; ?></td>
                        <td><?php echo substr($stat['play_date'], 0, 16); ?></td>
                    </tr>
                    <?php endforeach; ?>
                    <?php if (empty($recent_stats)): ?>
                    <tr>
                        <td colspan="5">게임 통계가 없습니다.</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <script>
    let score = 0;
    let timeLeft = 180;
    let startTime = Date.now();
    let timerInterval;
    let totalQuestions = <?php echo count($data['results']); ?>;
    let answeredQuestions = 0;

    // 타이머 시작
    function startTimer() {
        const ticktock_sound = document.getElementById('ticktock_sound');
        startTime = Date.now();
        timerInterval = setInterval(() => {
            timeLeft--;
            document.getElementById('time').innerText = timeLeft;
            
            // 시간이 감소할 때마다 소리 재생
            ticktock_sound.currentTime = 0;
            ticktock_sound.play();            
           
            if (timeLeft <= 0) {
                clearInterval(timerInterval);
                alert("시간이 종료되었습니다!");
                calculateScore();
            }
        }, 1000);
    }

    // 정답 확인
    function checkAnswer(quizIndex, userAnswer, correctAnswer) {
        answeredQuestions++;
        const resultElement = document.getElementById(`result-${quizIndex}`);
        if (userAnswer === correctAnswer) {
            resultElement.innerText = "정답입니다! 🎉";
            resultElement.style.color = "green";
            score++;
        } else {
            resultElement.innerText = `틀렸습니다. 정답은 "${correctAnswer}" 입니다. 😅`;
            resultElement.style.color = "red";
        }
        resultElement.style.display = "block";
        
        // 모든 문제 답변 시 자동으로 점수 계산
        if (answeredQuestions === totalQuestions) {
            setTimeout(calculateScore, 500);
        }
    }

    // 점수 계산
    function calculateScore() {
        clearInterval(timerInterval);
        const gameTime = 180 - timeLeft; // 소요 시간 계산
        const finalScoreElement = document.getElementById('final-score');
        const totalScore = score * 10; // 맞은 문제 수 × 10점
        
        // PHP 8.2 호환성을 위해 템플릿 문자열 대신 표준 문자열 연결 사용
        finalScoreElement.innerHTML = 
            '<p>최종 점수: <strong>' + score + '문제 정답</strong> (' + totalScore + '점)</p>' +
            '<p>게임 시간: ' + gameTime + '초</p>';
        finalScoreElement.style.display = "block";
        
        // 로그인 상태일 때만 점수 저장 옵션 표시
        <?php if (!$is_guest): ?>
        document.getElementById('save-score-container').style.display = "block";
        <?php else: ?>
        document.getElementById('login-message').style.display = "block";
        <?php endif; ?>
    }

// 게임 통계 저장 및 포인트 지급
function saveGameStats() {
    // 기본 변수 설정
    var gameTime = 180 - timeLeft;
    var totalScore = score * 10;
    
    // AJAX 호출 전 로딩 표시 (옵션)
    var saveButton = document.querySelector('#save-score-container button');
    if(saveButton) {
        saveButton.disabled = true;
        saveButton.textContent = '저장 중...';
    }
    
    // AJAX를 사용하여 서버에 결과 전송
    var xhr = new XMLHttpRequest();
    xhr.open("POST", "save_quiz_stats.php", true);
    xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    
    xhr.onload = function() {
        // 버튼 상태 복원 (옵션)
        if(saveButton) {
            saveButton.disabled = false;
            saveButton.textContent = '결과 저장 및 포인트 받기';
        }
        
        if (xhr.status === 200) {
            var responseText = xhr.responseText;
            console.log("서버 응답:", responseText);
            
            // 응답이 비어있는 경우 처리
            if (!responseText || responseText.trim() === '') {
                alert("서버 응답이 비어있습니다.");
                return;
            }
            
            try {
                // JSON 파싱 전 처리 - PHP 오류 메시지 제거
                var jsonStart = responseText.indexOf('{');
                var jsonEnd = responseText.lastIndexOf('}') + 1;
                
                if(jsonStart >= 0 && jsonEnd > jsonStart) {
                    // JSON 부분만 추출
                    var jsonText = responseText.substring(jsonStart, jsonEnd);
                    var response = JSON.parse(jsonText);
                    
                    if (response && response.success) {
                        // 경고 메시지가 있으면 표시
                        var message = "게임 결과가 저장되었습니다! " + totalScore + "점이 포인트로 지급되었습니다.";
                        if (response.warning) {
                            message += "\n경고: " + response.warning;
                        }
                        alert(message);
                        
                        // 통계 테이블 업데이트
                        var newRow = document.createElement('tr');
                        newRow.innerHTML = 
                            '<td>' + response.nickname + '</td>' +
                            '<td>' + score + '</td>' +
                            '<td>' + totalScore + '</td>' +
                            '<td>' + gameTime + '</td>' +
                            '<td>' + response.date + '</td>';
                        
                        var statsTable = document.getElementById('stats-table-body');
                        if (statsTable) {
                            if (statsTable.querySelector('td[colspan="5"]')) {
                                // 데이터가 없다는 행이 있으면 제거
                                statsTable.innerHTML = '';
                            }
                            
                            // 맨 위에 새 행 추가
                            statsTable.insertBefore(newRow, statsTable.firstChild);
                            
                            // 결과 저장 버튼 비활성화
                            var saveContainer = document.getElementById('save-score-container');
                            if (saveContainer) {
                                saveContainer.style.display = 'none';
                            }
                        } else {
                            console.error("통계 테이블을 찾을 수 없습니다.");
                        }
                    } else {
                        var errorMsg = "오류가 발생했습니다.";
                        if (response && response.message) {
                            errorMsg += " " + response.message;
                        }
                        alert(errorMsg);
                    }
                } else {
                    // JSON 형식이 아닌 응답
                    console.error("유효하지 않은 JSON 응답:", responseText);
                    alert("서버에서 유효하지 않은 응답이 반환되었습니다.");
                }
            } catch (e) {
                console.error("JSON 파싱 오류:", e, "원본 데이터:", responseText);
                alert("응답 처리 중 오류가 발생했습니다. 개발자 도구를 확인해주세요.");
            }
        } else {
            alert("서버 요청 실패: " + xhr.status);
        }
    };
    
    xhr.onerror = function() {
        if(saveButton) {
            saveButton.disabled = false;
            saveButton.textContent = '결과 저장 및 포인트 받기';
        }
        alert("네트워크 오류가 발생했습니다.");
    };
    
    // 전송 데이터 준비 및 인코딩
    var data = "correct_answers=" + encodeURIComponent(score) + 
               "&score=" + encodeURIComponent(totalScore) + 
               "&play_time=" + encodeURIComponent(gameTime);
    
    xhr.send(data);
}

// 다음 퀴즈 로드 (AJAX)
function loadMoreQuizzes() {
    var xhr = new XMLHttpRequest();
    xhr.open("GET", "load_quizzes.php", true);
    
    // 로딩 중 상태 표시 (옵션)
    var loadButton = document.querySelector('button[onclick="loadMoreQuizzes()"]');
    if(loadButton) {
        loadButton.disabled = true;
        loadButton.textContent = '로딩 중...';
    }
    
    xhr.onload = function () {
        if(loadButton) {
            loadButton.disabled = false;
            loadButton.textContent = '다음 퀴즈 로드';
        }
        
        if (xhr.status === 200) {
            try {
                // 콘텐츠 업데이트
                document.querySelector('.quiz-container').innerHTML = xhr.responseText;
                
                // 변수 초기화
                score = 0;
                timeLeft = 180;
                answeredQuestions = 0;
                startTimer(); // 새로운 퀴즈 로드 후 타이머 재시작
            } catch (e) {
                console.error("퀴즈 로드 오류:", e);
                alert("새 퀴즈를 로드하는 중 오류가 발생했습니다.");
            }
        } else {
            alert("서버 요청 실패: " + xhr.status);
        }
    };
    
    xhr.onerror = function() {
        if(loadButton) {
            loadButton.disabled = false;
            loadButton.textContent = '다음 퀴즈 로드';
        }
        alert("네트워크 오류가 발생했습니다.");
    };
    
    xhr.send();
}

    // 페이지 로드 시 타이머 시작
    window.addEventListener('load', startTimer);
    </script>
</body>
</html>
<?php
include_once(G5_PATH.'/_tail.php');
?>