<?php
include_once('../common.php');

// 출력 버퍼링 시작 - 모든 오류 및 출력을 캡처하기 위함
ob_start();

// 로그인 상태 확인
if ($is_guest) {
    // 출력 버퍼 비우기
    ob_end_clean();
    
    // 헤더 설정 후 응답 전송
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(array('success' => false, 'message' => '로그인 후 이용 가능합니다.'));
    exit;
}

try {
    // POST 데이터 가져오기 및 유효성 검사
    $correct_answers = isset($_POST['correct_answers']) ? intval($_POST['correct_answers']) : 0;
    $score = isset($_POST['score']) ? intval($_POST['score']) : 0;
    $play_time = isset($_POST['play_time']) ? intval($_POST['play_time']) : 0;

    // 기본 유효성 검사
    if ($correct_answers < 0 || $score < 0 || $play_time < 0) {
        throw new Exception('유효하지 않은 값이 전달되었습니다.');
    }

    // 점수 유효성 확인 (맞은 문제 수 × 10점인지)
    if ($score !== $correct_answers * 10) {
        throw new Exception('점수 계산이 잘못되었습니다.');
    }

    // SQL 인젝션 방지
    $mb_id = sql_real_escape_string($member['mb_id']);
    $mb_nick = sql_real_escape_string($member['mb_nick']);
    
    // 게임 통계 저장
    $sql = "INSERT INTO g5_quiz_stats
            (mb_id, nickname, correct_answers, score, play_time)
            VALUES
            ('$mb_id', '$mb_nick', $correct_answers, $score, $play_time)";
    
    $result = sql_query($sql);
    
    if (!$result) {
        throw new Exception('데이터베이스 저장에 실패했습니다.');
    }
    
    // 포인트 부여
    $point_code = '@퀴즈게임';
    $point_content = "퀴즈 게임 결과 - {$correct_answers}문제 정답";
    $unique_id = $member['mb_id'] . '-quiz-' . uniqid('');
    
    $point_result = insert_point(
        $member['mb_id'],
        $score,
        $point_content,
        $point_code,
        $member['mb_id'],
        $unique_id
    );
    
    if (!$point_result) {
        throw new Exception('포인트 부여에 실패했습니다.');
    }
    
    // 최근 게임 시간 포맷
    $current_time = date("Y-m-d H:i");
    
    // 출력 버퍼 비우기
    ob_end_clean();
    
    // 성공 응답 전송
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(array(
        'success' => true,
        'nickname' => $member['mb_nick'],
        'date' => $current_time
    ));
    
} catch (Exception $e) {
    // 출력 버퍼 비우기
    ob_end_clean();
    
    // 오류 응답 전송
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(array(
        'success' => false,
        'message' => $e->getMessage()
    ));
}
?>