<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

function editor_html($id, $content, $is_dhtml_editor=true)
{
    global $g5, $config, $w, $board, $write, $bo_table;
    static $js = true;

    if( 
        $is_dhtml_editor && $content && 
        (
        (!$w && (isset($board['bo_insert_content']) && !empty($board['bo_insert_content'])))
        || ($w == 'u' && isset($write['wr_option']) && strpos($write['wr_option'], 'html') === false )
        )
    ){       //글쓰기 기본 내용 처리
        if( preg_match('/\r|\n/', $content) && $content === strip_tags($content, '<a><strong><b>') ) {  //textarea로 작성되고, html 내용이 없다면
            $content = nl2br($content);
        }
    }

    
    $editor_url = G5_EDITOR_URL.'/'.$config['cf_editor'];

    $html = "";
    $html .= "<span class=\"sound_only\">웹에디터 시작</span>";

    $smarteditor_class = $is_dhtml_editor ? "jodit" : "";
    $html .= "\n<textarea id=\"$id\" name=\"$id\" class=\"$smarteditor_class\" maxlength=\"65536\" style=\"width:100%;height:300px\">$content</textarea>";
    if ($is_dhtml_editor && $js) {
        
        $html .= "\n".'<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/jodit/3.13.4/jodit.min.css">';
        $html .= "\n".'<script src="//cdnjs.cloudflare.com/ajax/libs/jodit/3.13.4/jodit.min.js"></script>';               

        // Add custom CSS
        $html .= "\n".'<style>
            .jodit-toolbar-button {
                color: #2196F3 !important;
            }
            .jodit-toolbar-button svg,
            .jodit-toolbar-button img,
            .jodit-toolbar-button__icon {
                fill: #2196F3 !important;
                filter: invert(48%) sepia(79%) saturate(2476%) hue-rotate(190deg) brightness(118%) contrast(119%);
            }
            .jodit-toolbar-button__text {
                color: #2196F3 !important;
            }
            .jodit-toolbar {
                background: #f8f9fa !important;
            }
            /* Add list styling */
            .jodit-wysiwyg ul {
                list-style: disc !important;
                margin-left: 20px !important;
                padding-left: 20px !important;
            }
            .jodit-wysiwyg ol {
                list-style: decimal !important;
                margin-left: 20px !important;
                padding-left: 20px !important;
            }
            .jodit-wysiwyg ul li,
            .jodit-wysiwyg ol li {
                display: list-item !important;
                margin: 5px 0 !important;
            }
            /* Add Jodit footer styling */
            .jodit-status-bar,
            .jodit-status-bar .jodit-status-bar__item,
            .jodit-status-bar .jodit-status-bar__item a,
            .jodit-status-bar .jodit-powered-by,
            .jodit-status-bar .jodit-powered-by a {
                color: #2196F3 !important;
            }
            .jodit-status-bar .jodit-powered-by a:hover {
                text-decoration: underline;
                color: #1976D2 !important;
            }
        </style>';
        }

    if ($is_dhtml_editor) {
        $html .= "\n".'<script>
        jQuery(function($){
            if(typeof Jodit !== "undefined") {
                var '.$id.'_editor = new Jodit("#'.$id.'",{
                    language: "ko",
                    uploader: {
                        url: "'.$editor_url.'/upload.php?bo_table='.$bo_table.'",
                        insertImageAsBase64URI: false,
                        imagesExtensions: ["jpg", "png", "jpeg", "gif"],
                        maxFileSize: 10485760,
                        process: function (resp) {
                            for(var i=0;i<resp.data.images.length;i++){
                                '.$id.'_editor.setEditorValue('.$id.'_editor.getEditorValue() +"<img src=\'" + resp.data.baseurl + "/" + resp.data.images[i] + "\'>");
                            }
                            return true;        
                        }
                    },
                    height: 300,
                    allowResizeX: true,
                    allowResizeY: true,
                    disablePlugins: ["mobile"],                    
                    toolbarButtonSize: "large", //toolbarButtonSize 옵션은 "small", "middle", "large" 세 가지 크기를 지원합니다.
                    //theme: "dark",
                                                                             
                    buttons: [
                    
                        "font", "fontsize", "brush", "paragraph", "|",
                        "bold", "strikethrough", "underline", "italic", "|",
                        "superscript", "subscript", "|",
                        "ul", "ol", "|",                                                
                        "outdent", "indent", "|",
                        "align", "undo", "redo", "|",                        
                        "image", "video", "table", "link", "print", "|",
                        "hr", "eraser", "copyformat", "|",
                        "selectall", "copy", "paste", "cut", "find", "|",
                        "symbol", "fullsize", "preview", "source", "|",
                        {
                            name: "insertEmoji",
                            iconURL: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0Ij48cGF0aCBkPSJNMTIgMkM2LjQ4IDIgMiA2LjQ4IDIgMTJzNC40OCAxMCAxMCAxMCAxMC00LjQ4IDEwLTEwUzE3LjUyIDIgMTIgMnpNMTIgMjBjLTQuNDEgMC04LTMuNTktOC04czMuNTktOCA4LTggOCAzLjU5IDggOC0zLjU5IDgtOCA4em0zLjUtOWMuODMgMCAxLjUuNjcgMS41IDEuNXMtLjY3IDEuNS0xLjUgMS41LTEuNS0uNjctMS41LTEuNS42Ny0xLjUgMS41LTEuNXptLTctMGMuODMgMCAxLjUuNjcgMS41IDEuNXMtLjY3IDEuNS0xLjUgMS41LTEuNS0uNjctMS41LTEuNS42Ny0xLjUgMS41LTEuNXptMy41IDkuNWMtMy44NiAwLTctMS4xMy03LTIuNWgxNGMwIDEuMzctMy4xNCAyLjUtNyAyLjV6Ii8+PC9zdmc+",
                            tooltip: "이모지 선택",
                            popup: function(editor, current, control, close) {
                                const emojis = {                                    
                                    "자주 사용": ["😊", "👍", "❤️", "😂", "🙏", "✨", "😍", "🥰", "💕", "😭", "😅", "🤣", "🎉", "💪", "🙌"],
                                    "표정": ["😀", "😃", "😄", "😁", "😅", "😂", "🤣", "😊", "😇", "🙂", "🙃", "😉", "😌", "😍", "🥰", "😘", "😗", "😙", "😚", "😋", "😛", "😝", "😜", "🤪", "🤨", "🧐", "🤓", "😎", "🤩", "🥳", "😏", "😫", "😪", "😴", "🥱", "🤤", "🤗", "🤔", "🤭", "🤫", "🤥", "😶", "😐", "😑", "😬", "🙄", "😯", "😦", "😧"],
                                    "감정": ["😤", "😢", "😭", "😦", "😧", "😨", "😩", "🥺", "😬", "😮", "😯", "😲", "😱", "🥵", "🥶", "😳", "🤯", "😵", "🥴", "😠", "😡", "🤬", "😷", "🤒", "🤕", "🤢", "🤮", "🤧", "😇", "🥳", "🥰", "😈", "👿", "🤡", "💩", "👻", "💀", "☠️", "👽", "👾", "🤖", "🎃"],
                                    "손동작": ["👍", "👎", "👌", "✌️", "🤞", "🤟", "🤘", "🤙", "👈", "👉", "👆", "👇", "✋", "🤚", "👋", "🤜", "🤛", "👏", "🙌", "👐", "🤲", "🤝", "🙏", "✍️", "💪", "🦾", "🦿", "🦵", "🦶", "👂", "🦻", "👃", "🧠", "🦷", "🦴", "👀", "👁️", "👅", "👄"],
                                    "하트": ["❤️", "🧡", "💛", "💚", "💙", "💜", "🤎", "🖤", "🤍", "💔", "❣️", "💕", "💞", "💓", "💗", "💖", "💘", "💝", "💟", "♥️", "♡", "💌", "💘", "💝", "💖", "💗", "💓", "💞", "💕", "💟", "❣️", "💔", "❤️‍🔥", "❤️‍🩹"],
                                    "자연": ["🌸", "🌺", "🌹", "🌷", "🌼", "🌻", "🌞", "🌙", "⭐", "🌟", "✨", "⚡", "☀️", "🌤️", "🌈", "🌊", "🍀", "🌿", "☘️", "🍃", "🌱", "🌳", "🌲", "🎋", "🍂", "🍁", "🌾", "💐", "🌷", "🌹", "🪴", "🎍", "🍄", "🌵", "🌴", "🌳", "🌲", "🎄", "🌿", "☘️", "🍀"],
                                    "음식": ["🍎", "🍏", "🍊", "🍋", "🍌", "🍉", "🍇", "🍓", "🍈", "🍒", "🍑", "🥭", "🍍", "🥥", "🥝", "🍅", "🥑", "🥦", "🥬", "🥒", "🌶️", "🌽", "🥕", "🥔", "🍠", "🥐", "🥯", "🍞", "🥖", "🥨", "🧀", "🥚", "🍳", "🥞", "🧇", "🥓", "🥩", "🍗", "🍖", "🦴", "🌭", "🍔", "🍟", "🍕", "🥪", "🥙", "🧆", "🌮", "🌯", "🥗", "🥘", "🥫"],
                                    "동물": ["🐶", "🐱", "🐭", "🐹", "🐰", "🦊", "🐻", "🐼", "🐨", "🐯", "🦁", "🐮", "🐷", "🐸", "🐵", "🙈", "🙉", "🙊", "🐔", "🐧", "🐦", "🐤", "🦆", "🦅", "🦉", "🦇", "🐺", "🐗", "🐴", "🦄", "🦓", "🦌", "🦬", "🐮", "🐃", "🐂", "🐄", "🐎", "🐖", "🐏", "🐑", "🦙", "🐐", "🦌"],
                                    "활동": ["⚽", "🏀", "🏈", "⚾", "🥎", "🎾", "🏐", "🏉", "🥏", "🎱", "🪀", "🏓", "🏸", "🏒", "🏑", "🥍", "🏏", "🪃", "🥅", "⛳", "🪁", "🎣", "🤿", "🎽", "🎿", "🛷", "🥌", "🎯", "🪀", "🪁", "🎱", "🎮", "🎲", "🧩", "🎭", "🎨", "🎬", "🎤", "🎧", "🎼", "🎹", "🥁", "🎷", "🎺", "🎸", "🪕", "🎻"],
                                    "여행": ["✈️", "🚗", "🚕", "🚙", "🚌", "🚎", "🏎️", "🚓", "🚑", "🚒", "🚐", "🛻", "🚚", "🚛", "🚜", "🛵", "🏍️", "🛺", "🚲", "🛴", "🛹", "🛼", "🚉", "🚂", "🚆", "🚇", "🚊", "🚞", "🚟", "🚠", "🚡", "🚁", "🛶", "⛵", "🚤", "🛥️", "🛳️", "⛴️", "🚢", "🗺️", "🗿", "🗽", "🗼", "🏰", "🏯", "🏛️"]
                                };

                                const container = document.createElement("div");
                                container.style.padding = "10px";
                                container.style.maxWidth = "400px";
                                container.style.maxHeight = "300px";
                                container.style.overflow = "auto";

                                Object.keys(emojis).forEach(category => {
                                    const categoryTitle = document.createElement("div");
                                    categoryTitle.style.fontWeight = "bold";
                                    categoryTitle.style.margin = "10px 0 5px 0";
                                    categoryTitle.textContent = category;
                                    container.appendChild(categoryTitle);

                                    const emojiContainer = document.createElement("div");
                                    emojiContainer.style.display = "flex";
                                    emojiContainer.style.flexWrap = "wrap";
                                    emojiContainer.style.gap = "5px";

                                    emojis[category].forEach(emoji => {
                                        const btn = document.createElement("button");
                                        btn.innerHTML = emoji;
                                        btn.style.cursor = "pointer";
                                        btn.style.fontSize = "20px";
                                        btn.style.padding = "5px";
                                        btn.style.border = "none";
                                        btn.style.background = "none";
                                        btn.onclick = function() {
                                            editor.selection.insertHTML(emoji);
                                            close();
                                        };
                                        emojiContainer.appendChild(btn);
                                    });
                                    container.appendChild(emojiContainer);
                                });

                                return container;
                            }
                        }
                    ],

                    removeButtons: ["file"],
                    defaultFontFamily: "Malgun Gothic",
                    defaultFontSize: "12",                    
                    
                    colors: {                                                
                        greyscale:  ["#000000", "#434343", "#666666", "#999999", "#B7B7B7", "#CCCCCC", "#D9D9D9", "#EFEFEF", "#F3F3F3", "#FFFFFF"],
                        palette:    ["#980000", "#FF0000", "#FF9900", "#FFFF00", "#00F0F0", "#00FFFF", "#4A86E8", "#0000FF", "#9900FF", "#FF00FF"],
                        full: ["#E6B8AF", "#F4CCCC", "#FCE5CD", "#FFF2CC", "#D9EAD3", "#D0E0E3", "#C9DAF8", "#CFE2F3", "#D9D2E9", "#EAD1DC",
                               "#DD7E6B", "#EA9999", "#F9CB9C", "#FFE599", "#B6D7A8", "#A2C4C9", "#A4C2F4", "#9FC5E8", "#B4A7D6", "#D5A6BD",
                               "#CC4125", "#E06666", "#F6B26B", "#FFD966", "#93C47D", "#76A5AF", "#6D9EEB", "#6FA8DC", "#8E7CC3", "#C27BA0",
                               "#A61C00", "#CC0000", "#E69138", "#F1C232", "#6AA84F", "#45818E", "#3C78D8", "#3D85C6", "#674EA7", "#A64D79",
                               "#85200C", "#990000", "#B45F06", "#BF9000", "#38761D", "#134F5C", "#1155CC", "#0B5394", "#351C75", "#741B47",
                               "#5B0F00", "#660000", "#783F04", "#7F6000", "#274E13", "#0C343D", "#1C4587", "#073763", "#20124D", "#4C1130"]
                    },

                    useSearch: true,
                    direction: "ltr",
                    cleanHTML: {
                        fillEmptyParagraph: true,
                        removeEmptyElements: false,
                        removeSpans: false,
                        removeStyleAttributes: false
                    },
                    draggable: true,
                    tabIndex: 0,
                    placeholder: "내용을 입력해주세요...",
                    showTooltip: true,
                    showTooltipDelay: 500,
                    addNewLineOnDBLClick: true,
                    addNewLineDblClickTimeout: 300,
                    createAttributes: {
                        table: {
                            class: "table table-bordered"
                        }
                    },
                    maxHeight: 1000,
                    minHeight: 200,
                    style: {
                        fontSize: "14px",
                        lineHeight: "1.5"
                    },
                    colorPickerDefaultTab: "background",
                    link: {
                        processPastedLink: true,
                        openInNewTabCheckbox: true
                    },
                    table: {
                        allowCellSelection: true,
                        selectionCellStyle: "border: 1px double #1e88e5 !important;"
                    },



                    autofocus: true,
                    spellcheck: true,
                    enter: "P",
                    imageDefaultWidth: 800,
                    imageEditable: true,
                    linkNoFollow: true,
                    toolbarSticky: true,
                    showCharsCounter: true,
                    showWordsCounter: true,
                    showXPathInStatusbar: false,
                    askBeforePasteHTML: false,  // Add this line
                    askBeforePasteFromWord: false,  // Add this line
                    defaultActionOnPaste: \'insert_clear_html\',  // Add this line
                    resizeCallback: function(width, height) {
                    localStorage.setItem("jodit_height", height);
                    }
                });
                
                // Restore last editor height if available
                var savedHeight = localStorage.getItem("jodit_height");
                if (savedHeight) {
                    '.$id.'_editor.setHeight(savedHeight);
                }
            }
        });
        </script>';
    }
    
    if ($is_dhtml_editor && $js) {
        $js = false;
    }
    $html .= "\n<span class=\"sound_only\">웹 에디터 끝</span>";
    return $html;
}


// textarea 로 값을 넘긴다. javascript 반드시 필요
function get_editor_js($id, $is_dhtml_editor=true)
{
    if ($is_dhtml_editor) {
        return "var {$id}_editor_data = {$id}_editor.getEditorValue();";
    } else {
        return "var {$id}_editor = document.getElementById('{$id}');\n";
    }
}


//  textarea 의 값이 비어 있는지 검사
function chk_editor_js($id, $is_dhtml_editor=true)
{
    if ($is_dhtml_editor) {
        return "if (!{$id}_editor_data || jQuery.inArray({$id}_editor_data.toLowerCase(), ['&nbsp;','<p>&nbsp;</p>','<p><br></p>','<p></p>','<br>']) != -1) { alert(\"내용을 입력해 주십시오.\");return false; }\n";
    } else {
        return "if (!{$id}_editor.value) { alert(\"내용을 입력해 주십시오.\"); {$id}_editor.focus(); return false; }\n";
    }
}