<?php 
// 데이터베이스 연결 및 공통 파일 포함
include_once('../common.php');  // 공통 기능(데이터베이스 연결 등) 포함
include_once(G5_THEME_PATH.'/head.php');  // 테마 헤더 포함
include_once(G5_THEME_PATH.'/tail.php');  // 테마 푸터 포함

// 세션 확인: 비회원일 경우 경고 메시지 출력 후 특정 URL로 리다이렉션
if (!$is_member) {
    echo "<script>
            alert('회원만 접속 가능합니다');
            window.location.replace('여러분 사이트 주소');
          </script>";
    exit;
}

// 알림 메시지와 함께 리다이렉션하는 함수
function showAlertAndRedirect($message, $url = '', $redirectDelay = 4000) {
    if (empty($url)) $url = $_SERVER['PHP_SELF'];
    $alertClass = ($message == "이모티콘 지급 기간이 지났습니다.") ? " alert-error" : "";

    header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
    header('Pragma: no-cache');
    header('Content-Type: text/html; charset=utf-8');

    echo '<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="utf-8">
    <title>알림</title>
    <style>
        .overlay {
            position: fixed; top: 0; left: 0; width: 100%; height: 100%;
            background-color: rgba(0, 0, 0, 0.5); display: flex;
            justify-content: center; align-items: center;
            animation: fadeIn 0.5s ease-out; z-index: 1000;
        }
        .modal {
            background: #fff; padding: 30px 40px;
            box-shadow: 0 15px 40px rgba(0,0,0,0.2);
            border-radius: 15px; text-align: center;
            animation: fadeIn 0.5s ease-out, slideDown 0.5s ease-out;
            max-width: 450px; width: 90%;
        }
        .alert-container {
            border: 2px solid #4a148c; border-radius: 8px;
            padding: 10px; margin-bottom: 20px;
            background: #d1c4e9;
        }
        .alert-error { background: #ffcccc; border-color: #ff0000; }
        .alert-title {
            font-size: 20px; color: #4a148c;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.2);
            margin-bottom: 10px; padding: 5px 10px;
            background: #f3e5f5; border-radius: 5px;
        }
        .alert-message { font-size: 16px; color: #000; }
        .timer {
            font-weight: bold; font-size: 20px; color: #007bff;
            margin-top: 15px;
        }
        .preview-info {
            font-size: 16px; font-weight: 500; color: #444;
            background: #e0f7fa; border: 2px solid #4dd0e1;
            border-radius: 8px; padding: 20px; margin-bottom: 20px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1); text-align: center;
        }
        .preview-info strong { color: #00796b; display: block; margin-bottom: 8px; }
        .preview-info span { display: block; color: #000; margin: 4px 0; }
        .emoticon-item {
            border: 2px solid #4a148c; border-radius: 8px;
            padding: 10px; margin-bottom: 20px; text-align: center;
        }
        .emoticon-item strong {
            font-size: 20px; color: #4a148c;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.2);
            margin-bottom: 10px; padding: 5px 10px;
            background: #f3e5f5; border-radius: 5px;
        }
        .emoticon-item img {
            width: 50px; height: auto; margin: 5px;
        }
        @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
        @keyframes slideDown { from { transform: translateY(-50px); } to { transform: translateY(0); } }
    </style>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let timerElement = document.getElementById("timer");
            let countdown = ' . ($redirectDelay / 1000) . ';
            let interval = setInterval(function() {
                countdown--;
                timerElement.innerText = countdown + "초 후 메인 페이지로 이동합니다.";
                if (countdown <= 0) {
                    clearInterval(interval);
                    window.location.replace("' . $url . '");
                }
            }, 1000);
        });
    </script>
</head>
<body>
<div class="overlay">
    <div class="modal">
        <div class="preview-info">
            <strong>무료 기간제 이모티콘 - 행성 이모티콘 -</strong>
            <span>이모티콘 지급 기간 : 2025년 4월 20일까지</span>
            <span>이모티콘 사용기간 : 지급일로부터 30일까지</span>
        </div>
        <div class="emoticon-item">
            <strong>이모티콘 미리보기</strong><br>';
            for ($i = 1; $i <= 10; $i++) {
                echo '<img src="' . G5_IMG_URL . '/emoticon/promo/object/object_emoticon' . $i . '.png">';
            }
echo '      </div>
        <div class="alert-container' . $alertClass . '">
            <div class="alert-title">알림</div>
            <div class="alert-message">' . $message . '</div>
        </div>
        <p class="timer" id="timer">4초 후 메인 페이지로 이동합니다.</p>
    </div>
</div>
</body>
</html>';
    exit;
}

// ====== 이모티콘 지급 처리 영역 ======

$memberId = $member["mb_id"];
$currentDate = date("Y-m-d");
$emoticonDeadline = "2025-04-30";

// 이미 받은 회원인지 확인
$promoCheck = sql_fetch("SELECT COUNT(*) AS cnt FROM g5_emoticon_user_package_promo WHERE mb_id = '{$memberId}' AND package_code = 'object'");
if ($promoCheck['cnt'] > 0) {
    showAlertAndRedirect("이미 이모티콘을 받았습니다.", "여러분 사이트 주소");
    exit;
}

// 지급 기한 초과 확인
if ($currentDate > $emoticonDeadline) {
    showAlertAndRedirect("이모티콘 지급 기간이 지났습니다.", "여러분 사이트 주소");
    exit;
}

// 지급 처리
sql_query("
    INSERT INTO g5_emoticon_user_package_promo 
    (mb_id, package_code, is_active, acquired_date) 
    VALUES 
    ('{$memberId}', 'object', 1, '{$currentDate}')
");

// 완료 안내
showAlertAndRedirect("무료 기간제 이모티콘이 지급 되었습니다.", "여러분 사이트 주소");
?>
