<?php
include_once('../common.php');

// 회원 여부 확인
if (!$is_member) {
    echo "<script>
            alert('회원만 접속 가능합니다');
            window.location.replace('https://test.neonserver.space/');
          </script>";
    exit;
}
include_once(G5_THEME_PATH.'/head.php');


// ◆ 이모티콘 정의
$emoticons = [];
for ($i = 1; $i <= 30; $i++) {
    $emoticons[] = [
        "code" => "paid1_emoticon$i",
        "image" => "paid/paid1/paid1_emoticon$i.png",
        "price" => 50
    ];
}

// ◆ 현재 로그인한 회원 정보
$mb = get_member($member['mb_id']);

// ◆ POST 요청 처리
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $paid_emoticon_code = $_POST['paid_emoticon_id'];
    $emoticonPrice = intval($_POST['emoticon_price']);

    // 유효성 확인
    $valid_codes = array_column($emoticons, 'code');
    if (!in_array($paid_emoticon_code, $valid_codes)) {
        echo "<script>alert('잘못된 접근입니다.');</script>";
        exit;
    }

    // 보유 여부 확인
    $exists = sql_fetch("SELECT * FROM g5_emoticon_user_paid WHERE mb_id = '{$member['mb_id']}' AND paid_emoticon_code = '{$paid_emoticon_code}'");
    if ($exists) {
        echo "<script>alert('이미 보유한 이모티콘입니다.');</script>";
        exit;
    }

    // 포인트 차감
    if ($mb['mb_point'] >= $emoticonPrice) {
        $point = -$emoticonPrice;
        $content = '이모티콘 구매 차감';
        insert_point($member['mb_id'], $point, $content, '@passive', 'emoticon' . uniqid(), 'emoticon_buy');

        // 보유 처리
        sql_query("INSERT INTO g5_emoticon_user_paid (paid_emoticon_code, mb_id, is_active) VALUES ('{$paid_emoticon_code}', '{$member['mb_id']}', 1)");

        echo "<script>alert('구매가 완료되었습니다!');</script>";
        echo "<script>location.href='" . $_SERVER['REQUEST_URI'] . "';</script>";
        exit;
    } else {
        echo "<script>alert('포인트가 부족합니다.');</script>";
    }
}

// ◆ 구매 여부 확인을 위한 보유 이모티콘 코드 모음 복소
$owned_codes = [];
$result = sql_query("SELECT paid_emoticon_code FROM g5_emoticon_user_paid WHERE mb_id = '{$member['mb_id']}' AND is_active = 1");
while ($row = sql_fetch_array($result)) {
    $owned_codes[] = $row['paid_emoticon_code'];
}
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>이모티콘샵</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<header>
    <img id="shop_logo" src="shop_logo.png" alt="Shop Logo">
</header>
<a href="<?php echo G5_BBS_URL ?>/point.php" target="_blank" id="ol_after_pt" class="win_point">
    <div id="view_point">
        <i class="fa fa-database" aria-hidden="true"></i>
        포인트
        <span id="mb_point">
            <?php echo $mb['mb_point']; ?>
        </span>
    </div>
</a>
<main>
    <section id="emoticon-store">
        <?php foreach ($emoticons as $emo): ?>
            <div class='emoticon-item'>
                <img class='emoticon' src='<?php echo G5_IMG_URL . "/emoticon/{$emo['image']}"; ?>' alt='emoticon'>
                <p class='emoticon_price'>가격: <?php echo $emo['price']; ?> P</p>
                <?php if (in_array($emo['code'], $owned_codes)): ?>
                    <button class='bought-btn'>보유 중</button>
                <?php else: ?>
                    <form method='POST'>
                        <input type='hidden' name='paid_emoticon_id' value='<?php echo $emo['code']; ?>'>
                        <input type='hidden' name='emoticon_price' value='<?php echo $emo['price']; ?>'>
                        <button type='submit' class='buy-btn'>구매</button>
                    </form>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
    </section>
</main>
</body>
</html>
<?php include_once(G5_THEME_PATH.'/tail.php'); ?>
