<?php
include_once("./_common.php");
header("Expires: Mon 26 Jul 1997 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d, M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

//설정 로드
include_once("./setup.php");

// POST 변수 가져오기
$pgstc = isset($_POST['gstc']) ? (int)$_POST['gstc'] : 0;
$pmpoint = isset($_POST['pmpoint']) ? (int)$_POST['pmpoint'] : 0;
$okmoney = isset($_POST['okmoney']) ? (int)$_POST['okmoney'] : 0;
$tokenkey = isset($_POST['tokenkey']) ? (int)$_POST['tokenkey'] : 0;
$sgametokenkey = isset($_POST['gamekey']) ? (int)$_POST['gamekey'] : 0;
$member_point = $member['mb_point'];

// 통계 테이블 존재 여부 확인 및 생성
$sql = "SHOW TABLES LIKE 'g5_snail_game_stats'";
$result = sql_query($sql);
if (sql_num_rows($result) == 0) {
    $sql = "CREATE TABLE IF NOT EXISTS `g5_snail_game_stats` (
      `sg_id` int(11) NOT NULL AUTO_INCREMENT,
      `mb_id` varchar(20) NOT NULL,
      `nickname` varchar(255) NOT NULL,
      `bet_point` int(11) NOT NULL,
      `win_point` int(11) NOT NULL,
      `game_datetime` datetime NOT NULL,
      PRIMARY KEY (`sg_id`),
      KEY `mb_id` (`mb_id`),
      KEY `game_datetime` (`game_datetime`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
    sql_query($sql);
}

// 요청 유효성 검사
if (!$pgstc || !preg_match("/^[1-2]+$/", $pgstc)) {
    setalert_reload("정상적인 방법으로 게임을 진행하세요.");
}

if (!$tokenkey || !$sgametokenkey) {
    setalert_reload("정상적인 방법으로 게임을 진행하세요.");
}

// 오늘 게임 횟수 확인
$zzz = G5_TIME_YMD;
$sql = " select count(*) as cnt from `{$g5['point_table']}`
          where po_rel_table = '@daroll'
            and mb_id = '{$member['mb_id']}'
            and substring(po_rel_action,1,10) = '{$zzz}' ";
$row = sql_fetch($sql);
$today_cnt = $row['cnt'];

// 토큰 키 생성 및 검증
$ckey1 = date("ymd");
$ckey2 = $member_point;
$ckey3 = $member['mb_id'];
$stokenkey = substr(md5($ckey1.$ckey2.$ckey3),0,12);

$bckey1 = date("ymd");
$bckey2 = $tokenkey + $pmpoint;
$bckey3 = $member['mb_id'];
$bstokenkey = substr(md5($bckey1.$bckey2.$bckey3),0,12);

$mbckey1 = date("ymd");
$mbckey2 = $tokenkey;
$mbckey3 = $member['mb_id'];
$mbstokenkey = substr(md5($mbckey1.$mbckey2.$mbckey3),0,12);

// 닉네임 가져오기
$sql = "SELECT mb_nick FROM {$g5['member_table']} WHERE mb_id = '{$member['mb_id']}'";
$nick_row = sql_fetch($sql);
$nickname = $nick_row['mb_nick'];

// 베팅 시작 (포인트 차감)
if ($pgstc == 1) {
    // 게임 횟수 제한 확인
    if ($today_cnt > $today_max) {
        setalert_reload("하루에 게임은 ".$today_max."회만 가능합니다.");
    }

    // 토큰키 검증
    if ($sgametokenkey != $member_point) {
        setalert_reload("정상적인 방법으로 게임을 진행하세요.");
    }

    // 포인트 검증 및 처리
    if ($pmpoint && $pmpoint >= $set_min_point) {
        // 토큰 검증
        if ($stokenkey != $bstokenkey) {
            setalert_reload("정상적인 방법으로 게임을 진행하세요.");
        }

        // 최대 베팅 금액 확인
        $setto_maxcnt = 999 * $set_maxcnt;
        if ($pmpoint > $setto_maxcnt) {
            setalert_reload("정상적인 방법으로 게임을 진행하세요.");
        }

        // 최소 베팅 금액 확인
        if ($pmpoint < $set_min_point) {
            setalert_reload("정상적인 방법으로 게임을 진행하세요.");
        }

        // 최소 포인트 확인
        if ($member_point < $min_point) {
            setalert_reload("보유하신 포인트(".number_format($member_point).")가 모자라 게임이 불가능 합니다.\\n\\n".number_format($min_point)." 이상 포인트를 모으신 후 다시 이용해주세요.");
        }

        // 베팅 기록 저장
        $sql = "INSERT INTO g5_snail_game_stats
                SET mb_id = '{$member['mb_id']}',
                    nickname = '{$nickname}',
                    bet_point = '{$pmpoint}',
                    win_point = '0',
                    game_datetime = NOW()";
        sql_query($sql);
        
        // 최근 삽입된 ID 가져오기
        $last_sg_id = sql_insert_id();
        
        // 포인트 차감
        insert_point($member['mb_id'], $pmpoint * (-1), "달팽이 게임베팅 포인트차감", "@daroll", $member['mb_id']."|".$last_sg_id, G5_TIME_YMDHIS);

        // 화면 업데이트
        $dcpmpoint = $member_point - $pmpoint;
        echo "<script type='text/javascript'> parent.document.getElementById('mymoney').value = '{$dcpmpoint}';</script>";
        echo "<script type='text/javascript'> parent.document.getElementById('gametokenkey').value = '{$dcpmpoint}';</script>";
    } else {
        setalert_reload("정상적인 방법으로 게임을 진행하세요.");
    }
}
// 게임 종료 (포인트 지급)
else if ($pgstc == 2) {
    // 토큰키 검증
    if ($sgametokenkey != $member_point) {
        setalert_reload("정상적인 방법으로 게임을 진행하세요.");
    }

    // 게임 횟수 제한 확인
    if ($today_cnt > $today_max) {
        setalert_reload("하루에 게임은 ".$today_max."회만 가능합니다.");
    }

    // 포인트 검증 및 처리
    if ($okmoney && $okmoney > 9) {
        // 최대 가능 획득 금액 확인
        $tosetno_point1 = 999 * $setno_point1;
        $tosetno_point2 = 999 * $setno_point2;
        $toset_maxcnt = $tosetno_point1 + $tosetno_point2 + $tosetno_point3;

        if ($okmoney > $toset_maxcnt) {
            setalert_reload("정상적인 방법으로 게임을 진행하세요.");
        }

        // 토큰 검증
        if ($bstokenkey != $mbstokenkey) {
            setalert_reload("정상적인 방법으로 게임을 진행하세요.");
        }

        // 최소 포인트 확인
        $game_min_point = $min_point - $okmoney;
        $game_member_point = $member_point + $okmoney;

        if ($game_member_point < $game_min_point) {
            setalert_reload("보유하신 포인트(".number_format($member_point).")가 모자라 게임이 불가능 합니다.\\n\\n".number_format($min_point)." 이상 포인트를 모으신 후 다시 이용해주세요.");
        }

        // 최근 베팅 정보 찾기
        $sql = "SELECT sg_id, bet_point FROM g5_snail_game_stats 
                WHERE mb_id = '{$member['mb_id']}' 
                AND win_point = 0 
                ORDER BY sg_id DESC 
                LIMIT 1";
        $bet_row = sql_fetch($sql);
        
        if ($bet_row) {
            $sg_id = $bet_row['sg_id'];
            $bet_point = $bet_row['bet_point'];

            // 통계 업데이트
            $sql = "UPDATE g5_snail_game_stats 
                    SET win_point = '{$okmoney}' 
                    WHERE sg_id = '{$sg_id}'";
            sql_query($sql);
            
            // 포인트 지급
            insert_point($member['mb_id'], $okmoney, "달팽이 게임에서 포인트획득", "@dokroll", $member['mb_id']."|".$sg_id, "up".G5_TIME_YMDHIS);

            // 화면 업데이트
            $prokmoney = $member_point + $okmoney;
            echo "<script type='text/javascript'> parent.document.getElementById('mymoney').value = '{$prokmoney}';</script>";
            echo "<script type='text/javascript'> parent.document.getElementById('gametokenkey').value = '{$prokmoney}';</script>";
        } else {
            // 기록이 없는 경우 새로 삽입
            $sql = "INSERT INTO g5_snail_game_stats
                    SET mb_id = '{$member['mb_id']}',
                        nickname = '{$nickname}',
                        bet_point = '0',
                        win_point = '{$okmoney}',
                        game_datetime = NOW()";
            sql_query($sql);
            
            $sg_id = sql_insert_id();
            
            // 포인트 지급
            insert_point($member['mb_id'], $okmoney, "달팽이 게임에서 포인트획득", "@dokroll", $member['mb_id']."|".$sg_id, "up".G5_TIME_YMDHIS);

            // 화면 업데이트
            $prokmoney = $member_point + $okmoney;
            echo "<script type='text/javascript'> parent.document.getElementById('mymoney').value = '{$prokmoney}';</script>";
            echo "<script type='text/javascript'> parent.document.getElementById('gametokenkey').value = '{$prokmoney}';</script>";
        }
    } else {
        setalert_reload("정상적인 방법으로 게임을 진행하세요.");
    }
} else {
    setalert_reload("정상적인 방법으로 게임을 진행하세요.");
}
