<?php

/*
===========================================================

	프로젝트 이름 : 피리 웹프로그램

	만든사람 : 피리 PIREE

	홈페이지 : http://www.piree.co.kr

	작성날짜 : 2015년 04월 07일 화요일 오후 16시 50분 - 날씨 흐림

	저 작 권 : Copyright ⓒ 2014-2015 투스포츠 (원병철) All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.co.kr 에 문의해 주세요.

===========================================================
 피리 > 관리자 > 피리 쪽지 PLUS G5 > 처음
===========================================================


*/


	#########################################################
	# 시작 => 선_처리
	#########################################################

	//=======================================================
	// 기본처리_파일__첨부
	include_once('./_common.php');

	#########################################################
	# 끝 => 선_처리
	#########################################################



	#########################################################
	# 시작 => 선_처리__관리자_확인
	#########################################################

	//=======================================================
	// 시작 => 회원_여부__확인
	IF ($is_guest || !$is_member)
	{
		alert ("회원만 이용하실 수 있습니다.", G5_DOMAIN."/");
		EXIT;
	}
	// 끝 => 회원_여부__확인
	//=======================================================


	//=======================================================
	// 시작 => 관리자__아니면
	IF (!$is_admin)
	{
		alert ("권한이 없습니다.", G5_DOMAIN."/");
		EXIT;
	}
	// 끝 => 관리자__아니면
	//=======================================================


	//=======================================================
	// 관리자_확인
	auth_check($auth[$sub_menu], 'r');

	#########################################################
	# 끝 => 선_처리__관리자_확인
	#########################################################



	#########################################################
	# 시작 => 피리_전체_쪽지__설정_정보_파일__첨부
	#########################################################

	//=======================================================
	// 메뉴_번호__지정____770020
	$sub_menu = "770020";


	//=======================================================
	// 기본_설정_첨부__여부
	// 0 - 안해
	// 1 - 하자
	$is_get__piree_config = 0;


	//=======================================================
	// 피리_전체_쪽지__설정_정보__가져오기
	$is_get__770020 = 1;


	//=======================================================
	// 설정_화면__여부
	$is_piree_program_config = 1;


	//=======================================================
	// 설정_정보_파일__첨부
	include_once( get__sam_file($sub_menu, '') );

	#########################################################
	# 끝 => 피리_전체_쪽지__설정_정보_파일__첨부
	#########################################################



	#########################################################
	# 시작 => 상수__변수__배열
	#########################################################

	//=======================================================
	// 피리_전체_쪽지__건수
	$memo_admin_tot = 0;


	//=======================================================
	// 피리_전체_쪽지__배열
	$memo_admin_arr = array();


	//=======================================================
	// 회원_닉네임
	$member_nick_arr = array();

	#########################################################
	# 끝 => 상수__변수__배열
	#########################################################



	#########################################################
	# 시작 => 피리_전체_쪽지__불러오기
	#########################################################

		#######################################################
		# 시작 => 피리_전체_쪽지__가져오기
		#######################################################

		//=====================================================
		// 피리_전체_쪽지__가져오는__쿼리문
		$sql = "SELECT COUNT(*) FROM `".$piree_table['piree_memo_list']."`";
		$memo_admin_tot = sql_efv($sql);
		$memo_admin_tot = (int)$memo_admin_tot;

		#######################################################
		# 끝 => 피리_전체_쪽지__가져오기
		#######################################################



		#######################################################
		# 시작 => 목록_관련__상수__변수__배열
		#######################################################

		//=====================================================
		// 한_화면__글수
		$rows_n = $config['cf_page_rows'];


		//=====================================================
		// 전체_페이지__수
		$memo_admin_tot_page = ceil($memo_admin_tot / $rows_n);


		//=====================================================
		// 페이지_없으면__첫_페이지__1_페이지
		IF (!$page_n || $page_n < 1)								 $page_n = 1;


		//=====================================================
		// 시작__열
		$start_record_n = ($page_n - 1) * $rows_n;


		//=====================================================
		// 리스트_URL
		$page_url_s = "./?page_n=";

		#######################################################
		# 끝 => 목록_관련__상수__변수__배열
		#######################################################



		#######################################################
		# 시작 => 피리_전체_쪽지__불러오기
		#######################################################
		IF ($memo_admin_tot > 0)
		{

			//===================================================
			// 피리_전체_쪽지__불러오기
			$sql		= "SELECT * FROM `".$piree_table['piree_memo_list']."` ORDER BY `amm_n` DESC LIMIT ".$start_record_n.", ".$rows_n;
			$result = sql_query ($sql);


			//===================================================
			// 시작 => 반복문
			FOR ($i=0; $row=sql_fetch_array($result); $i++)
			{

					//===============================================
					// 전체_쪽지_번호
					$amm_n = $row['amm_n'];


					//===============================================
					// 보낸_회원_아이디
					$amm_send_mb_id = $row['amm_send_mb_id'];
					$memo_admin_arr[$amm_n]['amm_send_mb_id'] = $amm_send_mb_id;


					//===============================================
					// 시작 => 보낸_회원_닉네임__유무
					IF ($member_nick_arr[$amm_send_mb_id])
					{

							#############################################
							# 시작 => 보낸_회원_닉네임__있으면
							#############################################

							$memo_admin_arr[$amm_n]['amm_send_mb_nick'] = $member_nick_arr[$amm_send_mb_id];

					}
					ELSE
					{

							#############################################
							# 시작 => 보낸_회원_닉네임__없으면
							#############################################

							//===========================================
							// 회원_닉네임__가져오기
							$mem_info = get_member($amm_send_mb_id);


							//===========================================
							// 회원_닉네임
							$send_mb_nick = $mem_info['mb_nick'];


							//===========================================
							// 회원_닉네임__배열_저장
							$member_nick_arr[$amm_send_mb_id] = $send_mb_nick;


							//===========================================
							// 회원_닉네임__배열_저장
							$memo_admin_arr[$amm_n]['amm_send_mb_nick'] = $send_mb_nick;

					}
					// 끝 => 보낸_회원_닉네임__유무
					//===============================================


					//===============================================
					// 보낸_쪽지_번호
					$memo_admin_arr[$amm_n]['amm_send_memo_n'] = $row['amm_send_memo_n'];


					//===============================================
					// 보낸_시간
					$memo_admin_arr[$amm_n]['amm_send_time_n'] = $row['amm_send_time_n'];


					//===============================================
					// 읽은_회원
					$memo_admin_arr[$amm_n]['amm_read_member_t'] = $row['amm_read_member_t'];


					//===============================================
					// 쪽지_내용
					$memo_admin_arr[$amm_n]['amm_memo'] = stripslashes($row['amm_memo']);

			}
			// 끝 => 반복문
			//===================================================

		}
		#######################################################
		# 끝 => 피리_전체_쪽지__불러오기
		#######################################################

	#########################################################
	# 끝 => 피리_전체_쪽지__불러오기
	#########################################################



	#########################################################
	# 시작 => 화면_ECHO
	#########################################################

	//=======================================================
	// 타이틀
	$g5['title'] = "그누보드 추가 기능 PLUS G5";


	//=======================================================
	// HEAD__첨부
	include_once('../admin.head.php');

	#########################################################
	# 끝 => 화면_ECHO
	#########################################################


?>

<section>
		<h2>피리 쪽지</h2>


		<div class="tbl_head01 tbl_wrap">
				<table>
				<caption>피리 쪽지</caption>
				<thead>
				<tr>
					<th scope="col">번호</th>
					<th scope="col">보낸 회원</th>
					<th scope="col">보낸 시간</th>
					<th scope="col">읽음</th>
					<th scope="col">쪽지 내용</th>
				</thead>
				<tbody>

<?php

		//=====================================================
		// 시작 => 전체_쪽지_목록__유무
		IF ($memo_admin_tot > 0)
		{

			#####################################################
			# 시작 => 전체_쪽지_목록__있으면
			#####################################################

			//===================================================
			// 시작 => 반복문
			WHILE (list($key, $val) = each($memo_admin_arr))
			{

				//=================================================
				// 전체_쪽지_번호
				$amm_n = $key;


				//=================================================
				// 보낸_일시
				$send_time_s = date("Y-m-d", $val['amm_send_time_n']);


				//=================================================
				// 쪽지함_열기_링크
				$memo_link_u = G5_BBS_URL.'/memo_view.php?kind=send&me_id='.$val['amm_send_memo_n'];

?>
				<tr>
					<td class='td_left_60'><?php echo $amm_n ?></td>
					<td class="td_left_100"><?php echo $val['amm_send_mb_nick'] ?><br />( <?php echo $val['amm_send_mb_id'] ?> )</td>
					<td class="td_left_100"><?php echo $send_time_s ?></td>
					<td class="td_left_80"><?php echo $val['amm_read_member_t'] ?> 명</td>
					<td><a href="<?php echo $memo_link_u ?>" class="win_memo"><?php echo $val['amm_memo'] ?></a></td>
				</tr>

<?php
			}
			// 끝 => 반복문
			//===================================================

			#####################################################
			# 끝 => 전체_쪽지_목록__있으면
			#####################################################

		}
		ELSE
		{

			#####################################################
			# 시작 => 전체_쪽지_목록__없으면
			#####################################################

?>
				<tr>
					<td colspan="10" align="center"><strong>등록된 [ 전체 쪽지 ] 가 없습니다.</strong></td>
				</tr>

<?php

			#####################################################
			# 끝 => 전체_쪽지_목록__없으면
			#####################################################

		}
		// 끝 => 전체_쪽지_목록__유무
		//=====================================================

?>

				</tbody>
				</table>
		</div>


		<div class="btn_confirm">
				<a href="pi__config.form.php" class="btn_cancel">설정 정보 수정하기</a>
		</div>

</section>



		<br /><br />



<?php

	//=======================================================
	// 시작 => 전체_쪽지__사용_여부
	IF ($p770020__memo_admin_use_n == 1)
	{

			#####################################################
			# 시작 => 전체_쪽지__사용_하면
			#####################################################

			//===================================================
			// 피리_전체_쪽지__입력하는_폼__첨부
			include_once("./send_form.php");

	}
	ELSE
	{

			#####################################################
			# 시작 => 전체_쪽지__사용_하지_않으면
			#####################################################

?>
		<div class="tbl_head01 tbl_wrap" style="margin:20px; padding:20px; border:2px solid #999;">
				<strong>☞ "피리 쪽지" 사용 안함으로 설정하셔서 입력폼이 보이지 않습니다. ☜</strong> &nbsp; &nbsp; &nbsp; 
				<a href="pi__config.form.php">설정 변경 하기</a>
		</div>

<?php

	}
	// 끝 => 전체_쪽지__사용_여부
	//=======================================================

?>



		<br /><br />



<section>

		<div style="margin:20px; padding:20px; border:2px solid #999; line-height:2.4em;">
				<span style="color:#0000ff; font-weight:bold;">▶ 광고 , 일거리 구합니다.</span><br />
				1. 사이트 이전, DB  이전<br />
				2. PHP로 제작된 다른 사이트, 다른 프로그램에서 그누보드, 영카트로 변환<br />
				3. 그누보드 스킨 개발 (구인, 구직, 부동산, 아르바이트, 애완동물 분양, 캠핑장.펜션 예약등)<br />
				4. 그누보드, 영카트의  회원정보에 주소, 기존 주문의 주소에 새 우편번호를 입력해 드립니다.<br />
				5. PHP 단기 계약직, 프리랜서로 근무가능, 재택이나 서울 버스터미널 인근지역에 상주근무 가능<br />
				연락방법 : <a href="http://www.piree.co.kr" target="_blank">http://www.piree.co.kr 홈페이지에서 문의</a> , 메일주소 tosports@naver.com , piree1977@gmail.com
		</div>

</section>


<?php

	//=======================================================
	// ADMIN_TAIL__첨부
	include_once("../admin.tail.php");

?>