<?php

/*
=====================================================================

	프로젝트 이름 : 피리 웹프로그램

	만든사람 : 피리 PIREE ( piree1977@gmail.com )

	홈페이지 : www.piree.kr

	작성날짜 : 2015년 12월 21일 월요일 오전 04시 45분 - 날씨 쌀쌀하다. 혹한은 아니고

	저 작 권 : Copyright ⓒ 2014-2023 피리 piree.kr All right reserved
				      그누보드 외에 추가된 소스는~
				      만든사람의 허락없이 무단으로 사용할수 없습니다.
				      사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
				      http://www.piree.kr 에 문의해 주세요.

=====================================================================
 피리 > 피리 기본 관리 > 라이브러리 > 라이브러리
=====================================================================


*/


	###################################################################
	# 시작 => 접근__유효__확인
	###################################################################

	//=================================================================
	// 개별_페이지__접근_불가
	IF ( !defined('_GNUBOARD_') )								    	EXIT;


	//=================================================================
	// 관리자_확인
	auth_check($auth[$sub_menu], "r");

	###################################################################
	# 끝 => 접근__유효__확인
	###################################################################



	###################################################################
	# 시작 => 버젼_숫자__가져오기
	###################################################################
	function get__prog_version_n($fnc_version_s)
	{

			//=============================================================
			// 넘겨줄____버젼_숫자
			$version_n = 0;


			//=============================================================
			// 시작 => 버젼__있으면
			IF ( $fnc_version_s )
			{

					//=========================================================
					// 버젼__배열_나누기
					$exs = explode('.', $fnc_version_s);


					//=========================================================
					// 버젼_숫자_만들기
					IF ( (int)$exs[0] > 0 )									$version_n += ($exs[0]*100000000);
					IF ( (int)$exs[1] > 0 )									$version_n += ($exs[1]*1000000);
					IF ( (int)$exs[2] > 0 )									$version_n += ($exs[2]*10000);
					IF ( (int)$exs[3] > 0 )									$version_n += ($exs[3]*100);
					IF ( (int)$exs[4] > 0 )									$version_n += ($exs[4]*1);

			}
			// 끝 => 버젼__있으면
			//=============================================================


			//=============================================================
			// 넘겨주기____버젼_숫자
			return $version_n;

	}
	###################################################################
	# 끝 => 버젼_숫자__가져오기
	###################################################################



	###################################################################
	# 시작 => 프로그램_정보__입력하기
	###################################################################
	function save_piree__program_info($piree_menu_n)
	{

	  	###############################################################
	  	# 시작 => 저장_변수
	  	###############################################################

	  	//=============================================================
	  	// 외부_상수__전역_변수
	  	global $piree, $piree_prog_a, $prog_memo_s;


	  	//=============================================================
	  	// 프로그램_구분
	  	$grp_n = 1;


	  	//=============================================================
	  	// 사용자_번호
	  	// 0 - 없음
	  	$user_n = 0;

	  	###############################################################
	  	# 끝 => 저장_변수
	  	###############################################################



	  	###############################################################
	  	# 시작 => 프로그램__변수__다듬기
	  	###############################################################

	  	//=============================================================
	  	// 도메인
	  	$domain_s = G5_DOMAIN ."/";


	  	//=============================================================
	  	// 프로그램_버젼
	  	$func_prog_ver_n = get__prog_version_n($piree_prog_a[$piree_menu_n]['version_s']);

	  	###############################################################
	  	# 끝 => 프로그램__변수__다듬기
	  	###############################################################



	  	###############################################################
	  	# 시작 => 공통_쿼리__조합
	  	###############################################################

	  	//=============================================================
	  	// 공통_쿼리__조합
	  	$sql_common  = "`pgs_grp_n`				= '". $grp_n ."', ";
	  	$sql_common .= "`pgs_user_n`			= '". $user_n ."', ";
	  	$sql_common .= "`pgs_prog_c`			= '". $piree_prog_a[$piree_menu_n]['code'] ."', ";
	  	$sql_common .= "`pgs_prog_s`			= '". $piree_prog_a[$piree_menu_n]['name'] ."', ";
	  	$sql_common .= "`pgs_version_s`		= '". $piree_prog_a[$piree_menu_n]['version_s'] ."', ";
	  	$sql_common .= "`pgs_version_n`		= '". $func_prog_ver_n ."', ";
	  	$sql_common .= "`pgs_prog_memo_s`	= '". $prog_memo_s ."', ";
	  	$sql_common .= "`pgs_domain_s`		= '". $domain_s ."', ";
	  	$sql_common .= "`pgs_is_paid`			= '". $piree_prog_a[$piree_menu_n]['is_paid'] ."' ";

	  	###############################################################
	  	# 끝 => 공통_쿼리__조합
	  	###############################################################



	  	###############################################################
	  	# 시작 => 설정__저장하기
	  	###############################################################

	  	//=============================================================
	  	// 조건절
	  	$sql_wh_s = "`pgs_prog_n` = '". $piree_menu_n ."' AND `pgs_version_s` = '". $piree_prog_a[$piree_menu_n]['version_s'] ."'";


	  	//=============================================================
	  	// 프로그램_저장_여부__확인하는__쿼리문
	  	$sql_select = "SELECT COUNT(*) FROM `". $piree['program_sam'] ."` WHERE ". $sql_wh_s;
	  	$exist = sql_efv($sql_select);


	  	//=============================================================
	  	// 시작 => 설정_ROW__유무
	  	IF ( $exist > 0 )
	  	{

	  	  	###########################################################
	  	  	# 시작 => ROW_있으니__수정하기
	  	  	###########################################################

	  	  	//=========================================================
	  	  	// 수정하는__쿼리
	  	  	$sql_save  = "UPDATE `". $piree['program_sam'] ."` SET ";
	  	  	$sql_save .= $sql_common .", ";
	  	  	$sql_save .= "`pgs_modi_time_n`	= '". G5_SERVER_TIME ."' ";
	  	  	$sql_save .= "WHERE ". $sql_wh_s;


	  	  	//=========================================================
	  	  	// 에러_메세지
	  	  	$save_err_msg = "프로그램 설치 정보를 수정하지 못했습니다.";

	  	}
	  	ELSE
	  	{

	  	  	###########################################################
	  	  	# 시작 => ROW_없으니__입력하기
	  	  	###########################################################

	  	  	//=========================================================
	  	  	// 입력하는__쿼리
	  	  	$sql_save  = "INSERT INTO `". $piree['program_sam'] ."` SET ";
	  	  	$sql_save .= "`pgs_prog_n` = '". $piree_menu_n ."', ";
	  	  	$sql_save .= $sql_common .", ";
	  	  	$sql_save .= "`pgs_regi_time_n` = '". G5_SERVER_TIME ."'";


	  	  	//=========================================================
	  	  	// 에러_메세지
	  	  	$save_err_msg = "프로그램 설치 정보를 입력하지 못했습니다.";

	  	}
	  	// 끝 => 설정_ROW__유무
	  	//=============================================================


	  	//=============================================================
	  	// 시작 => 쿼리_실행
	  	IF ( !sql_query($sql_save) )
	  	{

	  	  	// 에러
	  	  	alert($save_err_msg, $go_url_s);
	  	  	EXIT;

	  	}
	  	// 끝 => 쿼리_실행
	  	//=============================================================

	  	###############################################################
	  	# 끝 => 설정__저장하기
	  	###############################################################

	}
	###################################################################
	# 끝 => 프로그램_정보__입력하기
	###################################################################


?>