<?php

/*
=====================================================================

	프로젝트 이름 : 피리 경기 예측	

	만든사람 : 피리 PIREE

	홈페이지 : www.piree.kr

	p770087 Ver 0.1.0 작업날짜 : 2022년 12월 29일 목요일 오전 10시 04분 - 날씨 맑음, -7.9, -2, -12, 0%, 1.8ms, 14% / 나쁨, 39, 29

	저 작 권 : Copyright ⓒ 2023 피리 PIREE . All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.kr 에 문의해 주세요.

=====================================================================
 피리 > 관리자 > 피리 경기 예측 PLUS G5 > 설정 수정 > 처리
=====================================================================


*/


	###################################################################
	# 시작 => 선_처리__메뉴_지정__관리자_확인
	###################################################################

	//=================================================================
	// 피리__웹_프로그램__설정__번호
	define('PIREE__CONFIG', $sub_menu);


	//=================================================================
	// 기본처리_파일__첨부
	include_once('./_common.php');


	//=================================================================
	// 시작 => 회원_아니면
	IF ( !$is_member )
	{
			alert('회원만 이용하실 수 있습니다.', G5_DOMAIN);
	}
	// 끝 => 회원_아니면
	//=================================================================


	//=================================================================
	// 시작 => 관리자__아니면
	IF ( !$is_admin )
	{
			alert('접근할 권한이 없습니다.', G5_DOMAIN);
	}
	// 끝 => 관리자__아니면
	//=================================================================


	//=================================================================
	// 관리자_확인
	auth_check($auth[$piree_prog_a[770087]['num']], 'w');

	###################################################################
	# 끝 => 선_처리
	###################################################################



	###################################################################
	# 시작 => 피리_경기_예측__설정_정보_파일__첨부
	###################################################################

	//=================================================================
	// 기본_설정_첨부__여부
	// 0 - 안해
	// 1 - 하자
	$get__p770000_conf = 1;


	//=================================================================
	// 설정_정보__가져오기
	$get__p770087 = 1;


	//=================================================================
	// 설정_화면__여부
	$prog_config_page = 1;


	//=================================================================
	// 피리_경기_예측__설정_정보_파일__첨부
	include_once( piree__path($piree_prog_a[770087]['num'], 'config') );

	###################################################################
	# 끝 => 피리_경기_예측__설정_정보_파일__첨부
	###################################################################



	###################################################################
	# 시작 => 상수__변수__배열
	###################################################################

	//=================================================================
	// 정보_저장__여부
	// 0 - 실패
	// 1 - 성공
	$is_save = $p770087__prog_c != "" ? 1 : 0;


	//=================================================================
	// 이동할__페이지
	$go_url_s = "./__config.form.php";

	###################################################################
	# 끝 => 상수__변수__배열
	###################################################################



	###################################################################
	# 시작 => 필요한_라이브러리_파일__첨부
	###################################################################

	//=================================================================
	// 회원__관련_파일__첨부
	include_once( piree__path($piree_prog_a[770000]['num'], 'member.lib.php', 0) );


	//=================================================================
	// 입력_관련_라이브러리__파일_첨부
	include_once( piree__path($piree_prog_a[770000]['num'], 'save.lib.php') );

	###################################################################
	# 끝 => 필요한_라이브러리_파일__첨부
	###################################################################



	###################################################################
	# 시작 => QUERY_STRING
	###################################################################

	//=================================================================
	// EXTEND_파일에서__파일_첨부
	$prog_top_include_n = (int)$_POST['prog_top_include_n'];


	//=================================================================
	// HEAD_태그에서__파일_첨부
	$prog_head_include_n = (int)$_POST['prog_head_include_n'];


	//=================================================================
	// BODY_태그_상단에__파일_첨부
	$prog_body_include_n = (int)$_POST['prog_body_include_n'];


	//=================================================================
	// PC_스킨
	$skin_pc_c = save__str($_POST['skin_pc_c']);


	//=================================================================
	// 모바일_스킨
	$skin_mo_c = save__str($_POST['skin_mo_c']);


	//=================================================================
	// 경기_예측_사용
	$use_match_predict_n = (int)$_POST['use_match_predict_n'];


	//=================================================================
	// 경기_예측_이용_레벨
	$match_predict_use_level = (int)$_POST['match_predict_use_level'];

	###################################################################
	# 끝 => QUERY_STRING
	###################################################################



	###################################################################
	# 시작 => 형변환__기본_값__검증하기
	###################################################################

	//=================================================================
	// 시작 => EXTEND_파일에서__파일_첨부__여부
	IF ( $prog_top_include_n != 1 && $prog_top_include_n != 11 )
	{
			$prog_top_include_n = 0;
	}
	// 끝 => EXTEND_파일에서__파일_첨부__여부
	//=================================================================


	//=================================================================
	// 시작 => HEAD_태그에서__파일_첨부__여부
	IF ( $prog_head_include_n != 1 && $prog_head_include_n != 11 )
	{
			$prog_head_include_n = 0;
	}
	// 끝 => HEAD_태그에서__파일_첨부__여부
	//=================================================================


	//=================================================================
	// 시작 => BODY_태그_상단에__파일_첨부__여부
	IF ( $prog_body_include_n != 1 && $prog_body_include_n != 11 )
	{
			$prog_body_include_n = 0;
	}
	// 끝 => BODY_태그_상단에__파일_첨부__여부
	//=================================================================


	//=================================================================
	// 시작 => PC_스킨
	IF ( !$skin_pc_c || $skin_pc_c == '' )
	{
			alert("[ PC 스킨 ]을 입력해 주세요.");
	}
	// 끝 => PC_스킨
	//=================================================================


	//=================================================================
	// 시작 => 모바일_스킨
	IF ( !$skin_mo_c || $skin_mo_c == '' )
	{
			// alert("[ 모바일 스킨 ]을 입력해 주세요.");
	}
	// 끝 => 모바일_스킨
	//=================================================================


	//=================================================================
	// 시작 => 경기_예측_사용__여부
	IF ( $use_match_predict_n != 1 )
	{
			$use_match_predict_n = 0;
	}
	// 끝 => 경기_예측_사용__여부
	//=================================================================


	//=================================================================
	// 시작 => 유효_검증하기____경기_예측_이용_레벨
	IF ( check__member_level($match_predict_use_level, 2, 10) != 1 )
	{
			$match_predict_use_level = 1;
	}
	// 끝 => 유효_검증하기____경기_예측_이용_레벨
	//=================================================================

	###################################################################
	# 끝 => 형변환__기본_값__검증하기
	###################################################################



	###################################################################
	# 시작 => XSS_공격_방지
	###################################################################

	//=================================================================
	// XSS_공격_방지
	// $AAAA = clean_xss_tags($AAAA);

	###################################################################
	# 끝 => XSS_공격_방지
	###################################################################



	###################################################################
	# 시작 => 피리__기본_정보_파일__첨부
	###################################################################

	//=================================================================
	// 피리__프로그램_기본_관리_파일__경로
	include_once( piree__admin_path($piree_prog_a[770000]['num'], 'program.lib.php', 0) );


	//=================================================================
	// 프로그램_정보__저장하기
	save_piree__program_info($piree_prog_a[770087]['num']);

	###################################################################
	# 끝 => 피리__기본_정보_파일__첨부
	###################################################################



	###################################################################
	# 시작 => 수치_정보__알아내기
	###################################################################

	//=================================================================
	// 제품__전체_수__파악하기
	$sql = "SELECT COUNT(*) FROM `". $piree['p770087_cost'] ."`";
	$goods_all_t = (int)sql_efv($sql);


	//=================================================================
	// 경기__전체_수__파악하기
	$sql = "SELECT COUNT(*) FROM `". $piree['p770087_match_list'] ."`";
	$match_all_t = (int)sql_efv($sql);

	###################################################################
	# 끝 => 수치_정보__알아내기
	###################################################################



	###################################################################
	# 시작 => 피리_경기_예측_설정__저장하기
	###################################################################

			###############################################################
			# 시작 => 공통_쿼리__조합
			###############################################################

			//=============================================================
			// 공통_쿼리__조합
			$sql_common  = "`pgs_prog_s`    = '". $piree_prog_a[$sub_menu]['name'] ."', ";
			$sql_common .= "`pgs_skin_pc_c` = '". $skin_pc_c ."', ";
			$sql_common .= "`pgs_skin_mo_c` = '". $skin_mo_c ."', ";


			//=============================================================
			// EXTEND_파일에서___파일_첨부__여부
			$sql_common .= "`pgs_top_include_n` = '". $prog_top_include_n ."', ";


			//=============================================================
			// HEAD_태그_안에서___파일_첨부__여부
			$sql_common .= "`pgs_head_include_n` = '". $prog_head_include_n ."', ";


			//=============================================================
			// BODY_태그_상단에___파일_첨부__여부
			$sql_common .= "`pgs_body_include_n` = '". $prog_body_include_n ."', ";

			###############################################################
			# 끝 => 공통_쿼리__조합
			###############################################################



			###############################################################
			# 시작 => 항목별__저장하기
			###############################################################

			//=============================================================
			// 경기_예측_사용
			$sql_common .= "`pgs_cf_1_n` = '". $use_match_predict_n ."', ";


			//=============================================================
			// 경기_예측_이용_레벨
			$sql_common .= "`pgs_cf_2_n` = '". $match_predict_use_level ."', ";

			###############################################################
			# 끝 => 항목별__저장하기
			###############################################################



			###############################################################
			# 시작 => 설정__저장하기
			###############################################################

			//=============================================================
			// 수정하는__쿼리
			$sql_updateate	= "UPDATE `". $piree['program_sam'] ."` SET ";
			$sql_updateate .= $sql_common;
			$sql_updateate .= "`pgs_modi_time_n`	= '". G5_SERVER_TIME  ."' ";
			$sql_updateate .= "WHERE `pgs_prog_n` = '". $piree_prog_a[770087]['num'] ."'";


			//=============================================================
			// 시작 => 쿼리_실행
			IF ( !sql_query($sql_updateate))
			{

					// 에러_메세지
					$save_err_msg = "[ ". $piree_prog_a[770087]['name'] ." ] 설정 정보를 수정하지 못했습니다.";

					// 에러
					alert($save_err_msg, $go_url_s);

			}
			// 끝 => 쿼리_실행
			//=============================================================

			###############################################################
			# 끝 => 설정__저장하기
			###############################################################

	###################################################################
	# 끝 => 피리_경기_예측_설정__저장하기
	###################################################################



	###################################################################
	# 시작 => 마무리__페이지_이동
	###################################################################

	//=================================================================
	// 알림창
	alert('설정 정보를 저장 하였습니다.', $go_url_s, 0);
	EXIT;

	###################################################################
	# 끝 => 마무리__페이지_이동
	###################################################################


?>