<?php

/*
=====================================================================

	프로젝트 이름 : 피리 경기 예측

	만든사람 : 피리 PIREE

	홈페이지 : www.piree.kr

	p770087 Ver 0.1.0 작업날짜 : 2022년 12월 29일 목요일 오전 09시 37분 - 날씨 맑음, -9.0, -2, -12, 20%, 1.5ms, 14% / 나쁨, 39, 29

	저 작 권 : Copyright ⓒ 2023 피리 PIREE . All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.kr 에 문의해 주세요.

=====================================================================
 피리 > 관리자 > 피리 경기 예측 PLUS G5 > 설치하기
=====================================================================


*/


	###################################################################
	# 시작 => 선_처리__메뉴_지정__관리자_확인
	###################################################################

	//=================================================================
	// 기본처리_파일__첨부
	include_once('./_common.php');


	//=================================================================
	// 설치_화면
	define('_INSTALL_', $piree_prog_a[770087]['num']);


	//=================================================================
	// 시작 => 회원_여부__확인
	IF ( $is_guest || !$is_member )
	{
			alert("회원만 이용하실 수 있습니다", G5_DOMAIN ."/");
	}
	// 끝 => 회원_여부__확인
	//=================================================================


	//=================================================================
	// 시작 => 관리자__아니면
	IF ( !$is_admin )
	{
			alert('접근할 권한이 없습니다.', G5_DOMAIN);
	}
	// 끝 => 관리자__아니면
	//=================================================================


	//=================================================================
	// 관리자_권한_확인
	auth_check($auth[$piree_prog_a[770087]['num']], 'w');

	###################################################################
	# 끝 => 선_처리__메뉴_지정__관리자_확인
	###################################################################



	###################################################################
	# 시작 => 피리_경기_예측__설정_정보_파일__첨부
	###################################################################

	//=================================================================
	// 기본_설정_첨부__여부
	// 0 - 안해
	// 1 - 하자
	$get__p770000_conf = 0;


	//=================================================================
	// 설정_정보__가져오기
	$get__p770087 = 1;


	//=================================================================
	// 설정_화면__여부
	$prog_config_page = 1;


	//=================================================================
	// 설정_정보_파일__첨부
	include_once( piree__path($piree_prog_a[770087]['num'], 'config') );

	###################################################################
	# 끝 => 피리_경기_예측__설정_정보_파일__첨부
	###################################################################



	###################################################################
	# 시작 => 필요한__라이브러리_파일__첨부
	###################################################################

	//=================================================================
	// FORM__관련_파일__첨부
	include_once( piree__path($piree_prog_a[770000]['num'], 'form.lib.php', 0) );

	###################################################################
	# 끝 => 필요한__라이브러리_파일__첨부
	###################################################################



	###################################################################
	# 시작 => 상수__변수__배열
	###################################################################

	//=================================================================
	// 페이지__타이틀
	$html_title = "설치하기 :: ". $piree_prog_a[$sub_menu]['name'] ." Ver ". $piree_prog_a[$sub_menu]['version_s'];


	//=================================================================
	// 페이지__타이틀
	$g5['title'] = $html_title;

	###################################################################
	# 끝 => 검증
	###################################################################



	###################################################################
	# 시작 => HEAD
	###################################################################

	//=================================================================
	// ADMIN__HEAD
	include_once( G5_ADMIN_PATH .'/admin.head.php' );


	//=================================================================
	// 상단__메뉴_코드
	$top_menu = 'install';


	//=================================================================
	// 상단__메뉴_파일
	include_once( piree__admin_path($sub_menu, 'top.menu.inc.php') );

	###################################################################
	# 끝 => HEAD
	###################################################################



	###################################################################
	# 시작 => 페이지__구성__기능
	###################################################################

	//==========================================x=======================
	// FORM__이름
	$config_form_name = "point_match_game_install_form";


	//=================================================================
	// FORM__ACTION
	$form_action_u = get__https_url(piree__admin_url($piree_prog_a[770087]['num'], '__install.update.php'), 'https');

	###################################################################
	# 끝 => 페이지__구성__기능
	###################################################################


?>

	<section>
			<h2>"<?php echo $piree_prog_a[770087]['name'] ?>" 설치하기</h2>

			<form name="<?php echo $page_form_name; ?>" id="<?php echo $page_form_name; ?>" action="<?php echo $form_action_u; ?>" method="post">

			<div class="btn_fixed_top">
					<input type="submit" value="설치하기" class="btn_submit btn">
			</div>

			<div class="local_desc01 local_desc">
					<p>설치하시려면 "<?php echo $piree_prog_a[$sub_menu]['name']; ?> 설치하기" 버튼을 눌러 주세요.</p>
					<p>이 프로그램은 설치하는 테이블이 없어서 "피리 웹프로그램 PLUS" 기본 테이블만 생성합니다.</p>
			</div>

			<div class="tbl_frm01 tbl_wrap">
					<table>
							<caption><?php echo $g5['title']; ?></caption>
							<colgroup>
									<col class="grid_4">
									<col>
							</colgroup>
							<tbody>
									<tr>
											<th scope="row"><label for="sq_subject">기존 테이블 삭제</label></th>
											<td>
													<input type="checkbox" name="is_table_drop" id="sq_subject" value="1"> "<?php echo $piree_prog_a[$sub_menu]['name']; ?>"에 필요한 기존 테이블들을 모두 삭제하고 다시 생성합니다.<br /><br />
													&nbsp; &nbsp; 
													<span style="color:#ff0000; font-weight:bold;">체크하시면 기존 자료가 모두 삭제되니 신중히 생각후 이용해 주세요.</span>
											</td>
									</tr>
							</tbody>
					</table>
			</div>

			</form>

	</section>


<?php

	//=================================================================
	// ADMIN__TAIL
	include_once( G5_ADMIN_PATH .'/admin.tail.php' );

?>