<?php

/*
=====================================================================

	프로젝트 이름 : 피리 경기 예측

	만든사람 : 피리 PIREE

	홈페이지 : www.piree.kr

	p770087 Ver 0.1.0 작업날짜 : 2022년 12월 30일 금요일 오전 10시 58분 - 날씨 맑음, -7.0, 0, -10, 0%, 1.4ms, 9% / 상당히 나쁨, 57, 48

	저 작 권 : Copyright ⓒ 2023 피리 PIREE . All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.kr 에 문의해 주세요.

=====================================================================
 피리 > 관리자 > 피리 경기 예측 PLUS G5 > 경기 관리 > 경기 목록 > 
=====================================================================


*/


	###################################################################
	# 시작 => 선_처리__메뉴_지정__관리자_확인
	###################################################################

	//=================================================================
	// 기본처리_파일__첨부
	include_once('./_common.php');


	//=================================================================
	// 시작 => 회원_아니면
	IF ( !$is_member )
	{
			alert('회원만 이용하실 수 있습니다.', G5_DOMAIN);
	}
	// 끝 => 회원_아니면
	//=================================================================


	//=================================================================
	// 시작 => 관리자__아니면
	IF ( !$is_admin )
	{
			alert('접근할 권한이 없습니다.', G5_DOMAIN);
	}
	// 끝 => 관리자__아니면
	//=================================================================


	//=================================================================
	// 관리자_권한_확인
	auth_check($auth[$piree_prog_a[770087]['num']], 'r');

	###################################################################
	# 끝 => 선_처리__메뉴_지정__관리자_확인
	###################################################################



	###################################################################
	# 시작 => 피리_경기_예측__설정_정보_파일__첨부
	###################################################################

	//=================================================================
	// 기본_설정_첨부__여부
	// 0 - 안해
	// 1 - 하자
	$get__p770000_conf = 1;


	//=================================================================
	// 설정_정보__가져오기
	$get__p770087 = 1;


	//=================================================================
	// 설정_화면__여부
	$prog_config_page = 0;


	//=================================================================
	// 피리_경기_예측__설정_정보_파일__첨부
	include_once( piree__path($piree_prog_a[770087]['num'], 'config') );

	###################################################################
	# 끝 => 피리_경기_예측__설정_정보_파일__첨부
	###################################################################



	###################################################################
	# 시작 => 필요한__라이브러리_파일__첨부
	###################################################################

	//=================================================================
	// FORM__관련_파일__첨부
	include_once( piree__path($piree_prog_a[770000]['num'], 'form.lib.php', 0) );

	###################################################################
	# 끝 => 필요한__라이브러리_파일__첨부
	###################################################################



	###################################################################
	# 시작 => 상수__변수__배열
	###################################################################

	//=================================================================
	// 경기_목록_보임_수
	$match_view_t = 0;


	//=================================================================
	// 경기_목록_배열
	$match_list_a = array();


	//=================================================================
	// 페이지_분할__링크
	$page_navi = '';

	###################################################################
	# 끝 => 상수__변수__배열
	###################################################################



	###################################################################
	# 시작 => 경기_정보__보기
	###################################################################

	//=================================================================
	// 시작 => 선택된__경기_번호__있으면
	IF ( $match_n > 0 )
	{

			//=============================================================
			// 경기_ROW__가져오기
			$match_a = match_row_get($match_n);


			//=============================================================
			// 시작 => 경기_ROW__없으면
			IF ( $match_n != $match_a['mpml_row_n'] )
			{

					//=========================================================
					// 선택된__경기_번호
					$match_n = 0;

			}
			// 끝 => 경기_ROW__없으면
			//=============================================================


			//=============================================================
			// 팀_득표_결과__상태_구분
			// before
			// after.result.ok
			// after.result.no
			$match_staus_c = '';


			//=============================================================
			// 시작 => 경기_경기__시작_여부
			IF ( $match_a['mpml_start_time_n'] > G5_SERVER_TIME )
			{

					//=========================================================
					// 팀_득표_결과__상태_구분
					$match_staus_c = 'before';

			}
			ELSE
			{

					//=========================================================
					// 시작 => 경기_결과__유무
					IF ( $match_a['mpml_win_team_n'] > 0 && $match_a['mpml_win_team_s'] )
					{

							//=====================================================
							// 팀_득표_결과__상태_구분
							$match_staus_c = 'after.result.ok';

					}
					else
					{

							//=====================================================
							// 팀_득표_결과__상태_구분
							$match_staus_c = 'after.result.no';

					}
					// 끝 => 경기_결과__유무
					//=========================================================

			}
			// 끝 => 경기_경기__시작_여부
			//=============================================================

	}
	// 끝 => 선택된__경기_번호__있으면
	//=================================================================

	###################################################################
	# 끝 => 경기_정보__보기
	###################################################################



	###################################################################
	# 시작 => 경기__불러오기
	###################################################################

	//=================================================================
	// 경기__전체_수__파악하기
	$sql_select = "SELECT COUNT(*) FROM `". $piree['p770087_match_list'] ."`";
	$match_t = (int)sql_efv($sql_select);


	//=================================================================
	// 시작 => 경기_자료__있으면
	IF ( $match_t > 0 )
	{

			###############################################################
			# 시작 => 페이지__분할
			###############################################################

			//=============================================================
			// 시작 => 페이지_없으면__1_페이지
			IF ( !$page || $page < 1 )
			{
					$page = 1;
			}
			// 끝 => 페이지_없으면__1_페이지
			//=============================================================


			//=============================================================
			// 목록_SCALE
			$list_scale_n = 20;


			//=============================================================
			// 전체_페이지_계산
			$total_page = ceil($font_all_t/$list_scale_n);
			$from_record = ($page - 1) * $list_scale_n;


			//=============================================================
			// 게시글__링크
			$this_page_link = "font.list.php?";


			//=============================================================
			// 페이지_분할__링크
			$page_navi = get_paging(10, $page, $total_page, $this_page_link);

			###############################################################
			# 끝 => 페이지__분할
			###############################################################



			###############################################################
			# 시작 => 경기_목록__가져오기
			###############################################################

			//=============================================================
			// 경기_목록__가져오기
			$sql_select  = "SELECT * FROM `". $piree['p770087_match_list'] ."` ";
			$sql_select .= "ORDER BY `mpml_row_n` DESC LIMIT ". $from_record .", ". $list_scale_n;
			$result = sql_query($sql_select);


			//=============================================================
			// 시작 => 반복문____경기_목록_ROW_수__만큼
			WHILE ( $res = sql_fetch_array($result) )
			{

					//=========================================================
					// 경기_목록_ROW_번호
					$loop_row_n = (int)$res['mpml_row_n'];


					//=========================================================
					// 경기_목록_배열
					$match_list_a[$loop_row_n] = $res;


					//=========================================================
					// 경기_목록_보이는_수
					$match_view_t++;

			}
			// 끝 => 반복문____경기_목록_ROW_수__만큼
			//=============================================================

			###############################################################
			# 끝 => 경기_목록__가져오기
			###############################################################

	}
	// 끝 => 경기_자료__있으면
	//=================================================================

	###################################################################
	# 끝 => 경기__불러오기
	###################################################################



	###################################################################
	# 시작 => 화면_ECHO
	###################################################################

	//=================================================================
	// 타이틀
	$g5['title'] = "경기 목록 :: ". $piree_prog_a[$sub_menu]['name'] ." Ver ". $piree_prog_a[$sub_menu]['version_s'];


	//=================================================================
	// HEAD__첨부
	include_once( G5_ADMIN_PATH .'/admin.head.php' );


	//=================================================================
	// 상단__메뉴_코드
	$top_menu = 'match.list';


	//=================================================================
	// 상단__메뉴_파일
	include_once( piree__admin_path($sub_menu, 'top.menu.inc.php') );


	//=================================================================
	// 경기_목록__결과_입력__FORM__ACTION
	$form_action__match_result_u = get__https_url(piree__admin_url($piree_prog_a[770087]['num'], 'match.result.update.php'), 'https');


	//=================================================================
	// 경기_목록__FORM__ACTION
	$form_action__match_list_u = get__https_url(piree__admin_url($piree_prog_a[770087]['num'], 'match.list.update.php'), 'https');

	###################################################################
	# 끝 => 화면_ECHO
	###################################################################



	//=================================================================
	// 시작 => 선택된__경기_번호__있으면
	IF ( $match_n > 0 )
	{
?>
			<section id="match_view_sec" style="margin-bottom:30px; border:5px solid #efefef; padding:0 15px 15px 15px;">

					<h2 class="h2_frm">경기 정보 보기</h2>

					<div class="tbl_frm01 tbl_wrap">
							<table>
					    <caption>경기 정보 보기</caption>
					    <colgroup>
									<col class="grid_4">
									<col>
									<col class="grid_3">
					    </colgroup>
					    <tbody>

					    <tr>
									<th scope="row"><label for="">경기 번호</label></th>
									<td>
											<?php echo $match_a['mpml_row_n']; ?>
									</td>
					    </tr>

					    <tr>
									<th scope="row"><label for="">등록회원</label></th>
									<td>
											<?php echo $match_a['mpml_mb_id']; ?>
									</td>
					    </tr>

					    <tr>
									<th scope="row">경기 이름</th>
									<td>
											<span class="str_4466ff_bold_11"><?php echo get__str($match_a['mpml_match_s'], 0, 1, 1, 0, 0); ?></span>
									</td>
					    </tr>

					    <tr>
									<th scope="row">경기 일시</th>
									<td>
											<?php echo date('Y년 m월 d일 H시 i분', $match_a['mpml_start_time_n']); ?>
									</td>
					    </tr>

					    <tr>
									<th scope="row">팀 / 승부</th>
									<td>

											<form method="post" name="match_result_input" id="match_result_input" action="<?php echo $form_action__match_result_u; ?>" onsubmit="return match_result_input_submit(this);">
											<input type="hidden" name="match_n" value="<?php echo $match_n; ?>">
											<input type="hidden" name="page" value="<?php echo $page; ?>">

											<table>
											<caption>팀 / 승부</caption>
											<colgroup>
													<col class="td_left_500">
													<col class="td_right_80">
											</colgroup>
											<tbody>

<?php

							//=====================================================
							// 시작 => 팀_득표_결과__상태_구분
							SWITCH ( $match_staus_c )
							{

									###################################################
									# 시작 => 경기_시작_전
									###################################################
									CASE 'before' :
?>
											<tr>
													<th>팀</th>
													<th>예측 표</th>
											</tr>
											<tr>
													<td>
															<span class="str_3334dd_bold_11"><?php echo $match_a['mpml_team_1_s']; ?></span> 
													</td>
													<td class="td_right">
															<span class="font_222_12"><?php echo $match_a['mpml_team_1_win_t']; ?></span> <span class="font_999">표</span>
													</td>
											</tr>
											<tr>
													<td>
															<span class="str_777_bold_11"><?php echo $match_a['mpml_team_2_s']; ?></span> 
													</td>
													<td class="td_right">
															<span class="font_222_12"><?php echo $match_a['mpml_team_2_win_t']; ?></span> <span class="font_999">표</span>
													</td>
											</tr>
											<tr>
													<td>
															<span class="str_37b44a_bold_11">무승부</span> 
													</td>
													<td class="td_right">
															<span class="font_222_12"><?php echo $match_a['mpml_team_tie_t']; ?></span> <span class="font_999">표</span>
													</td>
											</tr>
<?php
									BREAK;
									###################################################
									# 시작 => 경기_시작_전
									###################################################



									###################################################
									# 시작 => 경기_시작_후__경기_결과_입력_전
									###################################################
									CASE 'after.result.no' :
?>
											<tr>
													<th>팀 / 경기 결과 입력</th>
													<th>예측 표</th>
											</tr>
											<tr>
													<td>
															<input type="radio" name="match_result_choice_n" id="match_result_choice_1_n" value="1"> 
															<label for="match_result_choice_1_n" class="str_3334dd_bold_11"><?php echo $match_a['mpml_team_1_s']; ?></label> 
															<label for="match_result_choice_1_n" class="font_444_10">이(가) 승리 했습니다.</label>
													</td>
													<td class="td_right">
															<span class="font_222_12"><?php echo $match_a['mpml_team_1_win_t']; ?></span> <span class="font_999">표</span>
													</td>
											</tr>
											<tr>
													<td>
															<input type="radio" name="match_result_choice_n" id="match_result_choice_2_n" value="2">
															<label for="match_result_choice_2_n" class="str_777_bold_11"><?php echo $match_a['mpml_team_2_s']; ?></label> 
															<label for="match_result_choice_2_n" class="font_444_10">이(가) 승리 했습니다.</label>
													</td>
													<td class="td_right">
															<span class="font_222_12"><?php echo $match_a['mpml_team_2_win_t']; ?></span> <span class="font_999">표</span>
													</td>
											</tr>
											<tr>
													<td>
															<input type="radio" name="match_result_choice_n" id="match_result_choice_99_n" value="99"> 
															<label for="match_result_choice_99_n" class="str_37b44a_bold_11">무승부</label> 
															<label for="match_result_choice_99_n" class="font_444_10">였습니다.</label>
													</td>
													<td class="td_right">
															<span class="font_222_12"><?php echo $match_a['mpml_team_tie_t']; ?></span> <span class="font_999">표</span>
													</td>
											</tr>
											<tr>
													<td>
															<span class="font_777">한번 결과를 입력하면 수정할수 없으니 신중히 입력해 주세요.</span>
													</td>
													<td class="td_right">
															<input type="submit" name="act_button" value="경기 결과 입력" class="btn_submit btn" onclick="document.pressed=this.value">
													</td>
											</tr>
<?php
									BREAK;
									###################################################
									# 시작 => 경기_시작_후__경기_결과_입력_전
									###################################################



									###################################################
									# 시작 => 경기_시작_후__경기_결과_입력_후
									###################################################
									CASE 'after.result.ok' :

?>
											<tr>
													<th>팀 / 경기 결과</th>
													<th>예측 표</th>
											</tr>
											<tr>
													<td><?php

													IF ( $match_a['mpml_win_team_n'] == 1 )
													{
?>
															<span class="str_3334dd_bold_11" style="font-size:20pt !important;"><?php echo $match_a['mpml_team_1_s']; ?></span> 
															<span class="font_444_10">이(가) 승리 했습니다.</span>
<?php
													}
													ELSE
													{
?>
															<span class="str_3334dd_bold_11"><?php echo $match_a['mpml_team_1_s']; ?></span> 
<?php
													}

													?></td>
													<td class="td_right">
															<span class="font_222_12"><?php echo $match_a['mpml_team_1_win_t']; ?></span> <span class="font_999">표</span>
													</td>
											</tr>
											<tr>
													<td><?php

													IF ( $match_a['mpml_win_team_n'] == 2 )
													{
?>
															<span class="str_37b44a_bold_11" style="font-size:20pt !important;"><?php echo $match_a['mpml_team_2_s']; ?></span> 
															<span class="font_444_10">이(가) 승리 했습니다.</span>
<?php
													}
													ELSE
													{
?>
															<span class="str_37b44a_bold_11"><?php echo $match_a['mpml_team_2_s']; ?></span> 
<?php
													}

													?></td>
													<td class="td_right">
															<span class="font_222_12"><?php echo $match_a['mpml_team_2_win_t']; ?></span> <span class="font_999">표</span>
													</td>
											</tr>
											<tr>
													<td><?php

													IF ( $match_a['mpml_win_team_n'] == 99 )
													{
?>
															<span class="str_777_bold_11" style="font-size:20pt !important;">무승부</span> 
															<span class="font_444_10">였습니다.</span>
<?php
													}
													ELSE
													{
?>
															<span class="str_777_bold_11">무승부</span> 
<?php
													}

													?></td>
													<td class="td_right">
															<span class="font_222_12"><?php echo $match_a['mpml_team_tie_t']; ?></span> <span class="font_999">표</span>
													</td>
											</tr>
<?php
									BREAK;
									###################################################
									# 시작 => 경기_시작_후__경기_결과_입력_후
									###################################################

							}
							// 끝 => 팀_득표_결과__상태_구분
							//=====================================================

?>
											</table>

											</form>

									</td>
					    </tr>
							</table>

					</div>

			</section>

<?php
	}
	// 끝 => 선택된__경기_번호__있으면
	//=================================================================

?>


	<section id="match_list" style="margin-bottom:30px;">
			<h2>경기 목록</h2>

			<form method="post" name="match_list_form" id="match_list_form" action="<?php echo $form_action__match_list_u; ?>" onsubmit="return match_list_submit();">
			<input type="hidden" name="match_n" value="<?php echo $match_n; ?>">
			<input type="hidden" name="page" value="<?php echo $page; ?>">

			<div class="tbl_head01 tbl_wrap">
					<table>
					<caption>경기 목록</caption>
							<thead>
							<tr>
								<th scope="col">
								    <label for="chkall" class="sound_only">경기 목록 전체</label>
								    <input type="checkbox" name="chkall" value="1" id="chkall" onclick="check_all(this.form)">
								</th>
								<th scope="col">번호</th>
								<th scope="col">경기 이름</th>
								<th scope="col">경기 일시</th>
								<th scope="col">팀 1 승</th>
								<th scope="col">무승부</th>
								<th scope="col">팀 2 승</th>
								<th scope="col">등록일시<br>등록 IP</th>
							</tr>
					</thead>
					<tbody>

<?php

			//=============================================================
			// 시작 => 경기__유무
			IF ( $match_t > 0 )
			{

					###########################################################
					# 시작 => 경기__있으면
					###########################################################

					//=========================================================
					// 반복문__순서
					$loop_n = 0;


					//=========================================================
					// 시작 => 반복문__돌리기
					WHILE( list($key, $val) = each($match_list_a))
					{

							//=====================================================
							// TR_바탕색
							$bg = 'bg'.($loop_n%2);


							//=====================================================
							// 경기__번호
							$loop_match_n = (int)$val['mpml_row_n'];


							//=====================================================
							// 경기_URL
							$match_url = "match.list.php?match_n=". $loop_match_n ."&page=". $page;


							//=====================================================
							// 선택된__경기__표시
							$loop_this_view_icon_s = '';


							//=====================================================
							// 경기_경기_번호__CLASS
							$loop_match_num_class_c = 'font_222';


							//=====================================================
							// 경기_경기_이름__CLASS
							$loop_match_name_class_c = 'str_4466ff_bold_11';


							//=====================================================
							// 시작 => 경기_결과__있으면
							IF ( $match_n == $loop_match_n )
							{

									//=================================================
									// 선택된__경기__표시
									$loop_this_view_icon_s = '▶▶ ';


									//=================================================
									// 경기_경기_번호__CLASS
									$loop_match_num_class_c = 'str_ff3333_bold_10';


									//=================================================
									// 경기_경기_이름__CLASS
									$loop_match_name_class_c = 'str_ff3333_bold_13';

							}
							// 끝 => 경기_결과__있으면
							//=====================================================


							//=====================================================
							// 폰트_클래스
							$loop_font_class_1_s  = 'font_3334dd';
							$loop_font_class_2_s  = 'font_37b44a';
							$loop_font_class_99_s = 'font_777';


							//=====================================================
							// 스트라이크_줄
							$loop_strike_1_f_s   = '';
							$loop_strike_1_r_s   = '';
							$loop_strike_2_f_s   = '';
							$loop_strike_2_r_s   = '';
							$loop_strike_99_f_s  = '';
							$loop_strike_99_r_s  = '';


							//=====================================================
							// 굵게_여부
							$loop_span_1_f_s  = '';
							$loop_span_1_r_s  = '';
							$loop_span_2_f_s  = '';
							$loop_span_2_r_s  = '';
							$loop_span_99_f_s = '';
							$loop_span_99_r_s = '';


							//=====================================================
							// 시작 => 경기_결과__있으면
							IF ( $val['mpml_win_team_n'] == 1 || $val['mpml_win_team_n'] == 2 || $val['mpml_win_team_n'] == 99 )
							{

									//=================================================
									// 시작 => 경기_결과__구분
									SWITCH ( $val['mpml_win_team_n'] )
									{
											CASE 1 :
													$loop_font_class_1_s   = 'str_3334dd_bold_11';
													$loop_strike_1_f_s     = '';
													$loop_strike_1_r_s     = ' (승)';
													$loop_strike_2_f_s     = '<strike>';
													$loop_strike_2_r_s     = ' (패)</strike>';
													$loop_strike_99_f_s    = '<strike>';
													$loop_strike_99_r_s    = '</strike>';
													$loop_span_1_f_s       = '<span class="str_222_bold_11">';
													$loop_span_1_r_s       = '</span>';
											BREAK;

											CASE 2 :
													$loop_font_class_2_s   = 'str_37b44a_bold_11';
													$loop_strike_1_f_s     = '<strike>';
													$loop_strike_1_r_s     = ' (패)</strike>';
													$loop_strike_2_f_s     = '';
													$loop_strike_2_r_s     = ' (승)';
													$loop_strike_99_f_s    = '<strike>';
													$loop_strike_99_r_s    = '</strike>';
													$loop_span_2_f_s       = '<span class="str_222_bold_11">';
													$loop_span_2_r_s       = '</span>';
											BREAK;

											CASE 99 :
													$loop_font_class_99_s  = 'str_777_bold_11';
													$loop_strike_1_f_s     = '<strike>';
													$loop_strike_1_r_s     = '</strike>';
													$loop_strike_2_f_s     = '<strike>';
													$loop_strike_2_r_s     = '</strike>';
													// $loop_strike_99_f_s   = '<strike>';
													// $loop_strike_99_r_s   = '</strike>';
													$loop_span_99_f_s      = '<span class="str_222_bold_11">';
													$loop_span_99_r_s      = '</span>';
											BREAK;

									}
									// 끝 => 경기_결과__구분
									//=================================================

							}
							// 끝 => 경기_결과__있으면
							//=====================================================

?>
							<tr class="<?php echo $bg; ?>">
									<td rowspan="2" class="td_center_40">
											<label for="chk_<?php echo $loop_match_n; ?>" class="sound_only"><?php echo get__str($val['mpml_match_s'], 0, 1, 1, 0, 0); ?></label>
											<input type="checkbox" name="chk[]" value="<?php echo $loop_match_n ?>" id="chk_<?php echo $loop_match_n ?>">
									</td>
									<td rowspan="2" class="td_right_60"><span class="<?php echo $loop_match_num_class_c; ?>"><?php echo $loop_match_n ?></span></td>
									<td rowspan="2" class="td_left">
											<p><a href="<?php echo $match_url; ?>" class="<?php echo $loop_match_name_class_c; ?>"><?php echo $loop_this_view_icon_s . get__str($val['mpml_match_s'], 0, 1, 1, 0, 0); ?></a></p>
<?php

									//=================================================
									// 시작 => 경기_경기__시작_여부
									IF ( $val['mpml_start_time_n'] > G5_SERVER_TIME )
									{
?>
											<p><span class="font_777">아직 [ 경기 ]가 시작되지 않았습니다.</span></p>
<?php
									}
									// 끝 => 경기_경기__시작_여부
									//=================================================

?>
											<p></p>
									</td>
									<td rowspan="2" class="td_center_120">
											<?php echo date('Y-m-d H:i', $val['mpml_start_time_n']); ?>
									</td>
									<td class="td_center_120">
											<span class="<?php echo $loop_font_class_1_s; ?>"><?php echo $loop_strike_1_f_s . get__str($val['mpml_team_1_s'], 0, 1, 1, 0, 0) . $loop_strike_1_r_s; ?></span>
									</td>
									<td class="td_center_80">
											<span class="<?php echo $loop_font_class_99_s; ?>"><?php echo $loop_strike_99_f_s; ?>무승부<?php echo $loop_strike_99_r_s; ?></span>
									</td>
									<td class="td_center_120">
											<span class="<?php echo $loop_font_class_2_s; ?>"><?php echo $loop_strike_2_f_s . get__str($val['mpml_team_2_s'], 0, 1, 1, 0, 0) . $loop_strike_2_r_s; ?></span>
									</td>
									<td class="td_center_120">
											<?php echo date('Y-m-d H:i', $val['mpml_regi_time_n']); ?>
									</td>
							</tr>

							<tr class="<?php echo $bg; ?>">
									<td class="td_center">
											<?php echo $loop_span_1_f_s . number_format($val['mpml_team_1_win_t']) . $loop_span_1_r_s ?>
									</td>
									<td class="td_center">
											<?php echo $loop_span_99_f_s . number_format($val['mpml_team_tie_t']) . $loop_span_99_r_s ?>
									</td>
									<td class="td_center">
											<?php echo $loop_span_2_f_s . number_format($val['mpml_team_2_win_t']) . $loop_span_2_r_s ?>
									</td>
									<td class="td_center">
											<span class="font_999"><?php echo $val['mpml_regi_ip'] ?></span>
									</td>
							</tr>

<?php

							//=====================================================
							// 반복문__증가
							$loop_n++;

					}
					// 끝 => 반복문__돌리기
					//=========================================================

					###########################################################
					# 끝 => 경기__있으면
					###########################################################

			}
			ELSE
			{

					###########################################################
					# 시작 => 경기__없으면
					###########################################################

?>
							<tr>
								<td colspan="10" align="center" class="empty_table">
									<strong>등록된 [ 경기 / 경기 목록 ] 이 없습니다.</strong>
								</td>
							</tr>

<?php

					###########################################################
					# 끝 => 경기__없으면
					###########################################################

			}
			// 끝 => 경기__유무
			//=============================================================

?>

							</tbody>
					</table>
			</div>

			<div class="btn_fixed_top">
					<input type="submit" name="act_button" value="경기 삭제" class="btn_submit btn" onclick="document.pressed=this.value">
			</div>

			</form>

			<?php echo $page_navi; ?>

	</section>


	<script>

<?php

	//=================================================================
	// 시작 => 경기_경기__시작_여부
	IF ( $match_a['mpml_start_time_n'] > G5_SERVER_TIME )
	{
?>
			function match_result_input_submit(gform)
			{

					if ( gform.match_result_choice_n.value != 1 && gform.match_result_choice_n.value != 2 && gform.match_result_choice_n.value != 99 )
					{
							alert("[ 경기 결과 ]를 올바르게 입력해 주세요.");
							gform.match_result_choice_n[0].focus();
							return false;
					}

					return true;

			}

<?php
	}
	// 끝 => 경기_경기__시작_여부
	//=================================================================

?>


	function match_list_submit()
	{

		  if (!is_checked("chk[]"))
		  {
		        alert("[ "+ document.pressed +" ] 하실 항목을 하나 이상 선택하세요.");
		        return false;
		  }

		  return true;

	}

	</script>




<?php

	//=================================================================
	// ADMIN_TAIL__첨부
	include_once( G5_ADMIN_PATH .'/admin.tail.php' );

?>