﻿<?php

/*
=====================================================================

	프로젝트 이름 : 피리 경기 예측

	만든사람 : 피리 PIREE

	홈페이지 : www.piree.kr

	p770087 Ver 0.1.0 작업날짜 : 2023년 01월 10일 화요일 오후 23시 52분 - 날씨 맑음, -1.4, 5, -6, 20%, 0.7ms, 5% / 상당히 나쁨, 58, 45

	저 작 권 : Copyright ⓒ 2023 피리 PIREE . All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.kr 에 문의해 주세요.

=====================================================================
 피리 > 관리자 > 피리 경기 예측 PLUS G5 > 경기 관리 > 경기 등록 > 입력하기 > 폼
=====================================================================


*/


	###################################################################
	# 시작 => 선_처리__메뉴_지정__관리자_확인
	###################################################################

	//=================================================================
	// 기본처리_파일__첨부
	include_once('./_common.php');


	//=================================================================
	// 시작 => 회원_아니면
	IF ( !$is_member )
	{
			alert('회원만 이용하실 수 있습니다.', G5_DOMAIN);
	}
	// 끝 => 회원_아니면
	//=================================================================


	//=================================================================
	// 시작 => 관리자__아니면
	IF ( !$is_admin )
	{
			alert('접근할 권한이 없습니다.', G5_DOMAIN);
	}
	// 끝 => 관리자__아니면
	//=================================================================


	//=================================================================
	// 관리자_권한_확인
	auth_check($auth[$piree_prog_a[770087]['num']], 'w');

	###################################################################
	# 끝 => 선_처리__메뉴_지정__관리자_확인
	###################################################################



	###################################################################
	# 시작 => 피리_경기_예측__설정_정보_파일__첨부
	###################################################################

	//=================================================================
	// 기본_설정_첨부__여부
	// 0 - 안해
	// 1 - 하자
	$get__p770000_conf = 1;


	//=================================================================
	// 설정_정보__가져오기
	$get__p770087 = 1;


	//=================================================================
	// 설정_화면__여부
	$prog_config_page = 0;


	//=================================================================
	// 피리_경기_예측__설정_정보_파일__첨부
	include_once( piree__path($piree_prog_a[770087]['num'], 'config') );

	###################################################################
	# 끝 => 피리_경기_예측__설정_정보_파일__첨부
	###################################################################



	###################################################################
	# 시작 => 필요한__라이브러리_파일__첨부
	###################################################################

	//=================================================================
	// FORM__관련_파일__첨부
	include_once( piree__path($piree_prog_a[770000]['num'], 'form.lib.php', 0) );

	###################################################################
	# 끝 => 필요한__라이브러리_파일__첨부
	###################################################################



	###################################################################
	# 시작 => 상수__변수__배열
	###################################################################

	//=================================================================
	// 


	//=================================================================
	// 

	###################################################################
	# 끝 => 상수__변수__배열
	###################################################################



	###################################################################
	# 시작 => 수정__이면
	###################################################################

	//=================================================================
	// 시작 => 경기_번호__있으면
	IF ( $match_n > 0 )
	{

			//=============================================================
			// 경기_ROW__가져오기
			$sql_select = "SELECT * FROM `". $piree['p770087_match_list'] ."` WHERE `mpml_row_n` = '". $match_n ."'";
			$match_row_a = sql_fetch($sql_select);


			//=============================================================
			// 시작 => 경기_ROW__없으면
			IF ( $match_n != $match_row_a['mpml_row_n'] )
			{
					// 에러
					alert("경기 정보가 없습니다.");
			}
			// 끝 => 경기_ROW__없으면
			//=============================================================


			//=============================================================
			// 경기_이름
			$var_match_s = $match_row_a['mpml_match_s'];


			//=============================================================
			// 팀 1
			$var_team_1_s = $match_row_a['mpml_team_1_s'];


			//=============================================================
			// 팀 1
			$var_team_2_s = $match_row_a['mpml_team_2_s'];

	}
	// 끝 => 경기_번호__있으면
	//=================================================================

	###################################################################
	# 끝 => 수정__이면
	###################################################################



	###################################################################
	# 시작 => 화면_ECHO
	###################################################################

	//=================================================================
	// 타이틀
	$g5['title'] = "경기 입력/수정";


	//=================================================================
	// HEAD__첨부
	include_once( G5_ADMIN_PATH .'/admin.head.php' );


	//=================================================================
	// 상단__메뉴_코드
	$top_menu = 'match.regist.form';


	//=================================================================
	// 상단__메뉴_파일
	include_once( piree__admin_path($sub_menu, 'top.menu.inc.php') );


	//=================================================================
	// ADD_STYLESHEET ('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
	add_stylesheet('<link rel="stylesheet" href="'. $p770087__file_url_css . $est_css_file_s .'">', 80);


	//=================================================================
	// add_javascript('<script src="//ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js"></script>', 71);
	add_javascript('<script src="//mugifly.github.io/jquery-simple-datetimepicker/jquery.simple-dtpicker.js"></script>', 72);
	add_stylesheet('<link rel="stylesheet" href="//mugifly.github.io/jquery-simple-datetimepicker/jquery.simple-dtpicker.css">', 82);


	//=================================================================
	// 경기_등록__FORM__ACTION
	$form_action__match_regist_u = get__https_url(piree__admin_url($piree_prog_a[770087]['num'], 'match.regist.update.php'), 'https');

	###################################################################
	# 끝 => 화면_ECHO
	###################################################################


?>

	<section>
			<h2><?php echo $g5['title']; ?></h2>

			<form method="post" name="match_add__form" id="match_add__form" action="<?php echo $form_action__match_regist_u; ?>" onsubmit="return submit__match_add(this);">
			<input type="hidden" name="match_n" value="<?php echo $match_n; ?>">
			<input type="hidden" name="page"   value="<?php echo $page; ?>">

			<div class="tbl_frm01 tbl_wrap">
					<table>
					<tbody>

<?php

			//=============================================================
			// 시작 => 번호__있으면
			IF ( $match_n > 0 )
			{
?>
					<tr>
							<th scope="row" style="width:120px !important">번호</th>
							<td class="line_h_2_2">
									<?php echo $match_n; ?>
							</td>
					</tr>
<?php
			}
			// 끝 => 번호__있으면
			//=============================================================


			//=============================================================
			// 시작 => 등록인_아이디__있으면
			IF ( $match_row_a['mpml_mb_id'] )
			{
?>
					<tr>
							<th scope="row" style="width:120px !important">등록인 아이디</th>
							<td class="line_h_2_2">
									<?php echo $match_row_a['mpml_mb_id']; ?>
							</td>
					</tr>
<?php
			}
			// 끝 => 등록인_아이디__있으면
			//=============================================================

?>

					<tr>
							<th scope="row" style="width:120px !important"><label for="match_s">경기 이름<strong class="sound_only">필수입력</strong></label></th>
							<td class="line_h_2_2">
									</p><input type="text" name="match_s" id="match_s" value="<?php echo $match_row_a['mpml_match_s']; ?>" class="frm_input required" required style="width:90%;match-weight:bold;" placeholder="경기 이름">
							</td>
					</tr>

					<tr>
							<th scope="row" style="width:120px !important"><label for="team_1_s">팀 1<strong class="sound_only">필수입력</strong></label></th>
							<td class="line_h_2_2">
									</p><input type="text" name="team_1_s" id="team_1_s" value="<?php echo $match_row_a['mpml_team_1_s']; ?>" class="frm_input required" required style="width:90%;match-weight:bold;" placeholder="팀 1">
							</td>
					</tr>

					<tr>
							<th scope="row" style="width:120px !important"><label for="team_2_s">팀 2<strong class="sound_only">필수입력</strong></label></th>
							<td class="line_h_2_2">
									</p><input type="text" name="team_2_s" id="team_2_s" value="<?php echo $match_row_a['mpml_team_2_s']; ?>" class="frm_input required" required style="width:90%;match-weight:bold;" placeholder="팀 2">
							</td>
					</tr>

					<tr>
							<th scope="row" style="width:120px !important"><label for="match_start_time_d">경기 시작 일시<strong class="sound_only">필수입력</strong></label></th>
							<td class="line_h_2_2">
									</p><input type="text" name="match_start_time_d" id="match_start_time_d" value="" class="frm_input required" required readonly style="width:90%;" placeholder="경기 일시 날짜.시간">
							</td>
					</tr>

<?php

			//=============================================================
			// 시작 => 아이피__있으면
			IF ( $match_row_a['mpml_regi_ip'] )
			{
?>
					<tr>
							<th scope="row" style="width:120px !important"><label for="page_text_s">아이피<strong class="sound_only">필수입력</strong></label></th>
							<td class="line_h_2_2">
									<?php echo $match_row_a['mpml_regi_ip']; ?>
							</td>
					</tr>
<?php
			}
			// 끝 => 아이피__있으면
			//=============================================================


			//=============================================================
			// 시작 => 등록일시__있으면
			IF ( $match_row_a['mpml_regi_time_n'] > 0 )
			{
?>
					<tr>
							<th scope="row" style="width:120px !important"><label for="page_text_s">등록일시<strong class="sound_only">필수입력</strong></label></th>
							<td class="line_h_2_2">
									<?php echo date('Y년 m월 d일 H시 i분 s초', $match_row_a['mpml_regi_time_n']); ?>
							</td>
					</tr>
<?php
			}
			// 끝 => 등록일시__있으면
			//=============================================================

?>

					</tbody>
					</table>
			</div>


			<br />


			<div class="btn_fixed_top">
					<input type="submit" value="  저장 합니다  " class="btn_submi btn btn_01">
					<a href="match.info.form.php" class="btn_frmline">경기 등록</a>
					<a href="match.file.regist.form.php" class="btn_frmline">경기 파일 등록</a>
			</div>

			</form>

	</section>


	<script>

			$(function()
			{
				// 날짜_선택
				$('#match_start_time_d').appendDtpicker({ 'locale':'ko', 'autodateOnStart':false, 'minuteInterval':10 });
			});


			//=============================================================
			// 시작 => 경기_등록__FORM_SUBMIT
			function match_regist_submit(gform)
			{

			    // 시작 => 경기_이름
			    if( !gform.match_s.value )
			    {
			    		alert("[ 경기 이름 ] 를 입력해 주세요.");
			    		gform.match_s.focus();
			    		return false;
			    }

			    return true;

			}
			// 끝 => 경기_등록__FORM_SUBMIT
			//=============================================================

	</script>




<?php

	//=================================================================
	// ADMIN_TAIL__첨부
	include_once( G5_ADMIN_PATH .'/admin.tail.php' );

?>