<?php

/*
=====================================================================

	프로젝트 이름 : 피리 경기 예측

	만든사람 : 피리 PIREE

	홈페이지 : www.piree.kr

	p770087 Ver 0.1.0 작업날짜 : 2023년 01월 11일 수요일 오전 0시 47분 - 날씨 맑음, -1.9, 6, -5, 10%, 0.2ms, 4% / 상당히 나쁨, 61, 49

	저 작 권 : Copyright ⓒ 2023 피리 PIREE . All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.kr 에 문의해 주세요.

=====================================================================
 피리 > 관리자 > 피리 경기 예측 PLUS G5 > 경기 관리 > 경기 등록 > 입력하기 > 처리하기
=====================================================================


*/


	###################################################################
	# 시작 => 선_처리__메뉴_지정__관리자_확인
	###################################################################

	//=================================================================
	// 기본처리_파일__첨부
	include_once('./_common.php');


	//=================================================================
	// 시작 => 회원_아니면
	IF ( !$is_member )
	{
			alert('회원만 이용하실 수 있습니다.', G5_DOMAIN);
	}
	// 끝 => 회원_아니면
	//=================================================================


	//=================================================================
	// 시작 => 관리자__아니면
	IF ( !$is_admin )
	{
			alert('접근할 권한이 없습니다.', G5_DOMAIN);
	}
	// 끝 => 관리자__아니면
	//=================================================================


	//=================================================================
	// 관리자_권한_확인
	auth_check($auth[$piree_prog_a[770087]['num']], 'w');

	###################################################################
	# 끝 => 선_처리__메뉴_지정__관리자_확인
	###################################################################



	###################################################################
	# 시작 => 피리_경기_예측__설정_정보_파일__첨부
	###################################################################

	//=================================================================
	// 기본_설정_첨부__여부
	// 0 - 안해
	// 1 - 하자
	$get__p770000_conf = 1;


	//=================================================================
	// 설정_정보__가져오기
	$get__p770087 = 1;


	//=================================================================
	// 설정_화면__여부
	$prog_config_page = 0;


	//=================================================================
	// 피리_경기_예측__설정_정보_파일__첨부
	include_once( piree__path($piree_prog_a[770087]['num'], 'config') );

	###################################################################
	# 끝 => 피리_경기_예측__설정_정보_파일__첨부
	###################################################################



	###################################################################
	# 시작 => 상수__변수__배열
	###################################################################

	//=================================================================
	// 


	//=================================================================
	// 

	###################################################################
	# 끝 => 상수__변수__배열
	###################################################################



	###################################################################
	# 시작 => 필요한__라이브러리_파일__첨부
	###################################################################

	//=================================================================
	// 문자열_관련__라이브러리_파일__첨부
	include_once( piree__path($piree_prog_a[770000]['num'], 'save.lib.php', 0) );

	###################################################################
	# 끝 => 필요한__라이브러리_파일__첨부
	###################################################################



	###################################################################
	# 시작 => 검증하기
	###################################################################

	//=================================================================
	// 경기_이름__문자열__다듬기
	$match_s = save__str($match_s);


	//=================================================================
	// 불량_코드_확인
	check__bad_code($match_s,		'경기 타이틀');
	check__bad_code($team_1_s,	'팀 1');
	check__bad_code($team_2_s,	'팀 2');


	//=================================================================
	// 시작 => 경기_타이틀__없으면
	IF ( !$match_s )
	{
			alert("[ 경기 타이틀 ]을 입력해 주세요.");
	}
	// 끝 => 경기_타이틀__없으면
	//=================================================================


	//=================================================================
	// 시작 => 팀_1__없으면
	IF ( !$team_1_s )
	{
			alert("[ 팀 1 ]을 입력해 주세요.");
	}
	// 끝 => 팀_1__없으면
	//=================================================================


	//=================================================================
	// 시작 => 팀_2__없으면
	IF ( !$team_2_s )
	{
			alert("[ 팀 2 ]을 입력해 주세요.");
	}
	// 끝 => 팀_2__없으면
	//=================================================================


	//=================================================================
	// 경기_시작_일시__TIMESTAMP
	$match_start_time_n = strtotime($match_start_time_d);


	//=================================================================
	// 시작 => 경기_타이틀__없으면
	IF ( !$match_start_time_n || $match_start_time_n == 0 )
	{
			alert("[ 경기 시작 일시 ]를 입력해 주세요.");
	}
	// 끝 => 경기_타이틀__없으면
	//=================================================================


	//=================================================================
	// 경기_시작_일시__DATE_Y_m_d_H_i_s_형식으로__변환
	$match_start_time_new_d = date('Y-m-d H:i', $match_start_time_n);


	//=================================================================
	// 시작 => 경기_시작_일시__DATE_형식으로__다르면
	IF ( $match_start_time_d != $match_start_time_new_d )
	{
			alert("[ 경기 시작 일시 ]의 형식을 올바르게 입력해 주세요.");
	}
	// 끝 => 경기_시작_일시__DATE_형식으로__다르면
	//=================================================================

	###################################################################
	# 끝 => 검증하기
	###################################################################



	###################################################################
	# 시작 => 중복_확인__하기
	###################################################################

	//=================================================================
	// 중복_확인__쿼리문
	$sql  = "SELECT COUNT(*) FROM `". $piree['p770087_match'] ."`";
	$sql .= "WHERE `aem_mb_id` = '". $member['mb_id'] ."' AND `aem_match_s` = '". $match_s ."'";
	$exist_t = (int)sql_efv($sql);


	//=================================================================
	// 시작 => 중복이면
	IF ( $exist_t > 0 )
	{
			alert("이미 등록된 [ 경기 타이틀 ]입니다.");
	}
	// 끝 => 중복이면
	//=================================================================

	###################################################################
	# 끝 => 중복_확인__하기
	###################################################################



	###################################################################
	# 시작 => 저장하기
	###################################################################

	//=================================================================
	// 게시글__저장하는__쿼리문
	$sql_insert  = "INSERT INTO `". $piree['p770087_match_list'] ."` SET ";
	$sql_insert .= "`mpml_mb_id`				= '". $member['mb_id'] ."', ";
	$sql_insert .= "`mpml_match_s`			= '". $match_s ."', ";
	$sql_insert .= "`mpml_team_1_s`			= '". $team_1_s ."', ";
	$sql_insert .= "`mpml_team_2_s`			= '". $team_2_s ."', ";
	$sql_insert .= "`mpml_start_time_n`	= '". $match_start_time_n ."', ";
	$sql_insert .= "`mpml_regi_ip`			= '". $_SERVER['REMOTE_ADDR'] ."', ";
	$sql_insert .= "`mpml_regi_time_n`	= '". G5_SERVER_TIME ."'";


	//=================================================================
	// 시작 => 쿼리_실행__실패시
	IF ( !sql_query($sql_insert) )
	{


ECHO $sql_insert;

EXIT;


			alert("[ 경기 ] 정보를 저장하지 못했습니다.");

	}
	// 끝 => 쿼리_실행__실패시
	//=================================================================


	//=================================================================
	// 경기_번호__알아내기
	$match_n = sql_insert_id();

	###################################################################
	# 끝 => 저장하기
	###################################################################



	###################################################################
	# 시작 => 페이지__이동
	###################################################################

	//=================================================================
	// 이동할__페이지
	$go_url_s = 'match.list.php?match_n='. $match_n;


	//=================================================================
	// 페이지__이동
	go_url($go_url_s, 0);

	###################################################################
	# 끝 => 페이지__이동
	###################################################################


?>