<?php

/*
=====================================================================

	프로젝트 이름 : 피리 경기 예측

	만든사람 : 피리 PIREE

	홈페이지 : www.piree.kr

	p770087 Ver 0.1.0 작업날짜 : 2023년 01월 13일 금요일 오후 23시 59분분 - 날씨 맑음, 다소 많은 비, 5.8, 8, -2, 50%, 1.5ms, 23.3mm / 좋음, 14, 9

	저 작 권 : Copyright ⓒ 2023 피리 PIREE . All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.kr 에 문의해 주세요.

=====================================================================
 피리 > 관리자 > 피리 경기 예측 PLUS G5 > 경기 관리 > 경기 목록 > 결과 처리하기
=====================================================================


*/


	###################################################################
	# 시작 => 선_처리__메뉴_지정__관리자_확인
	###################################################################

	//=================================================================
	// 기본처리_파일__첨부
	include_once('./_common.php');


	//=================================================================
	// 시작 => 회원_아니면
	IF ( !$is_member )
	{
			alert('회원만 이용하실 수 있습니다.', G5_DOMAIN);
	}
	// 끝 => 회원_아니면
	//=================================================================


	//=================================================================
	// 시작 => 관리자__아니면
	IF ( !$is_admin )
	{
			alert('접근할 권한이 없습니다.', G5_DOMAIN);
	}
	// 끝 => 관리자__아니면
	//=================================================================


	//=================================================================
	// 관리자_권한_확인
	auth_check($auth[$piree_prog_a[770087]['num']], 'w');


	//=================================================================
	// 관리자_토큰__확인
	check_admin_token();

	###################################################################
	# 끝 => 선_처리__메뉴_지정__관리자_확인
	###################################################################



	###################################################################
	# 시작 => 피리_경기_예측__설정_정보_파일__첨부
	###################################################################

	//=================================================================
	// 기본_설정_첨부__여부
	// 0 - 안해
	// 1 - 하자
	$get__p770000_conf = 1;


	//=================================================================
	// 설정_정보__가져오기
	$get__p770087 = 1;


	//=================================================================
	// 설정_화면__여부
	$prog_config_page = 0;


	//=================================================================
	// 피리_경기_예측__설정_정보_파일__첨부
	include_once( piree__path($piree_prog_a[770087]['num'], 'config') );

	###################################################################
	# 끝 => 피리_경기_예측__설정_정보_파일__첨부
	###################################################################



	###################################################################
	# 시작 => 전달받은_값__확인_및_검증
	###################################################################

	//=================================================================
	// QUERY_STRING
	$match_n								= (int)$_POST['match_n'];
	$page										= (int)$_POST['page'];
	$match_result_choice_n	= (int)$_POST['match_result_choice_n'];


	//=================================================================
	// 시작 => 경기_결과__입력이_올바르지_않으면
	IF ( $match_result_choice_n != 1 && $match_result_choice_n != 2 && $match_result_choice_n != 99 )
	{
			alert("[ 경기 결과 ]를 올바르게 입력해 주세요.");
	}
	// 끝 => 경기_결과__입력이_올바르지_않으면
	//=================================================================

	###################################################################
	# 끝 => 전달받은_값__확인_및_검증
	###################################################################



	###################################################################
	# 시작 => 필요한__라이브러리_파일__첨부
	###################################################################

	//=================================================================
	// 문자열_관련__라이브러리_파일__첨부
	include_once( piree__path($piree_prog_a[770000]['num'], 'save.lib.php', 0) );


	//=================================================================
	// DB_함수_관련__라이브러리_파일__첨부
	include_once( piree__path($piree_prog_a[770000]['num'], 'db.func.lib.php', 0) );

	###################################################################
	# 끝 => 필요한__라이브러리_파일__첨부
	###################################################################



	###################################################################
	# 시작 => 사전__처리
	###################################################################

	//=================================================================
	// 경기_ROW__불러오기
	$sql_select  = "SELECT * FROM `". $piree['p770087_match_list'] ."` ";
	$sql_select .= "WHERE `mpml_row_n` = '". $match_n ."'";
	$match_a = sql_fetch($sql_select);


	//=================================================================
	// 시작 => 경기_ROW__없으면
	IF ( $match_n != $match_a['mpml_row_n'] )
	{
			alert("[ ". $match_n ." 번 ] 경기 정보가 없습니다.");
	}
	// 끝 => 경기_ROW__없으면
	//=================================================================	

	###################################################################
	# 끝 => 사전__처리
	###################################################################



	###################################################################
	# 시작 => 경기_경기__확인
	###################################################################

	//=================================================================
	// 시작 => 경기_ROW__없으면
	IF ( $match_a['mpml_win_team_n'] > 0 || $match_a['mpml_win_team_s'] )
	{
			alert("이미 [ 경기 결과 ]를 입력하셨습니다.");
	}
	// 끝 => 경기_ROW__없으면
	//=================================================================	


	//=================================================================
	// 시작 => 경기_ROW__없으면
	IF ( $match_a['mpml_start_time_n'] >= G5_SERVER_TIME )
	{
			alert("시작되지 않은 [ 경기 ]여서 결과를 입력할수 없습니다.");
	}
	// 끝 => 경기_ROW__없으면
	//=================================================================	

	###################################################################
	# 끝 => 경기_경기__확인
	###################################################################



	###################################################################
	# 시작 => 상수__변수__배열
	###################################################################

	//=================================================================
	// 시작 => 승리팀_또는_무승부__문자열__결정
	SWITCH ( $match_result_choice_n )
	{
			CASE 1 :					$mpml_win_team_s = $match_a['mpml_team_1_s'];					BREAK;
			CASE 2 :					$mpml_win_team_s = $match_a['mpml_team_2_s'];					BREAK;
			CASE 99 :					$mpml_win_team_s = '무승부';													BREAK;
	}
	// 끝 => 승리팀_또는_무승부__문자열__결정
	//=================================================================	

	###################################################################
	# 끝 => 상수__변수__배열
	###################################################################



	###################################################################
	# 시작 => 경기_경기_결과__저장하기
	###################################################################

	//=================================================================
	// 경기_수정하는__쿼리문
	$sql_updateate  = "UPDATE `". $piree['p770087_match_list'] ."` SET ";
	$sql_updateate .= "`mpml_win_team_n`		= '". $match_result_choice_n ."', ";
	$sql_updateate .= "`mpml_win_team_s`		= '". $mpml_win_team_s ."' ";
	$sql_updateate .= "WHERE `mpml_row_n` = '". $match_n ."'";


	//=================================================================
	// 시작 => 쿼리_실행
	IF ( !sql_query($sql_updateate))
	{

			// 에러
			alert("[ ". $match_a['mpml_match_s'] ." ]의 승부를 수정하지 못했습니다.");

	}
	// 끝 => 쿼리_실행
	//=================================================================	

	###################################################################
	# 끝 => 경기_경기_결과__저장하기
	###################################################################



	###################################################################
	# 시작 => 
	###################################################################

	//=================================================================
	// 


	//=================================================================
	// 

	###################################################################
	# 끝 => 
	###################################################################



	###################################################################
	# 시작 => 페이지__이동
	###################################################################

	//=================================================================
	// 이동할__페이지
	$go_url_s = "match.list.php?match_n=". $match_n ."&page=". $page;


	//=================================================================
	// 페이지__이동
	go_url($go_url_s, 0);

	###################################################################
	# 끝 => 페이지__이동
	###################################################################


?>