
<canvas id="canvask" width="235" height="235" style="background-color:gray"></canvas>
    
<script>
var canvask = document.getElementById("canvask");
var ctxk = canvask.getContext("2d");
var radiusk = canvask.height / 2;
ctxk.translate(radiusk, radiusk);
radiusk = radiusk * 0.90
//drawClockk();
setInterval(drawClockk, 1000);    

function drawClockk() {
  drawFacek(ctxk, radiusk);
  drawNumbersk(ctxk, radiusk); 
  drawTimek(ctxk, radiusk);    
}
    
function drawFacek(ctxk, radiusk) {
  var gradk;
  ctxk.beginPath();
  ctxk.arc(0, 0, radiusk, 0, 2*Math.PI);
  ctxk.fillStyle = 'white';
  ctxk.fill();
  gradk = ctxk.createRadialGradient(0,0,radiusk*0.95, 0,0,radiusk*1.05);
  gradk.addColorStop(0, '#333');
  gradk.addColorStop(0.5, 'white');
  gradk.addColorStop(1, '#333');
  ctxk.strokeStyle = gradk;
  ctxk.lineWidth = radiusk*0.1;
  ctxk.stroke();
  ctxk.beginPath();
  ctxk.arc(0, 0, radiusk*0.1, 0, 2*Math.PI);
  ctxk.fillStyle = '#333';
  ctxk.fill();
}  
    
function drawNumbersk(ctxk, radiusk) {
  var angk;
  var numk;
  ctxk.font = radiusk*0.15 + "px arial";
  ctxk.textBaseline="middle";
  ctxk.textAlign="center";
  for(numk = 1; numk < 13; numk++){
    angk = numk * Math.PI / 6;
    ctxk.rotate(angk);
    ctxk.translate(0, -radiusk*0.85);
    ctxk.rotate(-angk);
    ctxk.fillText(numk.toString(), 0, 0);
    ctxk.rotate(angk);
    ctxk.translate(0, radiusk*0.85);
    ctxk.rotate(-angk);
  }
} 
    

function drawTimek(ctxk, radiusk){
    var nowk = new Date();
    var hourk = nowk.getHours();
    var minutek = nowk.getMinutes();
    var secondk = nowk.getSeconds();
    //hour
    hourk=hourk%12;
    hourk=(hourk*Math.PI/6)+
    (minutek*Math.PI/(6*60))+
    (secondk*Math.PI/(360*60));
    drawHandk(ctxk, hourk, radiusk*0.5, radiusk*0.07);
    //minute
    minutek=(minutek*Math.PI/30)+(secondk*Math.PI/(30*60));
    drawHandk(ctxk, minutek, radiusk*0.8, radiusk*0.07);
    // second
    secondk=(secondk*Math.PI/30);
    drawHandk(ctxk, secondk, radiusk*0.9, radiusk*0.02);
}

function drawHandk(ctxk, posk, lengthk, widthk) {
    ctxk.beginPath();
    ctxk.lineWidth = widthk;
    ctxk.lineCap = "round";
    ctxk.moveTo(0,0);
    ctxk.rotate(posk);
    ctxk.lineTo(0, -lengthk);
    ctxk.stroke();
    ctxk.rotate(-posk);
}    
    
</script>

