 
<canvas id="canvasky" width="235" height="235" style="background-color:#ffffff;"></canvas>
    
<script>
var canvasky = document.getElementById("canvasky");
var ctxky = canvasky.getContext("2d");
var radiusky = canvasky.height / 2;
ctxky.translate(radiusky, radiusky);
radiusky = radiusky * 0.90
//drawClockk();
setInterval(drawClockky, 1000);    

function drawClockky() {
  drawFaceky(ctxky, radiusky);
  drawNumbersky(ctxky, radiusky); 
  drawTimeky(ctxky, radiusky);    
}
    
function drawFaceky(ctxky, radiusky) {
  var gradky;
  ctxky.beginPath();
  ctxky.arc(0, 0, radiusky, 0, 2*Math.PI);
  ctxky.fillStyle = '#ffff00'; //시계 내부색 
  ctxky.fill();
  gradky = ctxky.createRadialGradient(0,0,radiusky*0.95, 0,0,radiusky*1.05);
  gradky.addColorStop(0, '#333');//시계바늘 색 및 시계 내부원 색상
  gradky.addColorStop(0.5, '#ffffff'); //시계 외곽원과 내부원 사이 색상 
  gradky.addColorStop(1, '#0d0d0d');//시계 외곽 원 색상
  ctxky.strokeStyle = gradky;
  ctxky.lineWidth = radiusky*0.1;
  ctxky.stroke();
  ctxky.beginPath();
  ctxky.arc(0, 0, radiusky*0.1, 0, 2*Math.PI);
  ctxky.fillStyle = 'black'; //숫자 및 시계 가운데 점 색상
  ctxky.fill();
}  
    
function drawNumbersky(ctxky, radiusky) {
  var angky;
  var numky;
  ctxky.font = radiusky*0.17 + "px arial";// 시계숫자 크기 
  ctxky.textBaseline="middle";
  ctxky.textAlign="center";
  for(numky = 1; numky < 13; numky++){
    angky = numky * Math.PI / 6;
    ctxky.rotate(angky);
    ctxky.translate(0, -radiusky*0.85);
    ctxky.rotate(-angky);
    ctxky.fillText(numky.toString(), 0, 0);
    ctxky.rotate(angky);
    ctxky.translate(0, radiusky*0.85);
    ctxky.rotate(-angky);
  }
} 
    

function drawTimeky(ctxky, radiusky){
    var nowky = new Date();
    var hourky = nowky.getHours();
    var minuteky = nowky.getMinutes();
    var secondky = nowky.getSeconds();
    //hour
    hourky=hourky%12;
    hourky=(hourky*Math.PI/6)+
    (minuteky*Math.PI/(6*60))+
    (secondky*Math.PI/(360*60));
    drawHandky(ctxky, hourky, radiusky*0.5, radiusky*0.07);
    //minute
    minuteky=(minuteky*Math.PI/30)+(secondky*Math.PI/(30*60));
    drawHandky(ctxky, minuteky, radiusky*0.8, radiusky*0.07);
    // second
    secondky=(secondky*Math.PI/30);
    drawHandky(ctxky, secondky, radiusky*0.9, radiusky*0.02);
}

function drawHandky(ctxky, posky, lengthky, widthky) {
    ctxky.beginPath();
    ctxky.lineWidth = widthky;
    ctxky.lineCap = "square"; // 시계바는 끝 모양 round: 궁근 모양, square: 각진 모양 
    ctxky.moveTo(0,0);
    ctxky.rotate(posky);
    ctxky.lineTo(0, -lengthky);
    ctxky.stroke();
    ctxky.rotate(-posky);
}    
    
</script>

