<?php

/*
===========================================================

	프로젝트 이름 : 피리 웹프로그램

	만든사람 : 피리 PIREE

	홈페이지 : http://www.piree.co.kr

	작성날짜 : 2014년 03월 07일 금요일 오전 11시 00분, 날씨 꽃샘추위 위세가 좀 쎄다, 쌀쌀하다

	저 작 권 : Copyright ⓒ 2014-2015 투스포츠 (원병철) All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.co.kr 에 문의해 주세요.

===========================================================
 피리 > 관리자 > 신고하기 PLUS G5 > 처음
===========================================================


회원 신고 받은 회수
회원 신고한 회수
회원 무분별한 신고 회수


블라인드 처리할 신고 건수선택입력
게시글 - 블라인드 여부
댓글 - 블라인드 여부


*/


	#########################################################
	# 시작 => 선_처리__메뉴_지정__관리자_확인
	#########################################################

	//=======================================================
	// 메뉴_번호__지정____신고하기
	$sub_menu = "770006";


	//=======================================================
	// 기본처리_파일__첨부
	include_once('./_common.php');


	//=======================================================
	// 시작 => 회원_여부__확인
	IF ($is_guest || !$is_member)
	{
		alert ("회원만 이용하실 수 있습니다", G5_DOMAIN."/");
		EXIT;
	}
	// 끝 => 회원_여부__확인
	//=======================================================


	//=======================================================
	// 관리자_확인
	auth_check($auth[$sub_menu], 'r');

	#########################################################
	# 끝 => 선_처리
	#########################################################



	#########################################################
	# 시작 => 신고하기__설정_정보_파일__첨부
	#########################################################

	//=======================================================
	// 기본_설정_첨부__여부
	// 0 - 안해
	$is_get__piree_config = 0;


	//=======================================================
	// 신고하기__설정_정보__가져오기
	$is_get__report = 1;


	//=======================================================
	// 신고하기__설정_정보_파일__경로
	$piree_dir_path = PIREE_CONFIG_PATH ."/p__".$sub_menu."/pi__config.php";


	//=======================================================
	// 신고하기__설정_정보_파일__경로
	include_once($piree_dir_path);

	#########################################################
	# 끝 => 신고하기__설정_정보_파일__첨부
	#########################################################



	#########################################################
	# 시작 => 신고하기__설정_정보
	#########################################################

	//=======================================================
	// 스킨
	$rept_cfg__skin_pc_c		 = $report_config['skin_pc_c'];
	$rept_cfg__skin_mobile_c = $report_config['skin_mobile_c'];


	//=======================================================
	// DBNAME_이름
	$rept_cfg__DB_NAME_s = $report_config["DB_NAME_s"];


	//=======================================================
	// 블라인드__처리할__신고_건수
	$rept_cfg__blind_do_t = number_format($report_config["blind_do_t"]);


	//=======================================================
	// 신고_가능한__레벨
	$rept_cfg__report_do_level_n = number_format($report_config["report_do_level_n"]);


	//=======================================================
	// 신고_면제_할__레벨
	$rept_cfg__exemption_level_n = number_format($report_config["exemption_level_n"]);


	//=======================================================
	// 신고_면제_할__가입일수
	$rept_cfg__exemption_day_n = number_format($report_config["exemption_day_n"]);


	//=======================================================
	// 신고_한__회원의_포인트
	$rept_cfg__report_do_point_n = number_format($report_config["report_do_point_n"]);


	//=======================================================
	// 신고_당한__회원의_포인트
	$rept_cfg__report_get_point_n = number_format($report_config["report_get_point_n"]);


	//=======================================================
	// 무분별한__신고시_신고_한__회원의_포인트
	$rept_cfg__report_rash_point_n = number_format($report_config["report_rash_point_n"]);


	//=======================================================
	// 무분별한_신고시__신고_권한__제한
	$rept_cfg__report_rash_auth_n = number_format($report_config["report_rash_auth_n"]);

	#########################################################
	# 끝 => 신고하기__설정_정보
	#########################################################



	#########################################################
	# 시작 => 신고_사유__불러오기
	#########################################################

		#######################################################
		# 시작 => 상수__변수__배열
		#######################################################

		//=====================================================
		// 신고_사유__건수
		$reason_tot = 0;


		//=====================================================
		// 신고_사유__배열
		$reason_arr = array();

		#######################################################
		# 끝 => 상수__변수__배열
		#######################################################



		#######################################################
		# 시작 => 신고_사유__가져오기
		#######################################################

		//=====================================================
		// 신고_사유__가져오는__쿼리문
		$sql = "SELECT COUNT(*) FROM `".$piree_table['report_reason']."`";
		$reason_tot = sql_efv($sql);

		#######################################################
		# 끝 => 신고_사유__가져오기
		#######################################################



		#######################################################
		# 시작 => 신고_사유__불러오기
		#######################################################
		IF ($reason_tot > 0)
		{

			//===================================================
			// 신고하기__설정_정보__불러오기
			$sql		= "SELECT num,subject_s ";
			$sql	 .= "FROM `".$piree_table['report_reason']."` ORDER BY order_n ASC";
			$result = sql_query ($sql);


			//===================================================
			// 시작 => 반복문
			FOR ($i=0; $row=sql_fetch_array($result); $i++)
			{

				//=================================================
				// 신고_사유__번호
				$reason_n = $row['num'];


				//=================================================
				// 신고_사유__배열
				$reason_arr[$reason_n] = stripslashes($row["subject_s"]);

			}
			// 끝 => 반복문
			//===================================================

		}
		#######################################################
		# 끝 => 신고_사유__불러오기
		#######################################################

	#########################################################
	# 끝 => 신고_사유__불러오기
	#########################################################



	#########################################################
	# 시작 => 신고_목록
	#########################################################

		#######################################################
		# 시작 => 상수__변수__배열
		#######################################################

		//=====================================================
		// 신고_목록__건수
		$report_active_s__new = "접수";


		//=====================================================
		// 신고_목록__배열
		$report_list_arr = array();

		#######################################################
		# 끝 => 상수__변수__배열
		#######################################################



		#######################################################
		# 시작 => 신고_목록__가져오기
		#######################################################

		//=====================================================
		// 신고_목록__가져오는__쿼리문
		$sql	 = "SELECT COUNT(*) FROM `".$piree_table['report_list']."` ";
		$sql	.= "WHERE active_s='".$report_active_s__new."'";
		$total = sql_efv($sql);

		#######################################################
		# 끝 => 신고_목록__가져오기
		#######################################################



		#######################################################
		# 시작 => 신고_목록__불러오기
		#######################################################
		IF ($total > 0)
		{

			//===================================================
			// 신고하기__설정_정보__불러오기
			$sql		= "SELECT * FROM `".$piree_table['report_list']."` ";
			$sql	 .= "WHERE active_s='".$report_active_s__new."' ORDER BY regi_time_n DESC LIMIT 10";
			$result = sql_query ($sql);

		}
		#######################################################
		# 끝 => 신고_목록__불러오기
		#######################################################

	#########################################################
	# 끝 => 신고_목록
	#########################################################



	#########################################################
	# 시작 => 화면_ECHO
	#########################################################

	//=======================================================
	// 타이틀
	$g5['title'] = "신고하기 PLUS G5";


	//=======================================================
	// HEAD__첨부
	include_once("../admin.head.php");


	//=======================================================
	// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
	add_stylesheet('<link rel="stylesheet" href="'.G5_ADMIN_URL.'/p770006__report/style.css">', 0);

	#########################################################
	# 끝 => 화면_ECHO
	#########################################################


?>

<section>
		<h2>신고하기 설정 정보</h2>

		<div class="tbl_head01 tbl_wrap">
				<table>
				<caption>피리 신고하기 PLUS G5</caption>
				<thead>
				<tr>
					<th scope="col">PC 스킨</th>
					<th scope="col">모바일 스킨</th>
					<th scope="col">블라인드 기준</th>
					<th scope="col">신고 가능 레벨</th>
					<th scope="col">신고 면제 레벨</th>
					<th scope="col">신고 면제 가입일</th>
					<th scope="col">신고 한 포인트</th>
					<th scope="col">신고 당한 포인트</th>
					<th scope="col">무분별 신고 포인트</th>
					<th scope="col">무분별한 신고 제한</th>
				</tr>
				</thead>
				<tbody>

				<tr>
						<td align="center"><strong><?php echo $rept_cfg__skin_pc_c ?></strong></td>
						<td align="center"><strong><?php echo $rept_cfg__skin_mobile_c ?></strong></td>
						<td align="right"><strong><?php echo $rept_cfg__blind_do_t ?></strong>건 이상</td>
						<td align="right"><strong><?php echo $rept_cfg__report_do_level_n ?></strong></td>
						<td align="right"><strong><?php echo $rept_cfg__exemption_level_n ?></strong></td>
						<td align="right"><strong><?php echo $rept_cfg__exemption_day_n ?></strong></td>
						<td align="right"><strong><?php echo $rept_cfg__report_do_point_n ?></strong></td>
						<td align="right"><strong><?php echo $rept_cfg__report_get_point_n ?></strong></td>
						<td align="right"><strong><?php echo $rept_cfg__report_rash_point_n ?></strong></td>
						<td align="right"><strong><?php echo $rept_cfg__report_rash_auth_n ?></strong></td>
				</tr>

				</tbody>
				</table>
		</div>


		<div class="btn_confirm">
			<input type="button" class="btn_cancel" value=" 설정 정보 수정하기 " onClick="PageUrl('./pi__config.form.php')">
			<input type="button" class="btn_cancel" value=" 신고 사유 관리하기 " onClick="PageUrl('./pi__reason.list.php')">
			<input type="button" class="btn_cancel" value=" 신고 접수 관리하기 " onClick="PageUrl('./pi__reason.list.php')">
		</div>

</section>


<br />
<br />


<section>
		<h2>처리하지 않은 신고 목록 ( 확인후 조치해 주세요 )</h2>


		<div class="tbl_head01 tbl_wrap">
				<table>
				<caption>처리하지 않은 신고 목록</caption>
				<thead>
				<tr>
					<th scope="col">번호</th>
					<th scope="col">신고한 회원</th>
					<th scope="col">신고 받은 회원</th>
					<th scope="col">신고구분</th>
					<th scope="col">신고사유 / 메모</th>
					<th scope="col">신고날짜</th>
				</tr>
				</thead>
				<tbody>

<?php


		//=====================================================
		// 시작 => 신고_목록__유무
		IF ($total > 0)
		{

			#####################################################
			# 시작 => 신고_목록__있으면
			#####################################################

			//===================================================
			// 시작 => 반복문
			FOR ($i=0; $row=sql_fetch_array($result); $i++)
			{

				//=================================================
				// DO_회원
				$in_do_mem_s = get_sideview($row['do_mem_id'], $row["do_mem_nick"]);


				//=================================================
				// GET_회원
				$in_get_mem_s = get_sideview($row['get_mem_id'], $row["get_mem_nick"]);


				//=================================================
				// 신고_사유__번호
				$reason_n = $row["reason_n"];


				//=================================================
				// 신고_사유__제목
				$reason_s = $reason_arr[$reason_n];


				//=================================================
				// 신고_사유__제목
				$title_s = stripslashes($row["title_s"]);


				//=================================================
				// 신고_구분
				$report_prog_arr = get__report_div($row["prog_div_c"], $row['bo_table']);


				//=================================================
				// 신고_링크__가져오기
				$arti_link_s = get_report_row_url('admin_url', $row["prog_div_c"], $row['bo_table'], $row["arti_n"], $row["parent_n"], $row["get_mem_id"]);


				//=================================================
				// 신고일시
				$regi_time_s = date("y.m.d H:i:s", $row["regi_time_n"]);


				//=================================================
				// 내부링크
				$in_link_s = "pi__report.list.php?report_n=".$row['num'];

?>
				<tr>
					<td><?php echo $row['num'] ?></td>
					<td><?php echo $in_do_mem_s ?></td>
					<td><?php echo $in_get_mem_s ?></td>
					<td><a href="<?php echo $arti_link_s ?>" target="_blank"><?php echo $report_prog_arr["prog_s"] ?></a></td>
					<td>
						<span class="font_777">사유</span> <a href="<?php echo $in_link_s ?>"><?php echo $reason_s ?></a>
<?php

					//===============================================
					// 시작 => 메모__있으면
					IF ($row["report_memo_s"])
					{
						// 메모
						$in_report_memo_s = stripslashes($row["report_memo_s"]);
?>
						<br />
						<span class="font_777">메모</span> <a href="<?php echo $in_link_s ?>"><?php echo $in_report_memo_s ?></a>
<?php

					}
					// 끝 => 메모__있으면
					//===============================================

?>
						<br />
						<span class="font_777">제목</span> <a href="<?php echo $arti_link_s ?>" target="_blank"><?php echo $title_s ?></a>
					</td>
					<td><?php echo $regi_time_s ?></td>
				</tr>

<?php
			}
			// 끝 => 반복문
			//===================================================

			#####################################################
			# 끝 => 신고_목록__있으면
			#####################################################

		}
		ELSE
		{

			#####################################################
			# 시작 => 신고_목록__없으면
			#####################################################

?>
				<tr>
					<td colspan="6" align="center"><strong>접수된 신고가 없습니다.</strong></td>
				</tr>

<?php

			#####################################################
			# 끝 => 신고_목록__없으면
			#####################################################

		}
		// 끝 => 신고_목록__유무
		//=====================================================

?>

				</tbody>
				</table>
		</div>


		<div class="btn_confirm">
			<input type="button" class="btn_submit" value=" 신고 목록 " onClick="PageUrl('./pi__report.list.php')">
			<input type="button" class="btn_cancel" value=" 설정 정보 수정하기 " onClick="PageUrl('./pi__config.form.php')">
		</div>

</section>





<?php

	//=======================================================
	// ADMIN_TAIL__첨부
	include_once("../admin.tail.php");

?>