<?php
$sub_menu = '100600';
include_once './_common.php';

$g5['title'] = '그누보드 step2';
include_once '../admin.head.php';

$target_version = isset($_POST['target_version']) ? $_POST['target_version'] : null;
$username       = isset($_POST['username']) ? $_POST['username'] : null;
$userpassword   = isset($_POST['password']) ? $_POST['password'] : null;
$port           = isset($_POST['port']) ? $_POST['port'] : null;

$conn_result = $g5['update']->connect($_SERVER['HTTP_HOST'], $port, $username, $password);
if ($conn_result == false) {
    die("연결에 실패했습니다.");
}

$g5['update']->setTargetVersion($target_version);
if ($g5['update']->target_version == $g5['update']->now_version) {
    die("목표버전이 현재버전과 동일합니다.");
}

$compare_list = $g5['update']->getVersionCompareList();
if ($compare_list == false) {
    die("비교할 원본파일목록이 존재하지 않습니다.");
}

$result = $g5['update']->downloadVersion($target_version);
if ($result == false) {
    die("목표버전 다운로드에 실패했습니다.");
}
?>
<h2 class="h2_frm">버전 업데이트 진행</h2>
<ul class="anchor">
    <li><a href="./">업데이트</a></li>
    <li><a href="./rollback.php">복원</a></li>
    <li><a href="./log.php">로그</a></li>
</ul>

<p style="font-size:15px; font-weight:bold;"><?php echo $g5['update']->target_version; ?> 버전 파일 다운로드 완료</p>
<br>
<?php
$result = $g5['update']->createBackupZipFile();
$update_check['success']    = array();
$update_check['fail']       = array();
if ($result == "success") {
    foreach ($compare_list as $key => $var) {

        $originFilePath = G5_PATH . '/' . $var;
        $changeFilePath = G5_DATA_PATH . '/update/version/' . $target_version . '/' . $var;

        if (!file_exists($changeFilePath) && file_exists($originFilePath)) { // 업데이트파일은 존재하지않지만 현재파일은 존재할때
            $result = $g5['update']->deleteOriginFile($originFilePath);
            if ($result == "success") {
                $update_check['success'][] = $var;
            } else {
                $update_check['fail'][] = array('file' => $var, 'message' => $result);
            }
        }
        if (!is_dir(dirname($changeFilePath)) && is_dir(dirname($originFilePath))) { // 업데이트디렉토리는 존재하지않지만 현재디렉토리는 존재할때
            $result = $g5['update']->removeEmptyOriginDir(dirname($originFilePath));
            if ($result == "success") {
                $update_check['success'][] = $var;
            } else {
                $update_check['fail'][] = array('file' => $var, 'message' => $result);
            }
        }
        
        $result = $g5['update']->writeUpdateFile($originFilePath, $changeFilePath);
        if ($result == "success") {
            $update_check['success'][] = $var;
        } else {
            $update_check['fail'][] = array('file' => $var, 'message' => $result);
        }
    }
} else {
    $update_check['fail'][] = array('file' => $var, 'message' => $result);
}

$result = $g5['update']->writeLogFile($update_check['success'], $update_check['fail'], 'update');

$g5['update']->disconnect();

?>

<div>
    <p style="font-weight:bold; font-size:15px;">업데이트 성공</p>
    <?php if (isset($update_check['success'])) { ?>
        <?php foreach ($update_check['success'] as $key => $var) { ?>
            <p><?php echo $var; ?></p>
        <?php } ?>
    <?php } ?>
    <br>

    <p style="font-weight:bold; font-size:15px;">업데이트 실패</p>
    <?php if (isset($update_check['fail'])) { ?>
        <?php foreach ($update_check['fail'] as $key => $var) { ?>
            <p><span style="color:red;"><?php echo $var['file']; ?></span><?php echo ' : ' . $var['message']; ?></p>
        <?php } ?>
    <?php } ?>
</div>

<?php
include_once '../admin.tail.php';
?>