<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가 

$evt = array('evt_type'=>'', 'evt_name'=>'', 'mb_level_from'=>1, 'mb_level_to'=>10, 'date_from'=>G5_TIME_YMD, 'date_to'=>G5_TIME_YMD, 'time_from'=>'00:00', 'time_to'=>'24:00', 'point'=>'', 'probability'=>'100', 'content'=>'', 'cutline_gives'=>0, 'bo_tables'=>array());

if(isset($_REQUEST['eid']))
{
  $evt = sql_fetch("SELECT * FROM gpf_pointer WHERE id = '{$eid}'");
  if(!$evt) alert('존재하지 않는 이벤트입니다.');

  $evt['bo_tables'] = array();

  if($evt['evt_type'] != 'login')
  {
    $res = sql_query("SELECT * FROM gpf_pointer_tables WHERE evt_id = '{$evt['id']}' ");
    while($row = sql_fetch_array($res))
    {
      array_push($evt['bo_tables'], $row['bo_table']);
    }
  }
} else $eid = 0;

include_once dirname(__FILE__).'/_head.php';
?>
<h2>이벤트 등록</h2>
<div class="ptr_right">
  <a href="<?php echo $px_url; ?>&act=ptr_event_point" class="ptr_btn">목록으로</a>
</div>

<div class="ptr_section">

  <form name="ptrfrm" action="admin_do.php" method="post" onsubmit="return ptr_check_form();">
  <input type="hidden" name="id" value="<?php echo htmlspecialchars($plugin_id); ?>"/>
  <input type="hidden" name="act" value="ptr_event_point_exe"/>
  <input type="hidden" name="md" value="ptr_<?php echo ($eid ? 'edit' : 'add'); ?>_event"/>
  <input type="hidden" name="eid" value="<?php echo $eid; ?>"/>

  <dl>
    <dt><strong>이벤트명</strong></dt>
    <dd>
      <input type="text" name="ptr_evt_name" size="30" required value="<?php echo htmlspecialchars($evt['evt_name']); ?>" class="ptr_txt"/>
    </dd>
  </dl>
  
  <dl>
    <dt>회원레벨</dt>
    <dd>
      <select name="ptr_mb_level_from">
      <?php for($i=1; $i<=10; $i++) echo '<option value="'.$i.'"'.($i==$evt['mb_level_from'] ? ' selected' : '').'>'.$i.'</option>'; ?>
      </select>
      에서
      <select name="ptr_mb_level_to">
      <?php for($i=1; $i<=10; $i++) echo '<option value="'.$i.'"'.($i==$evt['mb_level_to'] ? ' selected' : '').'>'.$i.'</option>'; ?>
      </select>
      인 회원이
    </dd>
  </dl>

  <dl>
    <dt>기간</dt>
    <dd>
    <input type="text" name="ptr_date_from" size="10" required value="<?php echo htmlspecialchars($evt['date_from']); ?>" class="ptr_txt ptr_date"/>일 에서 
    <input type="text" name="ptr_date_to" size="10" required value="<?php echo htmlspecialchars($evt['date_to']); ?>" class="ptr_txt ptr_date"/>일 사이에
    </dd>
  </dl>

  <dl>
    <dt>시간</dt>
    <dd>
    <input type="text" name="ptr_time_from" size="10" required value="<?php echo htmlspecialchars($evt['time_from']); ?>" class="ptr_txt ptr_time"/> 부터 
    <input type="text" name="ptr_time_to" size="10" required value="<?php echo htmlspecialchars($evt['time_to']); ?>" class="ptr_txt ptr_time"/> 사이에
    </dd>
  </dl>

  <dl>
    <dt>액션</dt>
    <dd>
      <select name="ptr_evt_type">
      <option value="login" <?php echo ($evt['evt_type'] == 'login' ? ' selected' : ''); ?>>로그인</option>
      <option value="write" <?php echo ($evt['evt_type'] == 'write' ? ' selected' : ''); ?>>글쓰기</option>
      <option value="write_comment" <?php echo ($evt['evt_type'] == 'write_comment' ? ' selected' : ''); ?>>댓글쓰기</option>
      </select> 하면
    </dd>
  </dl>

  <dl id="ptr_bo_tables"<?php if(!$eid || $evt['evt_type'] == 'login') echo ' style="display:none"'; ?>>
    <dt>(게시판아이디 )</dt>
    <dd>
      <input type="text" name="ptr_bo_tables" size="30" value="<?php echo htmlspecialchars(implode(',', $evt['bo_tables'])); ?>" class="ptr_txt"/> <span class="ptr_desc">(콤마(,)로 구분하여 입력하세요. * 를 입력하면 모든 게시판에 적용됩니다)</span>
    </dd>
  </dl>

  <dl>
    <dt>포인트</dt>
    <dd>
    <input type="text" name="ptr_point" size="6" required value="<?php echo htmlspecialchars($evt['point']); ?>" class="ptr_txt"/> 포인트를
    </dd>
  </dl>

  <dl>
    <dt>확률</dt>
    <dd>
    <input type="text" name="ptr_probability" size="6" required value="<?php echo htmlspecialchars($evt['probability']); ?>" class="ptr_txt"/>% 확률로
      <span class="ptr_desc">( 1 ~ 100 까지의 정수 값 입력 )</span>
    </dd>
  </dl>

  <dl>
    <dt>커트라인</dt>
    <dd>
    <input type="text" name="ptr_cutline" size="6" required value="<?php echo htmlspecialchars($evt['cutline_gives']); ?>" class="ptr_txt"/> 명에게
      <span class="ptr_desc">(3 입력시 하루에 3명에게만 포인트 지급, 0 입력시 모두에게 지급 )</span>
    </dd>
  </dl>
  
  <dl>
    <dt>포인트 내역</dt>
    <dd>
    <input type="text" name="ptr_content" required size="30" value="<?php echo htmlspecialchars($evt['content']); ?>" class="ptr_txt"/> 으로 지급합니다.
    </dd>
  </dl>

  <dl> 
  <dd><input type="submit" value="<?php echo ($eid ? '수정하기' : '등록하기'); ?>" class="ptr_btn"/></dd>
  </dl>
  </form>

</div>

<link rel="stylesheet" href="<?php echo $plugin_url; ?>/js/jquery.datepick.css" />
<link rel="stylesheet" href="<?php echo $plugin_url; ?>/js/jquery.timepicker.css" />
<script src="<?php echo $plugin_url; ?>/js/jquery.datepick.min.js"></script>
<script src="<?php echo $plugin_url; ?>/js/jquery.timepicker.min.js"></script>
<script type="text/javascript">
function ptr_check_form()
{
  <?php if(!$eid) { ?>
  if(!confirm('등록 하시겠습니까?')) return false;
  <?php } else { ?>
  if(!confirm('수정 하시겠습니까?\n(커트라인 적용 내역이 리셋됩니다.)')) return false;
  <?php } ?>
  return true;
}
$(function() {
  $('[name=ptr_evt_type]').change(function() {
    if($(this).val() != 'login') $('#ptr_bo_tables').show();
    else $('#ptr_bo_tables').hide();
  });
  $('.ptr_date').datepick({dateFormat : "yyyy-mm-dd"});
  $('.ptr_time').timepicker({'timeFormat' : 'H:i'});
});
</script>
<?php
include_once dirname(__FILE__).'/_tail.php';
?>
